/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.util.pool;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.aperi.util.pool.ResourceCreator;

public class Pool {
    Hashtable activeResources = new Hashtable();
    Hashtable idleResources = new Hashtable();
    ResourceCreator creator = null;

    public Pool(ResourceCreator creator) {
        this.creator = creator;
    }

    public static String normalize(Hashtable parameters) {
        StringBuffer buffer = new StringBuffer();
        Enumeration e = parameters.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = parameters.get(key);
            buffer.append(key.toString() + ":" + value.toString());
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getResource(Hashtable parameters) {
        String normalizedParameters = Pool.normalize(parameters);
        Object resource = null;
        Hashtable hashtable = this.idleResources;
        synchronized (hashtable) {
            ArrayList idleList = (ArrayList)this.idleResources.get(normalizedParameters);
            resource = idleList != null && !idleList.isEmpty() ? idleList.remove(0) : this.creator.createResource(parameters);
        }
        hashtable = this.activeResources;
        synchronized (hashtable) {
            this.activeResources.put(resource, normalizedParameters);
        }
        this.creator.initializeResource(resource);
        return resource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean freeResource(Object resource) {
        this.creator.freeResource(resource);
        Object key = null;
        Hashtable hashtable = this.activeResources;
        synchronized (hashtable) {
            key = this.activeResources.remove(resource);
        }
        if (key == null) {
            System.out.println("ERROR IN POOL - attempted to free resource " + resource + " which isn't listed as active.");
            return false;
        }
        hashtable = this.idleResources;
        synchronized (hashtable) {
            ArrayList<Object> idleList = (ArrayList<Object>)this.idleResources.get(key);
            if (idleList == null) {
                idleList = new ArrayList<Object>();
                this.idleResources.put(key, idleList);
            }
            idleList.add(resource);
        }
        return true;
    }
}

