/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.util.queue;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.ListIterator;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.util.queue.IJobQueue;

public class DefaultJobQueue
implements IJobQueue {
    protected LinkedList order = new LinkedList();
    protected Object lock = new Object();
    protected boolean limited = false;
    protected HashSet iActiveJobs = new HashSet();

    public DefaultJobQueue() {
    }

    public DefaultJobQueue(boolean aLimited) {
        this.limited = aLimited;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addJob(JobInfo job) {
        Object object = this.lock;
        synchronized (object) {
            this.order.addLast(job);
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobInfo getNextJob() {
        JobInfo tempJobInfo = null;
        while (!Thread.interrupted() && tempJobInfo == null) {
            Object object = this.lock;
            synchronized (object) {
                if (this.order.size() > 0) {
                    ListIterator tempListIterator = this.order.listIterator(0);
                    while (tempListIterator.hasNext()) {
                        tempJobInfo = (JobInfo)tempListIterator.next();
                        if (this.limited && this.iActiveJobs.contains(tempJobInfo.getResourceId()) || tempJobInfo.getStatus() == 3) {
                            tempJobInfo = null;
                            continue;
                        }
                        if (this.limited) {
                            this.iActiveJobs.add(tempJobInfo.getResourceId());
                        }
                        tempListIterator.remove();
                        break;
                    }
                }
                if (tempJobInfo == null) {
                    try {
                        this.lock.wait();
                    }
                    catch (InterruptedException ie) {
                        return null;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                while (tempJobInfo != null && tempJobInfo.getStatus() == 4) {
                    if (this.limited) {
                        this.iActiveJobs.remove(tempJobInfo.getResourceId());
                    }
                    if ((tempJobInfo = tempJobInfo.getReplacementJob()) == null) continue;
                    this.order.remove(tempJobInfo);
                    if (!this.limited) continue;
                    this.iActiveJobs.add(tempJobInfo.getResourceId());
                }
            }
        }
        if (tempJobInfo != null) {
            this.jobStarted(tempJobInfo);
        }
        if (Thread.interrupted()) {
            return null;
        }
        return tempJobInfo;
    }

    public void jobStarted(JobInfo job) {
        job.setStartTime(System.currentTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobCompleted(JobInfo job) {
        job.setEndTime(System.currentTimeMillis());
        if (this.limited) {
            this.iActiveJobs.remove(job.getResourceId());
        }
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }
}

