/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.xmsg;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

public class IntlMessageFormat
extends Format {
    static final long serialVersionUID = 5553285815511168954L;
    protected MessageFormat format_ = null;
    private Locale locale_ = null;
    private static final char SINGLE_QUOTE = '\'';
    private static final char CURLY_BRACE_LEFT = '{';
    private static final char CURLY_BRACE_RIGHT = '}';
    private static final int STATE_INITIAL = 0;
    private static final int STATE_SINGLE_QUOTE = 1;
    private static final int STATE_LITERAL_BRACE = 2;
    private static final int STATE_MSG_ELEMENT = 3;

    public IntlMessageFormat(String pattern) {
        this.format_ = new MessageFormat(pattern);
        this.applyPattern(pattern);
    }

    public void setLocale(Locale theLocale) {
        this.locale_ = theLocale;
        this.format_.setLocale(this.locale_);
    }

    public Locale getLocale() {
        return this.format_.getLocale();
    }

    public void applyPattern(String newPattern) {
        Vector<String> tokens = new Vector<String>();
        boolean part = false;
        char tokenBegin = '{';
        char tokenEnd = '}';
        StringBuffer sb = null;
        tokens.clear();
        if (newPattern.indexOf(39) >= 0) {
            newPattern = IntlMessageFormat.fixPattern(newPattern);
        }
        this.format_.applyPattern(newPattern);
        for (int i = 0; i < newPattern.length(); ++i) {
            char ch = newPattern.charAt(i);
            if (!part) {
                if (ch != tokenBegin) continue;
                sb = new StringBuffer();
                part = true;
                continue;
            }
            if (ch == tokenEnd) {
                part = false;
                tokens.add(sb.toString());
                continue;
            }
            sb.append(ch);
        }
        Format newFormat = null;
        Locale locale = this.locale_ == null ? Locale.getDefault() : this.locale_;
        for (int i = 0; i < tokens.size(); ++i) {
            String mode;
            StringTokenizer st = new StringTokenizer((String)tokens.elementAt(i), ",");
            if (st.countTokens() != 2 && st.countTokens() != 3) continue;
            st.nextToken();
            String type = st.nextToken();
            if (type.equals("time")) {
                if (st.hasMoreTokens()) {
                    mode = st.nextToken();
                    if (mode.equals("short")) {
                        newFormat = DateFormat.getTimeInstance(3, locale);
                    } else if (mode.equals("medium")) {
                        newFormat = DateFormat.getTimeInstance(2, locale);
                    } else if (mode.equals("long")) {
                        newFormat = DateFormat.getTimeInstance(1, locale);
                    } else if (mode.equals("full")) {
                        newFormat = DateFormat.getTimeInstance(0, locale);
                    } else {
                        newFormat = DateFormat.getTimeInstance(2, locale);
                        ((SimpleDateFormat)newFormat).applyPattern(mode);
                    }
                } else {
                    newFormat = DateFormat.getTimeInstance(2, locale);
                }
                this.format_.setFormat(i, newFormat);
                continue;
            }
            if (type.equals("date")) {
                if (st.hasMoreTokens()) {
                    mode = st.nextToken();
                    if (mode.equals("short")) {
                        newFormat = DateFormat.getDateInstance(3, locale);
                    } else if (mode.equals("medium")) {
                        newFormat = DateFormat.getDateInstance(2, locale);
                    } else if (mode.equals("long")) {
                        newFormat = DateFormat.getDateInstance(1, locale);
                    } else if (mode.equals("full")) {
                        newFormat = DateFormat.getDateInstance(0, locale);
                    } else {
                        newFormat = DateFormat.getDateInstance(2, locale);
                        ((SimpleDateFormat)newFormat).applyPattern(mode);
                    }
                } else {
                    newFormat = DateFormat.getDateInstance(2, locale);
                }
                this.format_.setFormat(i, newFormat);
                continue;
            }
            if (!type.equals("number")) continue;
            if (st.hasMoreTokens()) {
                mode = st.nextToken();
                if (mode.equals("currency")) {
                    newFormat = NumberFormat.getCurrencyInstance(locale);
                } else if (mode.equals("percent")) {
                    newFormat = NumberFormat.getPercentInstance(locale);
                } else if (mode.equals("integer")) {
                    newFormat = NumberFormat.getNumberInstance(locale);
                    ((DecimalFormat)newFormat).setMaximumFractionDigits(0);
                    ((DecimalFormat)newFormat).setDecimalSeparatorAlwaysShown(false);
                    ((DecimalFormat)newFormat).setParseIntegerOnly(true);
                } else {
                    newFormat = NumberFormat.getInstance(locale);
                    ((DecimalFormat)newFormat).applyPattern(mode);
                }
            } else {
                newFormat = NumberFormat.getNumberInstance(locale);
            }
            this.format_.setFormat(i, newFormat);
        }
    }

    public String toPattern() {
        return this.format_.toPattern();
    }

    public void setFormats(Format[] newFormats) {
        this.format_.setFormats(newFormats);
    }

    public void setFormat(int variable, Format newFormat) {
        this.format_.setFormat(variable, newFormat);
    }

    public Format[] getFormats() {
        return this.format_.getFormats();
    }

    public final StringBuffer format(Object[] source, StringBuffer result, FieldPosition ignore) {
        return this.format_.format(source, result, ignore);
    }

    public static String format(String pattern, Object[] arguments) {
        IntlMessageFormat imf = new IntlMessageFormat(pattern);
        StringBuffer buf = new StringBuffer();
        buf = imf.format(arguments, buf, (FieldPosition)null);
        return new String(buf);
    }

    public final StringBuffer format(Object source, StringBuffer result, FieldPosition ignore) {
        return this.format_.format(source, result, ignore);
    }

    public Object[] parse(String source, ParsePosition status) {
        return this.format_.parse(source, status);
    }

    public Object[] parse(String source) throws ParseException {
        return this.format_.parse(source);
    }

    public Object parseObject(String text, ParsePosition status) {
        return this.format_.parseObject(text, status);
    }

    public Object clone() {
        IntlMessageFormat other = (IntlMessageFormat)super.clone();
        other.format_ = (MessageFormat)this.format_.clone();
        return other;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof IntlMessageFormat)) {
            return false;
        }
        return this.format_.equals(((IntlMessageFormat)obj).format_);
    }

    public int hashCode() {
        return this.format_.hashCode();
    }

    private static String fixPattern(String pattern) {
        StringBuffer buf = new StringBuffer(pattern.length() * 2);
        int state = 0;
        int j = pattern.length();
        for (int i = 0; i < j; ++i) {
            char c = pattern.charAt(i);
            block0 : switch (state) {
                case 0: {
                    switch (c) {
                        case '\'': {
                            state = 1;
                            break;
                        }
                        case '{': {
                            state = 3;
                        }
                    }
                    break;
                }
                case 1: {
                    switch (c) {
                        case '\'': {
                            state = 0;
                            break block0;
                        }
                        case '{': 
                        case '}': {
                            state = 2;
                            break block0;
                        }
                    }
                    buf.append('\'');
                    state = 0;
                    break;
                }
                case 2: {
                    switch (c) {
                        case '\'': {
                            state = 0;
                        }
                    }
                    break;
                }
                case 3: {
                    switch (c) {
                        case '}': {
                            state = 0;
                        }
                    }
                    break;
                }
            }
            buf.append(c);
        }
        if (state == 1) {
            buf.append('\'');
        }
        return new String(buf);
    }
}

