/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.xmsg;

import java.io.IOException;
import org.eclipse.aperi.xmsg.LoggerRegistry;
import org.eclipse.aperi.xmsg.MessageRegistry;
import org.eclipse.aperi.xmsg.MessageTextRenderer;
import org.eclipse.aperi.xmsg.WrappedLogger;
import sun.reflect.Reflection;

public class LocalizableException
extends IOException {
    static final long serialVersionUID = 5691777094922365144L;
    private static final int MAX_PRODUCTID_LENGTH = 5;
    protected String key;
    protected Object[] parameters;
    private transient MessageTextRenderer renderer;
    private transient String renderedMessage;

    private static String keyToProductID(String key) {
        char c;
        int length = key.length();
        if (length > 5) {
            length = 5;
        }
        StringBuffer buf = new StringBuffer(length);
        for (int i = 0; i < length && Character.isUpperCase(c = key.charAt(i)); ++i) {
            buf.append(c);
        }
        return buf.toString();
    }

    private ClassLoader getCallingLoader() {
        Class callingClass = Reflection.getCallerClass((int)3);
        return callingClass.getClassLoader();
    }

    public LocalizableException(String pKey, Object[] pParameters) {
        this.key = pKey;
        this.parameters = pParameters;
        ClassLoader loader = this.getCallingLoader();
        String productID = LocalizableException.keyToProductID(this.key);
        this.renderer = MessageRegistry.lookUpRenderer(loader, productID);
    }

    public String getMessage(WrappedLogger logger) {
        String localizedText = null;
        if (this.renderer != null) {
            localizedText = this.renderer.renderMessageText(this.key, this.parameters);
        }
        String result = localizedText != null ? logger.formatMessage(this.key, localizedText) : logger.formatUnrecognizedMessage(this.key, this.parameters);
        return result;
    }

    public String getMessage() {
        if (this.renderedMessage != null) {
            return this.renderedMessage;
        }
        ClassLoader loader = this.getCallingLoader();
        WrappedLogger logger = LoggerRegistry.getLogger(loader);
        return this.getMessage(logger);
    }

    public void printStackTrace() {
        ClassLoader loader = this.getCallingLoader();
        WrappedLogger logger = LoggerRegistry.getLogger(loader);
        this.renderedMessage = this.getMessage(logger);
        this.printStackTrace(logger.getPrintWriter());
        this.renderedMessage = null;
    }

    public void print() {
        ClassLoader loader = this.getCallingLoader();
        WrappedLogger logger = LoggerRegistry.getLogger(loader);
        String message = this.getMessage(logger);
        logger.getPrintWriter().println(message);
    }

    public String getKey() {
        return this.key;
    }

    public Object[] getParameters() {
        return this.parameters;
    }
}

