/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.xmsg;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.aperi.util.osgi.IDisposable;
import org.eclipse.aperi.xmsg.IMessageBundleSource;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.RegistryFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageBundleManager
implements IRegistryChangeListener,
IDisposable {
    public static final String ATTR_NAME = "name";
    public static final String ATTR_PREFIX = "prefix";
    public static final String ATTR_SOURCE = "source";
    private SortedMap<Integer, Map<String, IMessageBundleSource>> bundleSourceCache;
    private String extensionPointId;
    private ReadWriteLock cacheLock;

    public MessageBundleManager(String extensionPointId) {
        this.extensionPointId = extensionPointId;
        this.bundleSourceCache = new TreeMap<Integer, Map<String, IMessageBundleSource>>();
        this.cacheLock = new ReentrantReadWriteLock(true);
    }

    public void initialize() {
        IExtensionRegistry registry = RegistryFactory.getRegistry();
        if (registry != null) {
            IConfigurationElement[] elements = registry.getConfigurationElementsFor(this.extensionPointId);
            for (int i = 0; i < elements.length; ++i) {
                try {
                    this.addSource(elements[i]);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            registry.addRegistryChangeListener((IRegistryChangeListener)this);
        } else if (System.getProperty("osgi.framework") != null) {
            throw new RuntimeException("Failed to obtain reference to extension registry.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        this.cacheLock.writeLock().lock();
        try {
            RegistryFactory.getRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
            for (Map<String, IMessageBundleSource> map : this.bundleSourceCache.values()) {
                for (IMessageBundleSource source : map.values()) {
                    try {
                        source.dispose();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                map.clear();
            }
            this.bundleSourceCache.clear();
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }

    public void registryChanged(IRegistryChangeEvent event) {
        IExtensionDelta[] deltas = event.getExtensionDeltas();
        for (int i = 0; i < deltas.length; ++i) {
            int n;
            IExtension extension = deltas[i].getExtension();
            if (!extension.getExtensionPointUniqueIdentifier().equals(this.extensionPointId)) continue;
            IConfigurationElement[] elements = extension.getConfigurationElements();
            if (deltas[i].getKind() == 1) {
                for (n = 0; n < elements.length; ++n) {
                    try {
                        this.addSource(elements[n]);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                continue;
            }
            if (deltas[i].getKind() != 2) continue;
            for (n = 0; n < elements.length; ++n) {
                try {
                    this.removeSource(elements[n]);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSource(IConfigurationElement sourceElement) throws Exception {
        this.cacheLock.writeLock().lock();
        try {
            String prefix = sourceElement.getAttribute(ATTR_PREFIX);
            if (prefix != null) {
                Map<String, IMessageBundleSource> prefixSourceMap = this.getPrefixSourceMap(prefix.length());
                if (prefixSourceMap.containsKey(prefix)) {
                    throw new RuntimeException("Message source named " + prefixSourceMap.get(prefix) + " already registered under prefix " + prefix);
                }
                IMessageBundleSource source = (IMessageBundleSource)sourceElement.createExecutableExtension(ATTR_SOURCE);
                if (source != null) {
                    prefixSourceMap.put(prefix, source);
                }
            }
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSource(IConfigurationElement sourceElement) throws Exception {
        this.cacheLock.writeLock().lock();
        try {
            Map<String, IMessageBundleSource> prefixSourceMap;
            IMessageBundleSource source;
            String prefix = sourceElement.getAttribute(ATTR_PREFIX);
            if (prefix != null && (source = (prefixSourceMap = this.getPrefixSourceMap(prefix.length())).remove(prefix)) != null) {
                source.dispose();
            }
        }
        finally {
            this.cacheLock.writeLock().unlock();
        }
    }

    private Map<String, IMessageBundleSource> getPrefixSourceMap(Integer prefixLength) {
        HashMap prefixSourceMap = (HashMap)this.bundleSourceCache.get(prefixLength);
        if (prefixSourceMap == null) {
            prefixSourceMap = new HashMap();
            this.bundleSourceCache.put(prefixLength, prefixSourceMap);
        }
        return prefixSourceMap;
    }

    public ResourceBundle getBundle(String mesageKey) {
        return this.getBundle(mesageKey, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResourceBundle getBundle(String messageKey, Locale locale) {
        IMessageBundleSource source = null;
        if (messageKey != null) {
            this.cacheLock.readLock().lock();
            try {
                Integer[] prefixLengths = this.bundleSourceCache.keySet().toArray(new Integer[0]);
                for (int i = prefixLengths.length - 1; i >= 0; --i) {
                    if (messageKey.length() < prefixLengths[i]) continue;
                    String prefix = messageKey.substring(0, prefixLengths[i]);
                    source = this.getPrefixSourceMap(prefixLengths[i]).get(prefix);
                    if (source == null) continue;
                    break;
                }
            }
            finally {
                this.cacheLock.readLock().unlock();
            }
        }
        if (source != null) {
            return source.getResourceBundle(locale);
        }
        return null;
    }
}

