/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.xmsg;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.ResourceBundle;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.StorageException;
import org.eclipse.aperi.common.TSThread;
import org.eclipse.aperi.xmsg.IntlMessageFormat;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.LoggerRegistry;
import org.eclipse.aperi.xmsg.MessageBundleManager;
import org.eclipse.aperi.xmsg.MessageFormatter;
import org.eclipse.aperi.xmsg.MessageRegistry;
import org.eclipse.aperi.xmsg.MessageTextRenderer;
import org.eclipse.aperi.xmsg.OSException;
import org.eclipse.aperi.xmsg.TextRendererProvider;
import org.eclipse.aperi.xmsg.WrappedLogger;

public class MessageLog
extends TextRendererProvider
implements MessageTextRenderer,
WrappedLogger {
    public static final String TEXT_UNAVAILABLE = "<text unavailable>";
    public static final String INDENT = "                         ";
    public static final String TS_INDENT = "               ";
    public static final int TS_INDENT_LENGTH = 15;
    public static final String BUNDLE_SRC_EXTENSION_POINT_ID = "org.eclipse.aperi.common.messageSources";
    public static final String lineSeparator = System.getProperty("line.separator", "\n");
    public static final MessageFormatter messageFormatter;
    public static final DateFormat tsFormatter;
    private static final MessageBundleManager manager;
    private static final int PREPEND_NONE = 0;
    private static final int PREPEND_ID = 1;
    private static final int PREPEND_TS = 2;
    private static final String[] indents;

    public static void setThreadLog(PrintWriter pOutput) {
        TSThread.setProperty("TSThread.key.messageLog", pOutput);
    }

    public static PrintWriter getThreadLog() {
        return (PrintWriter)TSThread.getProperty("TSThread.key.messageLog");
    }

    public static DateFormat getDateFormat() {
        return DateFormat.getDateTimeInstance(3, 2);
    }

    public static PrintWriter getDefaultLog() {
        return (PrintWriter)TSThread.getDefaultProperty("TSThread.key.messageLog");
    }

    public static void setDefaultLog(PrintWriter pOutput) {
        TSThread.setDefaultProperty("TSThread.key.messageLog", pOutput);
    }

    public static void redirectErrOut(OutputStream logStream) {
        PrintStream pStream = new PrintStream(logStream);
        System.setOut(pStream);
        System.setErr(pStream);
    }

    private static String renderMessage(ResourceBundle messages, String id, Object[] parms) {
        String result = TEXT_UNAVAILABLE;
        String pattern = null;
        if (messages != null) {
            try {
                pattern = messages.getString(id);
            }
            catch (Exception ignored) {
                pattern = null;
            }
        }
        if (pattern != null) {
            try {
                result = IntlMessageFormat.format(pattern, parms);
            }
            catch (Exception alsoIgnored) {
                result = TEXT_UNAVAILABLE;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String format(String id, String msgText, Object[] args, int whichPieces) {
        StringBuffer space = new StringBuffer(80);
        if (whichPieces > 0) {
            if (whichPieces == 2) {
                DateFormat dateFormat = tsFormatter;
                synchronized (dateFormat) {
                    space.append(tsFormatter.format(new Date()));
                }
                space.append(" ");
            }
            space.append(id);
            space.append(": ");
        }
        space.append(msgText);
        if (msgText == TEXT_UNAVAILABLE && args != null) {
            for (int i = 0; i < args.length; ++i) {
                space.append(lineSeparator);
                space.append(indents[whichPieces]);
                space.append(args[i]);
            }
        }
        return space.toString();
    }

    private static String getPieces(String id, Object[] args, int whichPieces) {
        String msgText = MessageLog.renderMessage(manager.getBundle(id), id, args);
        return MessageLog.format(id, msgText, args, whichPieces);
    }

    public static String getMessage(String id, Object[] args) {
        return MessageLog.getPieces(id, args, 2);
    }

    public static String getMessage(String id) {
        return MessageLog.getPieces(id, null, 2);
    }

    public static String getMessage(String id, Object arg1) {
        Object[] args = new Object[]{arg1};
        return MessageLog.getPieces(id, args, 2);
    }

    public static String getMessage(String id, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg1, arg2};
        return MessageLog.getPieces(id, args, 2);
    }

    public static String getMessage(String id, Object arg1, Object arg2, Object arg3) {
        Object[] args = new Object[]{arg1, arg2, arg3};
        return MessageLog.getPieces(id, args, 2);
    }

    public static String getMessageNoTS(String id, Object[] args) {
        return MessageLog.getPieces(id, args, 1);
    }

    public static String getMessageNoTS(String id) {
        return MessageLog.getPieces(id, null, 1);
    }

    public static String getMessageNoTS(String id, Object arg1) {
        Object[] args = new Object[]{arg1};
        return MessageLog.getPieces(id, args, 1);
    }

    public static String getMessageNoTS(String id, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg1, arg2};
        return MessageLog.getPieces(id, args, 1);
    }

    public static String getMessageNoTS(String id, Object arg1, Object arg2, Object arg3) {
        Object[] args = new Object[]{arg1, arg2, arg3};
        return MessageLog.getPieces(id, args, 1);
    }

    public static String getMessageNoID(String id, Object[] args) {
        return MessageLog.getPieces(id, args, 0);
    }

    public static String getMessageNoID(String id) {
        return MessageLog.getPieces(id, null, 0);
    }

    public static String getMessageNoID(String id, Object arg1) {
        Object[] args = new Object[]{arg1};
        return MessageLog.getPieces(id, args, 0);
    }

    public static String getMessageNoID(String id, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg1, arg2};
        return MessageLog.getPieces(id, args, 0);
    }

    public static String getMessageNoID(String id, Object arg1, Object arg2, Object arg3) {
        Object[] args = new Object[]{arg1, arg2, arg3};
        return MessageLog.getPieces(id, args, 0);
    }

    public static void logMessage(String id, Object[] args) {
        String text = MessageLog.getMessage(id, args);
        PrintWriter output = MessageLog.getThreadLog();
        output.println(text);
    }

    public static void logMessage(String id) {
        MessageLog.logMessage(id, null);
    }

    public static void logMessage(String id, Object arg1) {
        Object[] args = new Object[]{arg1};
        MessageLog.logMessage(id, args);
    }

    public static void logMessage(String id, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg1, arg2};
        MessageLog.logMessage(id, args);
    }

    public static void logMessage(String id, Object arg1, Object arg2, Object arg3) {
        Object[] args = new Object[]{arg1, arg2, arg3};
        MessageLog.logMessage(id, args);
    }

    public static String getMessageWithException(String id, Exception e, Object[] args) {
        StringBuffer result = new StringBuffer(160);
        result.append(MessageLog.getMessage(id, args));
        String eMsg = e.getMessage();
        if (eMsg != null) {
            result.append(lineSeparator);
            if (!(e instanceof GeneralException) && !(e instanceof LocalizableException)) {
                result.append(INDENT);
            }
            result.append(eMsg);
        }
        return result.toString();
    }

    public static String getMessageWithException(String id, Exception e) {
        return MessageLog.getMessageWithException(id, e, null);
    }

    public static String getMessageWithException(String id, Exception e, Object arg1) {
        Object[] args = new Object[]{arg1};
        return MessageLog.getMessageWithException(id, e, args);
    }

    public static String getMessageWithException(String id, Exception e, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg1, arg2};
        return MessageLog.getMessageWithException(id, e, args);
    }

    public static String getMessageWithException(String id, Exception e, Object arg1, Object arg2, Object arg3) {
        Object[] args = new Object[]{arg1, arg2, arg3};
        return MessageLog.getMessageWithException(id, e, args);
    }

    public static void logException(String id, Exception e, Object[] args) {
        MessageLog.getThreadLog().println(MessageLog.getMessageWithException(id, e, args));
    }

    public static void logException(String id, Exception e) {
        MessageLog.logException(id, e, null);
    }

    public static void logException(String id, Exception e, Object arg1) {
        Object[] args = new Object[]{arg1};
        MessageLog.logException(id, e, args);
    }

    public static void logException(String id, Exception e, Object arg1, Object arg2) {
        Object[] args = new Object[]{arg1, arg2};
        MessageLog.logException(id, e, args);
    }

    public static void logException(String id, Exception e, Object arg1, Object arg2, Object arg3) {
        Object[] args = new Object[]{arg1, arg2, arg3};
        MessageLog.logException(id, e, args);
    }

    public static void logException(StorageException e) {
        MessageLog.getThreadLog().println(e.getMessage(messageFormatter));
    }

    private static native void init();

    public static void initNative() {
        StorageException.setDefaultFormatter(messageFormatter);
        OSException.load();
        MessageLog.init();
    }

    private MessageLog() {
    }

    public MessageTextRenderer lookUpRenderer(String key) {
        return this;
    }

    public String renderMessageText(String id, Object[] parms) {
        String result = MessageLog.renderMessage(manager.getBundle(id), id, parms);
        if (result.equals(TEXT_UNAVAILABLE)) {
            result = null;
        }
        return result;
    }

    public PrintWriter getPrintWriter() {
        return MessageLog.getThreadLog();
    }

    public String formatMessage(String id, String localizedText) {
        return MessageLog.format(id, localizedText, null, 2);
    }

    public String formatUnrecognizedMessage(String id, Object[] parms) {
        return MessageLog.format(id, TEXT_UNAVAILABLE, parms, 2);
    }

    static {
        MessageLog.setThreadLog(new PrintWriter(System.err, true));
        messageFormatter = new MyMessageFormatter();
        tsFormatter = MessageLog.getDateFormat();
        manager = new MessageBundleManager(BUNDLE_SRC_EXTENSION_POINT_ID);
        manager.initialize();
        MessageLog messageLog = new MessageLog();
        MessageRegistry.registerProvider(messageLog);
        LoggerRegistry.setDefaultLogger(messageLog);
        indents = new String[]{"", TS_INDENT, INDENT};
    }

    private static class MyMessageFormatter
    implements MessageFormatter {
        private MyMessageFormatter() {
        }

        public String format(String msgID, Object[] args) {
            return MessageLog.getMessage(msgID, args);
        }

        public String formatSystemError(String systemError) {
            return MessageLog.INDENT + systemError;
        }
    }
}

