/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi;

import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.discovery.Discover;
import org.eclipse.aperi.discovery.DiscoverUtils;
import org.eclipse.aperi.discovery.DiscoveryActivator;
import org.eclipse.aperi.discovery.ProcessProcessor;
import org.eclipse.aperi.discovery.cimom.CIMScanner;
import org.eclipse.aperi.discovery.cimom.SLPScanner;
import org.eclipse.aperi.discovery.interfaces.IDiscoverProcess;
import org.eclipse.aperi.discovery.parser.CIMParser;
import org.eclipse.aperi.discovery.parser.SLPObjectParser;
import org.eclipse.aperi.interfaces.DiscoverRequest;
import org.eclipse.aperi.interfaces.IDiscover;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.sanmgmt.middleware.data.RPCSecureJavaProvider;
import org.eclipse.aperi.sanmgmt.middleware.data.RoleChecker;
import org.eclipse.aperi.sanmgmt.middleware.data.Status;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.ICliDispatcher;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IService;

public class DiscoverService
implements IDiscover,
IService,
ICliDispatcher {
    public static String className = DiscoverService.class.getName();
    public static final String MESSAGE_NAME = "aperi.logger.message.Discovery";
    public static final String TRACE_NAME = "aperi.logger.trace.Discovery";
    public static String MSG_FILE = "org.eclipse.aperi.resources.Discover";
    public Status status = new Status(5, 6);
    public static final String PROPERTY_GROUP = "DiscoverService";
    public static final String PROPERTY_NUM_CIM_SCANNERS = "NumCIMScanners";
    public static final String PROPERTY_NUM_SLP_SCANNERS = "NumSLPScanners";
    public static final String PROPERTY_NUM_PROCESSORS = "NumProcessors";
    public static final String PROPERTY_NUM_CIM_PARSERS = "NumCIMParsers";
    public static final String PROPERTY_NUM_SLP_PARSERS = "NumSLPParsers";
    public static final int DEFAULT_NUM_RESOURCES = 10;
    HashSet<CIMScanner> cimScanners = null;
    HashSet<SLPScanner> slpScanners = null;
    HashSet<ProcessProcessor> processors = null;
    HashSet<CIMParser> cimParsers = null;
    HashSet<SLPObjectParser> slpParsers = null;
    public static ILogger msgLogger = null;
    public static ILogger traceLogger = null;
    private static IConfigService configServiceProxy = null;

    public void addProcess(String name, IDiscoverProcess process) {
        Router.getRouter().addProcess(name, process);
    }

    public String discover(String type, Hashtable properties) {
        String methodName = "discover";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        String result = null;
        Hashtable<String, Object[]> props = new Hashtable<String, Object[]>();
        props.put("Request", new Object[]{type, properties});
        result = Router.getRouter().perform(Discover.frontEndProcessHandler, props)[0];
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, (Object)result);
        }
        return result;
    }

    public String discover(String type, Hashtable properties, ILogger logger) {
        String methodName = "discover";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        String result = null;
        Hashtable<String, Object[]> props = new Hashtable<String, Object[]>();
        props.put("Request", new Object[]{type, properties});
        result = Router.getRouter().perform(Discover.frontEndProcessHandler, props, true, logger)[0];
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, (Object)result);
        }
        return result;
    }

    public String discover(DiscoverRequest request) {
        String methodName = "discover";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        Hashtable<String, Object[]> props = new Hashtable<String, Object[]>();
        props.put("Request", new Object[]{request.getCommand(), request.getParameters()});
        String result = Router.getRouter().perform(Discover.frontEndProcessHandler, props)[0];
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, (Object)result);
        }
        return result;
    }

    public String discover(DiscoverRequest request, ILogger logger) {
        String methodName = "discover";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        Hashtable<String, Object[]> props = new Hashtable<String, Object[]>();
        props.put("Request", new Object[]{request.getCommand(), request.getParameters()});
        String result = Router.getRouter().perform(Discover.frontEndProcessHandler, props, true, logger)[0];
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName, (Object)result);
        }
        return result;
    }

    public Map getSupportedDiscoverRequests() {
        return Router.getRouter().getSupportedRequests();
    }

    public AsyncResult cancel(String discoverRequest) {
        return DiscoverUtils.cancelJob(discoverRequest);
    }

    public AsyncResult waitTilComplete(String discoverRequest) {
        return DiscoverUtils.waitForJobToComplete(discoverRequest);
    }

    public AsyncResult getJobStatus(String discoverRequest) {
        return ServiceUtils.getJobStatus((String)discoverRequest);
    }

    public String getDescription() {
        return "Service that performs discovery functions";
    }

    public String getName() {
        return PROPERTY_GROUP;
    }

    public String getLocalizedName(Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return rb.getString("DiscoverService_Name");
    }

    public String getLocalizedDescription(Locale locale) {
        ResourceBundle rb = ResourceBundle.getBundle("org.eclipse.aperi.resources.ServiceMessages", locale);
        return rb.getString("DiscoverService_Description");
    }

    public Status getStatus() {
        return this.status;
    }

    public String getVersion() {
        return "5.0.0";
    }

    public boolean shutdown() {
        Iterator<Thread> i;
        this.status.setRunStatus(11);
        if (this.cimScanners != null) {
            i = this.cimScanners.iterator();
            while (i.hasNext()) {
                ((CIMScanner)i.next()).shutdown();
            }
            this.cimScanners = null;
        }
        if (this.slpScanners != null) {
            i = this.slpScanners.iterator();
            while (i.hasNext()) {
                ((SLPScanner)i.next()).shutdown();
            }
            this.slpScanners = null;
        }
        if (this.cimParsers != null) {
            i = this.cimParsers.iterator();
            while (i.hasNext()) {
                ((CIMParser)i.next()).shutdown();
            }
            this.cimParsers = null;
        }
        if (this.slpParsers != null) {
            i = this.slpParsers.iterator();
            while (i.hasNext()) {
                ((SLPObjectParser)i.next()).shutdown();
            }
            this.slpParsers = null;
        }
        if (this.processors != null) {
            i = this.processors.iterator();
            while (i.hasNext()) {
                ((ProcessProcessor)i.next()).shutdown();
            }
            this.processors = null;
        }
        this.status.setRunStatus(10);
        return true;
    }

    private int getCountProperty(String property, int defaultValue, Properties properties) {
        int num = defaultValue;
        try {
            String value = properties.getProperty(property);
            if (value != null) {
                num = Integer.parseInt(value);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return num;
    }

    public boolean startup() {
        String methodName = "startup";
        try {
            int i;
            this.status.setRunStatus(9);
            Properties properties = this.getConfigServiceProxy().getProperties(PROPERTY_GROUP);
            this.cimScanners = new HashSet();
            int num = this.getCountProperty(PROPERTY_NUM_CIM_SCANNERS, 10, properties);
            for (i = 0; i < num; ++i) {
                this.cimScanners.add(new CIMScanner());
            }
            this.slpScanners = new HashSet();
            num = this.getCountProperty(PROPERTY_NUM_SLP_SCANNERS, 1, properties);
            for (i = 0; i < num; ++i) {
                this.slpScanners.add(new SLPScanner());
            }
            this.processors = new HashSet();
            num = this.getCountProperty(PROPERTY_NUM_PROCESSORS, 10, properties);
            for (i = 0; i < num; ++i) {
                this.processors.add(new ProcessProcessor());
            }
            this.cimParsers = new HashSet();
            num = this.getCountProperty(PROPERTY_NUM_CIM_PARSERS, 10, properties);
            for (i = 0; i < num; ++i) {
                this.cimParsers.add(new CIMParser());
            }
            this.slpParsers = new HashSet();
            num = this.getCountProperty(PROPERTY_NUM_SLP_PARSERS, 1, properties);
            for (i = 0; i < num; ++i) {
                this.slpParsers.add(new SLPObjectParser());
            }
            String value = Discover.discoverAll;
        }
        catch (Throwable t) {
            t.printStackTrace();
            this.shutdown();
        }
        this.status.setRunStatus(8);
        return true;
    }

    public String dispatch(String method, String[] args) {
        boolean failed;
        StringBuffer output;
        String methodName;
        block20: {
            methodName = "dispatch";
            if (traceLogger.isLogging()) {
                traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)this, methodName);
            }
            output = new StringBuffer();
            failed = false;
            if (method.equalsIgnoreCase("help")) {
                output.append("\nDiscover Service CLI supports the following commands:\n - list supported\n - list jobs\n - discover <DiscoverRequest> <parameter>=<value>*");
            } else if (method.equalsIgnoreCase("list")) {
                if (args.length < 1) {
                    output.append("Missing parameter\n");
                    failed = true;
                } else if (args[0].equalsIgnoreCase("supported")) {
                    Map requests = this.getSupportedDiscoverRequests();
                    output.append("Supported DISCOVER requests:\n");
                    for (String key : requests.keySet()) {
                        DiscoverRequest request = (DiscoverRequest)requests.get(key);
                        output.append(key + " (" + request.getDescription() + ")\n");
                        for (String name : request.getParameters().keySet()) {
                            String type = request.getParameterType(name);
                            output.append("    " + name + "\t\t" + type + '\n');
                        }
                        output.append('\n');
                    }
                } else if (args[0].equalsIgnoreCase("jobs")) {
                    output.append(Router.getRouter().getJobStatus());
                } else {
                    output.append("Incorrect parameter");
                    failed = true;
                }
            } else if (method.equalsIgnoreCase("discover")) {
                try {
                    String function = args[0];
                    DiscoverRequest request = (DiscoverRequest)this.getSupportedDiscoverRequests().get(function);
                    if (request == null) {
                        output.append("Discover request: " + args[0] + " is not recognized.\n");
                        failed = true;
                        break block20;
                    }
                    Hashtable parameters = DiscoverUtils.parseParameters(args, request);
                    System.out.println(request + " " + parameters);
                    String id = this.discover(function, parameters);
                    output.append("Discover request " + id + " started.");
                }
                catch (Exception e) {
                    output.append(e);
                    e.printStackTrace();
                }
            } else {
                output.append("Invalid command\n");
                failed = true;
            }
        }
        if (failed) {
            output.append("Use 'help' to get syntax of supported commands.");
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)this, methodName);
        }
        return output.toString();
    }

    public Hashtable getRoleMap() {
        Hashtable<String, Integer> roleMap = new Hashtable<String, Integer>();
        roleMap.put("discover", new Integer(RoleChecker.FABRIC_ADMIN));
        roleMap.put("dispatch", new Integer(RoleChecker.FABRIC_ADMIN));
        return roleMap;
    }

    public IConfigService getConfigServiceProxy() {
        if (configServiceProxy == null) {
            configServiceProxy = (IConfigService)DiscoveryActivator._serviceHelper.bindLocal("ConfigService");
        }
        return configServiceProxy;
    }

    public Object invoke(String user, String jobName, String scheduleId, String description, String service, String interfaceName, String functionName, Object[] parameters) throws ServerException {
        try {
            Object proxy = DiscoveryActivator._serviceHelper.bindLocal(service);
            Method method = null;
            Method[] methods = proxy.getClass().getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Class<?>[] types;
                if (!methods[i].getName().equals(functionName) || parameters.length != (types = methods[i].getParameterTypes()).length) continue;
                boolean match = true;
                for (int ii = 0; ii < parameters.length; ++ii) {
                    if (parameters[ii] == null || types[ii].isInstance(parameters[ii])) continue;
                    match = false;
                    break;
                }
                if (!match) continue;
                method = methods[i];
                break;
            }
            if (method == null) {
                throw new NoSuchMethodException(service + "." + functionName);
            }
            Hashtable<String, String> properties = new Hashtable<String, String>();
            properties.put("TPC_USER", user == null ? "" : user);
            properties.put("TPC_JOBNAME", jobName == null ? "" : jobName);
            properties.put("TPC_SCHEDULE_ID", scheduleId == null ? "" : scheduleId);
            properties.put("TPC_DESCRIPTION", description == null ? "" : description);
            RPCSecureJavaProvider.addUserProperties(properties);
            return method.invoke(proxy, parameters);
        }
        catch (Exception e) {
            String[] parms = new String[]{service, interfaceName, functionName};
            SRMMessage tpcMsg = new SRMMessage("BTAFM4001E", parms);
            throw new ServerException(tpcMsg, (Throwable)e);
        }
    }

    static {
        msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        msgLogger.setMessageFile(MSG_FILE);
    }
}

