/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi;

import com.ibm.log.Level;
import java.io.InvalidClassException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.discovery.JobEngine;
import org.eclipse.aperi.discovery.interfaces.IDiscoverProcess;
import org.eclipse.aperi.discovery.interfaces.IDiscoverRouterService;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.common.CIMOMSelector;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.eclipse.aperi.interfaces.DiscoverRequest;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.util.UStack;
import org.eclipse.aperi.util.extensions.AbstractExtensionMgr;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;

public final class Router
extends AbstractExtensionMgr
implements Observer,
IDiscoverRouterService {
    public static final String MESSAGE_NAME = "aperi.logger.message.DiscoverRouter";
    public static final String TRACE_NAME = "aperi.logger.trace.DiscoverRouter";
    public static ILogger msgLogger = null;
    public static ILogger traceLogger = null;
    public static String MSG_FILE = "org.eclipse.aperi.resources.Router";
    public static String className = Router.class.getName();
    public static int LOCK_WAIT_TIME = 10000;
    private static final String EXTENSION_POINT_ID = "org.eclipse.aperi.discovery.discoverProcess";
    public static final String ATTR_NAME = "DiscoverProcessName";
    public static final String ATTR_IMPL = "impl";
    public static final String ELEMENT_SMISREGISTRATIONDATA = "SMISRegistrationData";
    public static final String ATTR_SMISVERSION = "SMISVersion";
    public static final String ATTR_SMISPROFILE = "SMISProfile";
    public static final String ATTR_VENDOR = "Vendor";
    public static final String ATTR_MODEL = "Model";
    public static final String ATTR_SMISPROVIDERVERION = "SMISProviderVersion";
    private static final String ROOT = "ROOT";
    private static Router stRouter;
    private Map cProcessMap;
    private Map<String, IDiscoverProcess> cLegacyProcessMap;
    private Map cRequestMap;
    private Map cStepMap;
    Object lock = new Object();

    private static Map getInnerMap(Map pMap, String pKey) {
        Map mResult;
        if (pMap.containsKey(pKey)) {
            mResult = (Map)pMap.get(pKey);
        } else {
            mResult = new HashMap();
            pMap.put(pKey, mResult);
        }
        return mResult;
    }

    public static synchronized Router getRouter() {
        if (stRouter == null) {
            stRouter = new Router();
            JobEngine.getInstance().addObserver((Observer)stRouter);
        }
        return stRouter;
    }

    private Router() {
        this.cProcessMap = new HashMap();
        this.cRequestMap = Collections.synchronizedMap(new HashMap());
        this.cLegacyProcessMap = Collections.synchronizedMap(new HashMap());
    }

    public void startup() {
        this.initialize();
        String[] extIds = this.getAllExtensionIds();
        for (int i = 0; i < extIds.length; ++i) {
            this.extensionAdded(extIds[i]);
        }
    }

    public boolean cancel(String pJobId) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map map = this.cProcessMap;
        synchronized (map) {
            this.cProcessMap.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object findBestMatch(Map pMap, UStack pStack, MatchGauge pGauge) {
        Map map = this.cProcessMap;
        synchronized (map) {
            String mKey = (String)pStack.pop();
            boolean mHasPrecise = pMap.containsKey(mKey);
            boolean mHasGeneric = pMap.containsKey(null);
            if (!mHasPrecise && !mHasGeneric) {
                pGauge.markMismatch();
                return null;
            }
            if (pStack.empty()) {
                if (!mHasPrecise) {
                    pGauge.countGenericMatch();
                    return pMap.get(null);
                }
                pGauge.countPreciseMatch();
                return pMap.get(mKey);
            }
            if (!mHasPrecise) {
                return this.findBestMatch((HashMap)pMap.get(null), pStack, pGauge.countGenericMatch());
            }
            if (!mHasGeneric) {
                return this.findBestMatch((HashMap)pMap.get(mKey), pStack, pGauge.countPreciseMatch());
            }
            MatchGauge bGauge1 = new MatchGauge();
            MatchGauge bGauge2 = new MatchGauge();
            Object bPos1 = this.findBestMatch((HashMap)pMap.get(null), new UStack(pStack), bGauge1.countGenericMatch());
            Object bPos2 = this.findBestMatch((HashMap)pMap.get(mKey), new UStack(pStack), bGauge2.countPreciseMatch());
            pGauge.concat(bGauge2.less(bGauge1) ? bGauge1 : bGauge2);
            return bGauge2.less(bGauge1) ? bPos1 : bPos2;
        }
    }

    public IDiscoverProcess findProcess(String pProcessName, Map pParameters) {
        if (this.cLegacyProcessMap.containsKey(pProcessName)) {
            DiscoverProcess process = (DiscoverProcess)((DiscoverProcess)this.cLegacyProcessMap.get(pProcessName)).clone();
            return process;
        }
        if (pParameters.get("CIMOM") == null) {
            int bSubsystemId = Integer.parseInt(pParameters.get("DEVICEID").toString());
            CIMOMSelector.SubsystemConnectionData bSystemConnection = CIMOMSelector.getSelector().getCimomForSubsystem(bSubsystemId);
            pParameters.put("CIMOM", new String[]{bSystemConnection.getCimom().getServiceUrl(), bSystemConnection.getCimNamespace(), bSystemConnection.getCimom().getUserId(), bSystemConnection.getCimom().getPassword()});
            pParameters.put("CAPABILITY", bSystemConnection.getCapability());
            pParameters.put("TL_CS", bSystemConnection.getSubsystemCop());
            pParameters.put("VENDOR", bSystemConnection.getSubsystem().getVendor());
            pParameters.put("MODEL", bSystemConnection.getSubsystem().getModel());
            pParameters.put("CIMOMSWLVL", bSystemConnection.getCimom().getSoftwareLevel());
        }
        UStack mData = new UStack();
        mData.push(pParameters.get("CIMOMSWLVL"));
        mData.push(pParameters.get("MODEL"));
        mData.push(pParameters.get("VENDOR"));
        mData.push((Object)((CapabilityData)pParameters.get("CAPABILITY")).getSmisProfile());
        mData.push((Object)((CapabilityData)pParameters.get("CAPABILITY")).getSmisVersion());
        mData.push((Object)pProcessName);
        Object mProcess = this.findBestMatch(this.cProcessMap, mData, new MatchGauge());
        IDiscoverProcess bDiscoverInstance = null;
        if (mProcess != null) {
            try {
                if (mProcess.getClass().getName().equals(String.class.getName())) {
                    bDiscoverInstance = (IDiscoverProcess)this.getExtensionImpl((String)mProcess, false);
                } else {
                    Class mProcessClass = (Class)mProcess;
                    bDiscoverInstance = (IDiscoverProcess)mProcessClass.newInstance();
                    bDiscoverInstance.getRequest().setCommand(pProcessName);
                }
                return bDiscoverInstance;
            }
            catch (Exception e) {
                traceLogger.exception(Level.ERROR, (Object)this, "findProcess", (Throwable)e, "Exception during process creation for " + pProcessName + " with received object " + mProcess.toString());
            }
        } else {
            traceLogger.text(Level.ERROR, (Object)this, "findProcess", "No process found for " + pProcessName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void finish(Request pRequest, boolean pSubstatus, int returnCode) {
        String methodName = "finish";
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFORMATION, (Object)className, methodName, "Router.finish " + pRequest.getDeviceServerRunNumber() + ":" + pRequest.getId() + ", status=" + pSubstatus + ", returnCode=" + returnCode + "- request.isRunning=" + pRequest.isRunning() + ", hasRunningChildRequests=" + pRequest.hasRunningChildRequests() + ", Job status=" + JobEngine.getInstance().getJobStatus(Integer.toString(pRequest.getId())));
        }
        Object object = pRequest;
        synchronized (object) {
            if (!pSubstatus && pRequest.getStatus() != 0) {
                pRequest.setStatus(4);
                if (pRequest.getReturnCode() == 0) {
                    pRequest.setReturnCode(returnCode);
                } else if (pRequest.getReturnCode() < returnCode) {
                    pRequest.setReturnCode(returnCode);
                }
            }
        }
        if (!pRequest.isRunning() && !pRequest.hasRunningChildRequests() && JobEngine.getInstance().getJobStatus(Integer.toString(pRequest.getId())) == 2) {
            if (pRequest.getStatus() == 2) {
                pRequest.setStatus(1);
            }
            if (pRequest.getParentRequest() != null && pRequest.getParentRequest().getJobLogger() != null && pRequest.getParentRequest().getJobLogger() != pRequest.getJobLogger()) {
                pRequest.getParentRequest().getJobLogger().message(IRecordType.TYPE_INFORMATION, (Object)Router.class.getName(), "finish", "DiscoverJob_childJobFinished", (Object[])new String[]{new Integer(pRequest.getId()).toString(), new Integer(pRequest.getStatus()).toString(), new Integer(pRequest.getReturnCode()).toString()});
            }
            if (!pRequest.isNoJobManagement() && pRequest.isMainProcess()) {
                ServiceUtils.updateJobRecord((int)Integer.parseInt(pRequest.getDeviceServerRunNumber()), (int)pRequest.getId(), (int)pRequest.getStatus(), (int)pRequest.getReturnCode());
            }
            if (pRequest.isExternalJobLogger()) {
                pRequest.getJobLogger().message(IRecordType.TYPE_INFORMATION, (Object)Router.class.getName(), "finish", "DiscoverJob_jobFinished", (Object[])new String[]{pRequest.getDeviceServerRunNumber(), new Integer(pRequest.getId()).toString(), new Integer(pRequest.getStatus()).toString(), new Integer(pRequest.getReturnCode()).toString()});
            }
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFORMATION, (Object)className, methodName, "Finished DiscoverProcess: RUN ID=" + pRequest.getDeviceServerRunNumber() + ", Job ID=" + new Integer(pRequest.getId()).toString() + ", Status =" + new Integer(pRequest.getStatus()).toString() + ", Return Code=" + new Integer(pRequest.getReturnCode()).toString());
            }
            if (pRequest.isMainProcess()) {
                pRequest.getJobLogger().message(IRecordType.TYPE_INFORMATION, (Object)Router.class.getName(), "finish", "DiscoverJob_jobFinished", (Object[])new String[]{pRequest.getDeviceServerRunNumber(), new Integer(pRequest.getId()).toString(), new Integer(pRequest.getStatus()).toString(), new Integer(pRequest.getReturnCode()).toString()});
                if (!pRequest.isExternalJobLogger()) {
                    LogManagerFactory.returnJobLogger((ILogger)pRequest.getJobLogger());
                }
            }
            this.cRequestMap.remove(Integer.toString(pRequest.getId()));
            JobEngine.getInstance().addFinishedRequests(pRequest.getDeviceServerRunNumber(), Integer.toString(pRequest.getId()));
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_INFORMATION, (Object)className, methodName, "Router.finished - " + pRequest.getId());
            }
            if (pRequest.getParentRequest() != null) {
                object = pRequest.getParentRequest();
                synchronized (object) {
                    pRequest.getParentRequest().removeChildRequest(pRequest);
                }
                this.finish(pRequest.getParentRequest(), pRequest.getReturnCode() == 0, pRequest.getReturnCode());
            } else {
                Object o = ServiceUtils.activeJobs.remove(pRequest.getDeviceServerRunNumber());
                if (o != null) {
                    ServiceUtils.completedJobResults.put(pRequest.getDeviceServerRunNumber(), o);
                } else {
                    AsyncResult result = ServiceUtils.getJobStatus((String)pRequest.getDeviceServerRunNumber());
                    if (ServiceUtils.populateResults((AsyncResult)result, (boolean)true)) {
                        ServiceUtils.completedJobResults.put(pRequest.getDeviceServerRunNumber(), result);
                    } else {
                        JobEngine.getInstance().cleanupRequestInformation(pRequest.getDeviceServerRunNumber());
                    }
                }
            }
            object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
        }
    }

    public DiscoverProcess.RegistrationData[] getRegisteredProcesses() {
        List mResult = this.recurseRequests(this.cProcessMap, new UStack());
        return mResult.toArray(new DiscoverProcess.RegistrationData[mResult.size()]);
    }

    public DiscoverProcess.RegistrationData[] getRegisteredProcessNames() {
        List mResult = this.recurseRequests(this.cProcessMap, new UStack());
        return mResult.toArray(new DiscoverProcess.RegistrationData[mResult.size()]);
    }

    public DiscoverProcess.RegistrationData[] getRegisteredSteps() {
        List mResult = this.recurseRequests(this.cStepMap, new UStack());
        return mResult.toArray(new DiscoverProcess.RegistrationData[mResult.size()]);
    }

    public List getRequests() {
        return this.getRequests(ROOT);
    }

    public List getRequests(String pParentRequest) {
        ArrayList<Object[]> mResult = new ArrayList<Object[]>();
        ArrayList mRequests = (ArrayList)this.cRequestMap.get(pParentRequest);
        if (mRequests != null) {
            for (String bRequest : mRequests) {
                Object[] bResult = new Object[]{bRequest, this.getRequests(bRequest), JobEngine.getInstance().getJobs(bRequest)};
                mResult.add(bResult);
            }
        }
        return mResult;
    }

    public Request getRequest(String pId) {
        return (Request)this.cRequestMap.get(pId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getSupportedRequests() {
        HashMap<String, DiscoverRequest> mResult = new HashMap<String, DiscoverRequest>();
        Map<String, IDiscoverProcess> map = this.cLegacyProcessMap;
        synchronized (map) {
            for (Map.Entry<String, IDiscoverProcess> bElement : this.cLegacyProcessMap.entrySet()) {
                mResult.put(bElement.getKey(), ((DiscoverProcess)bElement.getValue()).getRequest());
            }
        }
        return mResult;
    }

    public String[] perform(String pProcessName, Map pParameters) {
        return this.perform(pProcessName, pParameters, ROOT, false, null);
    }

    public String[] perform(String pProcessName, Map pParameters, String pParentRequestName) {
        return this.perform(pProcessName, pParameters, pParentRequestName, false, null);
    }

    public String[] perform(String pProcessName, Map pParameters, boolean pNoJobManagement, ILogger logger) {
        return this.perform(pProcessName, pParameters, ROOT, pNoJobManagement, logger);
    }

    /*
     * Exception decompiling
     */
    public String[] perform(String pProcessName, Map pParameters, String pParentRequestName, boolean pNoJobManagement, ILogger pJobLogger) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List recurseRequests(Map pMap, UStack pParameterStack) {
        ArrayList<DiscoverProcess.RegistrationData> mResult = new ArrayList<DiscoverProcess.RegistrationData>();
        Map map = pMap;
        synchronized (map) {
            for (Map.Entry mEntry : pMap.entrySet()) {
                pParameterStack.push(mEntry.getKey());
                if (mEntry.getValue() instanceof Map) {
                    mResult.addAll(this.recurseRequests((Map)mEntry.getValue(), pParameterStack));
                } else {
                    UStack bStack = new UStack(pParameterStack);
                    String bIVersion = (String)bStack.pop();
                    String bModel = (String)bStack.pop();
                    String bVendor = (String)bStack.pop();
                    String bProfile = (String)bStack.pop();
                    String bSmis = (String)bStack.pop();
                    String bProcess = (String)bStack.pop();
                    DiscoverProcess.RegistrationData bData = new DiscoverProcess.RegistrationData(bProcess, bSmis, bProfile, bVendor, bModel, bIVersion);
                    mResult.add(bData);
                }
                pParameterStack.pop();
            }
        }
        return mResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerProcess(Class pProcessClass) throws InvalidClassException {
        DiscoverProcess.RegistrationData[] mRegistration;
        Class mSuperclass = pProcessClass;
        do {
            if ((mSuperclass = mSuperclass.getSuperclass()) != null) continue;
            throw new InvalidClassException(pProcessClass.getName(), "Class doesn't extend " + DiscoverProcess.class.getName());
        } while (!mSuperclass.equals(DiscoverProcess.class));
        try {
            Method mGetRegistrationData = pProcessClass.getMethod("getRegistrationData", new Class[0]);
            mRegistration = (DiscoverProcess.RegistrationData[])mGetRegistrationData.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            throw new InvalidClassException(pProcessClass.getName(), "Class doesn't implement getRegistrationData() properly.");
        }
        for (int i = 0; i < mRegistration.length; ++i) {
            UStack bStack = new UStack();
            bStack.push((Object)mRegistration[i].getInstrumentationVersion());
            bStack.push((Object)mRegistration[i].getModel());
            bStack.push((Object)mRegistration[i].getVendor());
            bStack.push((Object)mRegistration[i].getProfile());
            bStack.push((Object)mRegistration[i].getSmisVersion());
            bStack.push((Object)mRegistration[i].getName());
            Map map = this.cProcessMap;
            synchronized (map) {
                String bKey = (String)bStack.pop();
                Map bMap = this.cProcessMap;
                while (!bStack.empty()) {
                    bMap = Router.getInnerMap(bMap, bKey);
                    bKey = (String)bStack.pop();
                }
                if (bMap.containsKey(bKey)) {
                    throw new IllegalArgumentException("Registration of DiscoverProcess " + pProcessClass.getName() + " failed! Pattern for process " + mRegistration[i].getName() + " already registered.");
                }
                bMap.put(bKey, pProcessClass);
                continue;
            }
        }
        return true;
    }

    public void addProcess(String pName, IDiscoverProcess pProcess) {
        pProcess.getRequest().setCommand(pName);
        this.cLegacyProcessMap.put(pName, pProcess);
    }

    public void update(Observable pObservable, Object pObj) {
        Request mRequest;
        String methodName = "update";
        JobInfo mJob = (JobInfo)pObj;
        if (traceLogger.isLogging()) {
            traceLogger.text(IRecordType.TYPE_INFORMATION, (Object)className, methodName, "Router.update - notified that job " + mJob.getId() + " has changed state.");
        }
        if ((mRequest = (Request)this.cRequestMap.get(mJob.getDiscoverRequest())) == null) {
            if (traceLogger.isLogging()) {
                traceLogger.text(IRecordType.TYPE_ERROR, (Object)className, methodName, "Error - no status for RequestID " + mJob.getDiscoverRequest());
            }
            return;
        }
        this.finish(mRequest, mJob.isSuccessful(), mJob.getReturnCode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJobStatus() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("CURRENT JOB STATUS\n");
        if (this.cRequestMap.isEmpty()) {
            buffer.append("No jobs are currently running.");
        } else {
            Map map = this.cRequestMap;
            synchronized (map) {
                Iterator i = this.cRequestMap.values().iterator();
                while (i.hasNext()) {
                    buffer.append("-----------------------\n");
                    Request request = (Request)i.next();
                    buffer.append("  Request: " + request.getId() + " Device Server Run ID: " + request.getDeviceServerRunNumber() + " hasRunningChildRequests: " + request.hasRunningChildRequests() + " isRunning: " + request.isRunning() + " status: " + request.getStatus() + "\n");
                    buffer.append("   Sub Requests: ");
                    Request[] subRequests = request.getChildRequests();
                    for (int ii = 0; ii < subRequests.length; ++ii) {
                        buffer.append(subRequests[ii].getId());
                    }
                    buffer.append("\n");
                    ArrayList jobs = JobEngine.getInstance().getJobs(new Integer(request.getId()).toString());
                    for (int ii = 0; ii < jobs.size(); ++ii) {
                        buffer.append(jobs.get(ii) + "\n");
                    }
                }
            }
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForJobToComplete(String deviceServerRunId) {
        boolean done = false;
        while (!done) {
            done = true;
            Object object = this.cRequestMap;
            synchronized (object) {
                for (Request request : this.cRequestMap.values()) {
                    if (!deviceServerRunId.equals(request.getDeviceServerRunNumber())) continue;
                    done = false;
                    break;
                }
            }
            if (done) break;
            object = this.lock;
            synchronized (object) {
                if (this.cRequestMap.isEmpty()) {
                    done = true;
                } else {
                    try {
                        this.lock.wait(LOCK_WAIT_TIME);
                    }
                    catch (InterruptedException ie) {
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitTilComplete(String pRequestId) {
        while (this.cRequestMap.containsKey(pRequestId)) {
            try {
                Object object = this.lock;
                synchronized (object) {
                    this.lock.wait(LOCK_WAIT_TIME);
                }
            }
            catch (InterruptedException ie) {
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void waitTilComplete(String[] pRequestIds) {
        this.waitTilComplete(pRequestIds[1]);
    }

    private String[] getScheduleIdSidRunNumber(String input) {
        if (input.length() <= 1) {
            return null;
        }
        int index = input.indexOf(58);
        if (index < 0) {
            return null;
        }
        String sid_run_number = input.substring(0, index);
        String scheduleId = input.substring(index + 1);
        String[] scheduleIdSidRunNumber = new String[]{scheduleId, sid_run_number};
        return scheduleIdSidRunNumber;
    }

    public String getExtensionPointId() {
        return EXTENSION_POINT_ID;
    }

    protected void extensionAdded(String extensionId) {
        String method = "extensionAdded";
        try {
            this.handleDiscoverProcessExtension(extensionId, true);
        }
        catch (Exception e) {
            traceLogger.exception(Level.ERROR, (Object)this, method, (Throwable)e, "Failed to register extension " + extensionId + " for Extensionpoint " + this.getExtensionPointId());
        }
    }

    protected void extensionRemoved(String extensionId) {
        String method = "extensionRemoved";
        try {
            this.handleDiscoverProcessExtension(extensionId, false);
        }
        catch (Exception e) {
            traceLogger.exception(Level.ERROR, (Object)this, method, (Throwable)e, "Failed to deregister extension " + extensionId + " for Extensionpoint " + this.getExtensionPointId());
        }
    }

    private void handleDiscoverProcessExtension(String extensionId, boolean registerExtension) {
        IConfigurationElement[] elements;
        String extensionName = this.getExtensionAttribute(extensionId, ATTR_NAME);
        IExtension extension = this.getExtension(extensionId);
        if (extension != null && (elements = extension.getConfigurationElements()) != null) {
            IConfigurationElement[] smisRegistrations = elements[0].getChildren(ELEMENT_SMISREGISTRATIONDATA);
            for (int i = 0; i < smisRegistrations.length; ++i) {
                IConfigurationElement smisRegistrationData = smisRegistrations[i];
                this.registerSMISProcess(extensionId, extensionName, smisRegistrationData, registerExtension);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerSMISProcess(String pExtensionID, String pName, IConfigurationElement pConfigElement, boolean registerExtension) {
        if (ELEMENT_SMISREGISTRATIONDATA.equals(pConfigElement.getName())) {
            UStack bStack = new UStack();
            bStack.push((Object)pConfigElement.getAttribute(ATTR_SMISPROVIDERVERION));
            bStack.push((Object)pConfigElement.getAttribute(ATTR_MODEL));
            bStack.push((Object)pConfigElement.getAttribute(ATTR_VENDOR));
            bStack.push((Object)pConfigElement.getAttribute(ATTR_SMISPROFILE));
            bStack.push((Object)pConfigElement.getAttribute(ATTR_SMISVERSION));
            bStack.push((Object)pName);
            Map map = this.cProcessMap;
            synchronized (map) {
                String bKey = (String)bStack.pop();
                Map bMap = this.cProcessMap;
                while (!bStack.empty()) {
                    bMap = Router.getInnerMap(bMap, bKey);
                    bKey = (String)bStack.pop();
                }
                if (bMap.containsKey(bKey)) {
                    if (!registerExtension) {
                        bMap.remove(bKey);
                    } else {
                        throw new IllegalArgumentException("Registration of DiscoverProcess " + pExtensionID + " failed! Pattern for process " + pName + " already registered.");
                    }
                }
                bMap.put(bKey, pExtensionID);
            }
        } else {
            throw new IllegalArgumentException("No SMISRegistrationData Extensionelement passed.");
        }
    }

    static {
        String methodName = "Initialization";
        msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
    }

    private static final class MatchGauge {
        private int mPreciseMatchCount;
        private int mLevel;
        private int mMatchPattern;

        public MatchGauge() {
            this.mPreciseMatchCount = 0;
            this.mLevel = 0;
            this.mMatchPattern = 0;
        }

        public MatchGauge(MatchGauge rhs) {
            this.mPreciseMatchCount = rhs.mPreciseMatchCount;
            this.mLevel = rhs.mLevel;
            this.mMatchPattern = rhs.mMatchPattern;
        }

        public MatchGauge countPreciseMatch() {
            ++this.mLevel;
            ++this.mPreciseMatchCount;
            this.mMatchPattern += 1 << this.mLevel;
            return this;
        }

        public MatchGauge countGenericMatch() {
            ++this.mLevel;
            return this;
        }

        public void markMismatch() {
            this.mPreciseMatchCount = -1;
        }

        public MatchGauge concat(MatchGauge rhs) {
            if (rhs.mPreciseMatchCount == -1) {
                this.markMismatch();
            } else {
                this.mPreciseMatchCount += rhs.mPreciseMatchCount;
                this.mMatchPattern += rhs.mMatchPattern << this.mLevel;
                this.mLevel += rhs.mLevel;
            }
            return this;
        }

        public boolean less(MatchGauge rhs) {
            return this.mPreciseMatchCount != rhs.mPreciseMatchCount ? this.mPreciseMatchCount < rhs.mPreciseMatchCount : this.mMatchPattern < rhs.mMatchPattern;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append('(');
            buffer.append(this.mPreciseMatchCount);
            buffer.append(',');
            buffer.append(this.mMatchPattern);
            buffer.append(',');
            buffer.append(this.mLevel);
            buffer.append(')');
            return buffer.toString();
        }
    }
}

