/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.control.ControlEngine;
import org.eclipse.aperi.control.data.JobInfo;
import org.eclipse.aperi.discovery.JobEngine;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.interfaces.DiscoverRequest;

public class DiscoverUtils {
    public static Hashtable parseParameters(String[] args, DiscoverRequest request) throws Exception {
        Hashtable<String, String[]> parameters = new Hashtable<String, String[]>();
        for (int i = 1; i < args.length; ++i) {
            Object v;
            System.out.println(args[i]);
            int offset = args[i].indexOf(61);
            if (offset == -1) {
                throw new Exception("Invalid parameter format");
            }
            String name = args[i].substring(0, offset).trim();
            String value = args[i].substring(offset + 1).trim();
            String type = request.getParameterType(name);
            if (type == null) {
                throw new Exception("Parameter " + name + " is not a parameter for this request.");
            }
            Class<?> klass = Class.forName(type);
            if (type.equals("[Ljava.lang.String;")) {
                StringTokenizer token = new StringTokenizer(value, ",");
                ArrayList<String[]> values = new ArrayList<String[]>();
                while (token.hasMoreTokens()) {
                    v = (String[])token.nextElement();
                    values.add((String[])v);
                }
                v = values.toArray(new String[0]);
                parameters.put(name, (String[])v);
                continue;
            }
            Class[] constructorArgClasses = new Class[]{String.class};
            Object[] constructorArgs = new Object[]{value};
            v = klass.getConstructor(constructorArgClasses).newInstance(constructorArgs);
            parameters.put(name, (String[])v);
        }
        return parameters;
    }

    public static final Map setProbeTimeout(Map pProbeParams, long pTimeout, LogTraceHelper pLTH) {
        try {
            String[] mTarget = (String[])pProbeParams.get("CIMOM");
            if (mTarget == null) {
                pLTH.traceWarning("Error setting probe timeout to " + pTimeout + ". No target.");
                return pProbeParams;
            }
            if (mTarget.length < 5) {
                String[] bNewTarget = new String[5];
                System.arraycopy(mTarget, 0, bNewTarget, 0, mTarget.length);
                mTarget = bNewTarget;
            }
            if (pTimeout > 0L) {
                mTarget[4] = "" + pTimeout;
                pLTH.traceHigh("Set probe timeout to " + pTimeout);
            } else {
                mTarget[4] = null;
                pLTH.traceHigh("Set probe timeout to default");
            }
            pProbeParams.put("CIMOM", mTarget);
            return pProbeParams;
        }
        catch (Exception pEx) {
            pLTH.traceError("Error setting probe timeout to " + pTimeout, (Throwable)pEx);
            return pProbeParams;
        }
    }

    public static AsyncResult waitForJobToComplete(String jobId) {
        AsyncResult result = null;
        Object ajob = ServiceUtils.activeJobs.get(jobId);
        if (ajob != null) {
            if (ajob instanceof JobInfo) {
                ControlEngine ce = ControlEngine.getInstance();
                result = ce.waitForJobToComplete(jobId);
                ServiceUtils.completedJobResults.remove(jobId);
            }
        } else {
            result = (AsyncResult)ServiceUtils.completedJobResults.get(jobId);
            if (result != null) {
                ServiceUtils.completedJobResults.remove(jobId);
                JobEngine.getInstance().cleanupRequestInformation(jobId);
            } else {
                Router.getRouter().waitForJobToComplete(jobId);
                return ServiceUtils.getJobStatus((String)jobId);
            }
        }
        return result;
    }

    public static AsyncResult cancelJob(String jobId) {
        Object ajob = ServiceUtils.activeJobs.get(jobId);
        if (ajob != null) {
            if (ajob instanceof JobInfo) {
                ControlEngine ce = ControlEngine.getInstance();
                ce.cancelJob(jobId);
            }
        } else {
            Router.getRouter().cancel(jobId);
        }
        return ServiceUtils.getJobStatus((String)jobId);
    }
}

