/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.DiscoverService;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.discovery.interfaces.IDiscoverRouterService;
import org.eclipse.aperi.interfaces.IDiscover;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IService;
import org.eclipse.aperi.util.ServiceUtil;
import org.eclipse.aperi.util.osgi.IDisposable;
import org.eclipse.aperi.util.osgi.ServiceHelper;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class DiscoveryActivator
implements BundleActivator,
IDisposable {
    ServiceUtil _serviceMgmtUtil = null;
    public static ServiceHelper _serviceHelper;
    private static Vector<IDisposable> _disposables;
    private static BundleContext _bundleContext;
    ServiceRegistration _discoverRouterSrvReg;

    public void start(BundleContext context) throws Exception {
        _bundleContext = context;
        this._serviceMgmtUtil = new ServiceUtil();
        _disposables = new Vector();
        DiscoveryActivator.registerDisposable((IDisposable)this._serviceMgmtUtil);
        DiscoveryActivator.registerDisposable(this);
        _bundleContext = context;
        this._serviceMgmtUtil = new ServiceUtil();
        _serviceHelper = new ServiceHelper(_bundleContext);
        DiscoveryActivator.registerDisposable((IDisposable)_serviceHelper);
        Hashtable<String, String> mServiceProperties = new Hashtable<String, String>();
        ((Dictionary)mServiceProperties).put("org.eclipse.aperi.webservice.name", "DiscoverService");
        Router mRouter = Router.getRouter();
        mRouter.startup();
        this._discoverRouterSrvReg = context.registerService(IDiscoverRouterService.class.getName(), (Object)mRouter, null);
        String[] mDiscoveryServices = new String[]{IService.class.getName()};
        DiscoverService discoverService = new DiscoverService();
        this._serviceMgmtUtil.addService((IService)discoverService, IDiscover.class, mServiceProperties);
        this._serviceMgmtUtil.addService((IService)discoverService, IService.class, mServiceProperties);
        this._serviceMgmtUtil.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        this._serviceMgmtUtil.stop();
        this._discoverRouterSrvReg.unregister();
        _serviceHelper.dispose();
        Router.getRouter().clear();
        this.disposeAll();
        _disposables = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerDisposable(IDisposable disposable) {
        Vector<IDisposable> vector = _disposables;
        synchronized (vector) {
            _disposables.add(disposable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeAll() {
        Vector<IDisposable> vector = _disposables;
        synchronized (vector) {
            for (IDisposable disposable : _disposables) {
                disposable.dispose();
                _disposables.remove(disposable);
            }
        }
    }

    public static Object getService(Class serviceClass) {
        return DiscoveryActivator.getService(_bundleContext, serviceClass, null);
    }

    public static Object getService(BundleContext context, Class serviceClass, ServiceTrackerCustomizer customizer) {
        Object serviceObject = null;
        ServiceTracker tracker = new ServiceTracker(context, serviceClass.getName(), customizer);
        if (tracker != null) {
            tracker.open();
            serviceObject = tracker.getService();
            tracker.close();
        }
        return serviceObject;
    }

    public void dispose() {
        this._serviceMgmtUtil = null;
        _bundleContext = null;
    }

    static {
        _disposables = null;
        _bundleContext = null;
    }
}

