/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.parser;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.discovery.interfaces.ObjectResponse;
import org.eclipse.aperi.discovery.parser.AlertProcessor;
import org.eclipse.aperi.disk.common.CIMOMManager;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.RegisteredCimom;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.MapperRouter;
import org.eclipse.aperi.sanmgmt.logging.ILogger;
import org.eclipse.aperi.sanmgmt.logging.IRecordType;
import org.eclipse.aperi.sanmgmt.logging.LogManagerFactory;
import org.eclipse.aperi.util.queue.DefaultJobQueue;
import org.eclipse.aperi.util.queue.IJobQueue;
import org.eclipse.aperi.util.queue.QueueController;
import org.sblim.slp.ServiceLocationAttribute;

public class SLPObjectParser
extends Thread {
    public static String queueName = "SLPObjectParser";
    private DBConnection connection = null;
    private boolean shutdown = false;
    private Thread thread = null;
    public static final String MESSAGE_NAME = "aperi.logger.message.SLPObjectParser";
    public static final String TRACE_NAME = "aperi.logger.trace.SLPObjectParser";
    public static String MSG_FILE = "org.eclipse.aperi.discovery.parser.resources.MsgLoggingTMS";
    private static final String PROCESSID_PREFIX = "S";
    private static String className = SLPObjectParser.class.getName();
    public static ILogger msgLogger = null;
    public static ILogger traceLogger = null;

    public SLPObjectParser() {
        this.setName(queueName + " (" + this.getName() + ")");
        QueueController.getInstance().addQueue(queueName, (IJobQueue)new DefaultJobQueue());
        this.start();
    }

    private DBConnection getConnection() {
        String methodName = "getConnection";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        try {
            DBConnPoolDataSource ds = DBConnPoolDataSource.getInstance();
            DBConnection dbc = (DBConnection)ds.getPooledConnection();
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
            return dbc;
        }
        catch (Exception e) {
            if (traceLogger.isLogging()) {
                traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
            msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            if (traceLogger.isLogging()) {
                traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
            }
            return null;
        }
    }

    public Hashtable parse(Vector parameters) {
        String methodName = "parse";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        Hashtable<String, String> map = new Hashtable<String, String>();
        for (Object oAttrib : parameters) {
            if (oAttrib instanceof ServiceLocationAttribute) {
                ServiceLocationAttribute attribute = (ServiceLocationAttribute)oAttrib;
                String key = attribute.getId();
                Vector values = attribute.getValues();
                if (values == null || values.size() == 0) {
                    if (!traceLogger.isLogging()) continue;
                    String msg = "Parsing warning: " + attribute.toString() + " does not have a value.";
                    traceLogger.text(IRecordType.TYPE_WARNING, (Object)className, methodName, msg);
                    continue;
                }
                if (values.size() == 1) {
                    map.put(key, values.elementAt(0).toString());
                    continue;
                }
                map.put(key, values.toString());
                continue;
            }
            if (!traceLogger.isLogging()) continue;
            String msg = queueName + ": Invalid object type (ServiceLocationAttribute expected): " + oAttrib.getClass();
            traceLogger.text(IRecordType.TYPE_WARNING, (Object)className, methodName, msg);
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        methodName = "run";
        if (SLPObjectParser.traceLogger.isLogging()) {
            SLPObjectParser.traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)SLPObjectParser.className, methodName);
        }
        SLPObjectParser.msgLogger.message(IRecordType.TYPE_INFO, (Object)SLPObjectParser.className, methodName, "SLPObjectParser_Started");
        this.thread = Thread.currentThread();
        table = new RegisteredCimom();
        while (!this.shutdown) {
            block48: {
                block51: {
                    block46: {
                        block50: {
                            block44: {
                                if (SLPObjectParser.traceLogger.isLogging()) {
                                    msg = SLPObjectParser.queueName + ": waiting for a job";
                                    SLPObjectParser.traceLogger.text(IRecordType.TYPE_INFO, (Object)SLPObjectParser.className, methodName, msg);
                                }
                                job = QueueController.getInstance().getNextJob(SLPObjectParser.queueName);
                                if (this.shutdown) continue;
                                if (job == null) {
                                    if (!SLPObjectParser.traceLogger.isLogging()) continue;
                                    msg = SLPObjectParser.queueName + ":Error - got a NULL job from the queue";
                                    SLPObjectParser.traceLogger.text(IRecordType.TYPE_ERROR, (Object)SLPObjectParser.className, methodName, msg);
                                    continue;
                                }
                                jobLogger = null;
                                request = Router.getRouter().getRequest(job.getDiscoverRequest());
                                if (request != null) {
                                    jobLogger = request.getJobLogger();
                                }
                                if (jobLogger != null) {
                                    jobLogger.message(IRecordType.TYPE_INFORMATION, (Object)SLPObjectParser.className, methodName, "SLPObjectParserJob_Run", (Object[])new String[]{request.getDeviceServerRunNumber(), String.valueOf(request.getId())});
                                }
                                if (!((response = job.getRequest()) instanceof ObjectResponse)) break block48;
                                if (SLPObjectParser.traceLogger.isLogging()) {
                                    msg = SLPObjectParser.queueName + ": Received an Object response";
                                    SLPObjectParser.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)SLPObjectParser.className, methodName, msg);
                                }
                                try {
                                    try {
                                        block45: {
                                            block52: {
                                                this.connection = this.getConnection();
                                                cimomAttributes = (Vector)response.getData();
                                                SLPObjectParser.msgLogger.message(IRecordType.TYPE_INFO, (Object)SLPObjectParser.className, methodName, "SLPObjectParser_NumCIMOMsFound", (Object)String.valueOf(cimomAttributes.size()));
                                                if (jobLogger != null) {
                                                    jobLogger.message(IRecordType.TYPE_INFORMATION, (Object)SLPObjectParser.className, methodName, "SLPObjectParser_NumCIMOMsFound", (Object)String.valueOf(cimomAttributes.size()));
                                                }
                                                mResVec = new Vector<MapperResult>();
lbl36:
                                                // 5 sources

                                                for (Vector attributes : cimomAttributes) {
                                                    block43: {
                                                        properties = this.parse(attributes);
                                                        if (SLPObjectParser.traceLogger.isLogging()) {
                                                            msg = "Found Cimom. Properties are: " + properties;
                                                            SLPObjectParser.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)SLPObjectParser.className, methodName, msg);
                                                        }
                                                        try {
                                                            mr = MapperRouter.getMapperRouter();
                                                            mapper = mr.findMapper("SLP", null, null, null);
                                                            if (mapper == null) {
                                                                if (!SLPObjectParser.traceLogger.isLogging()) break block43;
                                                                msg = "DB Mapper does not exist for CIMOM " + properties;
                                                                SLPObjectParser.traceLogger.text(IRecordType.TYPE_ERROR, (Object)SLPObjectParser.className, methodName, msg);
                                                                SLPObjectParser.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)SLPObjectParser.className, methodName);
                                                            }
                                                            ** GOTO lbl-1000
                                                        }
                                                        catch (Exception e) {
                                                            if (SLPObjectParser.traceLogger.isLogging()) {
                                                                SLPObjectParser.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, methodName, (Throwable)e);
                                                            }
                                                            SLPObjectParser.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, methodName, (Throwable)e);
                                                            if (jobLogger != null) {
                                                                jobLogger.message(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, methodName, "SLPObjectParserJob_Error", (Object[])new String[]{request.getDeviceServerRunNumber(), String.valueOf(request.getId()), e.getMessage()});
                                                            }
                                                            try {
                                                                this.connection.rollback();
                                                            }
                                                            catch (SQLException ignore) {}
                                                            continue;
                                                        }
                                                    }
                                                    var16_18 = null;
                                                    break block44;
                                                }
                                                break block52;
lbl-1000:
                                                // 1 sources

                                                {
                                                    if (properties.isEmpty() || properties.get("template-url-syntax") == null) ** GOTO lbl36
                                                    mResVec.add(mapper.persist(this.connection, properties, null));
                                                }
                                                ** GOTO lbl36
                                            }
                                            this.connection.commit();
                                            this.connection.close();
                                            this.connection = null;
                                            cm = CIMOMManager.getCIMOMManager();
                                            cms = cm.getCIMOMs();
                                            mrEnum = mResVec.elements();
                                            while (mrEnum.hasMoreElements()) {
                                                mRes = (MapperResult)mrEnum.nextElement();
                                                AlertProcessor.processAlerts("S" + CIMOMManager.getUniqueNumberString(), mRes, new Hashtable<K, V>(), new Hashtable<K, V>());
                                            }
                                            try {
                                                cm.testCIMOMConnection(cms);
                                            }
                                            catch (ServerException e) {
                                                if (SLPObjectParser.traceLogger.isLogging()) {
                                                    SLPObjectParser.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, methodName, (Throwable)e);
                                                }
                                                SLPObjectParser.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, methodName, (Throwable)e);
                                                if (jobLogger == null) break block45;
                                                jobLogger.message(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, methodName, "SLPObjectParserJob_Error", (Object[])new String[]{request.getDeviceServerRunNumber(), String.valueOf(request.getId()), e.getMessage()});
                                            }
                                        }
                                        job.setReturnCode(0);
                                        job.complete(true);
                                        break block46;
                                    }
                                    catch (Throwable e) {
                                        block47: {
                                            if (SLPObjectParser.traceLogger.isLogging()) {
                                                SLPObjectParser.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, methodName, e);
                                            }
                                            SLPObjectParser.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, methodName, e);
                                            if (jobLogger != null) {
                                                jobLogger.message(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, methodName, "SLPObjectParserJob_Error", (Object[])new String[]{request.getDeviceServerRunNumber(), String.valueOf(request.getId()), e.getMessage()});
                                            }
                                            job.setReturnCode(99);
                                            job.complete(false);
                                            var16_18 = null;
                                            try {
                                                if (this.connection != null) {
                                                    this.connection.close();
                                                    this.connection = null;
                                                }
                                            }
                                            catch (Exception e) {
                                                if (SLPObjectParser.traceLogger.isLogging()) {
                                                    SLPObjectParser.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, methodName, (Throwable)e);
                                                }
                                                SLPObjectParser.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, methodName, (Throwable)e);
                                                if (jobLogger == null) break block47;
                                                jobLogger.message(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, methodName, "SLPObjectParserJob_Error", (Object[])new String[]{request.getDeviceServerRunNumber(), String.valueOf(request.getId()), e.getMessage()});
                                            }
                                        }
                                        response.close();
                                        break block48;
                                    }
                                }
                                catch (Throwable var15_21) {
                                    block49: {
                                        var16_18 = null;
                                        ** try [egrp 6[TRYBLOCK] [10 : 1102->1124)] { 
lbl123:
                                        // 1 sources

                                        if (this.connection != null) {
                                            this.connection.close();
                                            this.connection = null;
                                        }
                                        break block49;
lbl127:
                                        // 1 sources

                                        catch (Exception e) {
                                            if (SLPObjectParser.traceLogger.isLogging()) {
                                                SLPObjectParser.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, methodName, (Throwable)e);
                                            }
                                            SLPObjectParser.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, methodName, (Throwable)e);
                                            if (jobLogger == null) break block49;
                                            jobLogger.message(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, methodName, "SLPObjectParserJob_Error", (Object[])new String[]{request.getDeviceServerRunNumber(), String.valueOf(request.getId()), e.getMessage()});
                                        }
                                    }
                                    response.close();
                                    throw var15_21;
                                }
                            }
                            ** try [egrp 6[TRYBLOCK] [10 : 1102->1124)] { 
lbl138:
                            // 1 sources

                            if (this.connection != null) {
                                this.connection.close();
                                this.connection = null;
                            }
                            break block50;
lbl142:
                            // 1 sources

                            catch (Exception e) {
                                if (SLPObjectParser.traceLogger.isLogging()) {
                                    SLPObjectParser.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, methodName, (Throwable)e);
                                }
                                SLPObjectParser.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, methodName, (Throwable)e);
                                if (jobLogger == null) break block50;
                                jobLogger.message(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, methodName, "SLPObjectParserJob_Error", (Object[])new String[]{request.getDeviceServerRunNumber(), String.valueOf(request.getId()), e.getMessage()});
                            }
                        }
                        response.close();
                        return;
                    }
                    var16_18 = null;
                    ** try [egrp 6[TRYBLOCK] [10 : 1102->1124)] { 
lbl154:
                    // 1 sources

                    if (this.connection != null) {
                        this.connection.close();
                        this.connection = null;
                    }
                    break block51;
lbl158:
                    // 1 sources

                    catch (Exception e) {
                        if (SLPObjectParser.traceLogger.isLogging()) {
                            SLPObjectParser.traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, methodName, (Throwable)e);
                        }
                        SLPObjectParser.msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, methodName, (Throwable)e);
                        if (jobLogger == null) break block51;
                        jobLogger.message(IRecordType.TYPE_ERROR_EXC, (Object)SLPObjectParser.className, methodName, "SLPObjectParserJob_Error", (Object[])new String[]{request.getDeviceServerRunNumber(), String.valueOf(request.getId()), e.getMessage()});
                    }
                }
                response.close();
            }
            if (!SLPObjectParser.traceLogger.isLogging()) continue;
            msg = SLPObjectParser.queueName + ": Finishing job";
            SLPObjectParser.traceLogger.text(IRecordType.TYPE_MISC_DATA, (Object)SLPObjectParser.className, methodName, msg);
        }
        if (!SLPObjectParser.traceLogger.isLogging()) return;
        SLPObjectParser.traceLogger.exit(IRecordType.TYPE_EXIT, (Object)SLPObjectParser.className, methodName);
    }

    public void shutdown() {
        String methodName = "shutdown";
        if (traceLogger.isLogging()) {
            traceLogger.entry(IRecordType.TYPE_ENTRY, (Object)className, methodName);
        }
        this.shutdown = true;
        if (this.thread != null) {
            msgLogger.message(IRecordType.TYPE_INFO, (Object)className, methodName, "SLPObjectParser_Shutdown");
            try {
                this.thread.interrupt();
                this.thread.join(30000L);
                this.thread = null;
            }
            catch (Exception e) {
                if (traceLogger.isLogging()) {
                    traceLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
                }
                msgLogger.exception(IRecordType.TYPE_ERROR_EXC, (Object)className, methodName, (Throwable)e);
            }
        }
        if (traceLogger.isLogging()) {
            traceLogger.exit(IRecordType.TYPE_EXIT, (Object)className, methodName);
        }
    }

    static {
        msgLogger = LogManagerFactory.getMessageLogger((String)MESSAGE_NAME);
        traceLogger = LogManagerFactory.getTraceLogger((String)TRACE_NAME);
        msgLogger.setMessageFile(MSG_FILE);
    }
}

