/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.discovery.snmp.scanner.interfaces;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

public class Response
implements Serializable {
    private static final long serialVersionUID = 20001130L;
    public static final String level = "LEVEL";
    public static final String benchmarkLevel = "BENCHMARK";
    public static final String benchmarkLabel = "BENCHMARK LABEL";
    public static final String sameAsBenchmark = "SAME AS BENCHMARK";
    public static int RETURN_CODE_OK = 0;
    public static int RETURN_CODE_ERROR = 47;
    public static int RETURN_CODE_INACTIVE_SCANNER = 48;
    private Hashtable parameters = new Hashtable();
    private int returnCode;
    private byte[] data;

    public Response(int returnCode, String data) {
        this(returnCode, data, new Hashtable());
    }

    public Response(int returnCode, String[] data) {
        this(returnCode, data, new Hashtable());
    }

    public Response(int returnCode, String data, Hashtable parameters) {
        this.returnCode = returnCode;
        this.data = (byte[])(data != null && !data.equals("") ? this.compressData(data.getBytes()) : null);
    }

    public Response(int returnCode, String[] data, Hashtable parameters) {
        this.returnCode = returnCode;
        this.parameters = parameters;
        this.data = (byte[])(data != null && data.length != 0 ? this.compressData(this.convertToByteArray(data)) : null);
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public String getData() {
        if (this.data == null || this.data.length == 0) {
            return new String();
        }
        return new String(this.uncompressData(this.data));
    }

    public Hashtable getParameters() {
        return this.parameters;
    }

    public String toString() {
        String result = new String();
        result = result.concat("\nResponse object\n");
        result = result.concat("  Return code = " + this.returnCode + "\n");
        if (this.data != null) {
            result = result.concat("  Data = \n" + this.getData() + "\n\n");
        }
        return result;
    }

    private byte[] compressData(byte[] d) {
        byte[] bytes = null;
        if (d != null && d.length != 0) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                GZIPOutputStream gos = new GZIPOutputStream(baos);
                gos.write(d, 0, d.length);
                gos.close();
                bytes = baos.toByteArray();
            }
            catch (IOException e) {
                e.printStackTrace();
                bytes = null;
            }
        }
        return bytes;
    }

    private byte[] uncompressData(byte[] d) {
        String methodName = "uncompressData";
        byte[] bytes = null;
        if (d != null && d.length != 0) {
            try {
                int bytesRead;
                ByteArrayInputStream bais = new ByteArrayInputStream(d);
                GZIPInputStream gis = new GZIPInputStream(bais);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buffer = new byte[1024];
                while ((bytesRead = gis.read(buffer, 0, buffer.length)) != -1) {
                    baos.write(buffer, 0, bytesRead);
                }
                gis.close();
                bytes = baos.toByteArray();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return bytes;
    }

    private String convertToString(String[] s) {
        StringBuffer result = new StringBuffer();
        String str = null;
        if (s != null && s.length != 0) {
            for (int i = 0; i < s.length; ++i) {
                result.append(s[i]);
            }
            str = result.toString();
        }
        return str;
    }

    private byte[] convertToByteArray(String[] s) {
        byte[] bytes = null;
        if (s != null && s.length != 0) {
            bytes = this.convertToString(s).getBytes();
        }
        return bytes;
    }
}

