/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.collection;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.ProbePerfTracker;
import org.eclipse.aperi.discovery.TrackProbePerformance;
import org.eclipse.aperi.discovery.interfaces.DiscoveryException;
import org.eclipse.aperi.discovery.interfaces.JobInfo;
import org.eclipse.aperi.discovery.parser.AlertProcessor;
import org.eclipse.aperi.discovery.parser.CIMProcessor;
import org.eclipse.aperi.disk.api.impl.DiskManagerConfigSvc;
import org.eclipse.aperi.disk.common.CIMOMManager;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.disk.common.util.ExternalKeyConverter;
import org.eclipse.aperi.disk.common.util.exceptions.IDParseException;
import org.eclipse.aperi.infrastructure.database.ComplexQuery;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBPreparedStatement;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.infrastructure.database.SQLExceptionHelper;
import org.eclipse.aperi.infrastructure.database.objects.CapabilityData;
import org.eclipse.aperi.infrastructure.database.tables.TResCimkeyVolumeTable;
import org.eclipse.aperi.infrastructure.database.tables.TResCimom2namespaceTable;
import org.eclipse.aperi.infrastructure.database.tables.TResRegisteredCimomTable;
import org.eclipse.aperi.infrastructure.database.tables.TResStorageVolumeTable;
import org.eclipse.aperi.infrastructure.mapping.MapperResult;
import org.eclipse.aperi.infrastructure.mapping.MapperRouter;
import org.eclipse.aperi.interfaces.IDBAttributeMapper;
import org.sblim.wbem.cim.CIMInstance;
import org.sblim.wbem.cim.CIMObjectPath;

public class DiskCIMProcessor
extends CIMProcessor {
    protected String cSMISVersion;
    protected String cDeviceModel;
    protected String cInstrumentationVersion;
    protected Hashtable cDBReferences = null;
    protected String cCIMNamespace;
    protected String cCIMServiceURL;
    protected String cScannerId;
    protected String cDedicated = null;
    protected String cAlertID = null;
    protected int cRequestId = 0;
    private int cCommitThreshold = 0;
    private List cCommitBuffer = null;
    private int cDeadlockRetries = 0;
    private int cMaxRetryInterval = 0;
    private DBPreparedStatement cVolKeyStmt = null;
    private DBPreparedStatement cVolIDStmt = null;
    private DBPreparedStatement cPortIDStmt = null;
    private DBPreparedStatement cNSIDStmt = null;
    protected NamesIDCache cNamesCache = null;
    private Map cPortIDCache = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DiskCIMProcessor(String pScannerId) {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"DiskCIMProcessor", (Object[])new Object[]{pScannerId});
        try {
            this.cSMISVersion = "";
            this.cDeviceModel = "";
            this.cInstrumentationVersion = "";
            this.cCIMNamespace = "";
            this.cCIMServiceURL = "";
            this.cScannerId = pScannerId;
            this.cAlertID = null;
            this.cCommitBuffer = new ArrayList();
            this.cCommitThreshold = DiskManagerConfigSvc.getIntConfigValue((String)"Probe.CommitThreshold", (int)1);
            this.cDeadlockRetries = DiskManagerConfigSvc.getIntConfigValue((String)"Probe.Deadlock.MaxRetries", (int)2);
            this.cMaxRetryInterval = DiskManagerConfigSvc.getIntConfigValue((String)"Probe.Deadlock.MaxRetryInterval", (int)5000);
            this.cNamesCache = new NamesIDCache();
            this.cDBReferences = new Hashtable();
            this.cPortIDCache = new HashMap();
        }
        finally {
            mLTH.exit(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result initializeForSubsystemProbe(Map pParameters) {
        Result mResult = new Result();
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"initializeForSubsystemProbe", null);
        try {
            this.setSMISVersion(((CapabilityData)pParameters.get("CAPABILITY")).getSmisVersion());
            this.setDeviceModel((String)pParameters.get("MODEL"));
            this.setInstrumentationVersion((String)pParameters.get("CIMOMSWLVL"));
            this.setCIMNamespace(((String[])pParameters.get("CIMOM"))[1]);
            this.setCIMServiceURL(((String[])pParameters.get("CIMOM"))[0]);
            this.cAlertID = null;
            String mSubsystemID = (String)pParameters.get("SUBSYSTEMID");
            CIMObjectPath mCIMObjPath = (CIMObjectPath)pParameters.get("TL_CS");
            CIMInstance mCIMSubsystem = new CIMInstance(mCIMObjPath);
            pParameters.put("CIM_ComputerSystem", mCIMSubsystem);
            Hashtable mRefDBKeys = new Hashtable();
            mRefDBKeys.put("ref_toplevelsystem_id", pParameters.get("DEVICEID"));
            String[] mSubsysKey = null;
            try {
                mSubsysKey = ExternalKeyConverter.obtainStorageSubsystemKeyParts((String)mSubsystemID, (LogTraceHelper)mLTH);
            }
            catch (IDParseException bParseEX) {
                Result result = new Result(1);
                mLTH.exit((Object)mResult);
                return result;
            }
            mRefDBKeys.put("ref_toplevelsystem_name", mSubsysKey[0]);
            mRefDBKeys.put("ref_toplevelsystem_nameformat", mSubsysKey[1]);
            Hashtable mDBKeys = new Hashtable();
            mDBKeys.put(mCIMSubsystem.getClassName(), mRefDBKeys);
            this.setDBReferences(mDBKeys);
            mResult.setRc(0);
        }
        finally {
            mLTH.exit((Object)mResult);
        }
        return mResult;
    }

    public boolean start(int pRequestId) {
        CIMOMManager.getCIMOMManager().registerCIMOMUsage(this.cCIMServiceURL);
        this.cRequestId = pRequestId;
        this.cAlertID = discoverEventPrefix + pRequestId;
        TrackProbePerformance.startProbe(this.cScannerId);
        return super.start(pRequestId);
    }

    public MapperResult handleEntity(String pScannerID, String pCIMClassNameToPersist, Hashtable pCIMPropertiesToPersist) throws DiscoveryException {
        MapperResult mResult;
        block18: {
            LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"handleEntity", (Object[])new Object[]{pScannerID, pCIMClassNameToPersist});
            Hashtable mPropertiesToPersist = new Hashtable();
            mResult = null;
            String mScannerID = null;
            mScannerID = pScannerID == null || pScannerID.length() == 0 ? this.cScannerId : pScannerID;
            ProbePerfTracker.ProbeAction mProbeActionHandleEntity = TrackProbePerformance.startProbeAction(mScannerID, ProbePerfTracker.DISKCIMPROCESSOR_HANDLE_ENTITY);
            try {
                String mOriginalCIMClassName;
                if (mLTH.isTraceHighEnabled()) {
                    mLTH.traceHigh("Properties to persist: " + DiskMessageHelper.toMsgString((Object)pCIMPropertiesToPersist));
                }
                String mDBRefName = (mOriginalCIMClassName = (String)pCIMPropertiesToPersist.get("originalcimclassname")) != null ? mOriginalCIMClassName : pCIMClassNameToPersist;
                IDBAttributeMapper mMapper = MapperRouter.getMapperRouter().findMapper(pCIMClassNameToPersist, this.cSMISVersion, this.cDeviceModel, this.cInstrumentationVersion, this.cDedicated, mOriginalCIMClassName);
                if (mMapper == null) {
                    mLTH.traceWarning("DB Mapper does not exist for " + pCIMClassNameToPersist + " or original class " + mOriginalCIMClassName);
                    MapperResult mapperResult = null;
                    return mapperResult;
                }
                Enumeration mDBRefKeysEnum = this.cDBReferences.keys();
                while (mDBRefKeysEnum.hasMoreElements()) {
                    String bRefKey = (String)mDBRefKeysEnum.nextElement();
                    if (bRefKey.equals(mDBRefName)) continue;
                    Hashtable bCIMDBReferences = (Hashtable)this.cDBReferences.get(bRefKey);
                    mPropertiesToPersist.putAll(bCIMDBReferences);
                }
                mPropertiesToPersist.put("ref_namespace", this.cCIMNamespace);
                mPropertiesToPersist.put("ref_serviceurl", this.cCIMServiceURL);
                mPropertiesToPersist.put("ref_classname", pCIMClassNameToPersist);
                mPropertiesToPersist.putAll(pCIMPropertiesToPersist);
                mPropertiesToPersist = this.addSystemNameID(mPropertiesToPersist);
                String bMapper = mMapper.getClass().getName() + ".persist ";
                ProbePerfTracker.ProbeAction bTraceProbeAction = null;
                if (mLTH.isTraceHighEnabled()) {
                    mLTH.traceSvcEntry(bMapper, new Object[]{this.connection, mPropertiesToPersist, mScannerID});
                } else {
                    mLTH.traceSvcEntry(bMapper, null);
                }
                CommitBufferEntry bCBE = new CommitBufferEntry(mMapper, mPropertiesToPersist, mScannerID);
                this.cCommitBuffer.add(bCBE);
                bTraceProbeAction = TrackProbePerformance.startProbeAction(mScannerID, ProbePerfTracker.MAPPER_PERSIST);
                mResult = mMapper.persist(this.connection, mPropertiesToPersist, mScannerID);
                TrackProbePerformance.finishedProbeAction(bTraceProbeAction);
                bCBE.setKeyRefs(mResult.getKeyReferences());
                if (this.cAlertID != null) {
                    boolean isFirstProbe = false;
                    String firstProbe = (String)mPropertiesToPersist.get("ref_subsystem_migrated");
                    if (firstProbe != null && firstProbe.compareTo("1") == 0) {
                        isFirstProbe = true;
                    }
                    AlertProcessor.processAlerts(this.cAlertID, mResult, this.newEntities, this.modifiedEntities, isFirstProbe);
                }
                Hashtable mNewDBReferences = mResult.getKeyReferences();
                mLTH.traceSvcReturn(bMapper, (Object)mNewDBReferences);
                if (!mNewDBReferences.isEmpty()) {
                    this.cDBReferences.put(mDBRefName, mNewDBReferences);
                }
                this.commit(mLTH);
                TrackProbePerformance.finishedProbeAction(mProbeActionHandleEntity);
            }
            catch (SQLException bEx) {
                mLTH.traceWarning("SQL Exception while persisting properties: " + DiskMessageHelper.toMsgString(mPropertiesToPersist));
                mLTH.traceError(bEx.getMessage(), (Throwable)bEx);
                try {
                    this.handleSQLException(mLTH, bEx, "handle Entity");
                    break block18;
                }
                catch (SQLException bInnerEx) {
                    this.rollback(mLTH);
                    throw new DiscoveryException(bInnerEx);
                }
            }
            catch (Exception bEx) {
                mLTH.traceWarning("Exception while persisting properties: " + DiskMessageHelper.toMsgString(mPropertiesToPersist));
                mLTH.traceError(bEx.getMessage(), (Throwable)bEx);
                this.rollback(mLTH);
                throw new DiscoveryException(bEx);
            }
            finally {
                TrackProbePerformance.finishedProbeAction(mProbeActionHandleEntity);
                mLTH.exit(mResult);
            }
            mLTH.exit((Object)mResult);
        }
        return mResult;
    }

    public void handleSQLException(LogTraceHelper pLTH, SQLException bEx, String pSituation) throws SQLException {
        block10: {
            boolean mRethrow = false;
            boolean mNewConnection = false;
            try {
                boolean mClosedConneection = this.connection.isClosed();
                for (int mRetries = 0; this.connection != null && this.connection.isClosed() && mRetries < this.cDeadlockRetries; ++mRetries) {
                    if (pLTH != null) {
                        pLTH.traceWarning("Connection closed, obtaining new Connection");
                    }
                    this.connection = ServiceUtils.getConnection();
                    this.cVolKeyStmt = null;
                    this.cNamesCache.reset();
                }
                boolean bl = mNewConnection = this.connection != null && !this.connection.isClosed();
                if (mClosedConneection && mNewConnection) {
                    if (pLTH != null) {
                        pLTH.traceWarning("Continueing probe with scanner ID " + this.cScannerId + " with new db connection.");
                    }
                    this.handleDeadlock();
                    break block10;
                }
                if (!mClosedConneection && SQLExceptionHelper.isDeadlock((DBConnection)this.connection, (SQLException)bEx)) {
                    this.handleDeadlock();
                    break block10;
                }
                mRethrow = true;
                throw bEx;
            }
            catch (SQLException bInnerEx) {
                this.rollback(pLTH);
                if (mRethrow) {
                    if (pLTH != null) {
                        pLTH.traceError("Non-deadlock exception during " + pSituation, (Throwable)bInnerEx);
                    }
                    throw bEx;
                }
                if (pLTH != null) {
                    pLTH.traceError("Exception during connection check or deadlock handling.", (Throwable)bInnerEx);
                }
                throw bInnerEx;
            }
        }
    }

    public void handleEntity(JobInfo pJob, String pCIMClassNameToPersist, Hashtable pCIMPropertiesToPersist) throws DiscoveryException {
        this.handleEntity(this.getScanID(pJob), pCIMClassNameToPersist, pCIMPropertiesToPersist);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAssociation(JobInfo job, String association, String pContextCIMClassName, Hashtable entity1_properties, String pCIMClassNameToPersist, Hashtable pCIMPropertiesToPersist, Hashtable properties) throws DiscoveryException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"handleAssociation", (Object[])new Object[]{job.getResourceId(), association, pCIMClassNameToPersist});
        try {
            this.handleEntity(job, pCIMClassNameToPersist, pCIMPropertiesToPersist);
        }
        finally {
            mLTH.exit(null);
        }
    }

    public void handleInstance(JobInfo job, CIMInstance bInstance) throws DiscoveryException {
        Hashtable mCIMProperties = CIMProcessor.convertPropertiesToHashtable(bInstance.getAllProperties(), new Hashtable());
        mCIMProperties.put("originalcimclassname", bInstance.getClassName());
        this.handleEntity(job, bInstance.getClassName(), mCIMProperties);
    }

    protected String getScanID(JobInfo pJob) {
        String result = null;
        if (pJob != null) {
            result = super.getScanID(pJob);
        }
        if (result == null) {
            result = this.cScannerId;
        }
        return result;
    }

    public void setDBReferences(Hashtable pHashtable) {
        this.cDBReferences = pHashtable;
    }

    public Hashtable getDBReferences() {
        return this.cDBReferences;
    }

    public void setCIMNamespace(String pCIMNamespace) {
        this.cCIMNamespace = pCIMNamespace == null ? "" : pCIMNamespace;
    }

    public String getCIMNamespace() {
        return this.cCIMNamespace;
    }

    public void setCIMServiceURL(String pCIMServiceURL) {
        this.cCIMServiceURL = pCIMServiceURL == null ? "" : pCIMServiceURL;
    }

    public String getCIMServiceURL() {
        return this.cCIMServiceURL;
    }

    public void setDeviceModel(String pDeviceModel) {
        this.cDeviceModel = pDeviceModel;
    }

    public void setInstrumentationVersion(String pInstrumentationVersion) {
        this.cInstrumentationVersion = pInstrumentationVersion;
    }

    public void setSMISVersion(String pSMISVersion) {
        this.cSMISVersion = pSMISVersion;
    }

    public void setDedicated(String pDedicated) {
        this.cDedicated = pDedicated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void end(int discoverRequest) {
        LogTraceHelper mLTH = LogTraceHelper.entry((String)("" + discoverRequest), (Object)this, (String)"end", (Object[])new Object[]{"" + discoverRequest});
        try {
            ProbePerfTracker.ProbeAction mProbeActionEnd = TrackProbePerformance.startProbeAction(this.cScannerId, ProbePerfTracker.PROCESSOR_END);
            super.end(discoverRequest);
            TrackProbePerformance.finishedProbeAction(mProbeActionEnd);
        }
        finally {
            mLTH.exit((Object)"void");
        }
    }

    public void shutdown(int discoverRequest) {
        this.cRequestId = discoverRequest;
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        LogTraceHelper mLTH = LogTraceHelper.entry((String)("" + this.cRequestId), (Object)this, (String)"shutdown", (Object[])new Object[]{"" + this.cRequestId});
        try {
            TrackProbePerformance.finishedProbe(this.cScannerId, mLTH);
            try {
                this.doCommit(mLTH);
                if (this.cVolKeyStmt != null) {
                    this.cVolKeyStmt.close();
                }
                if (this.cVolIDStmt != null) {
                    this.cVolIDStmt.close();
                }
                if (this.cPortIDStmt != null) {
                    this.cPortIDStmt.close();
                }
                if (this.cNSIDStmt != null) {
                    this.cNSIDStmt.close();
                }
                this.cNamesCache.release();
                this.cPortIDCache.clear();
                this.cPortIDCache = null;
            }
            catch (SQLException pEx) {
                mLTH.traceError("Error commiting or closing statements", (Throwable)pEx);
            }
            super.shutdown();
        }
        finally {
            mLTH.exit((Object)"void");
            CIMOMManager.getCIMOMManager().deRegisterCIMOMUsage(this.cCIMServiceURL);
        }
    }

    public short getSystemNamesID(String pSystemName) throws SQLException {
        return this.cNamesCache.getSystemNameID(pSystemName);
    }

    public int getVolumeID(Hashtable cVolumeCOP, int pNamespaceID) throws SQLException {
        int mReturn = Integer.MIN_VALUE;
        String bVolumeID = (String)cVolumeCOP.get("DeviceID".toLowerCase());
        DBPreparedStatement mStmt = this.getVolIdStatement();
        mStmt.setInt(1, pNamespaceID);
        mStmt.setShort(2, this.cNamesCache.getClassNameID((String)cVolumeCOP.get("CreationClassName".toLowerCase())));
        mStmt.setString(3, bVolumeID);
        mStmt.setShort(4, this.cNamesCache.getClassNameID((String)cVolumeCOP.get("SystemCreationClassName".toLowerCase())));
        mStmt.setShort(5, this.cNamesCache.getSystemNameID((String)cVolumeCOP.get("SystemName".toLowerCase())));
        ProbePerfTracker.ProbeAction mProbeActionQuery = TrackProbePerformance.startProbeAction(this.cScannerId, ProbePerfTracker.DBC_QUERY);
        DBResultSet mRS = mStmt.executeQuery();
        if (mRS.next()) {
            mReturn = mRS.getInt(1);
        }
        TrackProbePerformance.finishedProbeAction(mProbeActionQuery);
        mRS.close();
        this.commit(null);
        return mReturn;
    }

    private DBPreparedStatement getVolIdStatement() throws SQLException {
        if (this.cVolIDStmt == null) {
            this.cVolIDStmt = this.connection.prepareStatement("SELECT VOLUME_ID FROM T_RES_CIMKEY_VOLUME WHERE CIM_NAMESPACE_ID=? AND CREATION_CLASS_NAME_ID=? AND DEVICE_ID=? AND SYSTEM_CREATION_CLASS_NAME_ID=? AND SYSTEM_NAMES_ID=?");
        }
        return this.cVolIDStmt;
    }

    public Object[] getVolumeKeys(Hashtable cVolumeCOP, int pNamespaceID) throws SQLException {
        Object[] mReturn = null;
        String bVolumeID = (String)cVolumeCOP.get("DeviceID".toLowerCase());
        DBPreparedStatement mStmt = this.getVolKeyStatement();
        mStmt.setInt(1, pNamespaceID);
        mStmt.setInt(2, (int)this.cNamesCache.getClassNameID((String)cVolumeCOP.get("CreationClassName".toLowerCase())));
        mStmt.setString(3, bVolumeID);
        mStmt.setInt(4, (int)this.cNamesCache.getClassNameID((String)cVolumeCOP.get("SystemCreationClassName".toLowerCase())));
        mStmt.setShort(5, this.cNamesCache.getSystemNameID((String)cVolumeCOP.get("SystemName".toLowerCase())));
        ProbePerfTracker.ProbeAction mProbeActionQuery = TrackProbePerformance.startProbeAction(this.cScannerId, ProbePerfTracker.DBC_QUERY);
        DBResultSet mRS = mStmt.executeQuery();
        if (mRS.next()) {
            mReturn = new Object[]{mRS.getString(1), new Integer(mRS.getInt(2)), new Integer(mRS.getInt(3)), new Integer(mRS.getInt(4))};
        }
        TrackProbePerformance.finishedProbeAction(mProbeActionQuery);
        mRS.close();
        this.commit(null);
        return mReturn;
    }

    private DBPreparedStatement getVolKeyStatement() throws SQLException {
        if (this.cVolKeyStmt == null) {
            StringBuffer mStatement = new StringBuffer();
            mStatement.append("SELECT sv.").append("NAME").append(",");
            mStatement.append("sv.").append("NAME_FORMAT").append(",");
            mStatement.append("sv.").append("SUBSYSTEM_ID").append(",");
            mStatement.append("sv.").append("SVID").append(" FROM ");
            mStatement.append(TResStorageVolumeTable.getTablename()).append(" as sv ");
            mStatement.append("WHERE sv.").append("SVID").append(" IN (SELECT ck.");
            mStatement.append("VOLUME_ID").append(" FROM ");
            mStatement.append(TResCimkeyVolumeTable.getTablename()).append(" as ck WHERE ck.");
            mStatement.append("CIM_NAMESPACE_ID").append("=? AND ck.");
            mStatement.append("CREATION_CLASS_NAME_ID").append("=? AND ck.");
            mStatement.append("DEVICE_ID").append("=? AND ck.");
            mStatement.append("SYSTEM_CREATION_CLASS_NAME_ID").append("=? AND ck.");
            mStatement.append("SYSTEM_NAMES_ID").append("=?)");
            this.cVolKeyStmt = this.connection.prepareStatement(mStatement.toString());
        }
        return this.cVolKeyStmt;
    }

    public int getPortID(Hashtable cPortCOP, int pNamespaceID) throws SQLException {
        Integer mCVal = (Integer)this.cPortIDCache.get(cPortCOP.toString());
        if (mCVal != null) {
            return mCVal;
        }
        int mReturn = Integer.MIN_VALUE;
        String bVolumeID = (String)cPortCOP.get("DeviceID".toLowerCase());
        DBPreparedStatement mStmt = this.getPortIdStatement();
        mStmt.setInt(1, pNamespaceID);
        mStmt.setShort(2, this.cNamesCache.getClassNameID((String)cPortCOP.get("CreationClassName".toLowerCase())));
        mStmt.setString(3, bVolumeID);
        mStmt.setShort(4, this.cNamesCache.getClassNameID((String)cPortCOP.get("SystemCreationClassName".toLowerCase())));
        mStmt.setShort(5, this.cNamesCache.getSystemNameID((String)cPortCOP.get("SystemName".toLowerCase())));
        ProbePerfTracker.ProbeAction mProbeActionQuery = TrackProbePerformance.startProbeAction(this.cScannerId, ProbePerfTracker.DBC_QUERY);
        DBResultSet mRS = mStmt.executeQuery();
        if (mRS.next()) {
            mReturn = mRS.getInt(1);
        }
        TrackProbePerformance.finishedProbeAction(mProbeActionQuery);
        mRS.close();
        this.commit(null);
        if (mReturn != Integer.MIN_VALUE) {
            this.cPortIDCache.put(cPortCOP.toString(), new Integer(mReturn));
        }
        return mReturn;
    }

    private DBPreparedStatement getPortIdStatement() throws SQLException {
        if (this.cPortIDStmt == null) {
            this.cPortIDStmt = this.connection.prepareStatement("SELECT PORT_ID FROM T_RES_CIMKEY_PORT WHERE CIM_NAMESPACE_ID=? AND CREATION_CLASS_NAME_ID=? AND DEVICE_ID=? AND SYSTEM_CREATION_CLASS_NAME_ID=? AND SYSTEM_NAMES_ID=?");
        }
        return this.cPortIDStmt;
    }

    public void commit(LogTraceHelper pLTH) throws SQLException {
        if (this.cCommitBuffer.size() >= this.cCommitThreshold) {
            this.doCommit(pLTH);
        }
    }

    protected void rollback(LogTraceHelper pLTH) {
        block2: {
            try {
                this.cCommitBuffer.clear();
                this.connection.rollback();
            }
            catch (SQLException bEx) {
                if (pLTH == null) break block2;
                pLTH.traceWarning("SQLException during rolback: " + bEx.getMessage());
            }
        }
    }

    public void doCommit(LogTraceHelper pLTH) throws SQLException {
        try {
            if (pLTH != null) {
                pLTH.traceHigh("Commiting processor transaction (buffer-size :" + this.cCommitBuffer.size() + ") ");
            }
            ProbePerfTracker.ProbeAction mProbeActionCommit = TrackProbePerformance.startProbeAction(this.cScannerId, ProbePerfTracker.DBC_COMMIT);
            this.connection.commit();
            TrackProbePerformance.finishedProbeAction(mProbeActionCommit);
            this.cCommitBuffer.clear();
        }
        catch (SQLException pEx) {
            this.handleSQLException(pLTH, pEx, "commit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleDeadlock() throws SQLException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)this, (String)"handleDeadlock", null);
        this.cCommitThreshold /= 2;
        if (this.cCommitThreshold < 1) {
            this.cCommitThreshold = 1;
        }
        mLTH.traceWarning("Handling deadlock situation for scanner ID " + this.cScannerId + " with " + this.cCommitBuffer.size() + " entries in the buffer.");
        mLTH.traceWarning("Transaction size now set to  " + this.cCommitThreshold);
        try {
            Random mRandomGen = new Random();
            int mRetries = 0;
            while (mRetries < this.cDeadlockRetries) {
                try {
                    this.persistCommitBuffer(mLTH);
                    return;
                }
                catch (SQLException pEx) {
                    try {
                        if (SQLExceptionHelper.isDeadlock((DBConnection)this.connection, (SQLException)pEx)) {
                            mLTH.traceWarning("Deadlock during retry (" + ++mRetries + "/" + this.cDeadlockRetries + ")");
                            try {
                                long mWaitInt = (long)mRandomGen.nextInt(this.cMaxRetryInterval) * (long)mRetries;
                                mLTH.traceHigh("Waiting for " + mWaitInt + "msecs before retrying deadlocked operations");
                                Thread.sleep(mRandomGen.nextInt(this.cMaxRetryInterval));
                            }
                            catch (InterruptedException pIE) {}
                            continue;
                        }
                        mLTH.traceError("Non-deadlock exception during re-persisting of commit buffer", (Throwable)pEx);
                        throw pEx;
                    }
                    catch (SQLException pInnerEx) {
                        mLTH.traceError("Checking exception for deadlock situation produced an error.", (Throwable)pInnerEx);
                        mLTH.traceError("Original exception to check:", (Throwable)pEx);
                        throw pInnerEx;
                        return;
                    }
                }
            }
        }
        finally {
            mLTH.exit((Object)"void");
        }
    }

    private MapperResult persistCommitBuffer(LogTraceHelper pLTH) throws SQLException {
        MapperResult mResult = new MapperResult();
        int mBufSize = this.cCommitBuffer.size();
        Iterator mEntityIterator = this.cCommitBuffer.iterator();
        while (mEntityIterator.hasNext()) {
            --mBufSize;
            CommitBufferEntry mBufferEntry = (CommitBufferEntry)mEntityIterator.next();
            if (pLTH != null && pLTH.isTraceHighEnabled()) {
                pLTH.traceHigh("Properties to persist during retry (" + mBufSize + " left): " + DiskMessageHelper.toMsgString((Object)mBufferEntry.getPersistData()));
            }
            ProbePerfTracker.ProbeAction bTraceProbeAction = TrackProbePerformance.startProbeAction(mBufferEntry.getScannerID(), ProbePerfTracker.MAPPER_PERSIST);
            mResult = mBufferEntry.getMapper().persist(this.connection, mBufferEntry.getPersistData(), mBufferEntry.getScannerID());
            TrackProbePerformance.finishedProbeAction(bTraceProbeAction);
            if (!mBufferEntry.compareKeyRefs(mResult.getKeyReferences())) {
                if (pLTH != null) {
                    pLTH.traceError("Retry to persist entity returned different key references. Rolling back to maintain db integrity", null);
                }
                this.rollback(pLTH);
                throw new SQLException("Error during deadlock handling retry: different key references returned by mapper during retry.");
            }
            this.connection.commit();
            mEntityIterator.remove();
        }
        if (this.cAlertID != null) {
            AlertProcessor.processAlerts(this.cAlertID, mResult, this.newEntities, this.modifiedEntities);
        }
        this.connection.commit();
        this.cCommitBuffer.clear();
        return mResult;
    }

    private Hashtable addSystemNameID(Hashtable pEntityData) {
        if (pEntityData.get("ref_system_names_id") != null) {
            return pEntityData;
        }
        String mSysName = (String)pEntityData.get("systemname");
        if (mSysName == null) {
            return pEntityData;
        }
        try {
            short mSNID = this.cNamesCache.getSystemNameID(mSysName);
            if (mSNID != Integer.MIN_VALUE) {
                pEntityData.put("ref_system_names_id", "" + mSNID);
            }
            return pEntityData;
        }
        catch (SQLException pEx) {
            return pEntityData;
        }
    }

    public String getNamespaceID(String pServiceURL, String pNamespace, LogTraceHelper pLTH) throws SQLException {
        String mReturn = null;
        DBPreparedStatement mStmt = this.getNSIDStatement();
        mStmt.clearParameters();
        mStmt.setString(1, pNamespace);
        mStmt.setString(2, pServiceURL);
        DBResultSet mRS = mStmt.executeQuery();
        if (mRS.next()) {
            mReturn = mRS.getString(1) + "";
        }
        mRS.closeAll();
        this.commit(pLTH);
        return mReturn;
    }

    private DBPreparedStatement getNSIDStatement() throws SQLException {
        if (this.cNSIDStmt == null) {
            StringBuffer mStatement = new StringBuffer();
            mStatement.append("SELECT c2n.").append("CIM_NAMESPACE_ID");
            mStatement.append(" FROM ");
            mStatement.append(TResCimom2namespaceTable.getTablename()).append(" as c2n ");
            mStatement.append("WHERE c2n.").append("NAMESPACE").append("=? AND c2n.");
            mStatement.append("CIMOM_ID").append(" IN (SELECT rc.");
            mStatement.append("REG_CIMOM_ID").append(" FROM ");
            mStatement.append(TResRegisteredCimomTable.getTablename()).append(" as rc WHERE rc.");
            mStatement.append("SERVICE_URL").append("=?)");
            this.cNSIDStmt = this.connection.prepareStatement(mStatement.toString());
        }
        return this.cNSIDStmt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int updateComplexQueryDeadlockRetry(DBConnection pCon, String pSql, Hashtable pParams) throws SQLException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Object)DiskCIMProcessor.class.getName(), (String)"updateComplexQueryDeadlockRetry", (Object[])new Object[]{pCon, pSql, pParams});
        int mQueryResult = 0;
        try {
            int mDeadlockRetries = DiskManagerConfigSvc.getIntConfigValue((String)"Probe.Deadlock.MaxRetries", (int)2);
            int mMaxRetryInterval = DiskManagerConfigSvc.getIntConfigValue((String)"Probe.Deadlock.MaxRetryInterval", (int)5000);
            Random mRandomGen = new Random();
            int mRetries = 0;
            while (mRetries < mDeadlockRetries) {
                try {
                    mQueryResult = ComplexQuery.sqlUpdate((DBConnection)pCon, (String)pSql, (Hashtable)pParams);
                    return mQueryResult;
                }
                catch (SQLException pEx) {
                    try {
                        if (SQLExceptionHelper.isDeadlock((DBConnection)pCon, (SQLException)pEx)) {
                            mLTH.traceWarning("Deadlock during retry (" + ++mRetries + "/" + mDeadlockRetries + ")");
                            try {
                                long mWaitInt = (long)mRandomGen.nextInt(mMaxRetryInterval) * (long)mRetries;
                                mLTH.traceHigh("Waiting for " + mWaitInt + "msecs before retrying deadlocked operations");
                                Thread.sleep(mRandomGen.nextInt(mMaxRetryInterval));
                            }
                            catch (InterruptedException pIE) {}
                            continue;
                        }
                        mLTH.traceError("Non-deadlock exception during re-persisting of commit buffer", (Throwable)pEx);
                        throw pEx;
                    }
                    catch (SQLException pInnerEx) {
                        mLTH.traceError("Checking exception for deadlock situation produced an error.", (Throwable)pInnerEx);
                        mLTH.traceError("Original exception to check:", (Throwable)pEx);
                        throw pInnerEx;
                        return mQueryResult;
                    }
                }
            }
        }
        finally {
            mLTH.exit((Object)new Integer(mQueryResult));
        }
    }

    public class NamesIDCache {
        private Map cCreationClassNamesList = new HashMap();
        private Map cSystemNamesList = new HashMap();
        private DBPreparedStatement cSysNameStmt = null;
        private DBPreparedStatement cCrClsNameStmt = null;

        public short getSystemNameID(String pSystemName) throws SQLException {
            Short mReturn = (Short)this.cSystemNamesList.get(pSystemName);
            if (mReturn != null) {
                return mReturn;
            }
            mReturn = this.retrieveSystemNameID(pSystemName);
            if (mReturn == null) {
                return Short.MIN_VALUE;
            }
            this.cSystemNamesList.put(pSystemName, mReturn);
            return mReturn;
        }

        private Short retrieveSystemNameID(String pSystemName) throws SQLException {
            Short mReturn = null;
            DBPreparedStatement mStmt = this.getSysNamesStmt();
            mStmt.setString(1, pSystemName);
            DBResultSet mRS = mStmt.executeQuery();
            if (mRS.next()) {
                mReturn = new Short(mRS.getShort(1));
            }
            mRS.close();
            DiskCIMProcessor.this.doCommit(null);
            return mReturn;
        }

        private DBPreparedStatement getSysNamesStmt() throws SQLException {
            if (this.cSysNameStmt == null) {
                this.cSysNameStmt = DiskCIMProcessor.this.connection.prepareStatement("select SYSTEM_NAMES_ID from T_RES_SYSTEM_NAMEs WHERE SYSTEM_NAME = ? FOR READ ONLY");
            }
            return this.cSysNameStmt;
        }

        public short getClassNameID(String pClassName) throws SQLException {
            Short mReturn = (Short)this.cCreationClassNamesList.get(pClassName);
            if (mReturn != null) {
                return mReturn;
            }
            mReturn = this.retrieveClassNameID(pClassName);
            if (mReturn == null) {
                return Short.MIN_VALUE;
            }
            this.cCreationClassNamesList.put(pClassName, mReturn);
            return mReturn;
        }

        private Short retrieveClassNameID(String pClassName) throws SQLException {
            Short mReturn = null;
            DBPreparedStatement mStmt = this.getClassNamesStmt();
            mStmt.setString(1, pClassName);
            DBResultSet mRS = mStmt.executeQuery();
            if (mRS.next()) {
                mReturn = new Short(mRS.getShort(1));
            }
            mRS.close();
            DiskCIMProcessor.this.doCommit(null);
            return mReturn;
        }

        private DBPreparedStatement getClassNamesStmt() throws SQLException {
            if (this.cCrClsNameStmt == null) {
                this.cCrClsNameStmt = DiskCIMProcessor.this.connection.prepareStatement("select ID from T_RES_CREATION_CLASS_NAME WHERE NAME = ? FOR READ ONLY");
            }
            return this.cCrClsNameStmt;
        }

        public void release() throws SQLException {
            this.cSystemNamesList = null;
            this.cCreationClassNamesList = null;
            if (this.cSysNameStmt != null) {
                this.cSysNameStmt.close();
            }
            if (this.cCrClsNameStmt != null) {
                this.cCrClsNameStmt.close();
            }
        }

        public void reset() throws SQLException {
            this.cSysNameStmt = null;
            this.cCrClsNameStmt = null;
        }
    }

    protected class CommitBufferEntry {
        IDBAttributeMapper cMapper;
        Hashtable cPropertiesToPersist;
        String cScannerID;
        Hashtable cRetKeyRefs = null;

        public CommitBufferEntry(IDBAttributeMapper pMapper, Hashtable pPropertiesToPersist, String pScannerID) {
            this.cMapper = pMapper;
            this.cPropertiesToPersist = (Hashtable)pPropertiesToPersist.clone();
            this.cScannerID = pScannerID;
        }

        public IDBAttributeMapper getMapper() {
            return this.cMapper;
        }

        public Hashtable getPersistData() {
            return this.cPropertiesToPersist;
        }

        public String getScannerID() {
            return DiskCIMProcessor.this.cScannerId;
        }

        public void setKeyRefs(Hashtable pRefs) {
            this.cRetKeyRefs = (Hashtable)pRefs.clone();
        }

        public boolean compareKeyRefs(Hashtable pNewRefs) {
            if (this.cRetKeyRefs == null) {
                return true;
            }
            return DiskMessageHelper.toMsgString((Object)this.cRetKeyRefs).equals(DiskMessageHelper.toMsgString((Object)pNewRefs));
        }
    }
}

