/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.disk.discovery;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.aperi.DiscoverProcess;
import org.eclipse.aperi.Router;
import org.eclipse.aperi.common.api.AsyncResult;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.common.api.Result;
import org.eclipse.aperi.discovery.Discover;
import org.eclipse.aperi.discovery.DiscoveryActivator;
import org.eclipse.aperi.discovery.interfaces.Request;
import org.eclipse.aperi.disk.DiscoveryConstants;
import org.eclipse.aperi.disk.common.CIMOMManager;
import org.eclipse.aperi.disk.common.log.LogTraceHelper;
import org.eclipse.aperi.disk.common.util.DiskMessageHelper;
import org.eclipse.aperi.interfaces.IDiscover;
import org.eclipse.aperi.interfaces.ParameterException;

public class TopLevelProcess
extends DiscoverProcess
implements DiscoveryConstants {
    Request cDiscoverRequest = null;
    Map cParameters = null;

    public TopLevelProcess(String description, boolean mainProcess) {
        super(description, mainProcess, new String[]{"CIMOMID_PARAM", "Type"}, new String[]{String[].class.getName(), String.class.getName()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result process(Request mDiscoverRequest, Map pParameters) throws ParameterException {
        LogTraceHelper mLTH = LogTraceHelper.entry((Request)this.cDiscoverRequest, (Object)this, (String)"process", (Object[])new Object[]{pParameters});
        this.cDiscoverRequest = mDiscoverRequest;
        this.cParameters = pParameters;
        try {
            IDiscover mDiscoverProxy = (IDiscover)DiscoveryActivator._serviceHelper.bindLocal("DiscoverService");
            String[] mCIMOMIDs = (String[])pParameters.get("CIMOMID_PARAM");
            AsyncResult[] mReturn = new AsyncResult[mCIMOMIDs.length];
            CIMOM[] mCIMOM = CIMOMManager.getCIMOMManager().getCIMOMs(mCIMOMIDs);
            if (mCIMOM.length == 0) {
                mLTH.traceWarning("No CIMOM information found for " + DiskMessageHelper.toMsgString((Object)mCIMOMIDs));
            }
            if (mCIMOM.length != mCIMOMIDs.length) {
                mLTH.traceWarning("Not all CIMOM information was found for " + DiskMessageHelper.toMsgString((Object)mCIMOMIDs));
                mLTH.traceWarning("Found CIMOM information :\n" + DiskMessageHelper.toMsgString((Object)mCIMOM));
            }
            for (int mLoop = 0; mLoop < mCIMOM.length; ++mLoop) {
                Hashtable<String, Object> mParams = new Hashtable<String, Object>();
                mParams.put("CIMOM", this.getCimomParams(mCIMOM[mLoop]));
                mParams.put("Type", (String)pParameters.get("Type"));
                HashMap<String, Object[]> mDispParams = new HashMap<String, Object[]>();
                mDispParams.put("Request", new Object[]{"collectStorageSubsystemsFromCIMOM", mParams});
                String mResult = Router.getRouter().perform(Discover.frontEndProcessHandler, mDispParams, new Integer(this.cDiscoverRequest.getId()).toString())[0];
                mLTH.traceInfo("GENDIS for  CIMOM: " + ((String[])mParams.get("CIMOM"))[0] + " started");
            }
        }
        finally {
            mLTH.exit((Object)"");
        }
        return new Result(0);
    }

    private Object getCimomParams(CIMOM pMcimom) {
        String[] mCIMOM = new String[]{pMcimom.getServiceUrl(), pMcimom.getInteropSchemaNamespace(), pMcimom.getUserId(), pMcimom.getPassword(), "", pMcimom.getSoftwareLevel()};
        return mCIMOM;
    }
}

