/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.internal.server.device;

import java.io.File;
import java.io.FileInputStream;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Properties;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.sanmgmt.Variables;
import org.eclipse.aperi.sanmgmt.dbconnparms.ConfigService;
import org.eclipse.aperi.sanmgmt.dbconnparms.interfaces.IConfigService;
import org.eclipse.aperi.sanmgmt.middleware.DeviceServiceManager;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IDeviceServiceManager;
import org.eclipse.aperi.sanmgmt.middleware.interfaces.IService;
import org.eclipse.aperi.util.SRMCrypto;
import org.eclipse.aperi.util.osgi.ServiceHelper;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class DeviceServerActivator
implements BundleActivator,
ServiceListener {
    private static BundleContext _bundleContext = null;
    public static ServiceHelper _serviceHelper;
    protected ServiceRegistration cServiceManagerRegistration;
    protected ServiceRegistration cConfigServiceRegistration;
    protected ConfigService cConfigService = null;

    public synchronized void start(BundleContext context) throws Exception {
        _bundleContext = context;
        _bundleContext.addServiceListener((ServiceListener)this);
        _serviceHelper = new ServiceHelper(_bundleContext);
        this.initializeDBPoolConnection();
        String[] mConfigServices = new String[]{IConfigService.class.getName(), IService.class.getName()};
        Hashtable<String, String> mConfigProperties = new Hashtable<String, String>();
        ((Dictionary)mConfigProperties).put("org.eclipse.aperi.webservice.name", "ConfigService");
        this.cConfigService = new ConfigService();
        this.cConfigService.startup();
        this.cConfigServiceRegistration = _bundleContext.registerService(mConfigServices, (Object)this.cConfigService, mConfigProperties);
        String[] mDeviceServiceManager = new String[]{IDeviceServiceManager.class.getName()};
        Hashtable<String, String> mServiceManagerProperties = new Hashtable<String, String>();
        ((Dictionary)mServiceManagerProperties).put("org.eclipse.aperi.webservice.name", "DeviceServiceManager");
        DeviceServiceManager.getInstance().startup();
        this.cServiceManagerRegistration = context.registerService(mDeviceServiceManager, (Object)DeviceServiceManager.getInstance(), mServiceManagerProperties);
    }

    public synchronized void stop(BundleContext context) throws Exception {
        if (this.cServiceManagerRegistration != null) {
            this.cServiceManagerRegistration.unregister();
        }
        DeviceServiceManager.getInstance().shutdown();
        if (this.cConfigServiceRegistration != null) {
            this.cConfigServiceRegistration.unregister();
        }
        if (this.cConfigService != null) {
            this.cConfigService.shutdown();
            this.cConfigService = null;
        }
        _serviceHelper.dispose();
        _serviceHelper = null;
        _bundleContext.removeServiceListener((ServiceListener)this);
        _bundleContext = null;
    }

    public synchronized void serviceChanged(ServiceEvent event) {
        if (_bundleContext != null) {
            ServiceReference sr = event.getServiceReference();
            Object object = _bundleContext.getService(sr);
        }
    }

    public static BundleContext getContext() {
        return _bundleContext;
    }

    public void initializeDBPoolConnection() {
        try {
            String configDir = Variables.getConfigurationDirectory();
            String configFile = configDir + File.separator + "setup.properties";
            if (new File(configFile).exists()) {
                FileInputStream fis = new FileInputStream(configFile);
                Properties setupProperties = new Properties();
                setupProperties.load(fis);
                String deviceType = setupProperties.getProperty("tsnm.type");
                if ("manager".equals(deviceType)) {
                    this.testDBConnection();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private boolean testDBConnection() {
        try {
            String propFile = Variables.getConfigurationDirectory() + File.separator + "tsnmdbparms.properties";
            FileInputStream fis = new FileInputStream(propFile);
            Properties props = new Properties();
            props.load(fis);
            String driver = props.getProperty("tivoli.sanmgmt.jdbc.dbDriver");
            String url = props.getProperty("tivoli.sanmgmt.jdbc.dbURL");
            String schema = props.getProperty("tivoli.sanmgmt.jdbc.dbSchema");
            String user = props.getProperty("tivoli.sanmgmt.jdbc.dbUser");
            String password = props.getProperty("tivoli.sanmgmt.jdbc.dbPassword");
            int poolMin = Integer.parseInt(props.getProperty("tivoli.sanmgmt.jdbc.conpool.min", "1"));
            int poolMax = Integer.parseInt(props.getProperty("tivoli.sanmgmt.jdbc.conpool.max", "10"));
            if (driver == null || url == null || schema == null || user == null || password == null) {
                System.err.println("Incomplete database connection properties");
                System.err.println("Driver = " + driver + "\n" + "URL = " + url + "\n" + "Schema = " + schema + "\n" + "User = " + user + "\n" + "Password = " + password + "\n" + "Pool Min = " + poolMin + "\n" + "Pool Max = " + poolMax + "\n");
                return false;
            }
            password = SRMCrypto.decrypt((String)password);
            DBConnPoolDataSource.initialize((String)driver, (String)url, (String)schema, (String)user, (String)password, (int)poolMax);
            DBConnPoolDataSource pool = DBConnPoolDataSource.getInstance();
            DBConnection dbc = null;
            for (int i = 0; i < 60; ++i) {
                try {
                    dbc = (DBConnection)pool.getPooledConnection();
                    break;
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                    if (i >= 59) continue;
                    System.err.println("Connection failed ... waiting for 30 seconds to retry");
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (Exception ignore) {
                        // empty catch block
                    }
                    continue;
                }
            }
            if (dbc == null) {
                return false;
            }
            try {
                dbc.close();
            }
            catch (Exception ignore) {}
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }
}

