/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.download;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.aperi.download.ConfigurationException;
import org.eclipse.aperi.download.Download;
import org.eclipse.aperi.download.ZipFile;
import org.eclipse.aperi.download.interfaces.IDownloadTarget;
import org.eclipse.aperi.download.interfaces.IZipDownload;
import org.eclipse.aperi.download.interfaces.IZipFile;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipDownload
extends Download
implements IZipDownload {
    public static final String ATTR_ZIP_FILE = "file";
    Vector<IZipFile> _zipFiles = new Vector();

    public ZipDownload(Node node) throws ConfigurationException {
        super(node);
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (!child.getNodeName().equals(ATTR_ZIP_FILE)) continue;
            this._zipFiles.add(new ZipFile(child));
        }
    }

    @Override
    public Vector<IZipFile> getZipFiles() {
        return this._zipFiles;
    }

    @Override
    public void downloadFile(String tempDir, String baseDir) throws IOException {
        URL url = new URL(this.getFileUrl());
        URLConnection urlConn = url.openConnection();
        long lastModified_server = urlConn.getLastModified();
        for (int i = 0; i < this._zipFiles.size(); ++i) {
            Vector<IDownloadTarget> downloadTargets = this._zipFiles.get(i).getDownloadTargets();
            if (this.prepTargets(lastModified_server, downloadTargets, baseDir)) {
                this._zipFiles.remove(i--);
                continue;
            }
            this.createPlaceholders(downloadTargets, baseDir);
        }
        InputStream in = urlConn.getInputStream();
        File[] downloadedFiles = this.extractSelectedZipEntries(in, this._zipFiles, tempDir);
        for (int i = 0; i < downloadedFiles.length; ++i) {
            this.copyToTargets(downloadedFiles[i], this._zipFiles.get(i).getDownloadTargets(), baseDir, lastModified_server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File[] extractSelectedZipEntries(InputStream in, Vector<IZipFile> zipFiles, String tempDir) throws IOException {
        File[] downloadedFiles = new File[zipFiles.size()];
        File tempDirFile = new File(tempDir);
        String regEx = this.createOrRegEx(zipFiles);
        ZipInputStream zipInputStream = new ZipInputStream(in);
        try {
            int matchCount = 0;
            while (matchCount < zipFiles.size()) {
                FileOutputStream fileOutputStream = null;
                int index = -1;
                try {
                    ZipEntry zipEntry = zipInputStream.getNextEntry();
                    if (zipEntry == null) {
                        throw new IOException("No files matching the regular expression \"" + regEx + "\" were found in the zip file.");
                    }
                    String internalPath = zipEntry.getName();
                    if (!internalPath.matches(regEx)) continue;
                    ++matchCount;
                    for (index = 0; index < zipFiles.size() && !internalPath.equals(zipFiles.get(index).getInternalPath()); ++index) {
                    }
                    String fileName = new File(internalPath).getName();
                    downloadedFiles[index] = File.createTempFile(fileName, null, tempDirFile);
                    fileOutputStream = new FileOutputStream(downloadedFiles[index]);
                    this.streamCopy(zipInputStream, fileOutputStream);
                }
                catch (IOException e) {
                    if (index != -1 && downloadedFiles[index].exists()) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException ioE) {
                            // empty catch block
                        }
                        downloadedFiles[index].delete();
                    }
                    throw e;
                }
                finally {
                    if (zipInputStream != null) {
                        try {
                            zipInputStream.closeEntry();
                        }
                        catch (IOException e) {}
                    }
                    if (fileOutputStream == null) continue;
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException e) {}
                }
            }
        }
        finally {
            try {
                zipInputStream.close();
            }
            catch (IOException e) {}
        }
        return downloadedFiles;
    }

    private String createOrRegEx(Vector<IZipFile> zipFiles) {
        Iterator<IZipFile> itr = zipFiles.iterator();
        StringBuffer regex = new StringBuffer();
        regex.append("(");
        while (itr.hasNext()) {
            regex.append(itr.next().getInternalPath());
            if (itr.hasNext()) {
                regex.append(")|(");
                continue;
            }
            regex.append(")");
        }
        return regex.toString();
    }
}

