/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.CreatorNameQueryable;
import org.eclipse.aperi.repository.ExtendedCNQueryable;
import org.eclipse.aperi.repository.RepositoryAccessor;

public class CreatorNameListProxy {
    private GuiListReq requestData;
    private RepositoryAccessor accessor;
    private CreatorNameQueryable castAccessor;
    private ExtendedCNQueryable twiceCast;
    private static final String firstPart = "SELECT creator, name, ";
    private static final String lastPart = " ORDER BY creator, name";

    public CreatorNameListProxy(RepositoryAccessor pAccessor, GuiListReq pRequestData) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CreatorNameListProxy.class.getName(), (String)"CreatorNameListProxy", (String)"pAccessor, pRequestData");
        }
        this.requestData = pRequestData;
        this.accessor = pAccessor;
        this.castAccessor = (CreatorNameQueryable)((Object)this.accessor);
        this.twiceCast = this.castAccessor instanceof ExtendedCNQueryable ? (ExtendedCNQueryable)this.castAccessor : null;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CreatorNameListProxy.class.getName(), (String)"CreatorNameListProxy");
        }
    }

    private NameList fetchOne(StringBuffer buf) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CreatorNameListProxy.class.getName(), (String)"fetchOne", (String)"buf");
        }
        NameList result = null;
        this.accessor.stmtPhase = 2;
        try {
            ResultSet resultSet = this.accessor.resultSet;
            if (resultSet.next()) {
                this.accessor.stmtPhase = 1;
                result = new NameList();
                this.accessor.colIndex = 1;
                buf.setLength(0);
                buf.append(this.accessor.getString(resultSet));
                buf.append('.');
                buf.append(this.accessor.getString(resultSet));
                result.nlName = buf.toString();
                result.nlID = this.accessor.getInt(resultSet);
                result.nlInfo = (short)this.requestData.listRequested;
                if (this.twiceCast != null) {
                    this.twiceCast.retrieveAdditionalColumns(result);
                }
                this.castAccessor.addQualifiers(this.requestData, result);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)CreatorNameListProxy.class.getName(), (String)"fetchOne", (Throwable)e);
            }
            this.accessor.stmtType = 0;
            this.accessor.sqlError(e);
        }
        NameList traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CreatorNameListProxy.class.getName(), (String)"fetchOne", (Object)traceResult);
        }
        return traceResult;
    }

    public NameList select() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CreatorNameListProxy.class.getName(), (String)"select", (String)"");
        }
        StringBuffer sqlText = new StringBuffer(120);
        sqlText.append(firstPart);
        sqlText.append(this.castAccessor.getIDColumnName());
        if (this.twiceCast != null) {
            sqlText.append(", ");
            sqlText.append(this.twiceCast.additionalColumnNames());
        }
        sqlText.append(" FROM ");
        sqlText.append(this.accessor.tableName);
        this.castAccessor.appendWhereClause(this.requestData, sqlText);
        sqlText.append(lastPart);
        this.accessor.selectStmt = this.accessor.prepareStmt(sqlText.toString());
        NameList head = null;
        NameList prev = null;
        try {
            NameList element;
            this.accessor.stmtPhase = 3;
            this.accessor.resultSet = this.accessor.selectStmt.executeQuery();
            while ((element = this.fetchOne(sqlText)) != null) {
                if (prev != null) {
                    prev.nlNext = element;
                } else {
                    head = element;
                }
                prev = element;
            }
            this.accessor.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)CreatorNameListProxy.class.getName(), (String)"select", (Throwable)e);
            }
            this.accessor.stmtType = 0;
            this.accessor.sqlError(e);
        }
        NameList traceResult = head;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CreatorNameListProxy.class.getName(), (String)"select", (Object)traceResult);
        }
        return traceResult;
    }
}

