/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.report;

import java.io.Serializable;
import java.sql.Connection;
import java.util.Iterator;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.TStorm.server.guireq.RespAgent;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.SoftwareVersion;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.GuiDataProvider;
import org.eclipse.aperi.repository.report.filter.ReportFilter;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.Server;

public class RptAgent
implements GuiDataProvider {
    public RptAgent(Connection dbc) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptAgent.class.getName(), (String)"RptAgent", (String)"dbc");
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptAgent.class.getName(), (String)"RptAgent");
        }
    }

    public Serializable getReportData(GuiReportReq grr) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptAgent.class.getName(), (String)"getReportData", (String)"grr");
        }
        int totalRows = 0;
        boolean rowSelected = true;
        String timezone = null;
        RespAgent node = new RespAgent();
        RespAgent listHdr = null;
        ReportFilter filter = null;
        if (grr.columnFilters != null) {
            filter = new ReportFilter(grr, node);
        }
        AgentManager.AgentAddress agentNode = new AgentManager.AgentAddress();
        Iterator i = Server.agentMgr.listAgents(agentNode);
        while (i.hasNext()) {
            agentNode = (AgentManager.AgentAddress)i.next();
            if (agentNode.computerID <= 0 || agentNode.state == 2) continue;
            if (node == null) {
                node = new RespAgent();
            }
            node.raComputerID = agentNode.computerID;
            node.raProductVersions = SoftwareVersion.decode((int)agentNode.softwareVersion);
            node.raPortNumber = agentNode.listenerPort;
            node.raConnectionErrors = agentNode.connectionErrors;
            node.raConsecutiveErrors = agentNode.consecutiveErrors;
            node.raState = agentNode.state;
            if (agentNode.state == 1) {
                if (agentNode.consecutiveErrors > 0) {
                    node.raState = (byte)4;
                } else if (agentNode.upgradeRequired > 0) {
                    node.raState = (byte)5;
                }
            }
            node.raHostAddress = agentNode.hostAddress;
            node.raTimestamp = agentNode.timestamp;
            node.raCpuArchitecture = agentNode.cpuArchitecture;
            timezone = agentNode.timezone.getID();
            node.raTimezone = timezone.equals("Custom") ? agentNode.timezone.getDisplayName(agentNode.timezone.useDaylightTime(), 0) : Util.formatTimeZone((String)timezone);
            node.raOsType = agentNode.osType;
            node.raTsName = agentNode.tsName;
            if (filter != null) {
                rowSelected = filter.isSelected(node);
            }
            if (!rowSelected) continue;
            node.raNext = listHdr;
            listHdr = node;
            node = null;
            ++totalRows;
        }
        RespAgent[] traceResult = this.packItUp(listHdr, totalRows);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptAgent.class.getName(), (String)"getReportData", (Object)traceResult);
        }
        return traceResult;
    }

    private RespAgent[] packItUp(RespAgent listHdr, int totalRows) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptAgent.class.getName(), (String)"packItUp", (String)"listHdr, totalRows");
        }
        RespAgent[] result = null;
        if (totalRows > 0) {
            RespAgent nextNode = null;
            result = new RespAgent[totalRows];
            int index = 0;
            while (listHdr != null) {
                nextNode = listHdr.raNext;
                listHdr.raNext = null;
                result[index] = listHdr;
                listHdr = nextNode;
                ++index;
            }
        }
        RespAgent[] traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptAgent.class.getName(), (String)"packItUp", (Object)traceResult);
        }
        return traceResult;
    }
}

