/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.report;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.eclipse.aperi.San.common.Lun;
import org.eclipse.aperi.TStorm.common.DevAccess;
import org.eclipse.aperi.TStorm.common.Disk;
import org.eclipse.aperi.TStorm.common.DiskHistory;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.GuiDataProvider;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.report.RptDiskAssetHist;
import org.eclipse.aperi.repository.report.filter.ReportFilter;
import org.eclipse.aperi.repository.table.TResLogicalDisk;
import org.eclipse.aperi.repository.table.TResVendorModel;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.xmsg.MessageLog;

public class RptDisk
extends StorageRepositoryAccessor
implements GuiDataProvider {
    PreparedStatement selectMirrorsStmt;
    private static final String SELECT = " select sh.computer_id as cmpID, sh.resource_id as resID, sh.resource_type, sh.scan_time, sh.removed_time, sh.path, da.controller_id, da.device_id, da.target, da.lun, da.path, dev.physical_volume_id, dev.vendor_id, dev.model_id, dev.serial_number, dev.firmware_rev, dev.manufacture_date, dev.use_count, dev.device_type, dev.unsupported_model, dev.flags, dev.removable_medium, dev.multi_port, dev.discovered_time, dev.subsystem_serial_number, dsk.disk_id, dsk.heads, dsk.cylinders, dsk.rpm, dsk.sector_size, dsk.sectors_avg_track, dsk.sectors_outr_track, dsk.sectors_innr_track, dsk.logical_block_size, dsk.minutes_powered_on, dsk.write_protected, dsk.write_cache_enable, dsk.read_cache_disable, dsk.auto_write_realloc, dsk.auto_read_realloc, dsk.no_error_recovery, dsk.failure_predicted, dsk.capacity, dsk.spare_blocks, dsk.volgroup_id, dsk.desired_awre, dsk.desired_arre, dsk.desired_noerrrcvry, dsk.disk_identity, dkh.disk_id, dkh.statistic_time, dkh.statistic_type, dkh.primary_defects, dkh.grown_defects, dkh.recovrd_wrt_errs, dkh.unrecovrd_wrt_errs, dkh.bytes_written, dkh.recovrd_rd_errs, dkh.unrecovrd_rd_errs, dkh.bytes_read, dkh.recovrd_vfy_errs, dkh.unrecovrd_vfy_errs, dkh.non_medium_errs, dkh.free_space, dkh.temperature, cmp.os_type, cmp.host_url from t_res_share sh, t_res_dev_access da, t_res_physical_volume dev, t_stat_disk dsk, t_stat_disk_hist dkh, t_res_host cmp where sh.resource_type = 10 and sh.resource_id = da.device_id and sh.resource_id = dev.physical_volume_id and sh.resource_id = dsk.disk_id and sh.resource_id = dkh.disk_id and sh.computer_id = cmp.computer_id and dkh.statistic_type = '3' and dsk.logical_disk_id < 0 union  select dev.subsystem_id as cmpID, dev.physical_volume_id as resID, 0, dev.update_timestamp, dev.update_timestamp, dev.device_id, -1, -1, -1, -1,  dev.device_id, dev.physical_volume_id, dev.vendor_id, dev.model_id, dev.serial_number, dev.firmware_rev, dev.manufacture_date,  dev.use_count, dev.device_type, dev.unsupported_model, dev.flags, dev.removable_medium, dev.multi_port, dev.update_timestamp,  dev.subsystem_serial_number, dsk.disk_id, dsk.heads, dsk.cylinders, dsk.rpm, dsk.sector_size, dsk.sectors_avg_track, dsk.sectors_outr_track, dsk.sectors_innr_track,  dsk.logical_block_size, dsk.minutes_powered_on, dsk.write_protected, dsk.write_cache_enable, dsk.read_cache_disable, dsk.auto_write_realloc,  dsk.auto_read_realloc, dsk.no_error_recovery, dsk.failure_predicted, dsk.capacity, dsk.spare_blocks, dsk.volgroup_id, dsk.desired_awre,  dsk.desired_arre, dsk.desired_noerrrcvry, dsk.disk_identity, dkh.disk_id, dkh.statistic_time, dkh.statistic_type, dkh.primary_defects,  dkh.grown_defects, dkh.recovrd_wrt_errs, dkh.unrecovrd_wrt_errs, dkh.bytes_written, dkh.recovrd_rd_errs, dkh.unrecovrd_rd_errs,  dkh.bytes_read, dkh.recovrd_vfy_errs, dkh.unrecovrd_vfy_errs, dkh.non_medium_errs, dkh.free_space, dkh.temperature, cmp.os_type,  case when cmp.user_provided_name is not null  and cmp.user_provided_name <> ''  then cmp.user_provided_name else cmp.display_name end display_name  from t_res_physical_volume dev,  t_stat_disk dsk,  t_stat_disk_hist dkh,  t_res_storage_subsystem cmp  where dev.physical_volume_id = dsk.disk_id  and   dsk.disk_id = dkh.disk_id  and   dev.subsystem_id = cmp.subsystem_id  and dkh.statistic_type = '3' union  select se.subsystem_id as cmpID, se.storage_extent_id as resID, 0, se.update_timestamp, se.update_timestamp, se.element_name, -1, -1, -1, -1, se.element_name, se.storage_extent_id, -1, -1, '', '', se.update_timestamp, -1, -1, CAST(NULL AS CHARACTER), -1, CAST(NULL AS CHARACTER), CAST(NULL AS CHARACTER), se.update_timestamp, '', dsk.disk_id, dsk.heads, dsk.cylinders, dsk.rpm, dsk.sector_size, dsk.sectors_avg_track, dsk.sectors_outr_track, dsk.sectors_innr_track,  dsk.logical_block_size, dsk.minutes_powered_on, dsk.write_protected, dsk.write_cache_enable, dsk.read_cache_disable, dsk.auto_write_realloc,  dsk.auto_read_realloc, dsk.no_error_recovery, dsk.failure_predicted, dsk.capacity, dsk.spare_blocks, dsk.volgroup_id, dsk.desired_awre, dsk.desired_arre,  dsk.desired_noerrrcvry, dsk.disk_identity, dkh.disk_id, dkh.statistic_time, dkh.statistic_type, dkh.primary_defects, dkh.grown_defects,  dkh.recovrd_wrt_errs, dkh.unrecovrd_wrt_errs, dkh.bytes_written, dkh.recovrd_rd_errs, dkh.unrecovrd_rd_errs, dkh.bytes_read, dkh.recovrd_vfy_errs,  dkh.unrecovrd_vfy_errs, dkh.non_medium_errs, dkh.free_space, dkh.temperature, cmp.os_type,  case when cmp.user_provided_name is not null  and cmp.user_provided_name <> ''  then cmp.user_provided_name else cmp.display_name end display_name  from t_res_storage_extent se,  t_stat_disk dsk,  t_stat_disk_hist dkh,  t_res_storage_subsystem cmp  where se.storage_extent_id = dsk.disk_id  and   dsk.disk_id = dkh.disk_id  and   se.subsystem_id = cmp.subsystem_id  and dkh.statistic_type = '3'";
    private static final String SELECT_VIRTUALIZED_MDISKS = "select svid, mdisk_id from t_res_storage_volume where mdisk_id > 0";
    private static final String ORDER_BY = " order by  cmpID, resID";
    private static final String FREESPACE = " and dkh.free_space >= 0 order by free_space desc";
    private static final String PRIMARY_DEFECTS = " and dkh.primary_defects  > 0 order by primary_defects desc";
    private static final String GROWN_DEFECTS = " and dkh.grown_defects > 0 order by grown_defects desc";
    private static final String RECOVERED_ERR = " and (dkh.recovrd_wrt_errs > 0 or dkh.recovrd_rd_errs  > 0 or dkh.recovrd_vfy_errs > 0 ) order by 64 desc";
    private static final String UNRECOVERED_ERR = " and (dkh.unrecovrd_wrt_errs > 0 or dkh.unrecovrd_rd_errs  > 0 or dkh.unrecovrd_vfy_errs > 0 ) order by 65 desc";
    private static final String PROBE_TIME = " order by statistic_time ";
    private static final String DISCOVERED_TIME = " order by 24";

    public RptDisk(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptDisk.class.getName(), (String)"RptDisk", (String)"dbc");
        }
        this.tableName = "t_res_physical_volume";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptDisk.class.getName(), (String)"RptDisk");
        }
    }

    public Serializable getReportData(GuiReportReq grr) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptDisk.class.getName(), (String)"getReportData", (String)"grr");
        }
        if (grr.reportSubtype < 0) {
            RptDiskAssetHist histRtn = new RptDiskAssetHist(this.dbc);
            Serializable traceResult = histRtn.getReportData(grr);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)RptDisk.class.getName(), (String)"getReportData", (Object)traceResult);
            }
            return traceResult;
        }
        Share shareList = new Share();
        shareList.shNext = null;
        Share share = shareList;
        int totalRows = 0;
        boolean rowSelected = true;
        ReportFilter filter = null;
        if (grr.columnFilters != null) {
            filter = new ReportFilter(grr, share);
        }
        Lun commonStorageList = this.getMDisksWithCommonStorage();
        try {
            String sqlText = SELECT + this.getReport(grr);
            this.selectStmt = this.prepareStmt(sqlText);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            Share curr = shareList;
            share = new Share();
            while (this.nextResult()) {
                String model;
                String vendor;
                DiskHistory diskHist;
                this.colIndex = 1;
                share.shComputerID = this.getInt(this.resultSet);
                share.shResourceID = this.getInt(this.resultSet);
                Share finder = shareList.shNext;
                while (finder != null && finder.shResourceID != share.shResourceID) {
                    finder = finder.shNext;
                }
                if (finder != null && finder.shResourceID == share.shResourceID) continue;
                DevAccess devAccess = new DevAccess();
                share.shResource = devAccess;
                Disk disk = new Disk();
                devAccess.daDevice = disk;
                disk.dskHistory = diskHist = new DiskHistory();
                share.shResourceType = this.getShort(this.resultSet);
                share.shScanTime = this.getTimestamp(this.resultSet);
                share.shRemovedTime = this.getTimestamp(this.resultSet);
                share.shPath = this.getString(this.resultSet);
                devAccess.daControllerID = this.getInt(this.resultSet);
                devAccess.daDeviceID = this.getInt(this.resultSet);
                devAccess.daTarget = this.getShort(this.resultSet);
                devAccess.daLUN = this.getShort(this.resultSet);
                devAccess.daPath = this.getString(this.resultSet);
                disk.devID = this.getInt(this.resultSet);
                TResVendorModel vmAccessor = new TResVendorModel(this.dbc);
                short vendor_id = this.getShort(this.resultSet);
                disk.devManufacturer = vendor = vmAccessor.getVendorName(vendor_id);
                disk.devModel = model = vmAccessor.getModelName(this.getShort(this.resultSet));
                disk.devSerialNumber = this.getString(this.resultSet);
                disk.devFirmwareRev = this.getString(this.resultSet);
                disk.devManufactureDate = this.getTimestamp(this.resultSet);
                disk.devUseCount = this.getShort(this.resultSet);
                disk.devType = this.getShort(this.resultSet);
                disk.devUnsupportedModel = this.getBoolean(this.resultSet);
                disk.devFlags = this.getShort(this.resultSet);
                disk.devRemovableMedium = this.getBoolean(this.resultSet);
                disk.devMultiPort = this.getBoolean(this.resultSet);
                disk.devDiscoveredTime = this.getTimestamp(this.resultSet);
                disk.devSubsystemSerialNumber = this.getString(this.resultSet);
                disk.devID = this.getInt(this.resultSet);
                disk.dskHeads = this.getInt(this.resultSet);
                disk.dskCylinders = this.getInt(this.resultSet);
                disk.dskRPM = this.getInt(this.resultSet);
                disk.dskSectorSize = this.getInt(this.resultSet);
                disk.dskSectorsPerAvgTrack = this.getInt(this.resultSet);
                disk.dskSectorsPerOuterTrack = this.getInt(this.resultSet);
                disk.dskSectorsPerInnerTrack = this.getInt(this.resultSet);
                disk.dskLogicalBlockSize = this.getInt(this.resultSet);
                disk.dskMinutesPoweredOn = this.getInt(this.resultSet);
                disk.dskWriteProtected = this.getBoolean(this.resultSet);
                disk.dskWriteCacheEnabled = this.getBoolean(this.resultSet);
                disk.dskReadCacheDisabled = this.getBoolean(this.resultSet);
                disk.dskAutoWriteRealloc = this.getBoolean(this.resultSet);
                disk.dskAutoReadRealloc = this.getBoolean(this.resultSet);
                disk.dskNoErrorRecovery = this.getBoolean(this.resultSet);
                disk.dskFailurePredicted = this.getBoolean(this.resultSet);
                disk.dskCapacity = this.getLong(this.resultSet);
                disk.dskSpareBlocks = this.getInt(this.resultSet);
                disk.dskVolgroupID = this.getInt(this.resultSet);
                disk.dskDesiredAWRE = this.getByte(this.resultSet);
                disk.dskDesiredARRE = this.getByte(this.resultSet);
                disk.dskDesiredNoErrRcvry = this.getByte(this.resultSet);
                disk.dskIdentity = this.getByte(this.resultSet);
                diskHist.dkhDiskID = this.getInt(this.resultSet);
                diskHist.dkhTimestamp = this.getTimestamp(this.resultSet);
                diskHist.dkhType = this.getByte(this.resultSet);
                diskHist.dkhPrimaryDefects = this.getInt(this.resultSet);
                diskHist.dkhGrownDefects = this.getInt(this.resultSet);
                diskHist.dkhRecoveredWriteErrors = this.getInt(this.resultSet);
                diskHist.dkhUnrecoveredWriteErrors = this.getInt(this.resultSet);
                diskHist.dkhBytesWritten = (long)this.getDouble(this.resultSet);
                diskHist.dkhRecoveredReadErrors = this.getInt(this.resultSet);
                diskHist.dkhUnrecoveredReadErrors = this.getInt(this.resultSet);
                diskHist.dkhBytesRead = (long)this.getDouble(this.resultSet);
                diskHist.dkhRecoveredVerifyErrors = this.getInt(this.resultSet);
                diskHist.dkhUnrecoveredVerifyErrors = this.getInt(this.resultSet);
                diskHist.dkhNonMediumErrors = this.getInt(this.resultSet);
                diskHist.dkhFreeSpace = this.getLong(this.resultSet);
                diskHist.dkhTemperature = this.getShort(this.resultSet);
                short osType = this.getShort(this.resultSet);
                if (Constants.isDiskArray((short)osType) || osType == 10) {
                    share.shComputerName = this.getString(this.resultSet);
                    share.shResourceType = (short)78;
                }
                if (filter != null) {
                    this.getComputerNames(share);
                    rowSelected = filter.isSelected(share);
                }
                if (this.isDiskToBeExcluded(disk.devID, commonStorageList)) {
                    rowSelected = false;
                } else if (filter == null) {
                    rowSelected = true;
                }
                if (!rowSelected) continue;
                curr.shNext = share;
                curr = share;
                ++totalRows;
                share = new Share();
            }
            this.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)RptDisk.class.getName(), (String)"getReportData", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        if (grr.isBatchReport) {
            this.getComputerNames(shareList.shNext);
        }
        Share[] traceResult = RptDisk.packUpShares(shareList.shNext, totalRows);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptDisk.class.getName(), (String)"getReportData", (Object)traceResult);
        }
        return traceResult;
    }

    private String getReport(GuiReportReq grr) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptDisk.class.getName(), (String)"getReport", (String)"grr");
        }
        switch (grr.reportSubtype) {
            case 1: {
                String traceResult = ORDER_BY;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)RptDisk.class.getName(), (String)"getReport", (Object)traceResult);
                }
                return traceResult;
            }
            case 39: {
                String traceResult = FREESPACE;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)RptDisk.class.getName(), (String)"getReport", (Object)traceResult);
                }
                return traceResult;
            }
            case 23: {
                String traceResult = PRIMARY_DEFECTS;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)RptDisk.class.getName(), (String)"getReport", (Object)traceResult);
                }
                return traceResult;
            }
            case 24: {
                String traceResult = GROWN_DEFECTS;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)RptDisk.class.getName(), (String)"getReport", (Object)traceResult);
                }
                return traceResult;
            }
            case 25: {
                String traceResult = RECOVERED_ERR;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)RptDisk.class.getName(), (String)"getReport", (Object)traceResult);
                }
                return traceResult;
            }
            case 26: {
                String traceResult = UNRECOVERED_ERR;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)RptDisk.class.getName(), (String)"getReport", (Object)traceResult);
                }
                return traceResult;
            }
            case 18: {
                String traceResult = PROBE_TIME;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)RptDisk.class.getName(), (String)"getReport", (Object)traceResult);
                }
                return traceResult;
            }
            case 37: {
                String traceResult = DISCOVERED_TIME;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)RptDisk.class.getName(), (String)"getReport", (Object)traceResult);
                }
                return traceResult;
            }
        }
        Object[] args = new Object[]{new Integer(grr.reportType), new Integer(grr.reportSubtype)};
        String errmsg = MessageLog.getMessage((String)"GEN0125E", (Object[])args);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptDisk.class.getName(), (String)"getReport");
        }
        throw new GeneralException(errmsg);
    }

    private void getComputerNames(Share node) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptDisk.class.getName(), (String)"getComputerNames", (String)"node");
        }
        AgentManager agentManager = Server.getAgentManager();
        while (node != null) {
            if (node.shResourceType == 10) {
                node.shComputerName = agentManager.getAgentName(node.shComputerID);
            }
            node = node.shNext;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptDisk.class.getName(), (String)"getComputerNames");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lun getMDisksWithCommonStorage() throws GeneralException {
        Lun lunList = null;
        Lun lun = new Lun();
        TResLogicalDisk ldAccessor = new TResLogicalDisk(this.dbc);
        try {
            this.selectStmt = this.prepareStmt(SELECT_VIRTUALIZED_MDISKS);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                this.colIndex = 1;
                lun.lunID = this.getInt(this.resultSet);
                lun.lunMdisk_id = this.getInt(this.resultSet);
                lun.lunNext = lunList;
                lunList = lun;
                lun = new Lun();
            }
        }
        catch (SQLException e) {
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            this.closeSelect();
        }
        return lunList;
    }

    private boolean isDiskToBeExcluded(int diskId, Lun mdiskList) {
        boolean excludeDisk = false;
        Lun tmpDsk = mdiskList;
        while (tmpDsk != null) {
            if (tmpDsk.lunMdisk_id == diskId) {
                excludeDisk = true;
                return excludeDisk;
            }
            tmpDsk = tmpDsk.lunNext;
        }
        return excludeDisk;
    }

    public static Share[] packUpShares(Share head, int totalRows) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptDisk.class.getName(), (String)"packUpShares", (String)"head, totalRows");
        }
        Share[] result = new Share[totalRows];
        totalRows = 0;
        while (head != null) {
            Share next = head.shNext;
            head.shNext = null;
            result[totalRows] = head;
            ++totalRows;
            head = next;
        }
        Share[] traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptDisk.class.getName(), (String)"packUpShares", (Object)traceResult);
        }
        return traceResult;
    }
}

