/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.report;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.GuiDataProvider;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.report.RptDisk;
import org.eclipse.aperi.repository.report.RptFsHist;
import org.eclipse.aperi.repository.report.filter.ReportFilter;
import org.eclipse.aperi.repository.table.TResShare;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.xmsg.MessageLog;

public class RptLogicalVolume
extends StorageRepositoryAccessor
implements GuiDataProvider {
    PreparedStatement selectMirrorsStmt;
    private int rowCount;
    private Share share = new Share();
    private ReportFilter filter;
    private static final String LV_SELECT_ALL = "select s.computer_id, s.resource_id, s.resource_type, s.scan_time, s.removed_time, s.path, l.logical_disk_id, l.parent_logdisk_id, l.logical_disk_type, l.capacity, l.use_count, l.mirror_count, l.is_swap, l.overhead from t_res_logical_disk l , t_res_share s, t_stat_computer c where s.resource_type = 11 and s.resource_id = l.logical_disk_id and l.parent_logdisk_id = -1 and s.computer_id = c.computer_id";
    private static final String ORDER_BY_LD = " order by l.logical_disk_id desc";
    private static final String WITHOUT_FS = " and l.logical_disk_id not in (select f.logical_disk_id from t_res_filesystem f)";
    private static final String FS_SELECT_ALL = "select f.filesystem_id, f.computer_id, f.group_id, f.logical_disk_id, f.log_disk_id, f.maxfiles, f.used_inodes, f.free_inodes, f.physical_size, f.capacity, f.used_space, f.free_space, f.last_scan_time, f.filesystem_type, f.use_count, f.mount_point, f.discovered_time from  t_res_filesystem f order by logical_disk_id";
    private static final String SELECT_SOME_BY_FS_PART1 = "select f.filesystem_id, f.computer_id, f.group_id, f.logical_disk_id, f.log_disk_id, f.maxfiles, f.used_inodes, f.free_inodes, f.physical_size, f.capacity, f.used_space, f.free_space, f.last_scan_time, f.filesystem_type, f.use_count, f.mount_point, f.discovered_time, s.computer_id, s.resource_id, s.resource_type, s.scan_time, s.removed_time, s.path, l.logical_disk_id, l.parent_logdisk_id, l.logical_disk_type, l.capacity, l.use_count, l.mirror_count, l.is_swap, l.overhead from  t_res_filesystem f, t_res_logical_disk l , t_res_share s where f.logical_disk_id = l.logical_disk_id and f.logical_disk_id = s.resource_id and f.computer_id  = s.computer_id";
    private static final String UNION_ALL = " union all ";
    private static final String SELECT_SOME_BY_FS_PART2 = "select ff.filesystem_id, ff.computer_id, ff.group_id, ff.logical_disk_id, ff.log_disk_id, ff.maxfiles, ff.used_inodes, ff.free_inodes, ff.physical_size, ff.capacity, ff.used_space, ff.free_space, ff.last_scan_time, ff.filesystem_type, ff.use_count, ff.mount_point, ff.discovered_time, ss.computer_id, ss.resource_id, ss.resource_type, ss.scan_time, ss.removed_time,";
    private static final String SELECT_SOME_BY_FS_PART3_NORMAL = " 'N/A', -1, -1, '0', -1, 0, 0, '0', 0";
    private static final String SELECT_SOME_BY_FS_PART4 = " from  t_res_filesystem ff, t_res_share ss  where ff.logical_disk_id <= 0 and ff.filesystem_id = ss.resource_id and ff.computer_id  = ss.computer_id";
    private static String selectSomeByFSPart2;
    private static final String FREESPACE_WHERE = " and free_space >= 0";
    private static final String FREESPACE_ORDERBY = " order by 12 ";
    private static final String PROBE_TIME = " order by 21 ";
    private static final String SCAN_TIME = " order by 13 ";
    private static final String DISCOVERED_TIME = " order by 17 ";
    private static final String REMOVED = " and logical_disk_id < 0 order by 22 ";

    public RptLogicalVolume(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptLogicalVolume.class.getName(), (String)"RptLogicalVolume", (String)"dbc");
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptLogicalVolume.class.getName(), (String)"RptLogicalVolume");
        }
    }

    public Serializable getReportData(GuiReportReq grr) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptLogicalVolume.class.getName(), (String)"getReportData", (String)"grr");
        }
        if (grr.reportSubtype == 28) {
            grr.productCode = 1;
            RptFsHist histRtn = new RptFsHist(this.dbc);
            Serializable traceResult = histRtn.getReportData(grr);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)RptLogicalVolume.class.getName(), (String)"getReportData", (Object)traceResult);
            }
            return traceResult;
        }
        this.rowCount = 0;
        Share shareList = null;
        this.tableName = "t_res_filesystem";
        StringBuffer buf = new StringBuffer(2000);
        this.filter = null;
        if (grr.columnFilters != null) {
            this.filter = new ReportFilter(grr, this.share);
        }
        switch (grr.reportSubtype) {
            case 2: {
                ReportFilter saveFilter = this.filter;
                this.filter = null;
                buf.append(LV_SELECT_ALL);
                buf.append(ORDER_BY_LD);
                this.selectStmt = this.prepareStmt(buf.toString());
                shareList = this.getLV(grr);
                if (shareList == null) break;
                this.selectStmt = this.prepareStmt(FS_SELECT_ALL);
                shareList = this.matchFS(shareList);
                if (saveFilter == null) break;
                shareList = this.applyFilter(shareList, saveFilter);
                break;
            }
            case 17: {
                buf.append(SELECT_SOME_BY_FS_PART1);
                buf.append(FREESPACE_WHERE);
                buf.append(UNION_ALL);
                buf.append(selectSomeByFSPart2);
                buf.append(FREESPACE_WHERE);
                buf.append(FREESPACE_ORDERBY);
                shareList = this.getSelectedLV(grr, buf);
                break;
            }
            case 18: {
                buf.append(SELECT_SOME_BY_FS_PART1);
                buf.append(UNION_ALL);
                buf.append(selectSomeByFSPart2);
                buf.append(PROBE_TIME);
                shareList = this.getSelectedLV(grr, buf);
                break;
            }
            case 19: {
                buf.append(SELECT_SOME_BY_FS_PART1);
                buf.append(UNION_ALL);
                buf.append(selectSomeByFSPart2);
                buf.append(SCAN_TIME);
                shareList = this.getSelectedLV(grr, buf);
                break;
            }
            case 37: {
                buf.append(SELECT_SOME_BY_FS_PART1);
                buf.append(UNION_ALL);
                buf.append(selectSomeByFSPart2);
                buf.append(DISCOVERED_TIME);
                shareList = this.getSelectedLV(grr, buf);
                break;
            }
            case 20: {
                buf.append(selectSomeByFSPart2);
                buf.append(REMOVED);
                shareList = this.getSelectedLV(grr, buf);
                break;
            }
            case 21: {
                buf.append(LV_SELECT_ALL);
                buf.append(WITHOUT_FS);
                buf.append(ORDER_BY_LD);
                this.selectStmt = this.prepareStmt(buf.toString());
                shareList = this.getLV(grr);
                break;
            }
            default: {
                Object[] args = new Object[]{new Integer(grr.reportType), new Integer(grr.reportSubtype)};
                String errmsg = MessageLog.getMessage((String)"GEN0125E", (Object[])args);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)RptLogicalVolume.class.getName(), (String)"getReportData");
                }
                throw new GeneralException(errmsg);
            }
        }
        buf = null;
        if (grr.isBatchReport) {
            this.getComputerNames(shareList);
        }
        Share[] traceResult = RptDisk.packUpShares(shareList, this.rowCount);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptLogicalVolume.class.getName(), (String)"getReportData", (Object)traceResult);
        }
        return traceResult;
    }

    public Share getLV(GuiReportReq grr) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptLogicalVolume.class.getName(), (String)"getLV", (String)"grr");
        }
        Share shareList = null;
        this.share.shResource = new LogicalDisk();
        boolean rowSelected = true;
        try {
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                this.colIndex = 1;
                this.fetchShare(this.share);
                this.fetchLogicalDisk((LogicalDisk)this.share.shResource);
                if (this.filter != null) {
                    this.getComputerNames(this.share);
                    rowSelected = this.filter.isSelected(this.share);
                }
                if (!rowSelected) continue;
                this.share.shNext = shareList;
                shareList = this.share;
                ++this.rowCount;
                this.share = new Share();
                this.share.shResource = new LogicalDisk();
            }
            this.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)RptLogicalVolume.class.getName(), (String)"getLV", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        Share traceResult = shareList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptLogicalVolume.class.getName(), (String)"getLV", traceResult);
        }
        return traceResult;
    }

    public Share matchFS(Share share) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptLogicalVolume.class.getName(), (String)"matchFS", (String)"share");
        }
        Share shareList = share;
        Share prev = null;
        try {
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            LogicalDisk ld = (LogicalDisk)share.shResource;
            TResShare accessorSH = new TResShare(this.dbc);
            accessorSH.prepGetUniqueShare();
            while (this.nextResult()) {
                Filesystem fs = new Filesystem();
                this.colIndex = 1;
                this.fetchFilesystem(fs);
                while (share != null && (ld.ldID < fs.fsLogicalDiskID || ld.ldID == fs.fsLogicalDiskID && share.shComputerID != fs.fsComputerID)) {
                    prev = share;
                    share = share.shNext;
                    if (share == null) continue;
                    ld = (LogicalDisk)share.shResource;
                }
                if (share == null || ld.ldID != fs.fsLogicalDiskID) {
                    Share sh = new Share();
                    ld = this.getBlankLogicalDisk();
                    sh.shResource = ld;
                    sh.shComputerID = fs.fsComputerID;
                    sh.shResourceID = fs.fsID;
                    accessorSH.getUniqueShare(sh);
                    sh.shPath = fs.fsLogicalDiskID == -1 ? "--- NOT MOUNTED ---" : " ";
                    sh.shNext = share;
                    share = sh;
                    if (prev != null) {
                        prev.shNext = sh;
                    } else {
                        shareList = sh;
                    }
                    ++this.rowCount;
                }
                ld.ldFilesystem = fs;
                prev = share;
                share = share.shNext;
                if (share == null) continue;
                ld = (LogicalDisk)share.shResource;
            }
            this.closeSelect();
            accessorSH.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)RptLogicalVolume.class.getName(), (String)"matchFS", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        Share traceResult = shareList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptLogicalVolume.class.getName(), (String)"matchFS", (Object)traceResult);
        }
        return traceResult;
    }

    public Share applyFilter(Share shareList, ReportFilter filter) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptLogicalVolume.class.getName(), (String)"applyFilter", (String)"shareList, filter");
        }
        this.getComputerNames(shareList);
        Share filteredList = null;
        Share prev = null;
        this.rowCount = 0;
        while (shareList != null) {
            this.share = shareList;
            shareList = this.share.shNext;
            if (!filter.isSelected(this.share)) continue;
            this.share.shNext = null;
            if (prev == null) {
                filteredList = this.share;
            } else {
                prev.shNext = this.share;
            }
            prev = this.share;
            ++this.rowCount;
        }
        Share traceResult = filteredList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptLogicalVolume.class.getName(), (String)"applyFilter", traceResult);
        }
        return traceResult;
    }

    public Share getSelectedLV(GuiReportReq grr, StringBuffer buf) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptLogicalVolume.class.getName(), (String)"getSelectedLV", (String)"grr, buf");
        }
        Share shareList = new Share();
        shareList.shNext = null;
        Share sh = this.share;
        LogicalDisk ld = new LogicalDisk();
        Filesystem fs = new Filesystem();
        this.share = shareList;
        boolean rowSelected = true;
        try {
            this.selectStmt = this.prepareStmt(buf.toString());
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                this.colIndex = 1;
                this.fetchFilesystem(fs);
                this.fetchShare(sh);
                this.fetchLogicalDisk(ld);
                ld.ldFilesystem = fs;
                sh.shResource = ld;
                if (this.filter != null) {
                    this.getComputerNames(sh);
                    rowSelected = this.filter.isSelected(sh);
                }
                if (!rowSelected) continue;
                this.share.shNext = sh;
                this.share = sh;
                ++this.rowCount;
                sh = new Share();
                ld = new LogicalDisk();
                fs = new Filesystem();
            }
            this.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)RptLogicalVolume.class.getName(), (String)"getSelectedLV", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        Share traceResult = shareList.shNext;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptLogicalVolume.class.getName(), (String)"getSelectedLV", (Object)traceResult);
        }
        return traceResult;
    }

    private void fetchFilesystem(Filesystem fs) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptLogicalVolume.class.getName(), (String)"fetchFilesystem", (String)"fs");
        }
        fs.fsID = this.getInt(this.resultSet);
        fs.fsComputerID = this.getInt(this.resultSet);
        fs.fsGroupID = this.getInt(this.resultSet);
        fs.fsLogicalDiskID = this.getInt(this.resultSet);
        fs.fsLogDiskID = this.getInt(this.resultSet);
        fs.fsMaxFiles = this.getInt(this.resultSet);
        fs.fsUsedInodes = this.getInt(this.resultSet);
        fs.fsFreeInodes = this.getInt(this.resultSet);
        fs.fsPhysicalSize = this.getLong(this.resultSet);
        fs.fsCapacity = this.getLong(this.resultSet);
        fs.fsUsedSpace = this.getLong(this.resultSet);
        fs.fsFreeSpace = this.getLong(this.resultSet);
        fs.fsScanTime = this.getTimestamp(this.resultSet);
        fs.fsType = this.getShort(this.resultSet);
        fs.fsUseCount = this.getShort(this.resultSet);
        fs.fsMountPoint = this.getString(this.resultSet);
        fs.fsDiscoveredTime = this.getTimestamp(this.resultSet);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptLogicalVolume.class.getName(), (String)"fetchFilesystem");
        }
    }

    private void fetchShare(Share share) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptLogicalVolume.class.getName(), (String)"fetchShare", (String)"share");
        }
        share.shComputerID = this.getInt(this.resultSet);
        share.shResourceID = this.getInt(this.resultSet);
        share.shResourceType = this.getShort(this.resultSet);
        share.shScanTime = this.getTimestamp(this.resultSet);
        share.shRemovedTime = this.getTimestamp(this.resultSet);
        share.shPath = this.getString(this.resultSet);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptLogicalVolume.class.getName(), (String)"fetchShare");
        }
    }

    private void fetchLogicalDisk(LogicalDisk ld) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptLogicalVolume.class.getName(), (String)"fetchLogicalDisk", (String)"ld");
        }
        ld.ldID = this.getInt(this.resultSet);
        ld.ldParentLogicalDiskID = this.getInt(this.resultSet);
        ld.ldType = this.getByte(this.resultSet);
        ld.ldCapacity = this.getLong(this.resultSet);
        ld.ldUseCount = this.getShort(this.resultSet);
        ld.ldMirrorCount = this.getByte(this.resultSet);
        ld.ldIsSwap = this.getBoolean(this.resultSet);
        ld.ldOverhead = this.getLong(this.resultSet);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptLogicalVolume.class.getName(), (String)"fetchLogicalDisk");
        }
    }

    private LogicalDisk getBlankLogicalDisk() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptLogicalVolume.class.getName(), (String)"getBlankLogicalDisk", (String)"");
        }
        LogicalDisk ld = new LogicalDisk();
        ld.ldID = -1;
        ld.ldParentLogicalDiskID = -1;
        ld.ldType = 0;
        ld.ldCapacity = -1L;
        ld.ldUseCount = 0;
        ld.ldMirrorCount = 0;
        ld.ldIsSwap = false;
        LogicalDisk traceResult = ld;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptLogicalVolume.class.getName(), (String)"getBlankLogicalDisk", (Object)traceResult);
        }
        return traceResult;
    }

    private void getComputerNames(Share node) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)RptLogicalVolume.class.getName(), (String)"getComputerNames", (String)"node");
        }
        AgentManager agentManager = Server.getAgentManager();
        while (node != null) {
            node.shComputerName = agentManager.getAgentName(node.shComputerID);
            node = node.shNext;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)RptLogicalVolume.class.getName(), (String)"getComputerNames");
        }
    }

    static {
        StringBuffer buf = new StringBuffer(600);
        buf.append(SELECT_SOME_BY_FS_PART2);
        buf.append(SELECT_SOME_BY_FS_PART3_NORMAL);
        buf.append(SELECT_SOME_BY_FS_PART4);
        selectSomeByFSPart2 = buf.toString();
    }
}

