/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.report;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.San.common.Lun;
import org.eclipse.aperi.TStorm.common.LogicalDisk;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Packer;
import org.eclipse.aperi.repository.GuiDataProvider;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.report.filter.ReportFilter;
import org.eclipse.aperi.repository.table.TResLogicalDisk;
import org.eclipse.aperi.repository.table.TResShare;
import org.eclipse.aperi.xmsg.MessageLog;

public class RptLun
extends RepositoryAccessor
implements GuiDataProvider {
    private Share share;
    private TResShare shAccessor;
    private static final String SELECT = ", d.subsystem_id , v.update_timestamp, v.display_name,  vendor.vendor_name, model.model_name, case when d.user_provided_name is not null  and d.user_provided_name <> ''  then d.user_provided_name else d.display_name end as ss_display_name,  d.os_type, v.mdisk_id, cimv.device_id from t_res_storage_volume v, t_res_storage_subsystem d, t_res_vendor vendor,   t_res_model model, t_res_cimkey_volume cimv where d.subsystem_id = v.subsystem_id  and model.model_id = d.model_id and vendor.vendor_id = d.vendor_id  and v.svid = cimv.volume_id";
    private static final String BY_SUBSYSTEM = " order by ss_display_name desc, v.name desc";
    private static final String BY_CAPACITY = " order by capacity";
    private static final String BY_PROBE_TIME = " order by v.update_timestamp desc";

    public RptLun(Connection dbc) {
        super(dbc);
        this.tableName = "t_res_storage_volume";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Serializable getReportData(GuiReportReq grr) throws GeneralException {
        Lun lunList = null;
        Lun lun = new Lun();
        LogicalDisk lDisk = new LogicalDisk();
        boolean rowSelected = true;
        ReportFilter filter = null;
        if (grr.columnFilters != null) {
            filter = new ReportFilter(grr, lun);
        }
        TResLogicalDisk ldAccessor = new TResLogicalDisk(this.dbc);
        try {
            this.selectStmt = this.prepareStmt(this.getSQLText(grr));
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                this.colIndex = ldAccessor.fetchLogicalDisk(lDisk, this.resultSet, true);
                lun.lunLogicalDisk = lDisk;
                lun.lunID = lDisk.ldID;
                lun.lunDaID = this.getInt(this.resultSet);
                lun.lunProbeTime = this.getTimestamp(this.resultSet);
                lun.lunName = lDisk.ldName;
                lun.lunWWN = this.getString(this.resultSet);
                lun.lunDaManufacturer = this.getString(this.resultSet);
                lun.lunDaModel = this.getString(this.resultSet);
                lun.lunDaAlias = this.getString(this.resultSet);
                lun.lunOSType = this.getShort(this.resultSet);
                lun.lunMdisk_id = this.getInt(this.resultSet);
                lun.lunDeviceId = this.getString(this.resultSet);
                if (!Constants.hasLunWWN((short)lun.lunOSType)) {
                    if (SQLUtil.isNullString(lun.lunName)) {
                        lun.lunName = lun.lunWWN;
                    }
                    lun.lunWWN = null;
                } else if (lun.lunOSType == 25 || lun.lunOSType == 27) {
                    if (!SQLUtil.isNullString(lun.lunName)) {
                        lun.lunWWN = lun.lunDeviceId;
                    } else {
                        lun.lunName = lun.lunDeviceId;
                        lun.lunWWN = null;
                    }
                }
                if (lDisk.ldSnapSourceID > 0) {
                    this.getDetachableMirrorInfo(lun);
                }
                if (filter != null) {
                    rowSelected = filter.isSelected(lun);
                }
                if (lun.lunMdisk_id > 0) {
                    rowSelected = false;
                } else if (filter == null) {
                    rowSelected = true;
                }
                if (!rowSelected) continue;
                lun.lunNext = lunList;
                lunList = lun;
                lun = new Lun();
                lDisk = new LogicalDisk();
            }
        }
        catch (SQLException e) {
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            this.close(this);
            if (this.shAccessor != null) {
                this.close(this.shAccessor);
            }
        }
        return (Serializable)Packer.pack(lunList);
    }

    private String getSQLText(GuiReportReq grr) throws GeneralException {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("select distinct");
        buffer.append(" v.svid, v.pool_id, v.logical_disk_type, v.capacity,  v.use_count, v.mirror_count, v.is_swap, v.snap_source_id,  v.is_vcmdb, v.replication_mode, v.not_exposed, v.overhead,  v.pool_id, v.lun_identity, -1, v.format, v.display_name, v.name,  v.package_redundancy, v.data_redundancy, v.is_assigned,  cimv.device_id ");
        buffer.append(SELECT);
        switch (grr.reportSubtype) {
            case 77: 
            case 79: {
                buffer.append(BY_SUBSYSTEM);
                break;
            }
            case 78: {
                buffer.append(BY_CAPACITY);
                break;
            }
            case 18: {
                buffer.append(BY_PROBE_TIME);
                break;
            }
            default: {
                Object[] args = new Object[]{new Integer(grr.reportType), new Integer(grr.reportSubtype)};
                String errmsg = MessageLog.getMessage((String)"GEN0125E", (Object[])args);
                throw new GeneralException(errmsg);
            }
        }
        return buffer.toString();
    }

    private void getDetachableMirrorInfo(Lun lun) throws GeneralException {
        if (this.shAccessor == null) {
            this.share = new Share();
            this.shAccessor = new TResShare(this.dbc);
            this.shAccessor.prepGetUniqueShare();
        }
        LogicalDisk lDisk = lun.lunLogicalDisk;
        this.share.shComputerID = lun.lunDaID;
        this.share.shResourceID = lDisk.ldSnapSourceID;
        this.share.shPath = null;
        this.shAccessor.getUniqueShare(this.share);
        if (this.share.shPath != null) {
            lun.lunPrimaryName = this.share.shPath;
        }
    }

    private void close(RepositoryAccessor accessor) {
        try {
            accessor.closeSelect();
        }
        catch (GeneralException generalException) {
            // empty catch block
        }
    }
}

