/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.report.filter;

import org.eclipse.aperi.TStorm.common.ColumnFilter;
import org.eclipse.aperi.TStorm.common.CustomReportDataAdjuster;
import org.eclipse.aperi.TStorm.server.guireq.GuiReportReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.report.filter.FilterEvaluator;
import org.eclipse.aperi.repository.report.filter.LikeEvaluator;
import org.eclipse.aperi.repository.report.filter.ReportFilter;

public class StringEvaluator {
    static FilterEvaluator makeEvaluator(GuiReportReq grr, ColumnFilter filter, CustomReportDataAdjuster adjuster) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)StringEvaluator.class.getName(), (String)"makeEvaluator", (String)"grr, filter, adjuster");
        }
        if (filter.clfCondition == 9 || filter.clfCondition == 10) {
            LikeEvaluator traceResult = new LikeEvaluator(filter, adjuster, grr.filtersIgnoreCase);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)StringEvaluator.class.getName(), (String)"makeEvaluator", (Object)traceResult);
            }
            return traceResult;
        }
        if (!grr.filtersIgnoreCase) {
            FilterEvaluator traceResult = ReportFilter.makeDefaultEvaluator(grr, filter, adjuster);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)StringEvaluator.class.getName(), (String)"makeEvaluator", (Object)traceResult);
            }
            return traceResult;
        }
        switch (filter.clfCondition) {
            case 1: 
            case 2: 
            case 7: 
            case 8: {
                EqEvaluator traceResult = new EqEvaluator(filter, adjuster);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)StringEvaluator.class.getName(), (String)"makeEvaluator", (Object)traceResult);
                }
                return traceResult;
            }
            case 4: 
            case 5: {
                LtEvaluator traceResult = new LtEvaluator(filter, adjuster);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)StringEvaluator.class.getName(), (String)"makeEvaluator", (Object)traceResult);
                }
                return traceResult;
            }
            case 3: 
            case 6: {
                GtEvaluator traceResult = new GtEvaluator(filter, adjuster);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)StringEvaluator.class.getName(), (String)"makeEvaluator", (Object)traceResult);
                }
                return traceResult;
            }
            case 11: 
            case 12: {
                BetweenEvaluator traceResult = new BetweenEvaluator(filter, adjuster);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)StringEvaluator.class.getName(), (String)"makeEvaluator", (Object)traceResult);
                }
                return traceResult;
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)StringEvaluator.class.getName(), (String)"makeEvaluator");
        }
        throw ReportFilter.badFilterCondition(grr, filter);
    }

    private static class BetweenEvaluator
    extends FilterEvaluator {
        public BetweenEvaluator(ColumnFilter filter, CustomReportDataAdjuster adjuster) {
            super(filter, adjuster);
        }

        public boolean isSelected(int row) {
            String lowRange;
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)BetweenEvaluator.class.getName(), (String)"isSelected", (String)"row");
            }
            boolean result = false;
            String reportValue = (String)this.adjuster.getCellData(row, (int)this.filter.clfColumnID);
            if (reportValue.compareToIgnoreCase(lowRange = (String)this.valueList.fvValue) >= 0) {
                String hiRange = (String)this.valueList.fvNext.fvValue;
                result = reportValue.compareToIgnoreCase(hiRange) <= 0;
            }
            boolean traceResult = this.applyNot ^ result;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)BetweenEvaluator.class.getName(), (String)"isSelected", (boolean)traceResult);
            }
            return traceResult;
        }

        public boolean isMatch(Object reportValue, Object userValue) {
            return false;
        }
    }

    private static class GtEvaluator
    extends FilterEvaluator {
        public GtEvaluator(ColumnFilter filter, CustomReportDataAdjuster adjuster) {
            super(filter, adjuster);
        }

        public boolean isMatch(Object reportValue, Object userValue) {
            String reportV = (String)reportValue;
            return reportV.compareToIgnoreCase((String)userValue) > 0;
        }
    }

    private static class LtEvaluator
    extends FilterEvaluator {
        public LtEvaluator(ColumnFilter filter, CustomReportDataAdjuster adjuster) {
            super(filter, adjuster);
        }

        public boolean isMatch(Object reportValue, Object userValue) {
            String reportV = (String)reportValue;
            return reportV.compareToIgnoreCase((String)userValue) < 0;
        }
    }

    private static class EqEvaluator
    extends FilterEvaluator {
        public EqEvaluator(ColumnFilter filter, CustomReportDataAdjuster adjuster) {
            super(filter, adjuster);
        }

        public boolean isMatch(Object reportValue, Object userValue) {
            String reportString = (String)reportValue;
            return reportString.equalsIgnoreCase((String)userValue);
        }
    }
}

