/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import org.eclipse.aperi.TStorm.common.AlertHeader;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.CreatorNameListProxy;
import org.eclipse.aperi.repository.CreatorNameQueryable;
import org.eclipse.aperi.repository.EditableObjectProxy;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.table.TAlertEmail;
import org.eclipse.aperi.server.guireq.AlertDefinition;
import org.eclipse.aperi.xmsg.MessageLog;

public class TAlertDefinition
extends RepositoryAccessor
implements CreatorNameQueryable {
    private static final AlertDefinition[] ARRAY_TYPE = new AlertDefinition[0];
    public static final String ID_COLUMN_NAME = "alert_id";
    TAlertEmail emailAccessor;
    private static final String SELECT_CLAUSE = "select alert_id, creator, name, enabled, product_id, alert_type, condition, threshold_type, threshold_value, snmp_trap, tec_event, os_log, os_log_severity, syslog_facility, email, notify_on_login, script_computer_id, script_name, dbms_type";
    private static final String SELECT_BY_RESOURCE = " from t_alert_definition a, t_res_attribute r where attribute_type = ? and exclude = '0' and attribute_id = alert_id and ((resource_type = ? and resource_id = ?) or (resource_type = ? and resource_id = ?) or (resource_type = ? and resource_id = ?) or resource_type = " + Short.toString((short)13) + ")" + " and not exists" + " (select 1 from t_res_attribute where exclude = '1'" + " and (resource_type = ? and resource_id = ?)" + " and attribute_type = ? and attribute_id = r.attribute_id)" + " and enabled = '1'" + " order by alert_id";
    private static final String SELECT_THRESHOLD_BY_ID = "select threshold_value from t_alert_definition where alert_id = ?";
    private static final String COLUMNS = "enabled, product_id, alert_type, condition, threshold_type, threshold_value, snmp_trap, tec_event, os_log, os_log_severity, syslog_facility, email, notify_on_login, script_computer_id, script_name, dbms_type";

    public TAlertDefinition(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertDefinition.class.getName(), (String)"TAlertDefinition", (String)"dbc");
        }
        this.tableName = "t_alert_definition";
        this.emailAccessor = new TAlertEmail(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertDefinition.class.getName(), (String)"TAlertDefinition");
        }
    }

    public void prepSelectByID(boolean allCols, boolean enabledOnly) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertDefinition.class.getName(), (String)"prepSelectByID", (String)"allCols, enabledOnly");
        }
        StringBuffer buffer = new StringBuffer(240);
        buffer.append(SELECT_CLAUSE);
        if (allCols) {
            buffer.append(", description, last_modified");
        }
        buffer.append(" from t_alert_definition where alert_id = ?");
        if (enabledOnly) {
            buffer.append(" and enabled = '1'");
        }
        this.emailAccessor.prepSelectByID();
        this.selectStmt = this.prepareStmt(buffer.toString());
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertDefinition.class.getName(), (String)"prepSelectByID");
        }
    }

    public AlertDefinition getByID(int alertID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertDefinition.class.getName(), (String)"getByID", (String)"alertID");
        }
        AlertDefinition traceResult = this.getByID(null, alertID);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertDefinition.class.getName(), (String)"getByID", (Object)traceResult);
        }
        return traceResult;
    }

    public void getByID(AlertHeader header) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertDefinition.class.getName(), (String)"getByID", (String)"header");
        }
        this.prepSelectByID(true, false);
        header.alert = this.getByID(header, header.ID);
        this.closeSelect();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertDefinition.class.getName(), (String)"getByID");
        }
    }

    private AlertDefinition getByID(AlertHeader header, int alertID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertDefinition.class.getName(), (String)"getByID", (String)"header, alertID");
        }
        AlertDefinition alert = null;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, alertID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.resultSet.next()) {
                alert = this.fetch(header);
            }
            this.resultSet.close();
            if (alert != null && alert.aldEmail) {
                this.emailAccessor.getAlertEmail(alert);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TAlertDefinition.class.getName(), (String)"getByID", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TAlertDefinition.class.getName(), (String)"getByID", (Throwable)e);
            }
            this.cleanup();
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TAlertDefinition.class.getName(), (String)"getByID");
            }
            throw e;
        }
        AlertDefinition traceResult = alert;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertDefinition.class.getName(), (String)"getByID", traceResult);
        }
        return traceResult;
    }

    private AlertDefinition fetch(AlertHeader header) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertDefinition.class.getName(), (String)"fetch", (String)"header");
        }
        AlertDefinition alert = new AlertDefinition();
        this.stmtPhase = 1;
        this.colIndex = 1;
        alert.aldAlertID = this.getInt(this.resultSet);
        alert.aldCreator = this.getString(this.resultSet);
        alert.setAldName(this.getString(this.resultSet));
        alert.aldEnabled = this.getBoolean(this.resultSet);
        alert.aldProductID = this.getShort(this.resultSet);
        alert.aldType = this.getShort(this.resultSet);
        alert.aldCondition = this.getShort(this.resultSet);
        alert.aldThresholdType = (byte)(this.getString(this.resultSet).charAt(0) - 48);
        alert.aldThresholdValue = this.getInt(this.resultSet);
        alert.aldSnmpTrap = this.getBoolean(this.resultSet);
        alert.aldTecEvent = this.getBoolean(this.resultSet);
        alert.aldOsLog = this.getBoolean(this.resultSet);
        alert.aldOsLogSeverity = this.getByte(this.resultSet);
        alert.aldSyslogFacility = this.getByte(this.resultSet);
        alert.aldEmail = this.getBoolean(this.resultSet);
        alert.aldNotifyOnLogin = this.getString(this.resultSet);
        alert.aldScriptComputerID = this.getInt(this.resultSet);
        alert.aldScriptName = this.getString(this.resultSet);
        alert.aldDbmsType = this.getByte(this.resultSet);
        if (header != null) {
            header.setDescription(this.getString(this.resultSet));
            header.lastModified = this.getLong(this.resultSet);
            header.creator = alert.aldCreator;
            header.setName(alert.getAldName());
            header.enabled = alert.aldEnabled;
        }
        AlertDefinition traceResult = alert;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertDefinition.class.getName(), (String)"fetch", (Object)traceResult);
        }
        return traceResult;
    }

    public AlertDefinition[] getByResource(short resourceType, int resourceID, short groupType, int groupID, short clusterGroupType, int clusterGroupID, short alertType) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertDefinition.class.getName(), (String)"getByResource", (String)"resourceType, resourceID, groupType, groupID, clusterGroupType, clusterGroupID, alertType");
        }
        ArrayList<AlertDefinition> alertArray = new ArrayList<AlertDefinition>();
        AlertDefinition[] alerts = null;
        this.emailAccessor.prepSelectByID();
        this.selectStmt = this.prepareStmt(SELECT_CLAUSE + SELECT_BY_RESOURCE);
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setShort(this.selectStmt, alertType);
            this.setShort(this.selectStmt, resourceType);
            this.setInt(this.selectStmt, resourceID);
            this.setShort(this.selectStmt, groupType);
            this.setInt(this.selectStmt, groupID);
            this.setShort(this.selectStmt, clusterGroupType);
            this.setInt(this.selectStmt, clusterGroupID);
            this.setShort(this.selectStmt, resourceType);
            this.setInt(this.selectStmt, resourceID);
            this.setShort(this.selectStmt, alertType);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            int lastAlertID = -1;
            while (this.resultSet.next()) {
                AlertDefinition alert = this.fetch(null);
                if (alert.aldAlertID == lastAlertID) continue;
                if (alert.aldEmail) {
                    this.emailAccessor.getAlertEmail(alert);
                }
                alertArray.add(alert);
                lastAlertID = alert.aldAlertID;
            }
            this.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TAlertDefinition.class.getName(), (String)"getByResource", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TAlertDefinition.class.getName(), (String)"getByResource", (Throwable)e);
            }
            this.cleanup();
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TAlertDefinition.class.getName(), (String)"getByResource");
            }
            throw e;
        }
        if (!alertArray.isEmpty()) {
            alerts = alertArray.toArray(ARRAY_TYPE);
        }
        AlertDefinition[] traceResult = alerts;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertDefinition.class.getName(), (String)"getByResource", (Object)traceResult);
        }
        return traceResult;
    }

    public void insert(CreateHeader header, AlertDefinition alert) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertDefinition.class.getName(), (String)"insert", (String)"header, alert");
        }
        String objectType = MessageLog.getMessageNoID((String)"STS0109L");
        alert.aldAlertID = header.ID;
        alert.aldEnabled = header.enabled;
        if (alert.aldEmail) {
            alert.aldEmailDef.aleAlertID = header.ID;
            this.emailAccessor.insert(alert.aldEmailDef);
        }
        EditableObjectProxy proxy = new EditableObjectProxy(this, header, objectType);
        proxy.initInsert(COLUMNS);
        try {
            this.setBoolean(this.insertStmt, alert.aldEnabled);
            this.setShort(this.insertStmt, alert.aldProductID);
            this.setShort(this.insertStmt, alert.aldType);
            this.setShort(this.insertStmt, alert.aldCondition);
            this.setString(this.insertStmt, Character.toString((char)(alert.aldThresholdType + 48)));
            this.setInt(this.insertStmt, alert.aldThresholdValue);
            this.setBoolean(this.insertStmt, alert.aldSnmpTrap);
            this.setBoolean(this.insertStmt, alert.aldTecEvent);
            this.setBoolean(this.insertStmt, alert.aldOsLog);
            this.setByte(this.insertStmt, alert.aldOsLogSeverity);
            this.setByte(this.insertStmt, alert.aldSyslogFacility);
            this.setBoolean(this.insertStmt, alert.aldEmail);
            this.setString(this.insertStmt, alert.aldNotifyOnLogin);
            this.setInt(this.insertStmt, alert.aldScriptComputerID);
            this.setString(this.insertStmt, alert.aldScriptName);
            this.setByte(this.insertStmt, alert.aldDbmsType);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TAlertDefinition.class.getName(), (String)"insert", (Throwable)e);
            }
            this.sqlError(e);
        }
        proxy.finishInsert();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertDefinition.class.getName(), (String)"insert");
        }
    }

    public void deleteByID(int alertID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertDefinition.class.getName(), (String)"deleteByID", (String)"alertID");
        }
        String objectType = MessageLog.getMessageNoID((String)"STS0109L");
        this.emailAccessor.deleteByID(alertID, objectType);
        EditableObjectProxy proxy = new EditableObjectProxy(this, null, objectType);
        proxy.deleteByID(alertID, ID_COLUMN_NAME);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertDefinition.class.getName(), (String)"deleteByID");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSelect() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertDefinition.class.getName(), (String)"closeSelect", (String)"");
        }
        try {
            super.closeSelect();
        }
        finally {
            this.emailAccessor.closeSelect();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertDefinition.class.getName(), (String)"closeSelect");
        }
    }

    public void cleanup() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertDefinition.class.getName(), (String)"cleanup", (String)"");
        }
        super.cleanup();
        this.emailAccessor.cleanup();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertDefinition.class.getName(), (String)"cleanup");
        }
    }

    public NameList selectNames(GuiListReq requestData) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertDefinition.class.getName(), (String)"selectNames", (String)"requestData");
        }
        CreatorNameListProxy proxy = new CreatorNameListProxy(this, requestData);
        NameList traceResult = proxy.select();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertDefinition.class.getName(), (String)"selectNames", (Object)traceResult);
        }
        return traceResult;
    }

    public String getIDColumnName() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertDefinition.class.getName(), (String)"getIDColumnName", (String)"");
        }
        String traceResult = ID_COLUMN_NAME;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertDefinition.class.getName(), (String)"getIDColumnName", (Object)traceResult);
        }
        return traceResult;
    }

    public void appendWhereClause(GuiListReq requestData, StringBuffer buf) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertDefinition.class.getName(), (String)"appendWhereClause", (String)"requestData, buf");
        }
        buf.append(" WHERE alert_type = ");
        buf.append(Short.toString(requestData.resourceType));
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertDefinition.class.getName(), (String)"appendWhereClause");
        }
    }

    public void addQualifiers(GuiListReq requestData, NameList element) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertDefinition.class.getName(), (String)"addQualifiers", (String)"requestData, element");
        }
        element.nlID2 = requestData.resourceType;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertDefinition.class.getName(), (String)"addQualifiers");
        }
    }

    public AlertDefinition[] getByResource(short resourceType, int resourceID, short groupType, int groupID, short alertType) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertDefinition.class.getName(), (String)"getByResource", (String)"resourceType, resourceID, groupType, groupID, alertType");
        }
        ArrayList<AlertDefinition> alertArray = new ArrayList<AlertDefinition>();
        AlertDefinition[] alerts = null;
        this.emailAccessor.prepSelectByID();
        this.selectStmt = this.prepareStmt(SELECT_CLAUSE + SELECT_BY_RESOURCE);
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setShort(this.selectStmt, alertType);
            this.setShort(this.selectStmt, resourceType);
            this.setInt(this.selectStmt, resourceID);
            this.setShort(this.selectStmt, groupType);
            this.setInt(this.selectStmt, groupID);
            this.setShort(this.selectStmt, resourceType);
            this.setInt(this.selectStmt, resourceID);
            this.setShort(this.selectStmt, alertType);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            int lastAlertID = -1;
            while (this.resultSet.next()) {
                AlertDefinition alert = this.fetch(null);
                if (alert.aldAlertID == lastAlertID) continue;
                if (alert.aldEmail) {
                    this.emailAccessor.getAlertEmail(alert);
                }
                alertArray.add(alert);
                lastAlertID = alert.aldAlertID;
            }
            this.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TAlertDefinition.class.getName(), (String)"getByResource", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TAlertDefinition.class.getName(), (String)"getByResource", (Throwable)e);
            }
            this.cleanup();
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TAlertDefinition.class.getName(), (String)"getByResource");
            }
            throw e;
        }
        if (!alertArray.isEmpty()) {
            alerts = alertArray.toArray(ARRAY_TYPE);
        }
        AlertDefinition[] traceResult = alerts;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertDefinition.class.getName(), (String)"getByResource", (Object)traceResult);
        }
        return traceResult;
    }

    public void prepGetThresholdByID() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertDefinition.class.getName(), (String)"prepGetThresholdByID", (String)"");
        }
        this.selectStmt = this.prepareStmt(SELECT_THRESHOLD_BY_ID);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertDefinition.class.getName(), (String)"prepGetThresholdByID");
        }
    }

    public long getThresholdByID(int alertID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TAlertDefinition.class.getName(), (String)"getThresholdByID", (String)"alertID");
        }
        long result = 0L;
        this.execQueryByID(alertID);
        if (this.nextResult()) {
            try {
                this.getPhase();
                result = this.getLong(this.resultSet);
            }
            catch (SQLException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)TAlertDefinition.class.getName(), (String)"getThresholdByID", (Throwable)e);
                }
                this.stmtType = 0;
                this.sqlError(e);
            }
        }
        this.closeResultSet();
        long traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertDefinition.class.getName(), (String)"getThresholdByID", (long)traceResult);
        }
        return traceResult;
    }
}

