/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import org.eclipse.aperi.TStorm.server.guireq.GuiChartSettingsReq;
import org.eclipse.aperi.common.ChartOptions;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;

public class TChartSettings
extends StorageRepositoryAccessor {
    private static final String GET_ALL_BY_CREATOR = "select report_id, report_subtype, chart_id, chart_subtype, batch_id, chart_type, hover_text, x_axis, trend_data, max_charts, max_series, title from t_chart_settings where creator = ?";
    private static final String GET = "select chart_type, hover_text, x_axis, trend_data, max_charts, max_series, title from t_chart_settings where report_id = ? and report_subtype = ? and chart_id = ? and chart_subtype = ? and creator = ? and batch_id = ?";
    private static final String INSERT = "insert into t_chart_settings (report_id, report_subtype, chart_id, chart_subtype, creator, batch_id, chart_type, hover_text, x_axis, trend_data, max_charts, max_series, title) values (?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String UPDATE_ALL = "update t_chart_settings set chart_type = ?, hover_text = ?, x_axis = ?, trend_data = ?, max_charts = ?, max_series = ?, title = ? where report_id = ? and report_subtype = ? and chart_id = ? and chart_subtype = ? and creator = ? and batch_id = ?";
    private static final String DELETE = "delete from t_chart_settings where report_id = ? and report_subtype = ? and chart_id = ? and chart_subtype = ? and creator = ? and batch_id = ?";
    private static final String DELETE_BATCH = "delete from t_chart_settings where batch_id = ?";

    public TChartSettings(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TChartSettings.class.getName(), (String)"TChartSettings", (String)"dbc");
        }
        this.tableName = "t_chart_settings";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TChartSettings.class.getName(), (String)"TChartSettings");
        }
    }

    public ChartOptions select(int report_id, int report_subtype, int chart_id, int chart_subtype, String user, int batch_id) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TChartSettings.class.getName(), (String)"select", (String)"report_id, report_subtype, chart_id, chart_subtype, user, batch_id");
        }
        ChartOptions chartOpts = null;
        try {
            this.selectStmt = this.prepareStmt(GET);
            this.setPhase();
            this.setInt(this.selectStmt, report_id);
            this.setInt(this.selectStmt, report_subtype);
            this.setInt(this.selectStmt, chart_id);
            this.setInt(this.selectStmt, chart_subtype);
            String creator = user;
            this.setString(this.selectStmt, creator);
            this.setInt(this.selectStmt, batch_id);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.getPhase();
            if (this.resultSet.next()) {
                chartOpts = new ChartOptions();
                chartOpts.chartType = this.getShort(this.resultSet);
                chartOpts.hoverText = this.getBoolean(this.resultSet);
                chartOpts.xaxisScale = this.getShort(this.resultSet);
                chartOpts.trends = this.getBoolean(this.resultSet);
                chartOpts.chartsPerView = this.getInt(this.resultSet);
                chartOpts.seriesPerChart = this.getInt(this.resultSet);
                chartOpts.title = this.getString(this.resultSet);
            } else if (batch_id > 0) {
                this.closeSelect();
                this.selectStmt = this.prepareStmt(GET);
                this.setPhase();
                this.setInt(this.selectStmt, report_id);
                this.setInt(this.selectStmt, report_subtype);
                this.setInt(this.selectStmt, chart_id);
                this.setInt(this.selectStmt, chart_subtype);
                this.setString(this.selectStmt, creator);
                this.setInt(this.selectStmt, 0);
                this.stmtPhase = 3;
                this.resultSet = this.selectStmt.executeQuery();
                this.getPhase();
                if (this.resultSet.next()) {
                    chartOpts = new ChartOptions();
                    chartOpts.chartType = this.getShort(this.resultSet);
                    chartOpts.hoverText = this.getBoolean(this.resultSet);
                    chartOpts.xaxisScale = this.getShort(this.resultSet);
                    chartOpts.trends = this.getBoolean(this.resultSet);
                    chartOpts.chartsPerView = this.getInt(this.resultSet);
                    chartOpts.seriesPerChart = this.getInt(this.resultSet);
                    chartOpts.title = this.getString(this.resultSet);
                }
            }
            this.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TChartSettings.class.getName(), (String)"select", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        ChartOptions traceResult = chartOpts;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TChartSettings.class.getName(), (String)"select", traceResult);
        }
        return traceResult;
    }

    public ArrayList select_all_by_creator(String user) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TChartSettings.class.getName(), (String)"select_all_by_creator", (String)"user");
        }
        ArrayList<GuiChartSettingsReq> al = new ArrayList<GuiChartSettingsReq>();
        try {
            this.selectStmt = this.prepareStmt(GET_ALL_BY_CREATOR);
            this.setPhase();
            this.setString(this.selectStmt, user);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            while (this.resultSet.next()) {
                this.getPhase();
                GuiChartSettingsReq gcsr = new GuiChartSettingsReq();
                gcsr.reportId = this.getShort(this.resultSet);
                gcsr.reportSubtype = this.getShort(this.resultSet);
                gcsr.chartId = this.getShort(this.resultSet);
                gcsr.chartSubtype = this.getShort(this.resultSet);
                gcsr.batchId = this.getShort(this.resultSet);
                ChartOptions chartOpts = new ChartOptions();
                chartOpts.chartType = this.getShort(this.resultSet);
                chartOpts.hoverText = this.getBoolean(this.resultSet);
                chartOpts.xaxisScale = this.getShort(this.resultSet);
                chartOpts.trends = this.getBoolean(this.resultSet);
                chartOpts.chartsPerView = this.getInt(this.resultSet);
                chartOpts.seriesPerChart = this.getInt(this.resultSet);
                chartOpts.title = this.getString(this.resultSet);
                gcsr.options = chartOpts;
                al.add(gcsr);
            }
            this.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TChartSettings.class.getName(), (String)"select", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        ArrayList<GuiChartSettingsReq> traceResult = al;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TChartSettings.class.getName(), (String)"select_all_by_creator", traceResult);
        }
        return traceResult;
    }

    public void delete(int report_id, int report_subtype, int chart_id, int chart_subtype, String user, int batch_id) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TChartSettings.class.getName(), (String)"delete", (String)"report_id, report_subtype, chart_id, chart_subtype, user, batch_id");
        }
        this.deleteStmt = this.prepareStmt(DELETE);
        this.setPhase();
        try {
            this.setInt(this.deleteStmt, report_id);
            this.setInt(this.deleteStmt, report_subtype);
            this.setInt(this.deleteStmt, chart_id);
            this.setInt(this.deleteStmt, chart_subtype);
            this.setString(this.deleteStmt, user);
            this.setInt(this.deleteStmt, batch_id);
            this.executeUpdate(this.deleteStmt);
            this.commit();
            this.closeDelete();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TChartSettings.class.getName(), (String)"delete", (Throwable)e);
            }
            this.stmtType = 3;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TChartSettings.class.getName(), (String)"delete");
        }
    }

    public void delete_batch(int batch_id) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TChartSettings.class.getName(), (String)"delete_batch", (String)"batch_id");
        }
        this.deleteStmt = this.prepareStmt(DELETE_BATCH);
        this.setPhase();
        try {
            this.setInt(this.deleteStmt, batch_id);
            this.executeUpdate(this.deleteStmt);
            this.commit();
            this.closeDelete();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TChartSettings.class.getName(), (String)"delete_batch", (Throwable)e);
            }
            this.stmtType = 3;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TChartSettings.class.getName(), (String)"delete_batch");
        }
    }

    public void insert(ChartOptions co, int report_id, int report_subtype, int chart_id, int chart_subtype, String creator, int batch_id) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TChartSettings.class.getName(), (String)"insert", (String)"co, report_id, report_subtype, chart_id, chart_subtype, creator, batch_id");
        }
        this.insertStmt = this.prepareStmt(INSERT);
        this.setPhase();
        try {
            this.setInt(this.insertStmt, report_id);
            this.setInt(this.insertStmt, report_subtype);
            this.setInt(this.insertStmt, chart_id);
            this.setInt(this.insertStmt, chart_subtype);
            this.setString(this.insertStmt, new String(creator));
            this.setInt(this.insertStmt, batch_id);
            this.setInt(this.insertStmt, co.chartType);
            this.setBoolean(this.insertStmt, co.hoverText);
            this.setInt(this.insertStmt, co.xaxisScale);
            this.setBoolean(this.insertStmt, co.trends);
            this.setInt(this.insertStmt, co.chartsPerView);
            this.setInt(this.insertStmt, co.seriesPerChart);
            this.setString(this.insertStmt, co.title);
            this.executeUpdate(this.insertStmt);
            this.commit();
            this.closeInsert();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TChartSettings.class.getName(), (String)"insert", (Throwable)e);
            }
            this.stmtType = 1;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TChartSettings.class.getName(), (String)"insert");
        }
    }

    public void updateAll(ChartOptions co, int report_id, int report_subtype, int chart_id, int chart_subtype, String creator, int batch_id) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TChartSettings.class.getName(), (String)"updateAll", (String)"co, report_id, report_subtype, chart_id, chart_subtype, creator, batch_id");
        }
        try {
            this.stmtType = 0;
            this.selectStmt = this.prepareStmt(GET);
            this.setPhase();
            this.setInt(this.selectStmt, report_id);
            this.setInt(this.selectStmt, report_subtype);
            this.setInt(this.selectStmt, chart_id);
            this.setInt(this.selectStmt, chart_subtype);
            this.setString(this.selectStmt, creator);
            this.setInt(this.selectStmt, batch_id);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.getPhase();
            if (this.resultSet.next()) {
                this.closeSelect();
                this.stmtType = 2;
                this.updateStmt = this.prepareStmt(UPDATE_ALL);
                this.setPhase();
                this.setInt(this.updateStmt, co.chartType);
                this.setBoolean(this.updateStmt, co.hoverText);
                this.setShort(this.updateStmt, co.xaxisScale);
                this.setBoolean(this.updateStmt, co.trends);
                this.setInt(this.updateStmt, co.chartsPerView);
                this.setInt(this.updateStmt, co.seriesPerChart);
                this.setString(this.updateStmt, co.title);
                this.setInt(this.updateStmt, report_id);
                this.setInt(this.updateStmt, report_subtype);
                this.setInt(this.updateStmt, chart_id);
                this.setInt(this.updateStmt, chart_subtype);
                this.setString(this.updateStmt, new String(creator));
                this.setInt(this.updateStmt, batch_id);
                this.executeUpdate(this.updateStmt);
                this.commit();
                this.closeUpdate();
            } else {
                this.closeSelect();
                this.insert(co, report_id, report_subtype, chart_id, chart_subtype, creator, batch_id);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TChartSettings.class.getName(), (String)"updateAll", (Throwable)e);
            }
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TChartSettings.class.getName(), (String)"updateAll");
        }
    }
}

