/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Arrays;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.identity.HardwareID;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.table.TResVendorModel;
import org.eclipse.aperi.xmsg.MessageLog;

public class TComputer {
    public int computerID = -1;
    public HardwareID hwID;
    public String tsName;
    public String ipAddress;
    public String networkName;
    public String domainName;
    public String timezoneID;
    public byte[] productState = null;
    public TComputer next = null;
    public String guid = null;
    public boolean wasAgentLess;
    private static final String SELECT_SQL_TEXT = "select computer_id, vendor_id, hardware_id, host_url, os_type, host_name, network_name, domain_name, ip_address, time_zone, product_states, guid, cpu_architecture from t_res_host ";
    private static final String SELECT_BY_HOST = "where host_name = ? or (vendor_id = ? and hardware_id = ?)";
    private static final String SELECT_BY_ID = "where computer_id = ?";
    private static final String SELECT_BY_GUID = "where guid = ?";
    private static final String SELECT_SS_SQL_TEXT = "select subsystem_id, vendor_id,  case when user_provided_name is not null  and user_provided_name <> ''  then user_provided_name  else display_name end display_name,  os_type, name, ip_address, product_states from t_res_storage_subsystem ";
    private static final String SELECT_BY_SS_ID = "where subsystem_id = ?";
    private static final String INSERT_SQL_TEXT = "insert into t_res_host (computer_id, vendor_id, hardware_id, host_url, os_type, host_name, network_name, domain_name, ip_address, time_zone, discovered_time, product_states, guid, cpu_architecture, original_alias)  values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
    private static final String INSERT_SS_SQL_TEXT = "insert into t_res_storage_subsystem (vendor_id,  display_name, os_type, name, name_type, ip_address, product_states)  values (?,?,?,?,?,?,?)";
    private PreparedStatement insert = null;
    private static final String UPDATE_SQL_TEXT = "update t_res_host set ip_address = ?, time_zone = ?, host_url = ?, os_type = ?, cpu_architecture = ?";
    private static String UPDATE_RDBMS_HOST_SQL_TEXT = "update t_res_host set host_name = ?, vendor_id = ?, hardware_id = ? where network_name = ? and domain_name = ? and os_type = 24";
    private static final String UPDATE_STATE_TEXT = "update t_res_host set product_states = ? where computer_id = ?";
    private static final String UPDATE_OSVERSION_TEXT = "update t_res_host set os_version = ? where computer_id = ?";
    private static final String UPDATE_NAMENSTATE_TEXT = " update t_res_host set host_name = ?, host_url = ?,  network_name = ?  where computer_id = ?";
    private PreparedStatement stateUpdate = null;

    public TComputer(String tsName, HardwareID hwID, String netName, String ipAddress, String timezoneID, byte[] pProductState, String guid) {
        this(tsName, hwID, null, null, ipAddress, timezoneID, pProductState, guid);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TComputer.class.getName(), (String)"TComputer", (String)"tsName, hwID, netName, ipAddress, timezoneID, pProductState, guid");
        }
        if (netName != null) {
            int delimiterPos = netName.indexOf(46);
            if (delimiterPos < 0) {
                this.networkName = netName;
            } else {
                this.networkName = netName.substring(0, delimiterPos);
                this.domainName = netName.substring(delimiterPos + 1);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TComputer.class.getName(), (String)"TComputer");
        }
    }

    public TComputer(String tsName, HardwareID hwID, String networkName, String domainName, String ipAddress, String timezoneID, byte[] productState, String guid) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TComputer.class.getName(), (String)"TComputer", (String)"tsName, hwID, networkName, domainName, ipAddress, timezoneID, productState, guid");
        }
        this.tsName = tsName;
        this.hwID = hwID;
        this.timezoneID = timezoneID;
        this.ipAddress = ipAddress;
        this.networkName = networkName;
        this.domainName = domainName;
        this.productState = productState;
        this.guid = guid;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TComputer.class.getName(), (String)"TComputer");
        }
    }

    public TComputer() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TComputer.class.getName(), (String)"TComputer", (String)"");
        }
        this.hwID = new HardwareID(null, null, null, 0);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TComputer.class.getName(), (String)"TComputer");
        }
    }

    public static TComputer getComputer(String tsName, HardwareID hwID, int computerID, String guid, Connection dbConnection) throws SQLException {
        TComputer anchor;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TComputer.class.getName(), (String)"getComputer", (String)"tsName, hwID, computerID, guid, dbConnection");
        }
        TComputer prev = anchor = new TComputer();
        TComputer computer = null;
        PreparedStatement select = null;
        TResVendorModel vmAccessor = new TResVendorModel(dbConnection);
        try {
            StringBuffer selectSql = new StringBuffer(256);
            selectSql.append(SELECT_SQL_TEXT);
            if (computerID == -1) {
                selectSql.append(SELECT_BY_HOST);
            } else if (computerID == -3) {
                selectSql.append(SELECT_BY_GUID);
            } else if (computerID != -2) {
                selectSql.append(SELECT_BY_ID);
            }
            select = dbConnection.prepareStatement(selectSql.toString());
            if (computerID == -1 && hwID != null) {
                select.setString(1, tsName);
                short vendor_id = vmAccessor.getVendorID(hwID.manufacturer);
                select.setShort(2, vendor_id);
                SQLUtil.setBytes(select, 3, hwID.hardwareID);
            } else if (computerID == -3) {
                select.setString(1, guid);
            } else if (computerID != -2) {
                select.setInt(1, computerID);
            }
            ResultSet rs = select.executeQuery();
            while (rs.next()) {
                computerID = rs.getInt(1);
                String fManufacturer = vmAccessor.getVendorName(rs.getShort(2));
                byte[] fIdentity = SQLUtil.getBytes(rs, 3);
                String fHostname = rs.getString(4);
                short fOsType = rs.getShort(5);
                String fTsName = rs.getString(6);
                String fNetworkName = rs.getString(7);
                String fDomainName = rs.getString(8);
                String fIpAddress = rs.getString(9);
                String fTimezoneID = rs.getString(10);
                byte[] repoState = SQLUtil.getBytes(rs, 11);
                String fGuid = rs.getString(12);
                short fCPUArch = rs.getShort(13);
                HardwareID fHwID = new HardwareID(fIdentity, fManufacturer, fHostname, fOsType, fCPUArch);
                computer = new TComputer(fTsName, fHwID, fNetworkName, fDomainName, fIpAddress, fTimezoneID, repoState, fGuid);
                computer.computerID = computerID;
                prev.next = computer;
                prev = computer;
            }
            select.close();
            dbConnection.commit();
            TComputer.getSS(computerID, dbConnection, anchor, prev);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TComputer.class.getName(), (String)"getComputer", (Throwable)e);
            }
            SQLUtil.errorCleanup(dbConnection, select);
            if (tsName == null) {
                tsName = "COMPUTER ID:" + computerID;
            }
            SQLUtil.logSQLException("SRV0052E", e, new Object[]{tsName});
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TComputer.class.getName(), (String)"getComputer");
            }
            throw e;
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TComputer.class.getName(), (String)"getComputer", (Throwable)e);
            }
            SQLUtil.errorCleanup(dbConnection, select);
        }
        TComputer traceResult = anchor.next;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TComputer.class.getName(), (String)"getComputer", (Object)traceResult);
        }
        return traceResult;
    }

    public static TComputer getSS(int computerID, Connection dbConnection) throws SQLException {
        return TComputer.getSS(computerID, dbConnection, null, null);
    }

    private static TComputer getSS(int computerID, Connection dbConnection, TComputer head, TComputer tail) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TComputer.class.getName(), (String)"getSS", (String)"tsName, hwID, computerID, dbConnection");
        }
        TComputer anchor = null;
        TComputer prev = null;
        TComputer computer = null;
        TComputer traceResult = null;
        if (head != null) {
            anchor = head;
            prev = tail;
        } else {
            prev = anchor = new TComputer();
        }
        PreparedStatement select = null;
        try {
            StringBuffer selectSql = new StringBuffer(256);
            selectSql.append(SELECT_SS_SQL_TEXT);
            if (computerID != -2) {
                selectSql.append(SELECT_BY_SS_ID);
            }
            select = dbConnection.prepareStatement(selectSql.toString());
            if (computerID != -2) {
                select.setInt(1, computerID);
            }
            ResultSet rs = select.executeQuery();
            while (rs.next()) {
                computerID = rs.getInt(1);
                TResVendorModel vmAccessor = new TResVendorModel(dbConnection);
                String fManufacturer = vmAccessor.getVendorName(rs.getShort(2));
                String fHostname = rs.getString(3);
                short fOsType = rs.getShort(4);
                String fTsName = rs.getString(5);
                String fIpAddress = rs.getString(6);
                byte[] repoState = SQLUtil.getBytes(rs, 7);
                HardwareID fHwID = new HardwareID(null, fManufacturer, fHostname, fOsType, -1);
                computer = new TComputer(fTsName, fHwID, null, null, fIpAddress, null, repoState, null);
                computer.computerID = computerID;
                prev.next = computer;
                prev = computer;
            }
            select.close();
            dbConnection.commit();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TComputer.class.getName(), (String)"getComputer", (Throwable)e);
            }
            SQLUtil.errorCleanup(dbConnection, select);
            SQLUtil.logSQLException("SRV0052E", e, new Object[]{new Integer(computerID)});
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TComputer.class.getName(), (String)"getComputer");
            }
            throw e;
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TComputer.class.getName(), (String)"getSS", (Throwable)e);
            }
            SQLUtil.errorCleanup(dbConnection, select);
        }
        traceResult = head != null ? anchor : anchor.next;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TComputer.class.getName(), (String)"getSS", (Object)traceResult);
        }
        return traceResult;
    }

    public int addComputer(Connection dbConnection) {
        int status;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TComputer.class.getName(), (String)"addComputer", (String)"dbConnection");
        }
        if ((status = this.insertComputer(dbConnection)) == 4) {
            TComputer repoComputer;
            block10: {
                repoComputer = null;
                try {
                    repoComputer = TComputer.getComputer(this.tsName, this.hwID, -1, null, dbConnection);
                }
                catch (SQLException e) {
                    if (!TraceLogger.enableTrace) break block10;
                    TraceLogger.exception((String)TComputer.class.getName(), (String)"addComputer", (Throwable)e);
                }
            }
            if (repoComputer == null) {
                int traceResult = 16;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TComputer.class.getName(), (String)"addComputer", (int)traceResult);
                }
                return traceResult;
            }
            this.computerID = repoComputer.computerID;
            if (!this.equalsRepositoryComputer(repoComputer)) {
                int traceResult = this.updateComputer(repoComputer, dbConnection);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TComputer.class.getName(), (String)"addComputer", (int)traceResult);
                }
                return traceResult;
            }
            int traceResult = 0;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TComputer.class.getName(), (String)"addComputer", (int)traceResult);
            }
            return traceResult;
        }
        int traceResult = status;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TComputer.class.getName(), (String)"addComputer", (int)traceResult);
        }
        return traceResult;
    }

    public int insertComputer(Connection dbConnection) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TComputer.class.getName(), (String)"insertComputer", (String)"dbConnection");
        }
        TComputer duplicateComputer = null;
        try {
            duplicateComputer = TComputer.getComputer(null, null, -3, this.guid, dbConnection);
            if (duplicateComputer != null) {
                int traceResult = 4;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TComputer.class.getName(), (String)"insertComputer", (int)traceResult);
                }
                return traceResult;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TComputer.class.getName(), (String)"insertComputer", (Throwable)e);
            }
            SQLUtil.logSQLException("SRV0050E", e, new Object[]{this.tsName});
            int traceResult = 16;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TComputer.class.getName(), (String)"insertComputer", (int)traceResult);
            }
            return traceResult;
        }
        try {
            this.prepareInsert(dbConnection);
            int id = SQLUtil.getIdentifier(1, 1, dbConnection);
            this.insertComputer(dbConnection, id);
            this.closeInsert();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TComputer.class.getName(), (String)"insertComputer", (Throwable)e);
            }
            SQLUtil.errorCleanup(dbConnection, this.insert);
            if (SQLUtil.isDuplicateKeyViolation(e)) {
                int traceResult = 4;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TComputer.class.getName(), (String)"insertComputer", (int)traceResult);
                }
                return traceResult;
            }
            SQLUtil.logSQLException("SRV0050E", e, new Object[]{this.tsName});
            int traceResult = 16;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TComputer.class.getName(), (String)"insertComputer", (int)traceResult);
            }
            return traceResult;
        }
        int traceResult = 0;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TComputer.class.getName(), (String)"insertComputer", (int)traceResult);
        }
        return traceResult;
    }

    public void insertComputer(Connection dbConnection, int cmpID) throws SQLException {
        block6: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)TComputer.class.getName(), (String)"insertComputer", (String)"dbConnection, cmpID");
            }
            try {
                byte[] byArray;
                this.insert.setInt(1, cmpID);
                TResVendorModel vmAccessor = new TResVendorModel(dbConnection);
                short vendor = vmAccessor.getVendorID(this.hwID.manufacturer);
                this.insert.setShort(2, vendor);
                SQLUtil.setBytes(this.insert, 3, this.hwID.hardwareID);
                this.insert.setString(4, this.hwID.hostName);
                this.insert.setShort(5, this.hwID.osType);
                this.insert.setString(6, this.tsName);
                this.insert.setString(7, this.networkName == null ? " " : this.networkName);
                this.insert.setString(8, this.domainName == null ? " " : this.domainName);
                this.insert.setString(9, this.ipAddress);
                this.insert.setString(10, this.timezoneID);
                this.insert.setTimestamp(11, new Timestamp(SQLUtil.getTimestamp(dbConnection).getTime()));
                if (this.productState == null) {
                    byte[] byArray2 = new byte[1];
                    byArray = byArray2;
                    byArray2[0] = 14;
                } else {
                    byArray = this.productState;
                }
                SQLUtil.setBytes(this.insert, 12, byArray);
                this.insert.setString(13, this.guid);
                this.insert.setShort(14, this.hwID.cpuArchitecture);
                this.insert.setString(15, this.hwID.hostName);
                this.insert.executeUpdate();
                dbConnection.commit();
                this.computerID = cmpID;
            }
            catch (GeneralException e) {
                if (!TraceLogger.enableTrace) break block6;
                TraceLogger.exception((String)TComputer.class.getName(), (String)"insertComputer", (Throwable)e);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TComputer.class.getName(), (String)"insertComputer");
        }
    }

    public void insertSS(Connection dbConnection) throws SQLException, GeneralException {
        byte[] byArray;
        short name_type = 1;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TComputer.class.getName(), (String)"insertSS", (String)"dbConnection");
        }
        TResVendorModel vmAccessor = new TResVendorModel(dbConnection);
        short vendor = vmAccessor.getVendorID(this.hwID.manufacturer);
        this.insert.setShort(1, vendor);
        this.insert.setString(2, this.hwID.hostName);
        this.insert.setShort(3, this.hwID.osType);
        this.insert.setString(4, this.tsName);
        this.insert.setShort(5, name_type);
        this.insert.setString(6, this.ipAddress);
        if (this.productState == null) {
            byte[] byArray2 = new byte[1];
            byArray = byArray2;
            byArray2[0] = 14;
        } else {
            byArray = this.productState;
        }
        SQLUtil.setBytes(this.insert, 7, byArray);
        this.insert.executeUpdate();
        dbConnection.commit();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TComputer.class.getName(), (String)"insertSS");
        }
    }

    public void prepareInsert(Connection dbConnection) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TComputer.class.getName(), (String)"prepareInsert", (String)"dbConnection");
        }
        this.insert = dbConnection.prepareStatement(INSERT_SQL_TEXT);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TComputer.class.getName(), (String)"prepareInsert");
        }
    }

    public void prepareInsertSS(Connection dbConnection) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TComputer.class.getName(), (String)"prepareInsertSS", (String)"dbConnection");
        }
        this.insert = dbConnection.prepareStatement(INSERT_SS_SQL_TEXT);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TComputer.class.getName(), (String)"prepareInsert");
        }
    }

    public void closeInsert() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TComputer.class.getName(), (String)"closeInsert", (String)"");
        }
        if (this.insert != null) {
            block5: {
                try {
                    this.insert.close();
                }
                catch (SQLException ignored) {
                    if (!TraceLogger.enableTrace) break block5;
                    TraceLogger.exception((String)TComputer.class.getName(), (String)"closeInsert", (Throwable)ignored);
                }
            }
            this.insert = null;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TComputer.class.getName(), (String)"closeInsert");
        }
    }

    public int updateComputer(TComputer repoComputer, Connection dbConnection) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TComputer.class.getName(), (String)"updateComputer", (String)"repoComputer, dbConnection");
        }
        boolean tsNameUpdate = false;
        boolean hardwareUpdate = false;
        boolean stateUpdate = false;
        boolean guidUpdate = false;
        StringBuffer updateSql = new StringBuffer(256);
        updateSql.append(UPDATE_SQL_TEXT);
        if (this.networkName != null) {
            updateSql.append(", network_name = ?, domain_name = ?");
        }
        if (!this.tsName.equals(repoComputer.tsName)) {
            updateSql.append(", host_name = ?");
            tsNameUpdate = true;
        }
        if (!this.hwID.equals((Object)repoComputer.hwID)) {
            updateSql.append(", vendor_id = ?, hardware_id = ?");
            hardwareUpdate = true;
        }
        if (this.productState != null && !Arrays.equals(this.productState, repoComputer.productState)) {
            updateSql.append(", product_states = ?");
            stateUpdate = true;
        }
        if (!this.guidEqual(this.guid, repoComputer.guid)) {
            updateSql.append(", guid = ?");
            guidUpdate = true;
        }
        updateSql.append(" where computer_id = ?");
        PreparedStatement update = null;
        int status = 0;
        try {
            update = dbConnection.prepareStatement(updateSql.toString());
            update.setString(1, this.ipAddress);
            update.setString(2, this.timezoneID);
            update.setString(3, this.hwID.hostName);
            update.setShort(4, this.hwID.osType);
            update.setShort(5, this.hwID.cpuArchitecture);
            int parmIndex = 6;
            if (this.networkName != null) {
                update.setString(parmIndex++, this.networkName);
                update.setString(parmIndex++, this.domainName == null ? " " : this.domainName);
            }
            if (tsNameUpdate) {
                update.setString(parmIndex++, this.tsName);
            }
            if (hardwareUpdate) {
                TResVendorModel vmAccessor = new TResVendorModel(dbConnection);
                short vendor_id = vmAccessor.getVendorID(this.hwID.manufacturer);
                update.setShort(parmIndex++, vendor_id);
                SQLUtil.setBytes(update, parmIndex++, this.hwID.hardwareID);
            }
            if (stateUpdate) {
                byte[] byArray;
                int n = parmIndex++;
                if (this.productState == null) {
                    byte[] byArray2 = new byte[1];
                    byArray = byArray2;
                    byArray2[0] = 14;
                } else {
                    byArray = this.productState;
                }
                SQLUtil.setBytes(update, n, byArray);
            }
            if (guidUpdate) {
                update.setString(parmIndex++, this.guid);
            }
            update.setInt(parmIndex, this.computerID);
            if (update.executeUpdate() == 0) {
                status = 100;
            }
            dbConnection.commit();
            update.close();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TComputer.class.getName(), (String)"updateComputer", (Throwable)e);
            }
            SQLUtil.errorCleanup(dbConnection, update);
            SQLUtil.logSQLException("SRV0053E", e, new Object[]{this.tsName, new Integer(this.computerID)});
            int traceResult = 16;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TComputer.class.getName(), (String)"updateComputer", (int)traceResult);
            }
            return traceResult;
        }
        catch (GeneralException ignored) {
            // empty catch block
        }
        int traceResult = status;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TComputer.class.getName(), (String)"updateComputer", (int)traceResult);
        }
        return traceResult;
    }

    public int updateRdbmsHost(Connection dbConnection) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TComputer.class.getName(), (String)"updateRdbmsHost", (String)"repoComputer, dbConnection");
        }
        PreparedStatement update = null;
        int status = 0;
        try {
            update = dbConnection.prepareStatement(UPDATE_RDBMS_HOST_SQL_TEXT);
            update.setString(1, this.tsName);
            TResVendorModel vmAccessor = new TResVendorModel(dbConnection);
            short vendor_id = vmAccessor.getVendorID(this.hwID.manufacturer);
            update.setShort(2, vendor_id);
            SQLUtil.setBytes(update, 3, this.hwID.hardwareID);
            update.setString(4, this.networkName);
            update.setString(5, this.domainName);
            int updatedRows = update.executeUpdate();
            dbConnection.commit();
            update.close();
            this.wasAgentLess = updatedRows > 0;
        }
        catch (SQLException e) {
            if (SQLUtil.isDuplicateKeyViolation(e)) {
                status = 4;
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TComputer.class.getName(), (String)"updateRdbmsHost", (Throwable)e);
            }
            SQLUtil.errorCleanup(dbConnection, update);
            SQLUtil.logSQLException("SRV0053E", e, new Object[]{this.tsName, new Integer(this.computerID)});
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TComputer.class.getName(), (String)"updateComputer", (int)16);
            }
            return 16;
        }
        catch (GeneralException ignored) {
            // empty catch block
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TComputer.class.getName(), (String)"updateComputer", (int)status);
        }
        return status;
    }

    protected boolean equalsRepositoryComputer(TComputer r) {
        boolean status;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TComputer.class.getName(), (String)"equalsRepositoryComputer", (String)"r");
        }
        boolean bl = status = this.hwID.equals((Object)r.hwID) && this.hwID.hostName.equals(r.hwID.hostName) && this.hwID.osType == r.hwID.osType && this.hwID.cpuArchitecture == r.hwID.cpuArchitecture && this.tsName.equals(r.tsName) && this.ipAddress.equals(r.ipAddress) && this.timezoneID.equals(r.timezoneID) && this.guidEqual(this.guid, r.guid);
        if (!SQLUtil.isNullString(this.networkName)) {
            boolean bl2 = status = status && this.networkName.equals(r.networkName);
            if (!SQLUtil.isNullString(this.domainName)) {
                boolean bl3 = status = status && this.domainName.equals(r.domainName);
            }
        }
        if (this.productState != null) {
            status = status && Arrays.equals(this.productState, r.productState);
        }
        boolean traceResult = status;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TComputer.class.getName(), (String)"equalsRepositoryComputer", (boolean)traceResult);
        }
        return traceResult;
    }

    public static boolean updateState(int computerID, byte[] states, Connection dbConnection) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TComputer.class.getName(), (String)"updateState", (String)"computerID, states, dbConnection");
        }
        PreparedStatement update = null;
        boolean status = true;
        try {
            byte[] byArray;
            update = dbConnection.prepareStatement(UPDATE_STATE_TEXT);
            if (states == null) {
                byte[] byArray2 = new byte[1];
                byArray = byArray2;
                byArray2[0] = 14;
            } else {
                byArray = states;
            }
            SQLUtil.setBytes(update, 1, byArray);
            update.setInt(2, computerID);
            if (update.executeUpdate() == 0) {
                status = false;
            }
            dbConnection.commit();
            update.close();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TComputer.class.getName(), (String)"updateState", (Throwable)e);
            }
            SQLUtil.errorCleanup(dbConnection, update);
            SQLUtil.logSQLException("SRV0160E", e, null);
            status = false;
        }
        boolean traceResult = status;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TComputer.class.getName(), (String)"updateState", (boolean)traceResult);
        }
        return traceResult;
    }

    public static final boolean updateOSVersion(int computerID, String osVersion, Connection dbConnection) {
        PreparedStatement update = null;
        boolean status = true;
        try {
            update = dbConnection.prepareStatement(UPDATE_OSVERSION_TEXT);
            update.setString(1, osVersion);
            update.setInt(2, computerID);
            if (update.executeUpdate() == 0) {
                status = false;
            }
            dbConnection.commit();
            update.close();
        }
        catch (SQLException e) {
            SQLUtil.errorCleanup(dbConnection, update);
            SQLUtil.logSQLException("SRV0160E", e, null);
            status = false;
        }
        return status;
    }

    public static boolean updateCompNames(int computerID, String newName, String netWorkName, Connection dbConnection) {
        PreparedStatement update = null;
        boolean status = true;
        try {
            update = dbConnection.prepareStatement(UPDATE_NAMENSTATE_TEXT);
            update.setString(1, newName);
            update.setString(2, newName);
            update.setString(3, netWorkName);
            update.setInt(4, computerID);
            if (update.executeUpdate() == 0) {
                status = false;
            }
            dbConnection.commit();
            update.close();
        }
        catch (SQLException e) {
            SQLUtil.errorCleanup(dbConnection, update);
            SQLUtil.logSQLException("SRV0160E", e, null);
            status = false;
        }
        return status;
    }

    public String prepareStateUpdate(Connection dbConnection) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TComputer.class.getName(), (String)"prepareStateUpdate", (String)"dbConnection");
        }
        String message = null;
        try {
            this.stateUpdate = dbConnection.prepareStatement(UPDATE_STATE_TEXT);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TComputer.class.getName(), (String)"prepareStateUpdate", (Throwable)e);
            }
            SQLUtil.logSQLException("SRV0160E", e, null);
            message = MessageLog.getMessageNoID((String)"SRV0160E");
        }
        String traceResult = message;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TComputer.class.getName(), (String)"prepareStateUpdate", (Object)traceResult);
        }
        return traceResult;
    }

    public String performStateUpdate(int computerID, byte[] states, Connection dbConnection) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TComputer.class.getName(), (String)"performStateUpdate", (String)"computerID, states, dbConnection");
        }
        String message = null;
        try {
            byte[] byArray;
            if (states == null) {
                byte[] byArray2 = new byte[1];
                byArray = byArray2;
                byArray2[0] = 14;
            } else {
                byArray = states;
            }
            SQLUtil.setBytes(this.stateUpdate, 1, byArray);
            this.stateUpdate.setInt(2, computerID);
            this.stateUpdate.executeUpdate();
            dbConnection.commit();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TComputer.class.getName(), (String)"performStateUpdate", (Throwable)e);
            }
            SQLUtil.logSQLException("SRV0160E", e, null);
            message = MessageLog.getMessageNoID((String)"SRV0160E");
        }
        String traceResult = message;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TComputer.class.getName(), (String)"performStateUpdate", (Object)traceResult);
        }
        return traceResult;
    }

    public void closeStateUpdate() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TComputer.class.getName(), (String)"closeStateUpdate", (String)"");
        }
        if (this.stateUpdate != null) {
            block5: {
                try {
                    this.stateUpdate.close();
                }
                catch (SQLException ignored) {
                    if (!TraceLogger.enableTrace) break block5;
                    TraceLogger.exception((String)TComputer.class.getName(), (String)"closeStateUpdate", (Throwable)ignored);
                }
            }
            this.stateUpdate = null;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TComputer.class.getName(), (String)"closeStateUpdate");
        }
    }

    private boolean guidEqual(String guid1, String guid2) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TComputer.class.getName(), (String)"guidEqual", (String)"guid1, guid2");
        }
        boolean equals = false;
        if (guid1 != null) {
            if (guid1.equals(guid2)) {
                equals = true;
            }
        } else if (guid2 == null) {
            equals = true;
        }
        boolean traceResult = equals;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TComputer.class.getName(), (String)"guidEqual", (boolean)traceResult);
        }
        return traceResult;
    }
}

