/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.Group;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.CreatorNameListProxy;
import org.eclipse.aperi.repository.CreatorNameQueryable;
import org.eclipse.aperi.repository.EditableObjectProxy;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.xmsg.MessageLog;

public class TGroup
extends RepositoryAccessor
implements CreatorNameQueryable {
    public static final String ID_COLUMN_NAME = "group_id";
    private static final String SELECT_BY_ID = "select group_id, creator, name, description, share_mode, group_type, flags from t_group where group_id = ?";
    private static final String SELECT_NAME_BY_ID = "select creator, name from t_group where group_id = ?";
    private static final String SELECT_ID_BY_NAME = "select group_id from t_group where creator = ? and name = ?";
    private static final String INSERT = "insert into t_group (group_id, creator, name, description, last_modified, last_mod_user, share_mode, group_type, flags) values (?, ?, ?, ?, ?, ?, '0', ?, 0)";
    private static final String COLUMNS = "group_type, share_mode, flags";

    public TGroup(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup.class.getName(), (String)"TGroup", (String)"dbc");
        }
        this.tableName = "t_group";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup.class.getName(), (String)"TGroup");
        }
    }

    public void prepSelectNameByID() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup.class.getName(), (String)"prepSelectNameByID", (String)"");
        }
        this.selectStmt = this.prepareStmt(SELECT_NAME_BY_ID);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup.class.getName(), (String)"prepSelectNameByID");
        }
    }

    public String fetchNameByID(int groupID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup.class.getName(), (String)"fetchNameByID", (String)"groupID");
        }
        String creator = null;
        String name = null;
        boolean rowReturned = false;
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setInt(this.selectStmt, groupID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            rowReturned = this.nextResult();
            if (rowReturned) {
                this.stmtPhase = 1;
                this.colIndex = 1;
                creator = this.getString(this.resultSet);
                name = this.getString(this.resultSet);
            }
            this.closeResultSet();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TGroup.class.getName(), (String)"fetchNameByID", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        if (rowReturned) {
            String traceResult = creator + '.' + name;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TGroup.class.getName(), (String)"fetchNameByID", (Object)traceResult);
            }
            return traceResult;
        }
        String traceResult = null;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup.class.getName(), (String)"fetchNameByID", traceResult);
        }
        return traceResult;
    }

    public Group selectByID(int id) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup.class.getName(), (String)"selectByID", (String)"id");
        }
        Group group = new Group();
        try {
            this.selectStmt = this.prepareStmt(SELECT_BY_ID);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, id);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.fetchOne(group);
            this.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TGroup.class.getName(), (String)"selectByID", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        Group traceResult = group;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup.class.getName(), (String)"selectByID", (Object)traceResult);
        }
        return traceResult;
    }

    private boolean fetchOne(Group group) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup.class.getName(), (String)"fetchOne", (String)"group");
        }
        this.stmtPhase = 1;
        try {
            if (this.resultSet.next()) {
                this.colIndex = 1;
                group.grpGroupID = this.getInt(this.resultSet);
                group.grpCreator = this.getString(this.resultSet);
                group.setGrpName(this.getString(this.resultSet));
                group.setGrpDescription(this.getString(this.resultSet));
                group.grpShareMode = this.getByte(this.resultSet);
                group.grpType = this.getByte(this.resultSet);
                group.grpFlags = this.getInt(this.resultSet);
                boolean traceResult = true;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TGroup.class.getName(), (String)"fetchOne", (boolean)traceResult);
                }
                return traceResult;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TGroup.class.getName(), (String)"fetchOne", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        boolean traceResult = false;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup.class.getName(), (String)"fetchOne", (boolean)traceResult);
        }
        return traceResult;
    }

    public NameList selectNames(GuiListReq requestData) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup.class.getName(), (String)"selectNames", (String)"requestData");
        }
        CreatorNameListProxy proxy = new CreatorNameListProxy(this, requestData);
        NameList traceResult = proxy.select();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup.class.getName(), (String)"selectNames", (Object)traceResult);
        }
        return traceResult;
    }

    public String getIDColumnName() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup.class.getName(), (String)"getIDColumnName", (String)"");
        }
        String traceResult = ID_COLUMN_NAME;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup.class.getName(), (String)"getIDColumnName", (Object)traceResult);
        }
        return traceResult;
    }

    public void appendWhereClause(GuiListReq requestData, StringBuffer buf) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup.class.getName(), (String)"appendWhereClause", (String)"requestData, buf");
        }
        buf.append(" WHERE group_type = ");
        buf.append(Integer.toString(requestData.listRequested));
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup.class.getName(), (String)"appendWhereClause");
        }
    }

    public void addQualifiers(GuiListReq requestData, NameList element) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup.class.getName(), (String)"addQualifiers", (String)"requestData, element");
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup.class.getName(), (String)"addQualifiers");
        }
    }

    public void retrieve(CreateHeader header, String groupType) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup.class.getName(), (String)"retrieve", (String)"header, groupType");
        }
        EditableObjectProxy proxy = new EditableObjectProxy(this, header, groupType);
        proxy.initSelect(null);
        this.closeSelect();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup.class.getName(), (String)"retrieve");
        }
    }

    public void deleteByID(int groupID, String groupType) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup.class.getName(), (String)"deleteByID", (String)"groupID, groupType");
        }
        EditableObjectProxy proxy = new EditableObjectProxy(this, null, groupType);
        proxy.deleteByID(groupID, this.getIDColumnName());
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup.class.getName(), (String)"deleteByID");
        }
    }

    public void insert(CreateHeader header, short groupType, String groupTypeLabel) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup.class.getName(), (String)"insert", (String)"header, groupType, groupTypeLabel");
        }
        EditableObjectProxy proxy = new EditableObjectProxy(this, header, groupTypeLabel);
        proxy.initInsert(COLUMNS);
        try {
            this.setShort(this.insertStmt, groupType);
            this.setByte(this.insertStmt, (byte)0);
            this.setInt(this.insertStmt, 0);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TGroup.class.getName(), (String)"insert", (Throwable)e);
            }
            this.sqlError(e);
        }
        proxy.finishInsert();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup.class.getName(), (String)"insert");
        }
    }

    private void prepareUpdate(String pTableName, String idColumnName, int groupID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup.class.getName(), (String)"prepareUpdate", (String)"pTableName, idColumnName, groupID");
        }
        this.tableName = pTableName;
        StringBuffer buf = new StringBuffer(100);
        buf.append("UPDATE ");
        buf.append(this.tableName);
        buf.append(" SET group_id = ");
        buf.append(Integer.toString(groupID));
        buf.append(" WHERE ");
        buf.append(idColumnName);
        buf.append(" = ?");
        this.updateStmt = this.prepareStmt(buf.toString());
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup.class.getName(), (String)"prepareUpdate");
        }
    }

    public void setGroup(String pTableName, String idColumnName, int groupID, NameList objects) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup.class.getName(), (String)"setGroup", (String)"pTableName, idColumnName, groupID, objects");
        }
        this.prepareUpdate(pTableName, idColumnName, groupID);
        try {
            while (objects != null) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.updateStmt, objects.nlID);
                this.executeUpdate(this.updateStmt);
                objects = objects.nlNext;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TGroup.class.getName(), (String)"setGroup", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        this.closeUpdate();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup.class.getName(), (String)"setGroup");
        }
    }

    public void revertToDefaultGroup(String pTableName, int groupID, int defaultGroupID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup.class.getName(), (String)"revertToDefaultGroup", (String)"pTableName, groupID, defaultGroupID");
        }
        this.prepareUpdate(pTableName, ID_COLUMN_NAME, defaultGroupID);
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.updateStmt, groupID);
            this.executeUpdate(this.updateStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TGroup.class.getName(), (String)"revertToDefaultGroup", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        this.closeUpdate();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup.class.getName(), (String)"revertToDefaultGroup");
        }
    }

    private int selectIDByName(String creator, String name) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup.class.getName(), (String)"selectIDByName", (String)"creator, name");
        }
        int groupID = -1;
        this.setPhase();
        try {
            this.setString(this.selectStmt, creator);
            this.setString(this.selectStmt, name);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.nextResult()) {
                this.getPhase();
                groupID = this.getInt(this.resultSet);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TGroup.class.getName(), (String)"selectIDByName", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        int traceResult = groupID;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup.class.getName(), (String)"selectIDByName", (int)traceResult);
        }
        return traceResult;
    }

    public int createDefaultGroup(String name, short groupType, String description, int defaultID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TGroup.class.getName(), (String)"createDefaultGroup", (String)"name, groupType, description, defaultID");
        }
        this.selectStmt = this.prepareStmt(SELECT_ID_BY_NAME);
        int groupID = this.selectIDByName("Default", name);
        if (groupID >= 0) {
            this.closeSelect();
            int traceResult = groupID;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TGroup.class.getName(), (String)"createDefaultGroup", (int)traceResult);
            }
            return traceResult;
        }
        this.closeResultSet();
        boolean constraintViolationOccurred = false;
        this.insertStmt = this.prepareStmt(INSERT);
        this.setPhase();
        try {
            this.setInt(this.insertStmt, defaultID);
            this.setString(this.insertStmt, "Default");
            this.setString(this.insertStmt, name);
            this.setString(this.insertStmt, description);
            this.setLong(this.insertStmt, 0L);
            this.setString(this.insertStmt, "Default");
            this.setShort(this.insertStmt, groupType);
            this.executeUpdate(this.insertStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TGroup.class.getName(), (String)"createDefaultGroup", (Throwable)e);
            }
            this.stmtType = 1;
            if (SQLUtil.isDuplicateKeyViolation(e)) {
                constraintViolationOccurred = true;
            }
            this.sqlError(e);
        }
        if (!constraintViolationOccurred) {
            this.commit();
        }
        this.closeInsert();
        if (!constraintViolationOccurred) {
            this.closeSelect();
            int traceResult = defaultID;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TGroup.class.getName(), (String)"createDefaultGroup", (int)traceResult);
            }
            return traceResult;
        }
        groupID = this.selectIDByName("Default", name);
        this.closeSelect();
        if (groupID < 0) {
            String s = MessageLog.getMessage((String)"SRV0159E", (Object)name);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TGroup.class.getName(), (String)"createDefaultGroup");
            }
            throw new GeneralException(s);
        }
        int traceResult = groupID;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TGroup.class.getName(), (String)"createDefaultGroup", (int)traceResult);
        }
        return traceResult;
    }
}

