/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.common.CimomConfig;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.StorageException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;

public class TResCimom
extends StorageRepositoryAccessor {
    public static final String DEFAULT_NAME_SPACE = "root/cimv2";
    private static final String ID_COLUMN = "cimom_id";
    private static final String GET_CIMOM = "select cimom_id, port, access_protocol, host, user_id, password, interop_schema_namespace from t_res_registered_cimom order  by host desc, port desc";
    private static final String GET_ID = "select cimom_id from t_res_registered_cimom where UPPER(host) = ?  and port = ?";
    private static final String INSERT = "insert into t_res_registered_cimom  (reg_cimom_id, cimom_id, port, access_protocol, host, user_id,  password, interop_schema_namespace) values (?, ?,?,?,?,?,?,?)";
    private static final String UPDATE_ALL = "update t_res_registered_cimom set port = ?, host = ?, user_id = ?, password = ?, access_protocol = ?, interop_schema_namespace = ?  where cimom_id = ?";
    private static final String UPDATE_PROTOCOL = "update t_res_registered_cimom set access_protocol = ? where cimom_id = ?";
    private static final String SELECT_BY_ID = "select host, port from t_res_registered_cimom where cimom_id = ?";

    public TResCimom(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResCimom.class.getName(), (String)"TResCimom", (String)"dbc");
        }
        this.tableName = "t_res_registered_cimom";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResCimom.class.getName(), (String)"TResCimom");
        }
    }

    public CimomConfig getCimoms() throws StorageException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResCimom.class.getName(), (String)"getCimoms", (String)"");
        }
        CimomConfig cimomList = null;
        try {
            this.selectStmt = this.prepareStmt(GET_CIMOM);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            while (this.resultSet.next()) {
                CimomConfig cimom = new CimomConfig();
                cimom.ciNext = cimomList;
                cimomList = cimom;
                this.fetchRow(cimom);
            }
            this.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResCimom.class.getName(), (String)"getCimoms", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        CimomConfig traceResult = cimomList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResCimom.class.getName(), (String)"getCimoms", traceResult);
        }
        return traceResult;
    }

    private void fetchRow(CimomConfig cimom) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResCimom.class.getName(), (String)"fetchRow", (String)"cimom");
        }
        this.getPhase();
        cimom.ciID = this.getInt(this.resultSet);
        cimom.ciPort = this.getInt(this.resultSet);
        cimom.ciProtocol = this.getByte(this.resultSet);
        cimom.ciHost = this.getString(this.resultSet);
        cimom.ciUserName = this.getString(this.resultSet);
        cimom.setPassword(this.getString(this.resultSet));
        cimom.ciINamespace = this.getString(this.resultSet);
        if (cimom.ciINamespace.startsWith(" ")) {
            cimom.ciINamespace = null;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResCimom.class.getName(), (String)"fetchRow");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(CimomConfig cimomList) throws StorageException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResCimom.class.getName(), (String)"delete", (String)"cimomList");
        }
        Class<TResCimom> clazz = TResCimom.class;
        synchronized (TResCimom.class) {
            this.prepDeleteByID(this.tableName, ID_COLUMN);
            CimomConfig cimom = cimomList;
            while (cimom != null) {
                this.deleteByID(cimom.ciID, true);
                cimom = cimom.ciNext;
            }
            this.closeDelete();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResCimom.class.getName(), (String)"delete");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(CimomConfig cimomList) throws StorageException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResCimom.class.getName(), (String)"save", (String)"cimomList");
        }
        int identifierCount = 0;
        Class<TResCimom> clazz = TResCimom.class;
        synchronized (TResCimom.class) {
            CimomConfig cimom = cimomList;
            while (cimom != null) {
                if (cimom.ciID > 0) {
                    this.update(cimom);
                } else if (!this.fetchID(cimom)) {
                    ++identifierCount;
                } else {
                    this.update(cimom);
                }
                cimom = cimom.ciNext;
            }
            this.closeSelect();
            this.closeUpdate();
            if (identifierCount > 0) {
                int identifier = TResCimom.getIdentifier(1, identifierCount, this.dbc);
                cimom = cimomList;
                while (cimom != null) {
                    if (cimom.ciID <= 0) {
                        cimom.ciID = identifier++;
                        this.insert(cimom);
                    }
                    cimom = cimom.ciNext;
                }
            }
            this.closeInsert();
            // ** MonitorExit[var4_3] (shouldn't be in output)
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResCimom.class.getName(), (String)"save");
            }
            return;
        }
    }

    public boolean fetchID(CimomConfig cimom) throws StorageException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResCimom.class.getName(), (String)"fetchID", (String)"cimom");
        }
        if (this.selectStmt == null) {
            this.selectStmt = this.prepareStmt(GET_ID);
        }
        boolean result = false;
        try {
            this.setPhase();
            this.setString(this.selectStmt, cimom.ciHost.toUpperCase());
            this.setInt(this.selectStmt, cimom.ciPort);
            this.resultSet = this.selectStmt.executeQuery();
            result = this.nextResult();
            if (result) {
                this.getPhase();
                cimom.ciID = this.getInt(this.resultSet);
            }
            this.closeResultSet();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResCimom.class.getName(), (String)"fetchID", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        boolean traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResCimom.class.getName(), (String)"fetchID", (boolean)traceResult);
        }
        return traceResult;
    }

    private void update(CimomConfig cimom) throws StorageException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResCimom.class.getName(), (String)"update", (String)"cimom");
        }
        if (this.updateStmt == null) {
            this.updateStmt = cimom.ciUserName == null ? this.prepareStmt(UPDATE_PROTOCOL) : this.prepareStmt(UPDATE_ALL);
        }
        try {
            this.setPhase();
            if (cimom.ciUserName != null) {
                this.setInt(this.updateStmt, cimom.ciPort);
                this.setString(this.updateStmt, cimom.ciHost);
                this.setLoginData(this.updateStmt, cimom);
            }
            this.setByte(this.updateStmt, cimom.ciProtocol);
            if (cimom.ciUserName != null) {
                this.setString(this.updateStmt, cimom.ciINamespace);
            }
            this.setInt(this.updateStmt, cimom.ciID);
            this.executeUpdate(this.updateStmt);
            this.dbc.commit();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResCimom.class.getName(), (String)"update", (Throwable)e);
            }
            if (!SQLUtil.isDuplicateKeyViolation(e)) {
                this.stmtType = 2;
                this.sqlError(e);
            }
            Object[] args = new Object[]{cimom.ciHost, new Integer(cimom.ciPort)};
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResCimom.class.getName(), (String)"update");
            }
            throw new StorageException("STS0303E", args);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResCimom.class.getName(), (String)"update");
        }
    }

    private void setLoginData(PreparedStatement pStmt, CimomConfig cimom) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResCimom.class.getName(), (String)"setLoginData", (String)"pStmt, cimom");
        }
        if (cimom.ciUserName == null) {
            pStmt.setNull(this.colIndex++, 12);
            pStmt.setNull(this.colIndex++, 12);
        } else {
            this.setString(pStmt, cimom.ciUserName);
            this.setString(pStmt, cimom.getPassword());
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResCimom.class.getName(), (String)"setLoginData");
        }
    }

    private void insert(CimomConfig cimom) throws StorageException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResCimom.class.getName(), (String)"insert", (String)"cimom");
        }
        if (this.insertStmt == null) {
            this.insertStmt = this.prepareStmt(INSERT);
        }
        try {
            this.setPhase();
            this.setInt(this.insertStmt, cimom.ciID);
            this.setInt(this.insertStmt, cimom.ciID);
            this.setInt(this.insertStmt, cimom.ciPort);
            this.setByte(this.insertStmt, cimom.ciProtocol);
            this.setString(this.insertStmt, cimom.ciHost);
            this.setLoginData(this.insertStmt, cimom);
            this.setString(this.insertStmt, cimom.ciINamespace);
            this.executeUpdate(this.insertStmt);
            this.dbc.commit();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResCimom.class.getName(), (String)"insert", (Throwable)e);
            }
            this.stmtType = 1;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResCimom.class.getName(), (String)"insert");
        }
    }

    public void prepGetCimomByID() throws GeneralException {
        this.selectStmt = this.prepareStmt(SELECT_BY_ID);
    }

    public String fetchCimomName(int cimomID, boolean failFriendly) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResCimom.class.getName(), (String)"fetchCimomName", (String)"cimomID, failFriendly");
        }
        String result = null;
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setInt(this.selectStmt, cimomID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.nextResult()) {
                this.stmtPhase = 1;
                this.colIndex = 1;
                result = this.getString(this.resultSet) + ":" + this.getString(this.resultSet);
            } else if (failFriendly) {
                result = "? (" + Integer.toString(cimomID) + ')';
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResCimom.class.getName(), (String)"fetchCimomName", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.closeResultSet();
        String traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResCimom.class.getName(), (String)"fetchCimomName", traceResult);
        }
        return traceResult;
    }

    public String fetchCimomName(int cimomID) throws GeneralException {
        return this.fetchCimomName(cimomID, true);
    }
}

