/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.aperi.TStorm.common.Controller;
import org.eclipse.aperi.TStorm.common.DevAccess;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.NameListQueryable;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TResComputer;
import org.eclipse.aperi.repository.table.TResLogicalDisk;

public class TResDevAccess
extends StorageRepositoryAccessor
implements NameListQueryable {
    public TResComputer cmpAccessor = null;
    private static final String FETCH = "select controller_id, device_id, target, lun, path, in_active from t_res_dev_access";
    private static final String BY_CONTROLLER = " where controller_id = ? order by target desc, lun desc";
    private static final String BY_DEVICE = " where device_id = ?";
    private static final String GET_ALL_DISKS = "select d.device_id, d.path, s.computer_id  from t_res_dev_access d, t_res_share s, t_res_controller c where s.resource_type = 10   and s.resource_id = d.device_id   and s.computer_id = c.computer_id   and d.controller_id = c.controller_id union  select d.device_id, d.path, s.computer_id  from t_res_dev_access d, t_res_share s, t_res_disk_group c where s.resource_type = 10   and s.resource_id = d.device_id   and s.computer_id = c.subsystem_id   and d.controller_id = c.disk_group_id";
    private static final String GET_DISKS_BY_COMPUTER = "select device_id, d.path, 0  from t_res_dev_access d, t_res_share s, t_res_controller c,       t_stat_disk x where s.computer_id = ? and s.resource_type = 10   and s.resource_id = d.device_id   and s.computer_id = c.computer_id   and d.device_id   = x.disk_id   and d.controller_id = c.controller_id";
    private static final String GET_SVC_DISKS_BY_SS = "select storage_extent_id, element_name, 0  from t_res_storage_extent where subsystem_id = ?";
    private static final String GET_DISKS_BY_SS = "select physical_volume_id, device_id, 0  from t_res_physical_volume where subsystem_id = ?";
    private static final String GET_DISKS_BY_DISK_GROUP = "select pv.physical_volume_id, pv.device_id, 0  from t_res_physical_volume pv, t_res_disk_group dg, t_res_storage_extent se where pv.subsystem_id = ? and pv.disk_group_id = dg.disk_group_id   and dg.storage_extent_id = se.storage_extent_id";
    private static final String GET_DISKS_IN_POOL_FOR_CHUNK_COLLECTION = "select pv.physical_volume_id, pv.device_id, 0  from t_res_physical_volume pv, t_res_physicalvolume2extent pve, t_res_storage_extent se where pv.subsystem_id = ? and pv.physical_volume_id = pve.physical_volume_id and pve.storage_extent_id = se.storage_extent_id and se.pool_id = ?  order by pv.serial_number";
    private static final String GET_DISKS_BY_POOL = "select pv.physical_volume_id, pv.device_id, 0  from t_res_physical_volume pv, t_res_physicalvolume2extent pve, t_res_storage_extent se where pv.subsystem_id = ? and pv.physical_volume_id = pve.physical_volume_id and pve.storage_extent_id = se.storage_extent_id and se.pool_id = ? UNION select pv.physical_volume_id, pv.device_id, 0 from t_res_physical_volume pv, t_stat_disk sd where pv.physical_volume_id = sd.disk_id and sd.volgroup_id = ?";
    private static final String GET_SVC_DISKS_BY_POOL = "select storage_extent_id, element_name, 0  from t_res_storage_extent where subsystem_id = ? and pool_id  = ? ";
    private static final String ORDER_BY_DISK_NAME = " order by 2 desc";
    private static final String GET_DISKS_BY_CONTROLLER = "select device_id, path, 0  from t_res_dev_access  where controller_id = ?  order by path desc";
    private static final String GET_PATH_BY_DEVICE_COMPUTER = "select a.path from t_res_dev_access a, t_res_controller c where a.device_id = ? and c.computer_id = ? and a.controller_id = c.controller_id";
    private static final String GET_PATH_BY_DEVICE_SS = "select a.path from t_res_dev_access a, t_res_disk_group c where a.device_id = ? and c.subsystem_id = ? and a.controller_id = c.disk_group_id";
    private static final String INSERT = "insert into t_res_dev_access (controller_id, target, lun, device_id, path, in_active) values (?,?,?,?,?,?)";
    private static final String UPDATE = "update t_res_dev_access set device_id = ?, path = ?, in_active = ? where controller_id = ? and target = ? and lun = ?";
    private static final String DELETE_BY_KEY = "delete from t_res_dev_access where controller_id = ? and target = ? and lun = ?";
    private static final String DELETE_BY_CONTROLLER = "delete from t_res_dev_access where controller_id = ?";
    private static final String DELETE_BY_COMPUTER = "delete from t_res_dev_access where controller_id in (select controller_id from t_res_controller where computer_id = ?)";
    private static final String DELETE_BY_SS = "delete from t_res_dev_access where controller_id in (select controller_id from t_res_disk_group where subsystem_id = ?)";

    public TResDevAccess(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDevAccess.class.getName(), (String)"TResDevAccess", (String)"dbc");
        }
        this.tableName = "t_res_dev_access";
        this.cmpAccessor = new TResComputer(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResDevAccess.class.getName(), (String)"TResDevAccess");
        }
    }

    public void prepSelectByCtlr() throws GeneralException {
        this.selectStmt = this.prepareStmt("select controller_id, device_id, target, lun, path, in_active from t_res_dev_access where controller_id = ? order by target desc, lun desc");
    }

    public void prepSelectByDevice() throws GeneralException {
        this.selectStmt = this.prepareStmt("select controller_id, device_id, target, lun, path, in_active from t_res_dev_access where device_id = ?");
    }

    public ResultSet getPoolDisks(int ss_id, int pool_id) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLogicalDisk.class.getName(), (String)"getPoolDisks", (String)"ss_id, pool_id");
        }
        ResultSet disks = null;
        try {
            PreparedStatement statement = this.dbc.prepareStatement(GET_DISKS_IN_POOL_FOR_CHUNK_COLLECTION);
            statement.setInt(1, ss_id);
            statement.setInt(2, pool_id);
            disks = statement.executeQuery();
        }
        catch (SQLException sqle) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResLogicalDisk.class.getName(), (String)"getPoolDisks", (Throwable)sqle);
            }
            this.sqlError(sqle);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResLogicalDisk.class.getName(), (String)"getPoolDisks", disks);
        }
        return disks;
    }

    public DevAccess getDevAccess(int id) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDevAccess.class.getName(), (String)"getDevAccess", (String)"id");
        }
        DevAccess daList = null;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, id);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                this.colIndex = 1;
                DevAccess da = new DevAccess();
                da.daControllerID = this.getInt(this.resultSet);
                da.daDeviceID = this.getInt(this.resultSet);
                da.daTarget = this.getShort(this.resultSet);
                da.daLUN = this.getShort(this.resultSet);
                da.daPath = this.getString(this.resultSet);
                da.daInactive = this.getBoolean(this.resultSet);
                da.daNextDevice = daList;
                daList = da;
            }
            this.closeResultSet();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResDevAccess.class.getName(), (String)"getDevAccess", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        DevAccess traceResult = daList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResDevAccess.class.getName(), (String)"getDevAccess", traceResult);
        }
        return traceResult;
    }

    public NameList selectNames(GuiListReq glr) throws GeneralException {
        return this.getDiskList(glr.computerID, glr.controllerID, glr.qualifier, glr.groupID);
    }

    public NameList getDiskList(int computerID, int controllerID, short qualifier, int volgroupID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDevAccess.class.getName(), (String)"getDiskList", (String)"computerID, controllerID, qualifier, volgroupID");
        }
        NameList diskList = null;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            short ssType = this.cmpAccessor.getStorageSubsystemType(computerID);
            if (ssType < 0) {
                this.prepDiskListStmtHost(computerID, controllerID, qualifier, volgroupID);
            } else {
                this.prepDiskListStmtSS(computerID, controllerID, volgroupID, ssType);
            }
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                this.colIndex = 1;
                NameList disk = new NameList();
                disk.nlID = this.getInt(this.resultSet);
                disk.nlName = this.getString(this.resultSet);
                disk.nlID2 = this.getInt(this.resultSet);
                disk.nlNext = diskList;
                diskList = disk;
            }
            this.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResDevAccess.class.getName(), (String)"getDiskList", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        NameList traceResult = diskList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResDevAccess.class.getName(), (String)"getDiskList", traceResult);
        }
        return traceResult;
    }

    private void prepDiskListStmtSS(int computerID, int controllerID, int volgroupID, short ssType) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDevAccess.class.getName(), (String)"prepareDiskListStatementSS", (String)"computerID, controllerID, volgroupID, ssType");
        }
        boolean storagePoolSpecified = false;
        boolean unionQuery = false;
        StringBuffer buffer = new StringBuffer(500);
        if (controllerID > 0) {
            buffer.append(GET_DISKS_BY_DISK_GROUP);
            buffer.append(" and dg.disk_group_id = " + controllerID);
        } else if (ssType == 21) {
            if (volgroupID > 0) {
                buffer.append(GET_SVC_DISKS_BY_POOL);
                storagePoolSpecified = true;
            } else {
                buffer.append(GET_SVC_DISKS_BY_SS);
            }
        } else if (volgroupID > 0) {
            buffer.append(GET_DISKS_BY_POOL);
            storagePoolSpecified = true;
            unionQuery = true;
        } else {
            buffer.append(GET_DISKS_BY_SS);
        }
        buffer.append(ORDER_BY_DISK_NAME);
        String sqlText = buffer.toString();
        this.selectStmt = this.prepareStmt(sqlText);
        this.setInt(this.selectStmt, computerID);
        if (storagePoolSpecified) {
            this.setInt(this.selectStmt, volgroupID);
            if (unionQuery) {
                this.setInt(this.selectStmt, volgroupID);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResDevAccess.class.getName(), (String)"prepareDiskListStatementSS");
        }
    }

    private void prepDiskListStmtHost(int computerID, int controllerID, short qualifier, int volgroupID) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDevAccess.class.getName(), (String)"prepareDiskListStatementHost", (String)"computerID, controllerID, qaulifier, volgroupID");
        }
        if (controllerID > 0) {
            this.selectStmt = this.prepareStmt(GET_DISKS_BY_CONTROLLER);
            this.setInt(this.selectStmt, controllerID);
        } else if (computerID > 0) {
            StringBuffer buffer = new StringBuffer(500);
            buffer.append(GET_DISKS_BY_COMPUTER);
            if (qualifier != 0) {
                buffer.append(" and c.controller_type ");
                if (qualifier > 0) {
                    buffer.append("= ");
                } else {
                    buffer.append("<> ");
                }
                buffer.append(8);
            }
            if (volgroupID > 0) {
                buffer.append(" and x.volgroup_id = " + volgroupID);
            }
            buffer.append(" order by d.path desc");
            String sqlText = buffer.toString();
            this.selectStmt = this.prepareStmt(sqlText);
            this.setInt(this.selectStmt, computerID);
        } else {
            this.selectStmt = this.prepareStmt(GET_ALL_DISKS);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResDevAccess.class.getName(), (String)"prepareDiskListStatementHost");
        }
    }

    public void prepPathDevCompQuery() throws GeneralException {
        this.selectStmt = this.prepareStmt(GET_PATH_BY_DEVICE_COMPUTER);
    }

    public void prepPathDevSSQuery() throws GeneralException {
        this.selectStmt = this.prepareStmt(GET_PATH_BY_DEVICE_SS);
    }

    public String getPathByDeviceComputer(int deviceID, int computerID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDevAccess.class.getName(), (String)"getPathByDeviceComputer", (String)"deviceID, computerID");
        }
        String result = null;
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setInt(this.selectStmt, deviceID);
            this.setInt(this.selectStmt, computerID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.nextResult()) {
                this.stmtPhase = 1;
                this.colIndex = 1;
                result = this.getString(this.resultSet);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResDevAccess.class.getName(), (String)"getPathByDeviceComputer", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.closeResultSet();
        String traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResDevAccess.class.getName(), (String)"getPathByDeviceComputer", traceResult);
        }
        return traceResult;
    }

    public void insertDevAccess(DevAccess daList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDevAccess.class.getName(), (String)"insertDevAccess", (String)"daList");
        }
        try {
            this.insertStmt = this.prepareStmt(INSERT);
            DevAccess da = daList;
            while (da != null) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setKey(this.insertStmt, da);
                this.setAttributes(this.insertStmt, da);
                this.executeUpdate(this.insertStmt);
                this.dbc.commit();
                da = da.daNextDevice;
            }
            this.closeInsert();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResDevAccess.class.getName(), (String)"insertDevAccess", (Throwable)e);
            }
            this.stmtType = 1;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResDevAccess.class.getName(), (String)"insertDevAccess");
        }
    }

    private void setKey(PreparedStatement stmt, DevAccess da) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDevAccess.class.getName(), (String)"setKey", (String)"stmt, da");
        }
        this.setInt(stmt, da.daControllerID);
        this.setShort(stmt, da.daTarget);
        this.setShort(stmt, da.daLUN);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResDevAccess.class.getName(), (String)"setKey");
        }
    }

    private void setAttributes(PreparedStatement stmt, DevAccess da) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDevAccess.class.getName(), (String)"setAttributes", (String)"stmt, da");
        }
        this.setInt(stmt, da.daDeviceID);
        this.setString(stmt, da.daPath);
        this.setBoolean(stmt, da.daInactive);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResDevAccess.class.getName(), (String)"setAttributes");
        }
    }

    public void updateDevAccess(DevAccess daList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDevAccess.class.getName(), (String)"updateDevAccess", (String)"daList");
        }
        try {
            this.updateStmt = this.prepareStmt(UPDATE);
            DevAccess da = daList;
            while (da != null) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setAttributes(this.updateStmt, da);
                this.setKey(this.updateStmt, da);
                this.executeUpdate(this.updateStmt);
                this.dbc.commit();
                da = da.daNextDevice;
            }
            this.closeUpdate();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResDevAccess.class.getName(), (String)"updateDevAccess", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResDevAccess.class.getName(), (String)"updateDevAccess");
        }
    }

    public void deleteDevAccess(DevAccess daList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDevAccess.class.getName(), (String)"deleteDevAccess", (String)"daList");
        }
        try {
            this.deleteStmt = this.prepareStmt(DELETE_BY_KEY);
            DevAccess da = daList;
            while (da != null) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setKey(this.deleteStmt, da);
                this.executeUpdate(this.deleteStmt);
                this.dbc.commit();
                da = da.daNextDevice;
            }
            this.closeDelete();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResDevAccess.class.getName(), (String)"deleteDevAccess", (Throwable)e);
            }
            this.stmtType = 3;
            this.deleteError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResDevAccess.class.getName(), (String)"deleteDevAccess");
        }
    }

    public void deleteDevAccess(Controller ctlrList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDevAccess.class.getName(), (String)"deleteDevAccess", (String)"ctlrList");
        }
        try {
            this.deleteStmt = this.prepareStmt(DELETE_BY_CONTROLLER);
            Controller ctlr = ctlrList;
            while (ctlr != null) {
                this.stmtPhase = 0;
                this.colIndex = 1;
                this.setInt(this.deleteStmt, ctlr.ctlrID);
                this.executeUpdate(this.deleteStmt);
                this.dbc.commit();
                ctlr = ctlr.ctlrNext;
            }
            this.closeDelete();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResDevAccess.class.getName(), (String)"deleteDevAccess", (Throwable)e);
            }
            this.stmtType = 3;
            this.deleteError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResDevAccess.class.getName(), (String)"deleteDevAccess");
        }
    }

    public void deleteByComputer(int computerID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResDevAccess.class.getName(), (String)"deleteByComputer", (String)"computerID");
        }
        try {
            boolean isSS = this.cmpAccessor.isStorageSubsystem(computerID);
            this.deleteStmt = !isSS ? this.prepareStmt(DELETE_BY_COMPUTER) : this.prepareStmt(DELETE_BY_SS);
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.deleteStmt, computerID);
            this.executeUpdate(this.deleteStmt);
            this.dbc.commit();
            this.closeDelete();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResDevAccess.class.getName(), (String)"deleteByComputer", (Throwable)e);
            }
            this.stmtType = 3;
            this.deleteError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResDevAccess.class.getName(), (String)"deleteByComputer");
        }
    }
}

