/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.eclipse.aperi.Nas.common.NasFiler;
import org.eclipse.aperi.San.common.Lun;
import org.eclipse.aperi.TStorm.common.Computer;
import org.eclipse.aperi.TStorm.common.EntityWWPN;
import org.eclipse.aperi.TStorm.common.Share;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.HasID;
import org.eclipse.aperi.common.MutableBoolean;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.constants.metadata.ResourceTypeManager;
import org.eclipse.aperi.repository.EnclosureAccessor;
import org.eclipse.aperi.repository.MissingAlertAccessible;
import org.eclipse.aperi.repository.NameListQueryable;
import org.eclipse.aperi.repository.QueryBySchedule;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.table.TResComputer;
import org.eclipse.aperi.repository.table.TResEntityWWPN;
import org.eclipse.aperi.repository.table.TResVendorModel;
import org.eclipse.aperi.server.guireq.AlertNameList;
import org.eclipse.aperi.xmsg.MessageLog;

public class TResDiskArray
extends RepositoryAccessor
implements MissingAlertAccessible,
NameListQueryable,
EnclosureAccessor {
    public static final String ID_COLUMN_NAME = "subsystem_id";
    private static final String JOIN_1 = "select  case when user_provided_name is not null  and user_provided_name <> ''  then user_provided_name else display_name end display_name  from t_res_storage_subsystem  where subsystem_id = ?";
    private static final String BIG_JOIN_PT_I = "select distinct a.attribute_id, d.subsystem_id, a.exclude from t_res_storage_subsystem d, t_res_attribute a where a.attribute_type = ? and d.subsystem_id";
    private static final String BIG_JOIN_PT_II = " and (a.resource_id = d.subsystem_id or a.resource_id = d.group_id or a.resource_type = " + Short.toString((short)13) + ") order by 1, 2, 3 desc";
    private static final String SELECT_SS_DETAIL = " select a.subsystem_id, a.vendor_id, a.model_id, a.code_level, a.serial_number, a.cache, a.nvs,  v.disk_capacity, v.disk_freespace, v.lun_capacity, a.last_probe_time, a.probe_status, a.group_id,  a.probing_host_id, a.vg_capacity, a.vg_freespace, a.dg_freespace, a.lgldisk_assigned_capacity,  a.lun_capacity_zos, a.os_type, v.n_disks, v.n_luns, a.name,  case when a.user_provided_name is not null  and a.user_provided_name <> ''  then a.user_provided_name else a.display_name end display_name  from t_res_storage_subsystem a, t_view_ss_aggrinfo v  where a.last_probe_time is not null and a.subsystem_id = v.subsystem_id and a.subsystem_id = ?  UNION  select a.subsystem_id, a.vendor_id, a.model_id, '', a.serial_number, -1, -1,  -1, -1, -1, (CAST (NULL AS TIMESTAMP)), (CAST (NULL AS CHAR)), a.group_id, a.probing_host_id, -1, -1, -1, -1, -1, a.os_type, -1, -1, a.name,  case when a.user_provided_name is not null  and a.user_provided_name <> ''  then a.user_provided_name else a.display_name end display_name  from t_res_storage_subsystem a where a.last_probe_time is null and a.subsystem_id = ?";
    private static final String SELECT_SVC = "select a.disk_array_id from t_res_storage_subsystem a where a.os_type = " + Short.toString((short)21);
    private static final String SELECT_DISK_ARRAY_ID = "select subsystem_id from t_res_storage_subsystem";
    private static final String INSERT = "insert into t_res_storage_subsystem (subsystem_id, vendor_id, model_id, code_level, cache, nvs, backend_storage_capacity, available_capacity, n_disks, n_luns, allocated_capacity, last_probe_time, probe_status, vg_capacity, vg_freespace, dg_freespace, group_id, probing_host_id, lgldisk_assigned_capacity, lun_capacity_zos) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?,?,?,?,?)";
    private static final String UPDATE = "update t_res_storage_subsystem set vendor_id = ?, model_id = ?, code_level = ?, cache = ?, nvs = ?, backend_storage_capacity = ?, available_capacity = ?, n_disks = ?, n_luns = ?, allocated_capacity = ?, last_probe_time = ?, probe_status = ?, vg_capacity = ?, vg_freespace = ?, dg_freespace = ?, lgldisk_assigned_capacity = ?, lun_capacity_zos = ? where subsystem_id = ?";
    private static final String UPDATE_LICENSED_ARRAY = "update t_res_storage_subsystem set probing_host_id = ?  where subsystem_id = ?";
    private static final String RESET_PROBING_COMPUTER = "update t_res_storage_subsystem set probing_host_id = 0 where probing_host_id = ";
    private static final String SELECT_NAMELIST = "select subsystem_id,  case when user_provided_name is not null  and user_provided_name <> ''  then user_provided_name else display_name end display_name,  os_type from t_res_storage_subsystem";
    private static final String SELECT_BY_ATTRIBUTE = "select d.subsystem_id,  case when d.user_provided_name is not null  and d.user_provided_name <> ''  then d.user_provided_name else d.display_name end display_name,  a.exclude from t_res_storage_subsystem d, t_res_attribute a where a.attribute_id = ? and  d.subsystem_id = a.resource_id order by 2, 3 desc";
    private static final String SELECT_BY_SCHEDULE = "select distinct d.subsystem_id, d.probing_host_id, a.exclude, d.os_type from t_res_storage_subsystem d, t_res_attribute a where a.attribute_id = ? and  (d.subsystem_id = a.resource_id or d.group_id = a.resource_id or a.resource_type = " + Short.toString((short)54) + ") order by 1, 3 desc";
    private static final String SELECT_LUN = "select sv.subsystem_id, man.vendor_name, mod.model_name, ss.name, sv.display_name, sv.name  from t_res_storage_subsystem ss, t_res_storage_volume sv, t_res_model mod, t_res_vendor man where sv.svid = ? and sv.subsystem_id = ss.subsystem_id and ss.vendor_id = man.vendor_id and ss.model_id = mod.model_id";
    private static final String GET_NUM_SS_LUNS = " select count(*) from t_res_storage_volume sv where sv.subsystem_id = ?";
    private static final String GET_NUM_POOL_LUNS = " select count(*) from t_res_storage_volume sv where sv.pool_id = ?";
    private static final String GET_NUM_SS_DISKS = " select count(*) from t_res_physical_volume pv where pv.subsystem_id = ?";
    private static final String GET_NUM_SVC_MDISKS = " select count(*) from t_res_storage_extent se where se.subsystem_id = ?";
    private static final String GET_NUM_POOL_DISKS = "\tselect max(t1.num) from\t (  (select count(*) as num from t_res_physical_volume pv, t_res_physicalvolume2extent pvte, t_res_storage_extent se\t\twhere pv.physical_volume_id = pvte.physical_volume_id and pvte.storage_extent_id = se.storage_extent_id\t\t\t\t  and se.pool_id = ?\t\t\t\t  UNION  \t\tselect count(*) as num from t_stat_disk sd where sd.volgroup_id = ?) as t1)";
    private static final String GET_NUM_POOL_DISKS_OLD = " WITH counts (num) as  (  (select count(*) from t_res_physical_volume pv, t_res_physicalvolume2extent pvte, t_res_storage_extent se     where pv.physical_volume_id = pvte.physical_volume_id and pvte.storage_extent_id = se.storage_extent_id           and se.pool_id = ?) UNION   (select count(*) from t_stat_disk sd where sd.volgroup_id = ?)  ) select max(num) from counts";
    private static final String GET_NUM_DISK_GROUP_DISKS = " select count(*) from t_res_physical_volume pv, t_res_disk_group dg, t_res_storage_extent se where pv.disk_group_id = dg.disk_group_id and dg.storage_extent_id = se.storage_extent_id and dg.disk_group_id = ?";
    private static final String GET_NUM_ASSIGNED_SVC_MDISKS = "select sum(number_of_backend_volumes)  from t_res_storage_pool where primordial = 0 and subsystem_id = ?";
    private QueryBySchedule queryBySchedule;
    private TResVendorModel vmAccessor = null;

    public TResDiskArray(Connection dbc) {
        super(dbc);
        this.tableName = "t_res_storage_subsystem";
        this.vmAccessor = new TResVendorModel(dbc);
    }

    public boolean getComputerStats(Computer computer, MutableBoolean beenProbed) throws GeneralException {
        return false;
    }

    public NasFiler getDiskArrays(int diskArrayID) throws GeneralException {
        NasFiler head = null;
        try {
            this.selectStmt = this.prepareStmt(SELECT_SS_DETAIL);
            this.colIndex = 1;
            this.setInt(this.selectStmt, diskArrayID);
            this.setInt(this.selectStmt, diskArrayID);
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException e) {
            this.stmtPhase = 3;
            this.sqlError(e);
        }
        while (this.nextResult()) {
            Computer diskArray = new Computer();
            this.fetchDiskArray(diskArray);
            diskArray.cmpNasFiler.nfNext = head;
            head = diskArray.cmpNasFiler;
            head.nfComputer = diskArray;
        }
        this.closeSelect();
        if (head == null && diskArrayID > 0) {
            String diskArrayLiteral = ResourceTypeManager.getName((short)78);
            String idString = Integer.toString(diskArrayID);
            String msg = MessageLog.getMessage((String)"STS0092E", (Object)diskArrayLiteral, (Object)idString);
            throw new GeneralException(msg);
        }
        return head;
    }

    private void fetchDiskArray(Computer diskArray) throws GeneralException {
        this.getPhase();
        try {
            int numAssignedMDisks;
            if (diskArray.cmpID > 0) {
                this.getInt(this.resultSet);
            } else {
                diskArray.cmpID = this.getInt(this.resultSet);
            }
            diskArray.cmpManufacturer = this.vmAccessor.getVendorName(this.getShort(this.resultSet));
            diskArray.cmpModel = this.vmAccessor.getModelName(this.getShort(this.resultSet));
            diskArray.cmpOSVersion = this.getString(this.resultSet);
            diskArray.cmpSerialNumber = this.getString(this.resultSet);
            long tempRAM = this.getLong(this.resultSet);
            diskArray.cmpRAM = tempRAM >= 0L ? (int)(tempRAM /= 0x100000L) : -1;
            long tempSwapSpace = this.getLong(this.resultSet);
            diskArray.cmpSwapSpace = tempSwapSpace >= 0L ? (int)(tempSwapSpace /= 0x100000L) : -1;
            diskArray.cmpDiskCapacity = this.getLong(this.resultSet);
            diskArray.cmpDiskFreeSpace = this.getLong(this.resultSet);
            diskArray.cmpLogicalDiskCapacity = this.getLong(this.resultSet);
            diskArray.cmpLastProbeTime = this.getTimestamp(this.resultSet);
            diskArray.cmpProbeStatus = this.getByte(this.resultSet);
            diskArray.cmpGroupID = this.getInt(this.resultSet);
            diskArray.cmpProbingCompID = this.getInt(this.resultSet);
            diskArray.cmpVolGroupCapacity = this.getLong(this.resultSet);
            diskArray.cmpVolGroupFreespace = this.getLong(this.resultSet);
            diskArray.cmpDiskGroupFreeCap = this.getLong(this.resultSet);
            diskArray.cmpLogicalDiskAssignedCapacity = this.getLong(this.resultSet);
            diskArray.cmpZOSLogicalDiskCapacity = this.getLong(this.resultSet);
            diskArray.cmpOSType = this.getShort(this.resultSet);
            diskArray.cmpNDisks = (int)this.getLong(this.resultSet);
            diskArray.cmpNLogicalDisks = (int)this.getLong(this.resultSet);
            if (diskArray.cmpNasFiler == null) {
                diskArray.cmpNasFiler = new NasFiler();
                diskArray.cmpNasFiler.nfName = this.getString(this.resultSet);
                diskArray.cmpNasFiler.nfAlias = this.getString(this.resultSet);
            }
            if ((numAssignedMDisks = this.getNumOfAssignedMDisks(diskArray.cmpID)) > -1) {
                diskArray.cmpSwapSpace = numAssignedMDisks;
            }
        }
        catch (SQLException e) {
            this.sqlError(e);
        }
    }

    public EntityWWPN getSVCNodeWWPNs() throws GeneralException {
        EntityWWPN svcWWPNList = null;
        NasFiler svcList = null;
        svcList = this.getSVCIDs();
        if (svcList == null) {
            return svcWWPNList;
        }
        TResEntityWWPN eWWPNAccessor = new TResEntityWWPN(this.dbc);
        NasFiler svc = svcList;
        while (svc != null) {
            svcWWPNList = eWWPNAccessor.getEntityWWPNs(svc.nfComputer.cmpID);
            svc = svc.nfNext;
        }
        return svcWWPNList;
    }

    private NasFiler getSVCIDs() throws GeneralException {
        String sqlText = SELECT_SVC;
        this.setSQLText(sqlText);
        NasFiler head = null;
        this.staticStmt = this.createStatement();
        try {
            this.resultSet = this.staticStmt.executeQuery(sqlText);
        }
        catch (SQLException e) {
            this.stmtPhase = 3;
            this.sqlError(e);
        }
        while (this.nextResult()) {
            this.getPhase();
            Computer diskArray = new Computer();
            try {
                diskArray.cmpID = this.getInt(this.resultSet);
                if (diskArray.cmpNasFiler == null) {
                    diskArray.cmpNasFiler = new NasFiler();
                }
                diskArray.cmpNasFiler.nfNext = head;
                head = diskArray.cmpNasFiler;
                head.nfComputer = diskArray;
            }
            catch (SQLException e) {
                this.sqlError(e);
            }
        }
        this.closeStaticStmt();
        return head;
    }

    public void prepFetchByID() throws GeneralException {
        this.selectStmt = this.prepareStmt(JOIN_1);
    }

    public boolean fetchByID(Share share) throws GeneralException {
        boolean result = false;
        this.setPhase();
        try {
            this.setInt(this.selectStmt, share.shResourceID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.nextResult()) {
                result = true;
                this.getPhase();
                share.shPath = this.getString(this.resultSet);
            }
        }
        catch (SQLException e) {
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.commit();
        this.closeResultSet();
        return result;
    }

    public void initQueryByAttrType(short attributeType, HasID list) throws GeneralException {
        StringBuffer buf = new StringBuffer(400);
        buf.append(BIG_JOIN_PT_I);
        SQLUtil.appendInClause(buf, list);
        buf.append(BIG_JOIN_PT_II);
        String sqlText = buf.toString();
        buf = null;
        this.selectStmt = this.prepareStmt(sqlText);
        this.setPhase();
        try {
            this.setShort(this.selectStmt, attributeType);
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException e) {
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.queryBySchedule = new QueryBySchedule(this, null);
    }

    public boolean fetchQueryBySchedule(NameList element) throws GeneralException {
        return this.queryBySchedule.fetch(element);
    }

    public Lun getLunByID(int lunID) throws GeneralException {
        Lun lun = null;
        this.selectStmt = this.prepareStmt(SELECT_LUN);
        this.execQueryByID(lunID);
        try {
            if (this.nextResult()) {
                this.getPhase();
                lun = new Lun();
                lun.lunID = lunID;
                lun.lunDaID = this.getInt(this.resultSet);
                lun.lunDaManufacturer = this.getString(this.resultSet);
                lun.lunDaModel = this.getString(this.resultSet);
                lun.lunDaSerialNumber = lun.lunDaAlias = this.getString(this.resultSet);
                String tmp = this.getString(this.resultSet);
                if (Util.isEmpty((String)tmp)) {
                    lun.lunName = this.getString(this.resultSet);
                } else {
                    lun.lunWWN = this.getString(this.resultSet);
                    lun.lunName = tmp;
                }
            }
            this.closeSelect();
        }
        catch (SQLException e) {
            this.stmtType = 0;
            this.sqlError(e);
        }
        return lun;
    }

    public void initQueryBySchedule(int scheduleID) {
    }

    public void resetProbingComputer(int diskArrayID) throws GeneralException {
        this.updateStmt = this.prepareStmt(UPDATE_LICENSED_ARRAY);
        this.setPhase();
        try {
            this.setInt(this.updateStmt, 0);
            this.setInt(this.updateStmt, diskArrayID);
            this.executeUpdate(this.updateStmt);
        }
        catch (SQLException e) {
            this.stmtType = 2;
            this.sqlError(e);
        }
        this.closeUpdate();
        this.commit();
    }

    public void resetAllProbingComputers(int computerID) throws GeneralException {
        StringBuffer buf = new StringBuffer(100);
        buf.append(RESET_PROBING_COMPUTER);
        buf.append(computerID);
        String sqlText = buf.toString();
        buf = null;
        this.setSQLText(sqlText);
        this.staticStmt = this.createStatement();
        this.stmtPhase = 3;
        try {
            this.staticStmt.execute(sqlText);
        }
        catch (SQLException e) {
            this.sqlError(e);
        }
        this.closeStaticStmt();
        this.commit();
    }

    public void insert(Computer computer) throws GeneralException {
        this.insertStmt = this.prepareStmt(INSERT);
        this.setPhase();
        try {
            this.setInt(this.insertStmt, computer.cmpID);
            this.setAttributes(this.insertStmt, computer);
            this.setInt(this.insertStmt, computer.cmpGroupID);
            this.setInt(this.insertStmt, computer.cmpProbingCompID);
            this.executeUpdate(this.insertStmt);
        }
        catch (SQLException e) {
            this.stmtType = 1;
            this.sqlError(e);
        }
        this.closeInsert();
        this.commit();
    }

    public boolean update(Computer computer) throws GeneralException {
        int rowsUpdated = 0;
        this.updateStmt = this.prepareStmt(UPDATE);
        this.setPhase();
        try {
            this.setAttributes(this.updateStmt, computer);
            this.setInt(this.updateStmt, computer.cmpID);
            rowsUpdated = this.executeUpdate(this.updateStmt);
        }
        catch (SQLException e) {
            this.stmtType = 2;
            this.sqlError(e);
        }
        this.closeUpdate();
        this.commit();
        return rowsUpdated > 0;
    }

    private void setAttributes(PreparedStatement stmt, Computer computer) throws SQLException, GeneralException {
        short vendor_id = this.vmAccessor.getVendorID(computer.cmpManufacturer);
        this.setShort(stmt, vendor_id);
        short model_id = this.vmAccessor.getModelID(computer.cmpModel);
        this.setShort(stmt, model_id);
        this.setString(stmt, computer.cmpOSVersion);
        this.setInt(stmt, computer.cmpRAM);
        this.setInt(stmt, computer.cmpSwapSpace);
        this.setLong(stmt, computer.cmpDiskCapacity);
        this.setLong(stmt, computer.cmpDiskFreeSpace);
        this.setInt(stmt, computer.cmpNDisks);
        this.setInt(stmt, computer.cmpNLogicalDisks);
        this.setLong(stmt, computer.cmpLogicalDiskCapacity);
        this.setTimestamp(stmt, computer.cmpLastProbeTime);
        this.setByte(stmt, computer.cmpProbeStatus);
        this.setLong(stmt, computer.cmpVolGroupCapacity);
        this.setLong(stmt, computer.cmpVolGroupFreespace);
        this.setLong(stmt, computer.cmpDiskGroupFreeCap);
        this.setLong(stmt, computer.cmpLogicalDiskAssignedCapacity);
        this.setLong(stmt, computer.cmpZOSLogicalDiskCapacity);
    }

    public NameList selectNames(GuiListReq req) throws GeneralException {
        AlertNameList head = null;
        AlertNameList prev = null;
        StringBuffer buf = new StringBuffer(250);
        buf.append(SELECT_NAMELIST);
        if (req.groupID > 0) {
            buf.append(" where group_id = ");
            buf.append(Integer.toString(req.groupID));
        }
        buf.append(" order by 1");
        this.selectStmt = this.prepareStmt(buf.toString());
        this.stmtPhase = 3;
        try {
            this.resultSet = this.selectStmt.executeQuery();
            while (this.nextResult()) {
                this.getPhase();
                AlertNameList element = new AlertNameList();
                element.nlInfo = (short)78;
                element.nlID = this.getInt(this.resultSet);
                element.nlName = this.getString(this.resultSet);
                element.nlID2 = this.getShort(this.resultSet);
                element.nlProductID = (short)3;
                element.nlSubProductID = 1;
                if (prev != null) {
                    prev.nlNext = element;
                } else {
                    head = element;
                }
                prev = element;
            }
        }
        catch (SQLException e) {
            this.stmtType = 0;
            this.sqlError(e);
        }
        this.closeSelect();
        return head;
    }

    public NameList queryDependents(int attributeID) throws GeneralException {
        this.selectStmt = this.prepareStmt(SELECT_BY_ATTRIBUTE);
        this.stmtType = 0;
        this.setPhase();
        try {
            this.setInt(this.selectStmt, attributeID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException e) {
            this.sqlError(e);
        }
        NameList head = null;
        NameList prev = null;
        this.stmtPhase = 1;
        while (this.nextResult()) {
            NameList element = new NameList();
            element.nlInfo = (short)78;
            this.colIndex = 1;
            try {
                element.nlID = this.getInt(this.resultSet);
                element.nlName = this.getString(this.resultSet);
                if (this.getBoolean(this.resultSet)) {
                    element.nlState = 1;
                }
            }
            catch (SQLException e) {
                this.sqlError(e);
            }
            if (prev == null) {
                head = element;
            } else {
                prev.nlNext = element;
            }
            prev = element;
        }
        this.closeSelect();
        return head;
    }

    public NameList computersTiedTo(int objectID) throws GeneralException {
        this.selectStmt = this.prepareStmt(SELECT_BY_SCHEDULE);
        this.stmtType = 0;
        this.setPhase();
        try {
            this.setInt(this.selectStmt, objectID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException e) {
            this.sqlError(e);
        }
        int lastDiskArrayID = -3;
        AlertNameList head = null;
        int diskArrayID = -1;
        int probingCompID = -1;
        int osType = -1;
        boolean excluded = false;
        while (this.nextResult()) {
            this.getPhase();
            try {
                diskArrayID = this.getInt(this.resultSet);
                probingCompID = this.getInt(this.resultSet);
                excluded = this.getBoolean(this.resultSet);
                osType = this.getInt(this.resultSet);
            }
            catch (SQLException e) {
                this.sqlError(e);
            }
            if (diskArrayID == lastDiskArrayID) continue;
            lastDiskArrayID = diskArrayID;
            if (excluded) continue;
            AlertNameList item = new AlertNameList();
            item.nlID = diskArrayID;
            item.nlInfo = (short)osType;
            item.nlID2 = probingCompID;
            item.nlProductID = (short)3;
            item.nlSubProductID = 1;
            item.nlNext = head;
            head = item;
        }
        this.closeSelect();
        return head;
    }

    public NameList getStorageSystems() throws GeneralException {
        try {
            this.selectStmt = this.prepareStmt(SELECT_DISK_ARRAY_ID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException e) {
            this.sqlError(e);
        }
        NameList head = null;
        NameList prev = null;
        this.stmtPhase = 1;
        while (this.nextResult()) {
            NameList element = new NameList();
            element.nlInfo = (short)78;
            this.colIndex = 1;
            try {
                element.nlID = this.getInt(this.resultSet);
            }
            catch (SQLException e) {
                this.sqlError(e);
            }
            if (prev == null) {
                head = element;
            } else {
                prev.nlNext = element;
            }
            prev = element;
        }
        this.closeSelect();
        return head;
    }

    public int getNumOfAssignedMDisks(int subsystem_id) throws GeneralException {
        int result = -1;
        TResComputer cmpAccessor = new TResComputer(this.dbc);
        short type = cmpAccessor.getStorageSubsystemType(subsystem_id);
        if (type == 21) {
            result = this.getNum(GET_NUM_ASSIGNED_SVC_MDISKS, subsystem_id, false);
        }
        return result;
    }

    public int getNumOfStorageSystemDisks(int subsystem_id) throws GeneralException {
        int result = -1;
        TResComputer cmpAccessor = new TResComputer(this.dbc);
        short type = cmpAccessor.getStorageSubsystemType(subsystem_id);
        result = type == 21 ? this.getNum(GET_NUM_SVC_MDISKS, subsystem_id, false) : this.getNum(GET_NUM_SS_DISKS, subsystem_id, false);
        return result;
    }

    public int getNumOfStorageSystemLUNs(int subsystem_id) throws GeneralException {
        return this.getNum(GET_NUM_SS_LUNS, subsystem_id, false);
    }

    public int getNumOfStoragePoolDisks(int pool_id) throws GeneralException {
        if (SQLUtil.isDerby()) {
            return this.getNum(GET_NUM_POOL_DISKS, pool_id, true);
        }
        return this.getNum(GET_NUM_POOL_DISKS_OLD, pool_id, true);
    }

    public int getNumOfStoragePoolVolumes(int pool_id) throws GeneralException {
        return this.getNum(GET_NUM_POOL_LUNS, pool_id, false);
    }

    public int getNumOfDiskGroupDisks(int disk_group_id) throws GeneralException {
        return this.getNum(GET_NUM_DISK_GROUP_DISKS, disk_group_id, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNum(String sqlText, int id, boolean unionQuery) throws GeneralException {
        int result = -1;
        PreparedStatement getNumStmt = null;
        ResultSet getNumResultSet = null;
        try {
            getNumStmt = this.dbc.prepareStatement(sqlText);
            getNumStmt.setInt(1, id);
            if (unionQuery) {
                getNumStmt.setInt(2, id);
            }
            if ((getNumResultSet = getNumStmt.executeQuery()).next()) {
                result = getNumResultSet.getInt(1);
            }
        }
        catch (SQLException e) {
            this.sqlError(e);
        }
        finally {
            try {
                if (getNumStmt != null) {
                    getNumStmt.close();
                }
                if (getNumResultSet != null) {
                    getNumResultSet.close();
                }
            }
            catch (SQLException sqle) {}
        }
        return result;
    }
}

