/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.table.TAlertLog;
import org.eclipse.aperi.repository.table.TResAttr;

public class TResVendorModel
extends RepositoryAccessor {
    private static final String SELECT_VENDOR_ID = "select vendor_id from t_res_vendor where vendor_name = ?";
    private static final String SELECT_VENDOR_NAME = "select vendor_name from t_res_vendor where vendor_id = ?";
    private static final String SELECT_MODEL_ID = "select model_id from t_res_model where model_name = ?";
    private static final String SELECT_MODEL_NAME = "select model_name from t_res_model where model_id = ?";
    private static final String INSERT_VENDOR = "insert into t_res_vendor (vendor_id, vendor_name)  values (?,?)";
    private static final String INSERT_MODEL = "insert into t_res_model (model_id, model_name)  values (?,?)";

    public TResVendorModel(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResAttr.class.getName(), (String)"TResVendorModel", (String)"dbc");
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResAttr.class.getName(), (String)"TResVendorModel");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getVendorID(String vendor) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResVendorModel.class.getName(), (String)"getVendor", (String)"vendor");
        }
        short result = -1;
        try {
            this.selectStmt = this.prepareStmt(SELECT_VENDOR_ID);
            this.colIndex = 1;
            this.stmtPhase = 0;
            this.setString(this.selectStmt, vendor);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.colIndex = 1;
            if (this.nextResult()) {
                this.stmtPhase = 1;
                result = this.getShort(this.resultSet);
            } else {
                result = (short)SQLUtil.getIdentifier(1, 1, this.dbc);
                this.insertStmt = this.prepareStmt(INSERT_VENDOR);
                this.colIndex = 1;
                this.stmtPhase = 0;
                this.setShort(this.insertStmt, result);
                this.setString(this.insertStmt, vendor);
                this.stmtPhase = 3;
                this.insertStmt.executeUpdate();
                this.dbc.commit();
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TAlertLog.class.getName(), (String)"getVendor", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            this.closeInsert();
            this.closeSelect();
            this.closeResultSet();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"getVendor", (short)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getModelID(String model) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResVendorModel.class.getName(), (String)"getModel", (String)"model");
        }
        short result = -1;
        try {
            this.selectStmt = this.prepareStmt(SELECT_MODEL_ID);
            this.colIndex = 1;
            this.stmtPhase = 0;
            this.setString(this.selectStmt, model);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.colIndex = 1;
            if (this.nextResult()) {
                this.stmtPhase = 1;
                result = this.getShort(this.resultSet);
            } else {
                result = (short)SQLUtil.getIdentifier(1, 1, this.dbc);
                this.insertStmt = this.prepareStmt(INSERT_MODEL);
                this.colIndex = 1;
                this.stmtPhase = 0;
                this.setShort(this.insertStmt, result);
                this.setString(this.insertStmt, model);
                this.stmtPhase = 3;
                this.insertStmt.executeUpdate();
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TAlertLog.class.getName(), (String)"getModel", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            this.closeInsert();
            this.closeSelect();
            this.closeResultSet();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"getVendor", (short)result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getVendorName(short vendor_id) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResVendorModel.class.getName(), (String)"getVendorName", (String)"id");
        }
        String result = null;
        try {
            this.selectStmt = this.prepareStmt(SELECT_VENDOR_NAME);
            this.colIndex = 1;
            this.stmtPhase = 0;
            this.setShort(this.selectStmt, vendor_id);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.colIndex = 1;
            if (this.nextResult()) {
                this.stmtPhase = 1;
                result = this.getString(this.resultSet);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TAlertLog.class.getName(), (String)"getVendorName", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            this.closeSelect();
            this.closeResultSet();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"getVendorName", result);
        }
        return result == null ? "" : result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getModelName(short model_id) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResVendorModel.class.getName(), (String)"getModelName", (String)"id");
        }
        String result = null;
        try {
            this.selectStmt = this.prepareStmt(SELECT_MODEL_NAME);
            this.colIndex = 1;
            this.stmtPhase = 0;
            this.setShort(this.selectStmt, model_id);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.colIndex = 1;
            if (this.nextResult()) {
                this.stmtPhase = 1;
                result = this.getString(this.resultSet);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TAlertLog.class.getName(), (String)"getModelName", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        finally {
            this.closeSelect();
            this.closeResultSet();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TAlertLog.class.getName(), (String)"getVendorName", result);
        }
        return result == null ? "" : result;
    }
}

