/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.regex.Pattern;
import org.eclipse.aperi.TStorm.common.VolGroup;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.NameListQueryable;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TResComputer;
import org.eclipse.aperi.repository.table.TResDiskArray;
import org.eclipse.aperi.repository.table.TResLogicalDisk;

public class TResVolGroup
extends StorageRepositoryAccessor
implements NameListQueryable {
    private Timestamp vgProbe = new Timestamp(0L);
    private Timestamp vgDisc = new Timestamp(0L);
    public TResComputer cmpAccessor = null;
    private boolean isStorageSubsystem = false;
    private static final String GET_VOLGROUPS = "select volgroup_id, name, computer_id, freespace, capacity,  -1, volgroup_type, lss, config, nbrvolumes, disk_group,  status, format, surf_lun_cap, unsurf_lun_cap,  nbrdisks, discovered_time, last_probe_time, rank_id, raid_id  from t_res_volgroup ";
    private static final String NOT_PRIMORDIAL_STORAGE_POOL = "primordial != 1";
    private static final String GET_STORAGE_POOLS = "select pool_id, display_name, subsystem_id, total_available_space,  capacity, extent_size,  vol_group_type, lss, config, number_of_storage_volumes,  '0', operational_status, format, surfaced_lun_cap, unsurfaced_lun_cap,  -1, discovered_time, update_timestamp, raid_level  from t_res_storage_pool where primordial != 1";
    private static final String GET_STORAGE_POOL_RESULTSET = " select pool_id, extent_size, raid_level from t_res_storage_pool where subsystem_id = ? and primordial != 1";
    private static final String GET_STORAGE_POOL_DISK_GROUP = "select dg.tag from t_res_disk_group dg, t_res_storage_extent se, t_res_storage_pool pool where pool.pool_id = se.pool_id and se.storage_extent_id = dg.storage_extent_id and pool.pool_id = ?";
    private static final String NAMELIST_SELECT_SP_IN_ARRAY_SITE = " select pool.pool_id, pool.display_name, pool.subsystem_id, pool.vol_group_type from t_res_disk_group dg,      t_res_storage_extent se,      t_res_storage_pool pool where dg.storage_extent_id = se.storage_Extent_id  and se.pool_id = pool.pool_id  and pool.subsystem_id = ?";
    private static final String GET_STORAGE_POOL_DISK_GROUP_WIDTH_RAID = "select dg.width, se.redundancy from t_res_disk_group dg, t_res_storage_extent se, t_res_storage_pool pool where pool.pool_id = se.pool_id and se.storage_extent_id = dg.storage_extent_id and pool.pool_id = ?";
    private static final String GET_STORAGE_POOL_DISK_GROUP_RAID = "select se.redundancy from t_res_disk_group dg, t_res_storage_extent se, t_res_storage_pool pool where pool.pool_id = se.pool_id and pool.pool_id = ?";
    private static final String GET_STORAGE_POOL_INFO = "select dg.width, se.redundancy, se.storage_extent_id from t_res_disk_group dg, t_res_storage_extent se, t_res_storage_pool pool where pool.pool_id = se.pool_id and se.storage_extent_id = dg.storage_extent_id and pool.pool_id = ?";
    private static final String GET_STORAGE_POOL_RAIDS = "select distinct sp.raid_level  from t_res_storage_pool sp  where sp.pool_id = ?";
    private static final String COLLECT_ARRAY_SITES = "select distinct dg.disk_group_number from T_RES_DISK_GROUP dg, T_RES_STORAGE_SUBSYSTEM ss, T_RES_STORAGE_EXTENT se, T_RES_STORAGE_POOL sp where ss.subsystem_id = dg.subsystem_id and dg.storage_extent_id = se.storage_extent_id and se.subsystem_id = dg.subsystem_id and se.pool_id = sp.pool_id and sp.subsystem_id = se.subsystem_id and sp.pool_id = ? order by 1";
    private static final String COLLECT_RANKS = "select distinct se.rank_id from T_RES_STORAGE_EXTENT se, T_RES_STORAGE_SUBSYSTEM ss, T_RES_STORAGE_POOL sp where ss.subsystem_id = se.subsystem_id and se.pool_id = sp.pool_id and sp.subsystem_id = se.subsystem_id and sp.pool_id = ? order by 1";
    private static final String GET_NUM_RANKS = "select count(*) from T_RES_STORAGE_EXTENT se, T_RES_STORAGE_POOL sp where se.pool_id = sp.pool_id and sp.pool_id = ? ";
    private static final String INSERT_VOLGROUP = "insert into t_res_volgroup  (volgroup_id, name, computer_id, freespace, capacity,   volgroup_type, lss, config, nbrvolumes, disk_group,   status, format, surf_lun_cap, unsurf_lun_cap,   nbrdisks, discovered_time, last_probe_time, rank_id, raid_id )  values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";
    private static final String INSERT_STORAGE_POOL = "insert into t_res_storage_pool  (pool_id, instance_id, subsystem_id, remaining_managed_space,  capacity,  vol_group_type, lss, config,  number_of_storage_volumes, disk_group, native_status, format,  surf_lun_cap, unsurf_lun_cap, number_of_backend_volumes,  discovered_time, update_timestamp, rank_id, raid_id )  values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?) ";
    private static final String DELETE_VOLGROUP = "delete from t_res_volgroup where volgroup_id = ?";
    private static final String DELETE_STORAGE_POOL = "delete from t_res_storage_pool where pool_id = ?";
    private static final String DELETE_STATS = "delete from t_stat_fs_hist where filesystem_id = ?";
    private static final String UPDATE_VOLGROUP = "update t_res_volgroup  set name = ?, computer_id = ?, freespace = ?, capacity = ?, volgroup_type = ?, lss = ?, config = ?, nbrvolumes = ?, disk_group = ?, status = ?, format = ?, surf_lun_cap = ?, unsurf_lun_cap = ?, nbrdisks = ?, last_probe_time = ?, rank_id = ?, raid_id = ?  where volgroup_id = ?";
    private static final String UPDATE_STORAGE_POOL = "update t_res_storage_pool  set instance_id = ?, subsystem_id = ?,  remaining_managed_space = ?, capacity = ?, vol_group_type = ?, lss = ?, config = ?, number_of_ storage_volumes = ?,  disk_group = ?, native_status = ?, format = ?, surf_lun_cap = ?,  unsurf_lun_cap = ?, number_of_backend_volumes = ?,  update_timestamp = ?, rank_id = ?, raid_id = ? where pool_id = ?";
    private static final String NAMELIST_SELECT = "select volgroup_id, name, computer_id, volgroup_type  from t_res_volgroup where computer_id = ? ";
    private static final String NAMELIST_SELECT_SP = "select pool_id, display_name, subsystem_id, vol_group_type  from t_res_storage_pool where primordial != 1 and subsystem_id = ? ";
    private static final String NAMELIST_SELECT_BY_VGID = "select volgroup_id, name, computer_id, volgroup_type  from t_res_volgroup where volgroup_id = ? ";
    private static final String NAMELIST_SELECT_BY_POOL_ID = "select pool_id, display_name, subsystem_id, vol_group_type  from t_res_storage_pool where primordial != 1 and pool_id = ? ";
    private static final String NAMELIST_ORDER = " order by 2";

    public TResVolGroup(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResVolGroup.class.getName(), (String)"TResVolGroup", (String)"dbc");
        }
        this.tableName = "t_res_volgroup";
        this.cmpAccessor = new TResComputer(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResVolGroup.class.getName(), (String)"TResVolGroup");
        }
    }

    public VolGroup getVolGroupByCmp(int computerID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResVolGroup.class.getName(), (String)"getVolGroupByCmp", (String)"computerID");
        }
        VolGroup vgList = null;
        String selectSql = null;
        this.isStorageSubsystem = this.cmpAccessor.isStorageSubsystem(computerID);
        selectSql = this.isStorageSubsystem ? "select pool_id, display_name, subsystem_id, total_available_space,  capacity, extent_size,  vol_group_type, lss, config, number_of_storage_volumes,  '0', operational_status, format, surfaced_lun_cap, unsurfaced_lun_cap,  -1, discovered_time, update_timestamp, raid_level  from t_res_storage_pool where primordial != 1 and subsystem_id = ?" : "select volgroup_id, name, computer_id, freespace, capacity,  -1, volgroup_type, lss, config, nbrvolumes, disk_group,  status, format, surf_lun_cap, unsurf_lun_cap,  nbrdisks, discovered_time, last_probe_time, rank_id, raid_id  from t_res_volgroup  where computer_id = ?";
        this.selectStmt = this.prepareStmt(selectSql);
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, computerID);
            vgList = this.getGroups();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResVolGroup.class.getName(), (String)"getVolGroupByCmp", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        VolGroup traceResult = vgList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResVolGroup.class.getName(), (String)"getVolGroupByCmp", (Object)traceResult);
        }
        return traceResult;
    }

    public VolGroup getVolGroupByID(int groupID, int cmpID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResVolGroup.class.getName(), (String)"getVolGroupByID", (String)"groupID");
        }
        VolGroup vgList = null;
        String selectSql = null;
        this.isStorageSubsystem = this.cmpAccessor.isStorageSubsystem(cmpID);
        selectSql = this.isStorageSubsystem ? "select pool_id, display_name, subsystem_id, total_available_space,  capacity, extent_size,  vol_group_type, lss, config, number_of_storage_volumes,  '0', operational_status, format, surfaced_lun_cap, unsurfaced_lun_cap,  -1, discovered_time, update_timestamp, raid_level  from t_res_storage_pool where primordial != 1 and pool_id = ?" : "select volgroup_id, name, computer_id, freespace, capacity,  -1, volgroup_type, lss, config, nbrvolumes, disk_group,  status, format, surf_lun_cap, unsurf_lun_cap,  nbrdisks, discovered_time, last_probe_time, rank_id, raid_id  from t_res_volgroup  where volgroup_id = ?";
        this.selectStmt = this.prepareStmt(selectSql);
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, groupID);
            vgList = this.getGroups();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResVolGroup.class.getName(), (String)"getVolGroupByID", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        VolGroup traceResult = vgList;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResVolGroup.class.getName(), (String)"getVolGroupByID", (Object)traceResult);
        }
        return traceResult;
    }

    private VolGroup getGroups() throws SQLException, GeneralException {
        VolGroup vg;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResVolGroup.class.getName(), (String)"getGroups", (String)"");
        }
        VolGroup result = null;
        this.stmtPhase = 3;
        this.resultSet = this.selectStmt.executeQuery();
        while ((vg = this.getVolGroup()) != null) {
            vg.vgNext = result;
            result = vg;
        }
        this.closeSelect();
        VolGroup traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResVolGroup.class.getName(), (String)"getGroups", (Object)traceResult);
        }
        return traceResult;
    }

    private VolGroup getVolGroup() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResVolGroup.class.getName(), (String)"getVolGroup", (String)"");
        }
        VolGroup vg = null;
        try {
            if (!this.nextResult()) {
                VolGroup traceResult = null;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TResVolGroup.class.getName(), (String)"getVolGroup", traceResult);
                }
                return traceResult;
            }
            this.stmtPhase = 1;
            this.colIndex = 1;
            vg = new VolGroup();
            vg.vgID = this.getInt(this.resultSet);
            vg.vgName = this.getString(this.resultSet);
            vg.vgComputerID = this.getInt(this.resultSet);
            vg.vgFreeSpace = this.getLong(this.resultSet);
            vg.vgTotalSpace = this.getLong(this.resultSet);
            vg.vgExtentSize = this.getInt(this.resultSet);
            vg.vgType = this.getShort(this.resultSet);
            vg.vgLSS = this.getString(this.resultSet);
            vg.vgConfig = this.getShort(this.resultSet);
            vg.vgVolumes = this.getInt(this.resultSet);
            vg.vgDiskGroup = this.getString(this.resultSet);
            vg.vgOperationalStatus = this.getInt(this.resultSet);
            vg.vgStatus = (short)vg.vgOperationalStatus;
            vg.vgFormat = this.getShort(this.resultSet);
            vg.vgSurfacedLunCap = this.getLong(this.resultSet);
            vg.vgUnSurfacedLunCap = this.getLong(this.resultSet);
            vg.vgDisks = this.getInt(this.resultSet);
            vg.vgDiscoveredTime = this.getTimestamp(this.resultSet);
            if (this.resultSet.wasNull()) {
                vg.vgDiscoveredTime = 86400000L;
            }
            vg.vgProbeTime = this.getTimestamp(this.resultSet);
            if (this.resultSet.wasNull()) {
                vg.vgProbeTime = 86400000L;
            }
            if (!this.isStorageSubsystem) {
                vg.vgRank = this.getString(this.resultSet);
                vg.vgRaidLevels = this.getString(this.resultSet);
            } else {
                TResDiskArray ssAccessor = new TResDiskArray(this.dbc);
                vg.vgDisks = ssAccessor.getNumOfStoragePoolDisks(vg.vgID);
                vg.vgVolumes = ssAccessor.getNumOfStoragePoolVolumes(vg.vgID);
                vg.vgType = this.setStoragePoolType(vg.vgComputerID);
                vg.vgConfigs = this.getStoragePoolRaidLevel(vg.vgID);
                vg.vgConfig = vg.vgConfigs.length > 0 ? vg.vgConfigs[0] : (short)11;
                if (vg.vgType == 5 || vg.vgType == 4) {
                    vg.vgArray = this.getArraySites(vg.vgID);
                    vg.vgRank = this.getRanks(vg.vgID);
                }
                vg.vgDiskGroup = this.getStoragePoolDiskGroup(vg.vgID);
                if (this.cmpAccessor.getStorageSubsystemType(vg.vgComputerID) == 14) {
                    vg.vgDisks = 1;
                }
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResVolGroup.class.getName(), (String)"getVolGroup", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        VolGroup traceResult = vg;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResVolGroup.class.getName(), (String)"getVolGroup", (Object)traceResult);
        }
        return traceResult;
    }

    public void saveVolGroups(VolGroup vgList, int identifierCount) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResVolGroup.class.getName(), (String)"saveVolGroups", (String)"vgList, identifierCount");
        }
        if (vgList == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TResVolGroup.class.getName(), (String)"saveVolGroups");
            }
            return;
        }
        VolGroup vg = null;
        int identifier = 0;
        try {
            if (identifierCount > 0) {
                identifier = TResVolGroup.getIdentifier(1, identifierCount, this.dbc);
            }
            vg = vgList;
            while (vg != null) {
                if (vg.vgID == -1) {
                    vg.vgID = identifier++;
                    this.insertVG(vg);
                } else if (vg.vgFlag == 2) {
                    this.updateVG(vg);
                }
                this.dbc.commit();
                vg = vg.vgNext;
            }
            this.closeSelect();
            this.closeInsert();
            this.closeUpdate();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResVolGroup.class.getName(), (String)"saveVolGroups", (Throwable)e);
            }
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResVolGroup.class.getName(), (String)"saveVolGroups");
        }
    }

    private void insertVG(VolGroup vg) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResVolGroup.class.getName(), (String)"insertVG", (String)"vg");
        }
        this.isStorageSubsystem = this.cmpAccessor.isStorageSubsystem(vg.vgComputerID);
        this.insertStmt = this.isStorageSubsystem ? this.prepareStmt(INSERT_STORAGE_POOL) : this.prepareStmt(INSERT_VOLGROUP);
        this.stmtType = 1;
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setInt(this.insertStmt, vg.vgID);
        this.setString(this.insertStmt, vg.vgName);
        this.setInt(this.insertStmt, vg.vgComputerID);
        this.setLong(this.insertStmt, vg.vgFreeSpace);
        this.setLong(this.insertStmt, vg.vgTotalSpace);
        this.setShort(this.insertStmt, vg.vgType);
        this.setString(this.insertStmt, vg.vgLSS);
        this.setShort(this.insertStmt, vg.vgConfig);
        this.setInt(this.insertStmt, vg.vgVolumes);
        if (vg.vgType == 4 || vg.vgType == 5) {
            this.setString(this.insertStmt, vg.getArraySitesforDB());
        } else {
            this.setString(this.insertStmt, vg.vgDiskGroup);
        }
        this.setInt(this.insertStmt, vg.vgOperationalStatus);
        this.setShort(this.insertStmt, vg.vgFormat);
        this.setLong(this.insertStmt, vg.vgSurfacedLunCap);
        this.setLong(this.insertStmt, vg.vgUnSurfacedLunCap);
        this.setInt(this.insertStmt, vg.vgDisks);
        this.setTimestamp(this.insertStmt, vg.vgDiscoveredTime, this.vgDisc);
        this.setTimestamp(this.insertStmt, vg.vgProbeTime, this.vgProbe);
        if (vg.vgType == 4 || vg.vgType == 5) {
            this.setString(this.insertStmt, vg.getRanks());
            this.setString(this.insertStmt, vg.getConfigs());
        } else if (vg.vgType == 6) {
            this.setString(this.insertStmt, null);
            this.setString(this.insertStmt, vg.getConfigs());
        } else {
            this.setString(this.insertStmt, null);
            this.setString(this.insertStmt, null);
        }
        this.executeUpdate(this.insertStmt);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResVolGroup.class.getName(), (String)"insertVG");
        }
    }

    public void deleteVGByComputer(int compID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResVolGroup.class.getName(), (String)"deleteVGByComputer", (String)"compID");
        }
        VolGroup vgList = this.getVolGroupByCmp(compID);
        this.deleteVolGroups(vgList);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResVolGroup.class.getName(), (String)"deleteVGByComputer");
        }
    }

    public void deleteVolGroups(VolGroup vgList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResVolGroup.class.getName(), (String)"deleteVolGroups", (String)"vgList");
        }
        try {
            VolGroup vg = vgList;
            while (vg != null) {
                this.deleteVG(vg);
                vg = vg.vgNext;
            }
            this.deleteStmt = this.prepareStmt(DELETE_STATS);
            vg = vgList;
            while (vg != null) {
                this.deleteVG(vg);
                vg = vg.vgNext;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResVolGroup.class.getName(), (String)"deleteVolGroups", (Throwable)e);
            }
            this.stmtType = 3;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResVolGroup.class.getName(), (String)"deleteVolGroups");
        }
    }

    private void deleteVG(VolGroup vg) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResVolGroup.class.getName(), (String)"deleteVG", (String)"vg");
        }
        if (this.deleteStmt == null) {
            this.isStorageSubsystem = this.cmpAccessor.isStorageSubsystem(vg.vgComputerID);
            this.deleteStmt = this.isStorageSubsystem ? this.prepareStmt(DELETE_STORAGE_POOL) : this.prepareStmt(DELETE_VOLGROUP);
        }
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setInt(this.deleteStmt, vg.vgID);
        this.executeUpdate(this.deleteStmt);
        this.dbc.commit();
        this.closeDelete();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResVolGroup.class.getName(), (String)"deleteVG");
        }
    }

    public void prepUpdateVG() throws GeneralException {
        this.updateStmt = this.prepareStmt(UPDATE_VOLGROUP);
    }

    public void updateVG(VolGroup vg) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResVolGroup.class.getName(), (String)"updateVG", (String)"vg");
        }
        this.isStorageSubsystem = this.cmpAccessor.isStorageSubsystem(vg.vgComputerID);
        this.updateStmt = this.isStorageSubsystem ? this.prepareStmt(UPDATE_STORAGE_POOL) : this.prepareStmt(UPDATE_VOLGROUP);
        this.stmtPhase = 0;
        this.colIndex = 1;
        try {
            this.setString(this.updateStmt, vg.vgName);
            this.setInt(this.updateStmt, vg.vgComputerID);
            this.setLong(this.updateStmt, vg.vgFreeSpace);
            this.setLong(this.updateStmt, vg.vgTotalSpace);
            this.setShort(this.updateStmt, vg.vgType);
            this.setString(this.updateStmt, vg.vgLSS);
            this.setShort(this.updateStmt, vg.vgConfig);
            this.setInt(this.updateStmt, vg.vgVolumes);
            if (vg.vgType == 4 || vg.vgType == 5) {
                this.setString(this.updateStmt, vg.getArraySitesforDB());
            } else {
                this.setString(this.updateStmt, vg.vgDiskGroup);
            }
            this.setInt(this.updateStmt, vg.vgOperationalStatus);
            this.setShort(this.updateStmt, vg.vgFormat);
            this.setLong(this.updateStmt, vg.vgSurfacedLunCap);
            this.setLong(this.updateStmt, vg.vgUnSurfacedLunCap);
            this.setInt(this.updateStmt, vg.vgDisks);
            this.setTimestamp(this.updateStmt, vg.vgProbeTime, this.vgProbe);
            if (vg.vgType == 4 || vg.vgType == 5) {
                this.setString(this.updateStmt, vg.getRanks());
                this.setString(this.updateStmt, vg.getConfigs());
            } else if (vg.vgType == 6) {
                this.setString(this.updateStmt, null);
                this.setString(this.updateStmt, vg.getConfigs());
            } else {
                this.setString(this.updateStmt, null);
                this.setString(this.updateStmt, null);
            }
            this.setInt(this.updateStmt, vg.vgID);
            this.executeUpdate(this.updateStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResVolGroup.class.getName(), (String)"updateVG", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResVolGroup.class.getName(), (String)"updateVG");
        }
    }

    public NameList selectNames(GuiListReq glr) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResVolGroup.class.getName(), (String)"selectNames", (String)"glr");
        }
        NameList head = null;
        NameList prev = null;
        StringBuffer buf = new StringBuffer(500);
        this.isStorageSubsystem = this.cmpAccessor.isStorageSubsystem(glr.computerID);
        if (this.isStorageSubsystem) {
            if (glr.groupID > 0) {
                buf.append(NAMELIST_SELECT_SP_IN_ARRAY_SITE);
                buf.append(" and disk_group_number = " + glr.groupID);
            } else {
                buf.append(NAMELIST_SELECT_SP);
            }
        } else {
            buf.append(NAMELIST_SELECT);
        }
        buf.append(NAMELIST_ORDER);
        this.selectStmt = this.prepareStmt(buf.toString());
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, glr.computerID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            while (this.nextResult()) {
                this.colIndex = 1;
                NameList element = new NameList();
                element.nlID = this.getInt(this.resultSet);
                element.nlName = this.getString(this.resultSet);
                element.nlID2 = this.getInt(this.resultSet);
                element.nlID3 = this.getShort(this.resultSet);
                if (prev != null) {
                    prev.nlNext = element;
                } else {
                    head = element;
                }
                prev = element;
            }
            this.closeStaticStmt();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResVolGroup.class.getName(), (String)"selectNames", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        NameList traceResult = head;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResVolGroup.class.getName(), (String)"selectNames", traceResult);
        }
        return traceResult;
    }

    public NameList selectNamesByVGID(GuiListReq glr) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResVolGroup.class.getName(), (String)"selectNameByVGID", (String)"glr");
        }
        NameList element = null;
        StringBuffer buf = new StringBuffer(500);
        this.isStorageSubsystem = this.cmpAccessor.isStorageSubsystem(glr.computerID);
        if (this.isStorageSubsystem) {
            buf.append(NAMELIST_SELECT_BY_POOL_ID);
        } else {
            buf.append(NAMELIST_SELECT_BY_VGID);
        }
        this.selectStmt = this.prepareStmt(buf.toString());
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setInt(this.selectStmt, glr.vgID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.stmtPhase = 1;
            if (this.nextResult()) {
                this.colIndex = 1;
                element = new NameList();
                element.nlID = this.getInt(this.resultSet);
                element.nlName = this.getString(this.resultSet);
                element.nlID2 = this.getInt(this.resultSet);
                element.nlID3 = this.getShort(this.resultSet);
            }
            this.closeStaticStmt();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResVolGroup.class.getName(), (String)"selectNameByVGID", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        NameList traceResult = element;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResVolGroup.class.getName(), (String)"selectNameByVGID", traceResult);
        }
        return traceResult;
    }

    private short setStoragePoolType(int subsystem_id) throws GeneralException {
        short result = -1;
        TResComputer cmpAccessor = new TResComputer(this.dbc);
        short ssType = cmpAccessor.getStorageSubsystemType(subsystem_id);
        switch (ssType) {
            case 12: {
                result = 2;
                break;
            }
            case 15: 
            case 18: {
                result = 3;
                break;
            }
            case 25: {
                result = 4;
                break;
            }
            case 27: {
                result = 5;
                break;
            }
            default: {
                result = 3;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStoragePoolDiskGroup(int pool_id) throws GeneralException {
        String result = null;
        PreparedStatement getDiskGroupStmt = null;
        ResultSet getDiskGroupResultSet = null;
        try {
            getDiskGroupStmt = this.dbc.prepareStatement(GET_STORAGE_POOL_DISK_GROUP);
            getDiskGroupStmt.setInt(1, pool_id);
            getDiskGroupResultSet = getDiskGroupStmt.executeQuery();
            if (getDiskGroupResultSet.next()) {
                result = getDiskGroupResultSet.getString(1);
            }
        }
        catch (SQLException e) {
            this.sqlError(e);
        }
        finally {
            try {
                if (getDiskGroupStmt != null) {
                    getDiskGroupStmt.close();
                }
                if (getDiskGroupResultSet != null) {
                    getDiskGroupResultSet.close();
                }
            }
            catch (SQLException sqle) {}
        }
        return result;
    }

    public short[] getStoragePoolRaidLevel(int pool_id) throws GeneralException {
        VolGroup vg = new VolGroup();
        vg.vgID = pool_id;
        this.getDSRaidLevels(vg);
        return vg.vgConfigs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getDSRaidLevels(VolGroup vg) throws GeneralException {
        vg.vgConfigs = new short[1];
        vg.vgConfigs[0] = 11;
        PreparedStatement getDSRaidStmt = null;
        ResultSet getDSRaidResultSet = null;
        try {
            String raidLevels;
            getDSRaidStmt = this.dbc.prepareStatement(GET_STORAGE_POOL_RAIDS);
            getDSRaidStmt.setInt(1, vg.vgID);
            getDSRaidResultSet = getDSRaidStmt.executeQuery();
            if (getDSRaidResultSet.next() && (raidLevels = getDSRaidResultSet.getString(1)) != null) {
                Pattern p = Pattern.compile(" ");
                String[] each_rl = p.split(raidLevels);
                vg.vgConfigs = new short[each_rl.length];
                for (int i = 0; i < each_rl.length; ++i) {
                    vg.vgConfigs[i] = 11;
                    for (int j = 0; j < VolGroup.RAID_LEVELS.length; j = (int)((short)(j + 1))) {
                        if (!VolGroup.RAID_LEVELS[j].equalsIgnoreCase(each_rl[i].trim())) continue;
                        vg.vgConfigs[i] = j;
                    }
                }
            }
        }
        catch (SQLException e) {
            this.sqlError(e);
        }
        finally {
            try {
                if (getDSRaidStmt != null) {
                    getDSRaidStmt.close();
                }
                if (getDSRaidResultSet != null) {
                    getDSRaidResultSet.close();
                }
            }
            catch (SQLException sqle) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getArraySites(int pool_id) throws GeneralException {
        PreparedStatement arraySitesStatement = null;
        ResultSet arraySitesResultSet = null;
        boolean getArraySites = false;
        String arraySites = new String();
        try {
            arraySitesStatement = this.dbc.prepareStatement(COLLECT_ARRAY_SITES);
            arraySitesStatement.setInt(1, pool_id);
            arraySitesResultSet = arraySitesStatement.executeQuery();
            this.dbc.commit();
            while (arraySitesResultSet.next()) {
                this.getPhase();
                String dgName = Short.toString(this.getShort(arraySitesResultSet));
                arraySites = arraySites.concat(dgName);
                arraySites = arraySites.concat(", ");
                getArraySites = true;
            }
            arraySites = getArraySites ? arraySites.substring(0, arraySites.length() - 2) : " ";
        }
        catch (SQLException sqle) {
            this.sqlError(sqle);
        }
        finally {
            try {
                if (arraySitesStatement != null) {
                    arraySitesStatement.close();
                }
                if (arraySitesResultSet != null) {
                    arraySitesResultSet.close();
                }
            }
            catch (SQLException sqle) {}
        }
        return arraySites;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRanks(int pool_id) throws GeneralException {
        PreparedStatement ranksStatement = null;
        ResultSet ranksResultSet = null;
        boolean getRanks = false;
        String ranks = new String();
        try {
            ranksStatement = this.dbc.prepareStatement(COLLECT_RANKS);
            ranksStatement.setInt(1, pool_id);
            ranksResultSet = ranksStatement.executeQuery();
            this.dbc.commit();
            while (ranksResultSet.next()) {
                this.getPhase();
                String dgName = Short.toString(this.getShort(ranksResultSet));
                ranks = ranks.concat(dgName);
                ranks = ranks.concat(", ");
                getRanks = true;
            }
            ranks = getRanks ? ranks.substring(0, ranks.length() - 2) : " ";
        }
        catch (SQLException sqle) {
            this.sqlError(sqle);
        }
        finally {
            try {
                if (ranksStatement != null) {
                    ranksStatement.close();
                }
                if (ranksResultSet != null) {
                    ranksResultSet.close();
                }
            }
            catch (SQLException sqle) {}
        }
        return ranks;
    }

    public ResultSet getStoragePoolDiskGroupWidthRaid(int pool_id) throws GeneralException {
        PreparedStatement getDiskGroupWidthStmt = null;
        ResultSet getDiskGroupWidthResultSet = null;
        try {
            getDiskGroupWidthStmt = this.dbc.prepareStatement(GET_STORAGE_POOL_DISK_GROUP_WIDTH_RAID);
            getDiskGroupWidthStmt.setInt(1, pool_id);
            getDiskGroupWidthResultSet = getDiskGroupWidthStmt.executeQuery();
        }
        catch (SQLException e) {
            this.sqlError(e);
        }
        return getDiskGroupWidthResultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public short getStoragePoolDiskGroupRaid(int pool_id) throws GeneralException {
        short result = -1;
        PreparedStatement getDiskGroupRaidStmt = null;
        ResultSet getDiskGroupRaidResultSet = null;
        try {
            getDiskGroupRaidStmt = this.dbc.prepareStatement(GET_STORAGE_POOL_DISK_GROUP_RAID);
            getDiskGroupRaidStmt.setInt(1, pool_id);
            getDiskGroupRaidResultSet = getDiskGroupRaidStmt.executeQuery();
            if (getDiskGroupRaidResultSet.next()) {
                result = getDiskGroupRaidResultSet.getShort(1);
            }
        }
        catch (SQLException e) {
            this.sqlError(e);
        }
        finally {
            try {
                if (getDiskGroupRaidStmt != null) {
                    getDiskGroupRaidStmt.close();
                }
                if (getDiskGroupRaidResultSet != null) {
                    getDiskGroupRaidResultSet.close();
                }
            }
            catch (SQLException sqle) {}
        }
        return result;
    }

    public ResultSet getStoragePools(int subsystem_id) throws GeneralException {
        ResultSet rsPools = null;
        try {
            PreparedStatement stmtPools = this.dbc.prepareStatement(GET_STORAGE_POOL_RESULTSET);
            stmtPools.setInt(1, subsystem_id);
            rsPools = stmtPools.executeQuery();
        }
        catch (SQLException sqle) {
            this.sqlError(sqle);
        }
        return rsPools;
    }

    public int getNumOfStoragePoolRanks(int pool_id) throws GeneralException {
        return this.getNum(GET_NUM_RANKS, pool_id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getNum(String sqlText, int id) throws GeneralException {
        int result = -1;
        PreparedStatement getNumStmt = null;
        ResultSet getNumResultSet = null;
        try {
            getNumStmt = this.dbc.prepareStatement(sqlText);
            getNumStmt.setInt(1, id);
            getNumResultSet = getNumStmt.executeQuery();
            if (getNumResultSet.next()) {
                result = getNumResultSet.getInt(1);
            }
        }
        catch (SQLException e) {
            this.sqlError(e);
        }
        finally {
            try {
                if (getNumStmt != null) {
                    getNumStmt.close();
                }
                if (getNumResultSet != null) {
                    getNumResultSet.close();
                }
            }
            catch (SQLException sqle) {}
        }
        return result;
    }

    public ResultSet getPoolRankInfo(int pool_id) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TResLogicalDisk.class.getName(), (String)"getPoolRanks", (String)"pool_id");
        }
        ResultSet ranks = null;
        try {
            PreparedStatement statement = this.dbc.prepareStatement(GET_STORAGE_POOL_INFO);
            statement.setInt(1, pool_id);
            ranks = statement.executeQuery();
        }
        catch (SQLException sqle) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TResLogicalDisk.class.getName(), (String)"getPoolRanks", (Throwable)sqle);
            }
            this.sqlError(sqle);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TResLogicalDisk.class.getName(), (String)"getPoolRanks", (Object)ranks);
        }
        return ranks;
    }

    public void closeInsert() throws GeneralException {
        super.closeInsert();
    }

    public void closeDelete() throws GeneralException {
        super.closeDelete();
    }

    public void closeSelect() throws GeneralException {
        super.closeSelect();
    }
}

