/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.TimeZone;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.identity.HardwareID;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.table.TComputer;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class TServer {
    public String serverName;
    public TComputer computer;
    public int serverID = -1;
    public int serverPort = -1;
    public long serverToken = -1L;
    public int serverType = 0;
    public boolean serverRelocated;
    public boolean initialRegisitration = false;
    private static final String SELECT_SQL_TEXT = "select server_id, server_token, port_number, computer_id from t_res_server where server_name = ? and server_type <> 1";
    private static final String INSERT_SQL_TEXT = "insert into t_res_server (server_id, server_token, server_name, port_number, computer_id, server_type) values (?,?,?,?,?,?)";
    private static final String UPDATE_SQL_TEXT = "update t_res_server set port_number = ?, computer_id = ? where server_id = ?";

    public TServer(String hostAlias, int port, String serverName, HardwareID hwID, String guid) throws GeneralException {
        this(serverName);
        TimeZone tZone;
        String timezoneID;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TServer.class.getName(), (String)"TServer", (String)"hostAlias, port, serverName, hwID, guid");
        }
        this.serverPort = port;
        String ipAddress = null;
        String localHostName = null;
        UnknownHostException exc1 = null;
        LocalizableException exc2 = null;
        try {
            localHostName = HardwareID.getLocalHostName();
            localHostName = localHostName.toLowerCase();
            InetAddress inet = InetAddress.getByName(localHostName);
            ipAddress = inet.getHostAddress();
        }
        catch (UnknownHostException e1) {
            exc1 = e1;
        }
        catch (LocalizableException e2) {
            exc2 = e2;
        }
        if (exc1 != null || exc2 != null) {
            Throwable exc = exc1 == null ? exc2 : exc1;
            MessageLog.logException((String)"GEN0042E", (Exception)exc);
            MessageLog.logMessage((String)"SRV0051E");
            throw new GeneralException();
        }
        if (hostAlias == null) {
            hostAlias = localHostName;
        }
        if (hwID == null) {
            hwID = new HardwareID(localHostName);
        }
        if (hwID.hardwareID == null) {
            hwID.setBogusHardwareID(hostAlias);
        }
        if ((timezoneID = (tZone = TimeZone.getDefault()).getID()).indexOf("Custom") != -1) {
            timezoneID = tZone.getDisplayName(tZone.useDaylightTime(), 0);
        }
        this.computer = new TComputer(hostAlias, hwID, null, null, ipAddress, timezoneID, null, guid);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TServer.class.getName(), (String)"TServer");
        }
    }

    protected TServer(String serverName) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TServer.class.getName(), (String)"TServer", (String)"serverName");
        }
        this.serverName = serverName;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TServer.class.getName(), (String)"TServer");
        }
    }

    public boolean registerServer() {
        boolean traceResult;
        Connection dbConnection;
        int status;
        block10: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)TServer.class.getName(), (String)"registerServer", (String)"");
            }
            status = 16;
            dbConnection = Server.getConnection();
            if (dbConnection == null) {
                boolean traceResult2 = this.registrationError();
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TServer.class.getName(), (String)"registerServer", (boolean)traceResult2);
                }
                return traceResult2;
            }
            try {
                TServer repoServer = TServer.getServer(this.serverName, dbConnection);
                if (repoServer == null) {
                    status = this.addServer(dbConnection);
                    if (status == 0) {
                        this.initialRegisitration = true;
                    }
                } else {
                    this.serverID = repoServer.serverID;
                    this.serverToken = repoServer.serverToken;
                    TComputer c = repoServer.computer;
                    if (this.computer.tsName.equals(c.tsName) || this.computer.hwID.equals((Object)c.hwID)) {
                        this.computer.computerID = c.computerID;
                    }
                    this.serverRelocated = this.serverPort != repoServer.serverPort || !this.computer.tsName.equals(c.tsName);
                    status = this.updateServer(repoServer, dbConnection);
                }
            }
            catch (SQLException e) {
                if (!TraceLogger.enableTrace) break block10;
                TraceLogger.exception((String)TServer.class.getName(), (String)"registerServer", (Throwable)e);
            }
        }
        Server.returnConnection(dbConnection);
        boolean bl = traceResult = status == 0 ? true : this.registrationError();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TServer.class.getName(), (String)"registerServer", (boolean)traceResult);
        }
        return traceResult;
    }

    private boolean registrationError() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TServer.class.getName(), (String)"registrationError", (String)"");
        }
        MessageLog.logMessage((String)"SRV0056E", (Object)this.serverName);
        boolean traceResult = false;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TServer.class.getName(), (String)"registrationError", (boolean)traceResult);
        }
        return traceResult;
    }

    public static TServer getServer(String name, Connection dbConnection) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TServer.class.getName(), (String)"getServer", (String)"name, dbConnection");
        }
        TServer repoServer = null;
        int computerID = -1;
        PreparedStatement select = null;
        try {
            select = dbConnection.prepareStatement(SELECT_SQL_TEXT);
            select.setString(1, name);
            ResultSet rs = select.executeQuery();
            if (rs.next()) {
                repoServer = new TServer(name);
                repoServer.serverID = rs.getInt(1);
                repoServer.serverToken = rs.getLong(2);
                repoServer.serverPort = rs.getInt(3);
                computerID = rs.getInt(4);
            }
            select.close();
            if (repoServer == null) {
                TServer traceResult = null;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TServer.class.getName(), (String)"getServer", traceResult);
                }
                return traceResult;
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TServer.class.getName(), (String)"getServer", (Throwable)e);
            }
            SQLUtil.errorCleanup(dbConnection, select);
            SQLUtil.logSQLException("SRV0052E", e, new Object[]{name});
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TServer.class.getName(), (String)"getServer");
            }
            throw e;
        }
        repoServer.computer = TComputer.getComputer(null, null, computerID, null, dbConnection);
        if (repoServer.computer == null) {
            MessageLog.logMessage((String)"SRV0058E", (Object)new Integer(computerID));
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TServer.class.getName(), (String)"getServer");
            }
            throw new SQLException();
        }
        TServer traceResult = repoServer;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TServer.class.getName(), (String)"getServer", (Object)traceResult);
        }
        return traceResult;
    }

    public int addServer(Connection dbConnection) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TServer.class.getName(), (String)"addServer", (String)"dbConnection");
        }
        if (this.computer.addComputer(dbConnection) != 0) {
            int traceResult = 16;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TServer.class.getName(), (String)"addServer", (int)traceResult);
            }
            return traceResult;
        }
        PreparedStatement insert = null;
        try {
            this.serverID = SQLUtil.getIdentifier(1, 1, dbConnection);
            this.serverToken = SQLUtil.getTimestamp(dbConnection).getTime();
            insert = dbConnection.prepareStatement(INSERT_SQL_TEXT);
            insert.setInt(1, this.serverID);
            insert.setLong(2, this.serverToken);
            insert.setString(3, this.serverName);
            insert.setInt(4, this.serverPort);
            insert.setInt(5, this.computer.computerID);
            insert.setInt(6, this.serverType);
            insert.executeUpdate();
            dbConnection.commit();
            insert.close();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TServer.class.getName(), (String)"addServer", (Throwable)e);
            }
            SQLUtil.errorCleanup(dbConnection, insert);
            SQLUtil.logSQLException("SRV0057E", e, new Object[]{this.serverName, new Integer(this.serverID)});
            int traceResult = 16;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TServer.class.getName(), (String)"addServer", (int)traceResult);
            }
            return traceResult;
        }
        int traceResult = 0;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TServer.class.getName(), (String)"addServer", (int)traceResult);
        }
        return traceResult;
    }

    public int updateServer(TServer repoServer, Connection dbConnection) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TServer.class.getName(), (String)"updateServer", (String)"repoServer, dbConnection");
        }
        if (this.computer.computerID != repoServer.computer.computerID) {
            if (this.computer.addComputer(dbConnection) != 0) {
                int traceResult = 16;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)TServer.class.getName(), (String)"updateServer", (int)traceResult);
                }
                return traceResult;
            }
        } else if (!this.computer.equalsRepositoryComputer(repoServer.computer) && this.computer.updateComputer(repoServer.computer, dbConnection) != 0) {
            int traceResult = 16;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TServer.class.getName(), (String)"updateServer", (int)traceResult);
            }
            return traceResult;
        }
        if (this.serverPort == repoServer.serverPort && this.computer.computerID == repoServer.computer.computerID) {
            int traceResult = 0;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TServer.class.getName(), (String)"updateServer", (int)traceResult);
            }
            return traceResult;
        }
        PreparedStatement update = null;
        try {
            update = dbConnection.prepareStatement(UPDATE_SQL_TEXT);
            update.setInt(1, this.serverPort);
            update.setInt(2, this.computer.computerID);
            update.setInt(3, this.serverID);
            update.executeUpdate();
            dbConnection.commit();
            update.close();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TServer.class.getName(), (String)"updateServer", (Throwable)e);
            }
            SQLUtil.errorCleanup(dbConnection, update);
            SQLUtil.logSQLException("SRV0054E", e, new Object[]{this.serverName, new Integer(this.serverID)});
            int traceResult = 16;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TServer.class.getName(), (String)"updateServer", (int)traceResult);
            }
            return traceResult;
        }
        int traceResult = 0;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TServer.class.getName(), (String)"updateServer", (int)traceResult);
        }
        return traceResult;
    }

    public boolean getInitialRegistration() {
        return this.initialRegisitration;
    }
}

