/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.aperi.TStorm.common.CuStatDef;
import org.eclipse.aperi.TStorm.common.Filesystem;
import org.eclipse.aperi.TStorm.common.SSummaryHist;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.xmsg.MessageLog;

public class TStatSpaceHist
extends StorageRepositoryAccessor {
    PreparedStatement selectUniqueStmt;
    SSummaryHist histBuffer;
    boolean filesystemHistory;
    private static final String FETCH_UNIQUE_SPACE_HIST = "select file_count, total_size from t_stat_space_hist where statistic_time = ? and statistic_type = ? and filesystem_id = ? and statistic_id = ?";
    private static final String FETCH_SPACE_ACCUMULATORS = "select filesystem_id, statistic_time, statistic_type, accum_count, statistic_id, file_count, total_size from t_stat_space_hist where statistic_type = ? and statistic_time <> ? and accum_count > 0";
    private static final String INSERT_SPACE_HIST = "insert into t_stat_space_hist (statistic_time, file_count, accum_count, total_size, statistic_type, filesystem_id, statistic_id) values (?,?,?,?,?,?,?)";
    private static final String INCREMENT_SPACE_ACCUMULATORS = "update t_stat_space_hist set file_count = (file_count + ?), total_size = (total_size + ?), accum_count = (accum_count + 1) where statistic_type = ? and filesystem_id = ? and statistic_id = ?";
    private static final String RESET_SPACE_ACCUMULATORS = "update t_stat_space_hist set total_size = 0, file_count = 0, accum_count = 0, statistic_time = ? where statistic_type = ? and filesystem_id = ? and statistic_id = ?";
    private static final String AGE_OFF_SPACE_HIST = "delete from t_stat_space_hist where statistic_time < ? and statistic_type = ? and filesystem_id = ? and statistic_id = ?";
    private static final String DELETE_SPACE_HIST_BY_FS = "delete from t_stat_space_hist where filesystem_id = ?";
    private static final String DELETE_SPACE_HIST_BY_STAT = "delete from t_stat_space_hist where statistic_id = ?";
    private static final String FETCH_UNIQUE_FS_HIST = "select file_count, capacity, free_space from t_stat_fs_hist where statistic_time = ? and statistic_type = ? and filesystem_id = ?";
    private static final String FETCH_FS_ACCUMULATORS = "select filesystem_id, statistic_time, statistic_type, accum_count, product_id, file_count, capacity, free_space, used_space from t_stat_fs_hist where statistic_type = ? and statistic_time <> ? and accum_count > 0";
    private static final String FETCH_MAX_FS_TIMESTAMP = "select max(statistic_time) from t_stat_fs_hist where filesystem_id = ? and statistic_type = ?";
    private static final String INSERT_FS_HIST = "insert into t_stat_fs_hist (statistic_time, file_count, accum_count, capacity, free_space, used_space, statistic_type, filesystem_id, product_id) values (?,?,?,?,?,?,?,?,?)";
    private static final String INCREMENT_FS_ACCUMULATORS = "update t_stat_fs_hist set file_count = (file_count + ?), capacity = (capacity + ?), free_space = (free_space + ?), used_space = (used_space + ?), accum_count = (accum_count + 1) where statistic_type = ? and filesystem_id = ? and product_id = ?";
    private static final String RESET_FS_ACCUMULATORS = "update t_stat_fs_hist set capacity = 0, free_space = 0, used_space = 0, file_count =0, accum_count = 0, statistic_time = ? where statistic_type = ? and filesystem_id = ? and product_id = ?";
    private static final String AGE_OFF_FS_HIST = "delete from t_stat_fs_hist where statistic_time < ? and statistic_type = ? and filesystem_id = ? and product_id = ?";
    private static final String DELETE_FS_HIST_BY_FS = "delete from t_stat_fs_hist where filesystem_id = ?";

    public TStatSpaceHist(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatSpaceHist.class.getName(), (String)"TStatSpaceHist", (String)"dbc");
        }
        this.tableName = "t_stat_space_hist";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatSpaceHist.class.getName(), (String)"TStatSpaceHist");
        }
    }

    public void prepSpaceHistSave() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatSpaceHist.class.getName(), (String)"prepSpaceHistSave", (String)"");
        }
        this.tableName = "t_stat_space_hist";
        this.insertStmt = this.prepareStmt(INSERT_SPACE_HIST);
        this.updateStmt = this.prepareStmt(INCREMENT_SPACE_ACCUMULATORS);
        this.deleteStmt = this.prepareStmt(AGE_OFF_SPACE_HIST);
        this.filesystemHistory = false;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatSpaceHist.class.getName(), (String)"prepSpaceHistSave");
        }
    }

    public void prepFSHistSave() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatSpaceHist.class.getName(), (String)"prepFSHistSave", (String)"");
        }
        this.tableName = "t_stat_fs_hist";
        this.insertStmt = this.prepareStmt(INSERT_FS_HIST);
        this.updateStmt = this.prepareStmt(INCREMENT_FS_ACCUMULATORS);
        this.deleteStmt = this.prepareStmt(AGE_OFF_FS_HIST);
        this.filesystemHistory = true;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatSpaceHist.class.getName(), (String)"prepFSHistSave");
        }
    }

    public void closeHistSave() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatSpaceHist.class.getName(), (String)"closeHistSave", (String)"");
        }
        this.closeInsert();
        this.closeUpdate();
        this.closeDelete();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatSpaceHist.class.getName(), (String)"closeHistSave");
        }
    }

    public void saveHist(CuStatDef statDef, SSummaryHist hist) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatSpaceHist.class.getName(), (String)"saveHist", (String)"statDef, hist");
        }
        try {
            if (statDef.sdDailyRetention > 0) {
                hist.sumType = 0;
                this.insertHist(hist);
                this.dbc.commit();
            }
            if (statDef.sdWeeklyRetention > 0) {
                hist.sumType = (byte)3;
                this.updateHist(hist);
            }
            if (statDef.sdMonthlyRetention > 0) {
                hist.sumType = (byte)4;
                this.updateHist(hist);
            }
            this.ageHist(statDef, hist);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatSpaceHist.class.getName(), (String)"saveHist", (Throwable)e);
            }
            MessageLog.logMessage((String)"STS0025E");
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatSpaceHist.class.getName(), (String)"saveHist");
        }
    }

    public void insertHist(SSummaryHist hist) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatSpaceHist.class.getName(), (String)"insertHist", (String)"hist");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setTimestamp(this.insertStmt, hist.sumScanTime);
            this.setLong(this.insertStmt, hist.sumFileCount);
            this.setShort(this.insertStmt, hist.sumAccumCount);
            this.setLong(this.insertStmt, hist.sumTotalSize);
            if (this.filesystemHistory) {
                this.setLong(this.insertStmt, hist.sumFreeSpace);
                this.setLong(this.insertStmt, hist.sumUsedSpace);
            }
            this.setIDs(this.insertStmt, hist);
            this.executeUpdate(this.insertStmt);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatSpaceHist.class.getName(), (String)"insertHist", (Throwable)e);
            }
            this.stmtType = 1;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatSpaceHist.class.getName(), (String)"insertHist");
        }
    }

    private void updateHist(SSummaryHist hist) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatSpaceHist.class.getName(), (String)"updateHist", (String)"hist");
        }
        this.stmtType = 2;
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setLong(this.updateStmt, hist.sumFileCount);
        this.setLong(this.updateStmt, hist.sumTotalSize);
        if (this.filesystemHistory) {
            this.setLong(this.updateStmt, hist.sumFreeSpace);
            this.setLong(this.updateStmt, hist.sumUsedSpace);
        }
        this.setIDs(this.updateStmt, hist);
        int updateCount = this.executeUpdate(this.updateStmt);
        if (updateCount != 1) {
            hist.sumAccumCount = 1;
            this.insertHist(hist);
        }
        this.dbc.commit();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatSpaceHist.class.getName(), (String)"updateHist");
        }
    }

    private void setIDs(PreparedStatement pStmt, SSummaryHist hist) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatSpaceHist.class.getName(), (String)"setIDs", (String)"pStmt, hist");
        }
        this.setByte(pStmt, hist.sumType);
        this.setInt(pStmt, hist.sumFilesystemID);
        this.setInt(pStmt, hist.sumStatisticID);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatSpaceHist.class.getName(), (String)"setIDs");
        }
    }

    private void ageHist(CuStatDef statDef, SSummaryHist hist) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatSpaceHist.class.getName(), (String)"ageHist", (String)"statDef, hist");
        }
        GregorianCalendar calendar = new GregorianCalendar();
        Date scanTime = new Date(hist.sumScanTime);
        try {
            if (statDef.sdDailyRetention != 0) {
                hist.sumType = 0;
                this.ageOff(calendar, scanTime, hist, statDef.sdDailyRetention, 5);
            }
            if (statDef.sdWeeklyRetention != 0) {
                hist.sumType = 1;
                this.ageOff(calendar, scanTime, hist, statDef.sdWeeklyRetention * 7, 5);
            }
            if (statDef.sdMonthlyRetention != 0) {
                hist.sumType = (byte)2;
                this.ageOff(calendar, scanTime, hist, statDef.sdMonthlyRetention, 2);
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatSpaceHist.class.getName(), (String)"ageHist", (Throwable)e);
            }
            this.stmtType = 3;
            MessageLog.logMessage((String)"STS0027E");
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatSpaceHist.class.getName(), (String)"ageHist");
        }
    }

    private void ageOff(Calendar calendar, Date scanTime, SSummaryHist hist, int retention, int calendarUnit) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatSpaceHist.class.getName(), (String)"ageOff", (String)"calendar, scanTime, hist, retention, calendarUnit");
        }
        this.stmtPhase = 0;
        this.colIndex = 1;
        calendar.setTime(scanTime);
        calendar.add(calendarUnit, -retention);
        this.setTimestamp(this.deleteStmt, calendar.getTime().getTime());
        this.setIDs(this.deleteStmt, hist);
        this.executeUpdate(this.deleteStmt);
        this.dbc.commit();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatSpaceHist.class.getName(), (String)"ageOff");
        }
    }

    public void deleteSpaceHist(Filesystem fsList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatSpaceHist.class.getName(), (String)"deleteSpaceHist", (String)"fsList");
        }
        this.tableName = "t_stat_space_hist";
        this.deleteStats(DELETE_SPACE_HIST_BY_FS, fsList);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatSpaceHist.class.getName(), (String)"deleteSpaceHist");
        }
    }

    public void deleteFSHist(Filesystem fsList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatSpaceHist.class.getName(), (String)"deleteFSHist", (String)"fsList");
        }
        this.tableName = "t_stat_fs_hist";
        this.deleteStats(DELETE_FS_HIST_BY_FS, fsList);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatSpaceHist.class.getName(), (String)"deleteFSHist");
        }
    }

    public void deleteSpaceHist(CuStatDef statList) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatSpaceHist.class.getName(), (String)"deleteSpaceHist", (String)"statList");
        }
        this.tableName = "t_stat_space_hist";
        this.deleteStats(DELETE_SPACE_HIST_BY_STAT, statList);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatSpaceHist.class.getName(), (String)"deleteSpaceHist");
        }
    }

    public void prepSpaceAverages() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatSpaceHist.class.getName(), (String)"prepSpaceAverages", (String)"");
        }
        this.tableName = "t_stat_space_hist";
        this.selectStmt = this.prepareStmt(FETCH_SPACE_ACCUMULATORS);
        this.insertStmt = this.prepareStmt(INSERT_SPACE_HIST);
        this.updateStmt = this.prepareStmt(RESET_SPACE_ACCUMULATORS);
        this.filesystemHistory = false;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatSpaceHist.class.getName(), (String)"prepSpaceAverages");
        }
    }

    public void prepFSAverages() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatSpaceHist.class.getName(), (String)"prepFSAverages", (String)"");
        }
        this.tableName = "t_stat_fs_hist";
        this.selectStmt = this.prepareStmt(FETCH_FS_ACCUMULATORS);
        this.insertStmt = this.prepareStmt(INSERT_FS_HIST);
        this.updateStmt = this.prepareStmt(RESET_FS_ACCUMULATORS);
        this.filesystemHistory = true;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatSpaceHist.class.getName(), (String)"prepFSAverages");
        }
    }

    public void closeAverages() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatSpaceHist.class.getName(), (String)"closeAverages", (String)"");
        }
        this.closeSelect();
        this.closeInsert();
        this.closeUpdate();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatSpaceHist.class.getName(), (String)"closeAverages");
        }
    }

    public void execSelect(SSummaryHist hist) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatSpaceHist.class.getName(), (String)"execSelect", (String)"hist");
        }
        try {
            this.closeResultSet();
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setByte(this.selectStmt, hist.sumType);
            this.setTimestamp(this.selectStmt, hist.sumScanTime);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatSpaceHist.class.getName(), (String)"execSelect", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatSpaceHist.class.getName(), (String)"execSelect");
        }
    }

    public boolean fetchAccumulator(SSummaryHist hist) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatSpaceHist.class.getName(), (String)"fetchAccumulator", (String)"hist");
        }
        try {
            boolean traceResult = this.fetchRow(hist);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TStatSpaceHist.class.getName(), (String)"fetchAccumulator", (boolean)traceResult);
            }
            return traceResult;
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatSpaceHist.class.getName(), (String)"fetchAccumulator", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
            boolean traceResult = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TStatSpaceHist.class.getName(), (String)"fetchAccumulator", (boolean)traceResult);
            }
            return traceResult;
        }
    }

    private boolean fetchRow(SSummaryHist hist) throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatSpaceHist.class.getName(), (String)"fetchRow", (String)"hist");
        }
        if (!this.nextResult()) {
            boolean traceResult = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)TStatSpaceHist.class.getName(), (String)"fetchRow", (boolean)traceResult);
            }
            return traceResult;
        }
        this.stmtPhase = 1;
        this.colIndex = 1;
        hist.sumFilesystemID = this.getInt(this.resultSet);
        hist.sumScanTime = this.getTimestamp(this.resultSet);
        hist.sumType = this.getByte(this.resultSet);
        hist.sumAccumCount = this.getShort(this.resultSet);
        hist.sumStatisticID = this.getInt(this.resultSet);
        this.getSpaceUsage(this.resultSet, hist);
        boolean traceResult = true;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatSpaceHist.class.getName(), (String)"fetchRow", (boolean)traceResult);
        }
        return traceResult;
    }

    private void getSpaceUsage(ResultSet results, SSummaryHist hist) throws SQLException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatSpaceHist.class.getName(), (String)"getSpaceUsage", (String)"results, hist");
        }
        hist.sumFileCount = this.getLong(results);
        hist.sumTotalSize = this.getLong(results);
        if (this.filesystemHistory) {
            hist.sumFreeSpace = this.getLong(results);
            hist.sumUsedSpace = this.getLong(results);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatSpaceHist.class.getName(), (String)"getSpaceUsage");
        }
    }

    public boolean fetchUnique(SSummaryHist hist) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatSpaceHist.class.getName(), (String)"fetchUnique", (String)"hist");
        }
        boolean status = false;
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setTimestamp(this.selectUniqueStmt, hist.sumScanTime);
            this.setIDs(this.selectUniqueStmt, hist);
            this.stmtPhase = 3;
            ResultSet result = this.selectUniqueStmt.executeQuery();
            status = this.nextResult(result);
            if (status) {
                this.stmtPhase = 1;
                this.colIndex = 1;
                this.getSpaceUsage(result, hist);
            }
            this.closeResultSet(result);
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatSpaceHist.class.getName(), (String)"fetchUnique", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        boolean traceResult = status;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatSpaceHist.class.getName(), (String)"fetchUnique", (boolean)traceResult);
        }
        return traceResult;
    }

    public void resetAccumulator(SSummaryHist hist) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatSpaceHist.class.getName(), (String)"resetAccumulator", (String)"hist");
        }
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setTimestamp(this.updateStmt, hist.sumScanTime);
            this.setIDs(this.updateStmt, hist);
            this.executeUpdate(this.updateStmt);
            this.dbc.commit();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatSpaceHist.class.getName(), (String)"resetAccumulator", (Throwable)e);
            }
            this.stmtType = 2;
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatSpaceHist.class.getName(), (String)"resetAccumulator");
        }
    }

    public long getMaxFsHistTime(int filesystemID, byte statisticType) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatSpaceHist.class.getName(), (String)"getMaxFsHistTime", (String)"filesystemID, statisticType");
        }
        this.tableName = "t_stat_fs_hist";
        long timestamp = 0L;
        this.selectStmt = this.prepareStmt(FETCH_MAX_FS_TIMESTAMP);
        try {
            this.setPhase();
            this.setInt(this.selectStmt, filesystemID);
            this.setByte(this.selectStmt, statisticType);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            this.getPhase();
            if (this.resultSet.next()) {
                timestamp = this.getTimestamp(this.resultSet);
            }
            this.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TStatSpaceHist.class.getName(), (String)"getMaxFsHistTime", (Throwable)e);
            }
            this.stmtType = 0;
            this.sqlError(e);
        }
        long traceResult = timestamp;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatSpaceHist.class.getName(), (String)"getMaxFsHistTime", (long)traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSelect() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TStatSpaceHist.class.getName(), (String)"closeSelect", (String)"");
        }
        super.closeSelect();
        if (this.selectUniqueStmt != null) {
            try {
                this.closeStmt(this.selectUniqueStmt, STMT_TYPE[0]);
            }
            finally {
                this.selectUniqueStmt = null;
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TStatSpaceHist.class.getName(), (String)"closeSelect");
        }
    }
}

