/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.repository.table;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.RepositoryAccessor;
import org.eclipse.aperi.server.guireq.UserPreferences;

public class TUserPrefs
extends RepositoryAccessor {
    String userID;
    UserPreferences prefs;
    private static final String FETCH = "select look_and_feel, max_panel_chain, max_panels, show_login_alerts, tab_to_display, export_path, space_units from t_user_preferences where user_id = ?";
    private static final String INSERT = "insert into t_user_preferences (look_and_feel, max_panel_chain, max_panels, show_login_alerts, tab_to_display, export_path, space_units, user_id) values (?,?,?,?,?,?,?,?)";
    private static final String UPDATE = "update t_user_preferences   set look_and_feel = ?, max_panel_chain = ?, max_panels = ?, show_login_alerts = ?, tab_to_display = ?, export_path = ?, space_units = ? where user_id = ?";

    public TUserPrefs(Connection dbc) {
        super(dbc);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TUserPrefs.class.getName(), (String)"TUserPrefs", (String)"dbc");
        }
        this.tableName = "t_user_preferences";
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TUserPrefs.class.getName(), (String)"TUserPrefs");
        }
    }

    public UserPreferences getUserPref(String userID) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TUserPrefs.class.getName(), (String)"getUserPref", (String)"userID");
        }
        UserPreferences prefs = new UserPreferences();
        this.stmtType = 0;
        this.selectStmt = this.prepareStmt(FETCH);
        try {
            this.stmtPhase = 0;
            this.colIndex = 1;
            this.setString(this.selectStmt, userID);
            this.stmtPhase = 3;
            this.resultSet = this.selectStmt.executeQuery();
            if (this.nextResult()) {
                this.stmtPhase = 1;
                this.colIndex = 1;
                prefs.lookAndFeel = this.getString(this.resultSet);
                prefs.maxDDIs = this.getInt(this.resultSet);
                prefs.maxPanels = this.getInt(this.resultSet);
                prefs.showLoginAlerts = this.getByte(this.resultSet);
                prefs.tabToDisplay = this.getByte(this.resultSet);
                prefs.exportPath = this.getString(this.resultSet);
                prefs.spaceUnits = this.getByte(this.resultSet);
            }
            this.closeSelect();
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TUserPrefs.class.getName(), (String)"getUserPref", (Throwable)e);
            }
            this.sqlError(e);
        }
        UserPreferences traceResult = prefs;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TUserPrefs.class.getName(), (String)"getUserPref", (Object)traceResult);
        }
        return traceResult;
    }

    public void saveUserPref(String userID, UserPreferences prefs) throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TUserPrefs.class.getName(), (String)"saveUserPref", (String)"userID, prefs");
        }
        this.userID = userID;
        this.prefs = prefs;
        try {
            if (this.update() == 0) {
                this.insert();
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)TUserPrefs.class.getName(), (String)"saveUserPref", (Throwable)e);
            }
            this.sqlError(e);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TUserPrefs.class.getName(), (String)"saveUserPref");
        }
    }

    private int update() throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TUserPrefs.class.getName(), (String)"update", (String)"");
        }
        this.stmtType = 2;
        this.updateStmt = this.prepareStmt(UPDATE);
        this.setFields(this.updateStmt);
        int status = this.executeUpdate(this.updateStmt);
        this.dbc.commit();
        this.closeUpdate();
        int traceResult = status;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TUserPrefs.class.getName(), (String)"update", (int)traceResult);
        }
        return traceResult;
    }

    private void insert() throws SQLException, GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)TUserPrefs.class.getName(), (String)"insert", (String)"");
        }
        this.stmtType = 1;
        this.insertStmt = this.prepareStmt(INSERT);
        this.setFields(this.insertStmt);
        this.executeUpdate(this.insertStmt);
        this.dbc.commit();
        this.closeInsert();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)TUserPrefs.class.getName(), (String)"insert");
        }
    }

    private void setFields(PreparedStatement stmt) throws SQLException {
        this.stmtPhase = 0;
        this.colIndex = 1;
        this.setString(stmt, this.prefs.lookAndFeel);
        this.setInt(stmt, this.prefs.maxDDIs);
        this.setInt(stmt, this.prefs.maxPanels);
        this.setByte(stmt, this.prefs.showLoginAlerts);
        this.setByte(stmt, this.prefs.tabToDisplay);
        this.setString(stmt, this.prefs.exportPath);
        this.setByte(stmt, this.prefs.spaceUnits);
        this.setString(stmt, this.userID);
    }
}

