/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.scheduler;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.eclipse.aperi.common.TSThread;
import org.eclipse.aperi.constants.metadata.ResourceTypeManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.scheduler.InternalIntervalNode;
import org.eclipse.aperi.scheduler.SchCommon;
import org.eclipse.aperi.scheduler.SchIntervalNode;
import org.eclipse.aperi.scheduler.SchRunNode;
import org.eclipse.aperi.scheduler.SchScheduleNode;
import org.eclipse.aperi.scheduler.ScheduleInterval;
import org.eclipse.aperi.scheduler.ScheduleQueue;
import org.eclipse.aperi.scheduler.ScheduleRunning;
import org.eclipse.aperi.scheduler.ScheduleSubmitted;
import org.eclipse.aperi.server.RequestManager;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.svp.SchedulerSvp;
import org.eclipse.aperi.xmsg.MessageLog;

public class ScheduleBuild
extends TSThread {
    private static ScheduleInterval intervalRoutine;
    Connection connection;
    PreparedStatement runNumberStmt;
    PreparedStatement insertStmt;
    PreparedStatement insertJobStmt;
    PreparedStatement updateStmt;
    PreparedStatement deleteRunStmt;
    PreparedStatement deleteJobStmt;
    PreparedStatement selectJobStmt = null;
    ResultSet selectResults;
    PrintWriter logWriter;
    ScheduleRunning runningRoutine;
    ScheduleSubmitted submittedRoutine;
    SchScheduleNode scheduleHdr;
    SchScheduleNode scheduleStack;
    SchRunNode runStack;
    long addMillis;
    long maxMillis;
    long currentMillis;
    int scheduleCount;
    int runCount;
    int CIDindex;
    int TZindex;
    int currentRunNumber = 1;
    int highRunNumber = 0;
    Object[] args = new Object[]{"update", "t_schedule", "ScheduleBuild.run"};
    Object[] args2 = new Object[]{"update", "t_runs", "ScheduleBuild.deleteSchedule"};
    Object[] args3 = new Object[]{"update", "t_runs", "ScheduleBuild.addRestart"};
    Object[] args4 = new Object[4];
    Object[] args5 = new Object[]{"select", "t_run_jobs", "ScheduleBuild.initRestart"};
    Object[] args6 = new Object[]{"select", "t_run_jobs", "ScheduleBuild.finishScheduleNode"};

    public ScheduleBuild(ThreadGroup group, String name) {
        super(group, name);
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleBuild.class.getName(), (String)"ScheduleBuild", (String)"group, name");
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleBuild.class.getName(), (String)"ScheduleBuild");
        }
    }

    public void run() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleBuild.class.getName(), (String)"run", (String)"");
        }
        this.logWriter = MessageLog.getThreadLog();
        MessageLog.setThreadLog((PrintWriter)this.logWriter);
        Server.getServiceManager().awaitInitialization();
        this.connection = Server.getConnection();
        if (this.connection == null) {
            MessageLog.logMessage((String)"JSS0006E", (Object[])this.args);
            SchCommon.stopped = true;
        } else {
            intervalRoutine = new ScheduleInterval();
            intervalRoutine.init(this);
            if (!SchCommon.stopped) {
                this.runningRoutine = SchCommon.runningRoutine;
                this.submittedRoutine = SchCommon.submittedRoutine;
                this.addMillis = SchCommon.millisAdvanced + 50L;
                this.initRestart();
                try {
                    this.runNumberStmt = this.connection.prepareStatement("update t_schedule set    high_run_number = ? where  schedule_id = ?");
                    this.args[1] = "t_runs";
                    this.updateStmt = this.connection.prepareStatement("update t_runs set    successful_jobs = ?, finish_time = ?, status = ? where  schedule_id = ? and run_number = ?");
                    this.args[0] = "insert";
                    this.insertStmt = this.connection.prepareStatement("insert into   t_runs (time_stamp, schedule_id, run_number, number_jobs) values (?,?,?,?)");
                    this.args[1] = "t_run_jobs";
                    this.insertJobStmt = this.connection.prepareStatement("insert into t_run_jobs (time_stamp, schedule_id, sid_run_number, computer_id, job_run_number, submit_status, submit_millis) values (?,?,?,?,?,-2,?)");
                    this.args[0] = "delete";
                    this.args[1] = "t_runs";
                    this.deleteRunStmt = this.connection.prepareStatement("delete from   t_runs where  schedule_id = ? and run_number < ?");
                    this.args[1] = "t_run_jobs";
                    this.deleteJobStmt = this.connection.prepareStatement("delete from   t_run_jobs where  schedule_id = ? and sid_run_number < ?");
                }
                catch (SQLException e1) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)ScheduleBuild.class.getName(), (String)"run", (Throwable)e1);
                    }
                    String msg = SQLUtil.getSQLExceptionMsg("JSS0007E", e1, this.args);
                    this.logWriter.println(msg);
                    SchCommon.stopped = true;
                }
                this.args[1] = "t_schedule";
                this.args[2] = "ScheduleBuild.insertRows";
                SchedulerSvp.requestManagerRoutine = new RequestManager("org.eclipse.aperi.server.data.schedulerHandler", SchedulerSvp.serviceQueue, SchedulerSvp.threadGroup, "SchedulerJobCompletion", 5, SchCommon.completeThreads / 2, SchCommon.completeThreads, 15);
                if (!SchedulerSvp.requestManagerRoutine.initialize()) {
                    SchCommon.stopped = true;
                }
                SchCommon.autoRestart = false;
                if (SchCommon.stopped && !SchCommon.shutDown) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)ScheduleBuild.class.getName(), (String)"run");
                    }
                    throw new RuntimeException(MessageLog.getMessage((String)"JSS0002E", null));
                }
                while (!SchCommon.stopped) {
                    try {
                        this.maxMillis = SQLUtil.getTimestamp(this.connection).getTime() + this.addMillis;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)ScheduleBuild.class.getName(), (String)"run", (Throwable)e);
                        }
                        return;
                    }
                    SchScheduleNode schedulePtr = intervalRoutine.getNext(this.maxMillis);
                    while (schedulePtr == null && !SchCommon.stopped) {
                        block26: {
                            try {
                                ScheduleBuild.sleep((long)1000L);
                            }
                            catch (InterruptedException e) {
                                if (!TraceLogger.enableTrace) break block26;
                                TraceLogger.exception((String)ScheduleBuild.class.getName(), (String)"run", (Throwable)e);
                            }
                        }
                        try {
                            this.maxMillis = SQLUtil.getTimestamp(this.connection).getTime() + this.addMillis;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            if (TraceLogger.enableTrace) {
                                TraceLogger.exception((String)ScheduleBuild.class.getName(), (String)"run", (Throwable)e);
                            }
                            return;
                        }
                        schedulePtr = intervalRoutine.getNext(this.maxMillis);
                    }
                    if (SchCommon.stopped) continue;
                    boolean ok = ScheduleQueue.isInternal(schedulePtr.SID) ? true : this.insertRows(schedulePtr);
                    if (ok) {
                        this.submit(schedulePtr);
                        continue;
                    }
                    this.args4[0] = Integer.toString(schedulePtr.runNumber);
                    this.args4[1] = ResourceTypeManager.getJobName((short)schedulePtr.jobType);
                    this.args4[2] = schedulePtr.creator + "." + schedulePtr.getName();
                    MessageLog.logMessage((String)"JSS0014E", (Object[])this.args4);
                }
            }
        }
        if (SchCommon.bounceNeeded) {
            SchedulerSvp.bounce();
        } else {
            if (!SchCommon.shutDown) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)ScheduleBuild.class.getName(), (String)"run");
                }
                throw new RuntimeException(MessageLog.getMessageNoTS((String)"JSS0078E"));
            }
            this.close();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleBuild.class.getName(), (String)"run");
        }
    }

    public synchronized SchScheduleNode addSchedule(SchIntervalNode interval) {
        SchScheduleNode schedulePtr;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleBuild.class.getName(), (String)"addSchedule", (String)"interval");
        }
        ++interval.highRunNumber;
        if (this.scheduleStack == null) {
            schedulePtr = new SchScheduleNode();
        } else {
            schedulePtr = this.scheduleStack;
            this.scheduleStack = this.scheduleStack.next;
            --this.scheduleCount;
        }
        if (this.scheduleHdr != null) {
            this.scheduleHdr.prev = schedulePtr;
        }
        schedulePtr.next = this.scheduleHdr;
        this.scheduleHdr = schedulePtr;
        schedulePtr.pingList = interval.pingList;
        schedulePtr.SID = interval.SID;
        schedulePtr.creator = interval.creator;
        schedulePtr.setName(interval.getTrueName());
        schedulePtr.jobType = interval.jobType;
        schedulePtr.arguments = interval.arguments;
        schedulePtr.alertID = interval.alertID;
        schedulePtr.scriptName = interval.scriptName;
        schedulePtr.runNumber = interval.highRunNumber;
        schedulePtr.jobData = interval.jobData;
        schedulePtr.alertLogID = interval.alertLogID;
        if (interval instanceof InternalIntervalNode) {
            InternalIntervalNode castInterval = (InternalIntervalNode)interval;
            schedulePtr.request = castInterval.request;
        }
        this.CIDindex = 0;
        while (this.CIDindex < interval.CIDarray.length) {
            SchRunNode runPtr;
            if (this.runStack == null) {
                runPtr = new SchRunNode();
            } else {
                runPtr = this.runStack;
                this.runStack = this.runStack.next;
                --this.runCount;
            }
            runPtr.next = schedulePtr.runHdr;
            schedulePtr.runHdr = runPtr;
            runPtr.back = schedulePtr;
            runPtr.CID = interval.CIDarray[this.CIDindex];
            runPtr.globalJob = interval.timezoneType == 2;
            if (interval.runNow) {
                runPtr.submitMillis = 0L;
            } else if (interval.TZarray == null) {
                runPtr.submitMillis = interval.submitMillis;
            } else {
                this.TZindex = interval.CIDTZarray[this.CIDindex];
                runPtr.submitMillis = interval.submitMillisArray[this.TZindex];
            }
            ++schedulePtr.numberRuns;
            ++this.CIDindex;
        }
        SchScheduleNode traceResult = schedulePtr;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleBuild.class.getName(), (String)"addSchedule", (Object)traceResult);
        }
        return traceResult;
    }

    public void initRestart() {
        Statement statement = null;
        ResultSet results = null;
        try {
            statement = this.connection.createStatement();
        }
        catch (SQLException e2) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ScheduleBuild.class.getName(), (String)"initRestart", (Throwable)e2);
            }
            if (SchedulerSvp.connectBad(this.connection)) {
                SchCommon.stopped = true;
                SchCommon.bounceNeeded = true;
            }
            String msg = SQLUtil.getSQLExceptionMsg("JSS0019E", e2, this.args5);
            this.logWriter.println(msg);
            return;
        }
        try {
            String stmt = "select computer_id, job_run_number, submit_millis,       schedule_id, sid_run_number from  t_run_jobs where submit_status  = -2 order by schedule_id, sid_run_number";
            int prevScheduleID = -777;
            int prevRunNumber = -777;
            SchScheduleNode schedulePtr = new SchScheduleNode();
            results = statement.executeQuery(stmt);
            while (results.next()) {
                SchRunNode runPtr = new SchRunNode();
                runPtr.CID = results.getInt(1);
                runPtr.runNumber = results.getInt(2);
                runPtr.submitMillis = results.getLong(3);
                runPtr.rowInserted = true;
                runPtr.logFileName = " ";
                int scheduleID = results.getInt(4);
                int runNumber = results.getInt(5);
                if (scheduleID != prevScheduleID || runNumber != prevRunNumber) {
                    prevScheduleID = scheduleID;
                    prevRunNumber = runNumber;
                    this.finishScheduleNode(schedulePtr);
                    schedulePtr = this.getScheduleNode(scheduleID, runNumber);
                }
                if (schedulePtr == null) continue;
                runPtr.next = schedulePtr.runHdr;
                schedulePtr.runHdr = runPtr;
                runPtr.back = schedulePtr;
            }
            this.finishScheduleNode(schedulePtr);
            schedulePtr = this.scheduleHdr;
            while (schedulePtr != null) {
                this.submit(schedulePtr);
                schedulePtr = schedulePtr.next;
            }
        }
        catch (SQLException e6) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ScheduleBuild.class.getName(), (String)"initRestart", (Throwable)e6);
            }
            if (SchedulerSvp.connectBad(this.connection)) {
                SchCommon.stopped = true;
                SchCommon.bounceNeeded = true;
            }
            String msg = SQLUtil.getSQLExceptionMsg("JSS0010E", e6, this.args5);
            this.logWriter.println(msg);
            return;
        }
        try {
            if (results != null) {
                results.close();
            }
        }
        catch (SQLException ignored) {
            // empty catch block
        }
        try {
            if (statement != null) {
                statement.close();
            }
        }
        catch (SQLException ignored) {
            // empty catch block
        }
        try {
            if (this.selectResults != null) {
                this.selectResults.close();
            }
        }
        catch (SQLException ignored) {
            // empty catch block
        }
        try {
            if (this.selectJobStmt != null) {
                this.selectJobStmt.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleBuild.class.getName(), (String)"initRestart");
        }
    }

    private void finishScheduleNode(SchScheduleNode schedulePtr) {
        if (schedulePtr != null) {
            try {
                this.selectJobStmt = this.connection.prepareStatement("select return_code from  t_run_jobs where schedule_id = ? and   sid_run_number = ? and   submit_status <> -2");
            }
            catch (SQLException e17) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)ScheduleBuild.class.getName(), (String)"finishScheduleNode", (Throwable)e17);
                }
                if (SchedulerSvp.connectBad(this.connection)) {
                    SchCommon.stopped = true;
                    SchCommon.bounceNeeded = true;
                }
                String msg = SQLUtil.getSQLExceptionMsg("JSS0007E", e17, this.args6);
                this.logWriter.println(msg);
                return;
            }
            try {
                this.selectJobStmt.setInt(1, schedulePtr.SID);
                this.selectJobStmt.setInt(2, schedulePtr.runNumber);
                this.selectResults = this.selectJobStmt.executeQuery();
                while (this.selectResults.next()) {
                    int returnCode = this.selectResults.getInt(1);
                    if (returnCode <= 4) {
                        ++schedulePtr.successfulRuns;
                        if (returnCode != 0) {
                            schedulePtr.anyWarnings = true;
                        }
                    }
                    ++schedulePtr.completedRuns;
                }
            }
            catch (SQLException e18) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)ScheduleBuild.class.getName(), (String)"finishScheduleNode", (Throwable)e18);
                }
                if (SchedulerSvp.connectBad(this.connection)) {
                    SchCommon.stopped = true;
                    SchCommon.bounceNeeded = true;
                }
                String msg = SQLUtil.getSQLExceptionMsg("JSS0010E", e18, this.args6);
                this.logWriter.println(msg);
                return;
            }
            int count = 0;
            SchRunNode runPtr = schedulePtr.runHdr;
            while (runPtr != null) {
                ++count;
                runPtr = runPtr.next;
            }
            schedulePtr.numberRuns = schedulePtr.completedRuns + count;
        }
    }

    public static SchIntervalNode getSchInterval(int scheduleID) {
        return intervalRoutine.getIntervalNode(scheduleID);
    }

    private SchScheduleNode getScheduleNode(int scheduleID, int runNumber) {
        SchScheduleNode schedulePtr;
        SchIntervalNode intervalPtr = intervalRoutine.getIntervalNode(scheduleID);
        if (intervalPtr == null) {
            schedulePtr = null;
            MessageLog.logMessage((String)"JSS0020E", (Object)Integer.toString(scheduleID));
        } else {
            schedulePtr = new SchScheduleNode();
            if (this.scheduleHdr != null) {
                this.scheduleHdr.prev = schedulePtr;
            }
            schedulePtr.next = this.scheduleHdr;
            this.scheduleHdr = schedulePtr;
            schedulePtr.pingList = intervalPtr.pingList;
            schedulePtr.SID = intervalPtr.SID;
            schedulePtr.creator = intervalPtr.creator;
            schedulePtr.setName(intervalPtr.getTrueName());
            schedulePtr.arguments = intervalPtr.arguments;
            schedulePtr.jobData = intervalPtr.jobData;
            schedulePtr.jobType = intervalPtr.jobType;
            schedulePtr.alertID = intervalPtr.alertID;
            schedulePtr.alertLogID = intervalPtr.alertLogID;
            schedulePtr.scriptName = intervalPtr.scriptName;
            schedulePtr.runNumber = runNumber;
            if (intervalPtr instanceof InternalIntervalNode) {
                InternalIntervalNode castInterval = (InternalIntervalNode)intervalPtr;
                schedulePtr.request = castInterval.request;
            }
        }
        return schedulePtr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRestart(int runNumber) {
        SchScheduleNode schedulePtr;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleBuild.class.getName(), (String)"addRestart", (String)"runNumber");
        }
        ResultSet results = null;
        Statement statement = null;
        boolean ok = true;
        ScheduleBuild scheduleBuild = this;
        synchronized (scheduleBuild) {
            block39: {
                block38: {
                    String stmt;
                    String msg;
                    SchRunNode runPtr = this.runningRoutine.getRun(runNumber);
                    if (runPtr != null) {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exit((String)ScheduleBuild.class.getName(), (String)"addRestart");
                        }
                        return;
                    }
                    if (this.scheduleStack == null) {
                        schedulePtr = new SchScheduleNode();
                    } else {
                        schedulePtr = this.scheduleStack;
                        this.scheduleStack = this.scheduleStack.next;
                        --this.scheduleCount;
                    }
                    if (this.scheduleHdr != null) {
                        this.scheduleHdr.prev = schedulePtr;
                    }
                    schedulePtr.next = this.scheduleHdr;
                    this.scheduleHdr = schedulePtr;
                    try {
                        statement = this.connection.createStatement();
                    }
                    catch (SQLException e2) {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)ScheduleBuild.class.getName(), (String)"addRestart", (Throwable)e2);
                        }
                        if (SchedulerSvp.connectBad(this.connection)) {
                            SchCommon.stopped = true;
                            SchCommon.bounceNeeded = true;
                        }
                        msg = SQLUtil.getSQLExceptionMsg("JSS0019E", e2, this.args3);
                        this.logWriter.println(msg);
                        ok = false;
                    }
                    if (ok) {
                        this.args3[1] = "t_run_jobs";
                        try {
                            stmt = "select a.schedule_id, a.sid_run_number, a.computer_id,                                     a.job_run_number, a.submit_status, a.return_code                             from   t_run_jobs a, t_run_jobs b                                                   where (b.job_run_number = " + Integer.toString(runNumber) + ") and                        (a.schedule_id    = b.schedule_id) and                                              (a.sid_run_number = b.sid_run_number)";
                            results = statement.executeQuery(stmt);
                            while (results.next()) {
                                schedulePtr.SID = results.getInt(1);
                                schedulePtr.runNumber = results.getInt(2);
                                if (this.runStack == null) {
                                    runPtr = new SchRunNode();
                                } else {
                                    runPtr = this.runStack;
                                    this.runStack = this.runStack.next;
                                    --this.runCount;
                                }
                                runPtr.next = schedulePtr.runHdr;
                                schedulePtr.runHdr = runPtr;
                                runPtr.back = schedulePtr;
                                runPtr.CID = results.getInt(3);
                                runPtr.runNumber = results.getInt(4);
                                int submitStatus = results.getInt(5);
                                runPtr.returnCode = results.getInt(6);
                                runPtr.rowInserted = true;
                                ++schedulePtr.numberRuns;
                                if (submitStatus == -1) {
                                    SchCommon.runningRoutine.addRun(runPtr);
                                    continue;
                                }
                                ++schedulePtr.completedRuns;
                                if (runPtr.returnCode > 4) continue;
                                ++schedulePtr.successfulRuns;
                            }
                        }
                        catch (SQLException e4) {
                            if (TraceLogger.enableTrace) {
                                TraceLogger.exception((String)ScheduleBuild.class.getName(), (String)"addRestart", (Throwable)e4);
                            }
                            if (SchedulerSvp.connectBad(this.connection)) {
                                SchCommon.stopped = true;
                                SchCommon.bounceNeeded = true;
                            }
                            msg = SQLUtil.getSQLExceptionMsg("JSS0010E", e4, this.args3);
                            this.logWriter.println(msg);
                            ok = false;
                        }
                    }
                    if (ok) {
                        this.args3[1] = "t_runs";
                        try {
                            int numberRuns;
                            stmt = "select number_jobs                                                                  from   t_runs                                                                       where  schedule_id = " + Integer.toString(schedulePtr.SID);
                            results = statement.executeQuery(stmt);
                            if (results.next() && (numberRuns = results.getInt(1)) != schedulePtr.numberRuns) {
                                schedulePtr.completedRuns += numberRuns - schedulePtr.numberRuns;
                                schedulePtr.numberRuns = numberRuns;
                            }
                        }
                        catch (SQLException e6) {
                            if (TraceLogger.enableTrace) {
                                TraceLogger.exception((String)ScheduleBuild.class.getName(), (String)"addRestart", (Throwable)e6);
                            }
                            if (SchedulerSvp.connectBad(this.connection)) {
                                SchCommon.stopped = true;
                                SchCommon.bounceNeeded = true;
                            }
                            msg = SQLUtil.getSQLExceptionMsg("JSS0010E", e6, this.args3);
                            this.logWriter.println(msg);
                        }
                    }
                    try {
                        if (results != null) {
                            results.close();
                        }
                    }
                    catch (SQLException ignored) {
                        if (!TraceLogger.enableTrace) break block38;
                        TraceLogger.exception((String)ScheduleBuild.class.getName(), (String)"addRestart", (Throwable)ignored);
                    }
                }
                try {
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException ignored) {
                    if (!TraceLogger.enableTrace) break block39;
                    TraceLogger.exception((String)ScheduleBuild.class.getName(), (String)"addRestart", (Throwable)ignored);
                }
            }
        }
        if (ok) {
            SchIntervalNode interval = SchCommon.intervalRoutine.getIntervalNode(schedulePtr.SID);
            if (interval == null) {
                MessageLog.logMessage((String)"JSS0020E", (Object)Integer.toString(schedulePtr.SID));
            } else {
                schedulePtr.creator = interval.creator;
                schedulePtr.setName(interval.getTrueName());
                schedulePtr.jobType = interval.jobType;
                schedulePtr.alertID = interval.alertID;
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleBuild.class.getName(), (String)"addRestart");
        }
    }

    private boolean insertRows(SchScheduleNode schedulePtr) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleBuild.class.getName(), (String)"insertRows", (String)"schedulePtr");
        }
        boolean worked = true;
        this.args[1] = "t_schedule";
        try {
            this.runNumberStmt.setInt(1, schedulePtr.runNumber);
            this.runNumberStmt.setInt(2, schedulePtr.SID);
            this.runNumberStmt.executeUpdate();
            this.connection.commit();
        }
        catch (SQLException e7) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ScheduleBuild.class.getName(), (String)"insertRows", (Throwable)e7);
            }
            if (SchedulerSvp.connectBad(this.connection)) {
                SchCommon.stopped = true;
                SchCommon.bounceNeeded = true;
            }
            String msg = SQLUtil.getSQLExceptionMsg("JSS0009E", e7, this.args);
            this.logWriter.println(msg);
            worked = false;
        }
        if (worked) {
            String msg;
            this.args[1] = "t_runs";
            SchRunNode runPtr = schedulePtr.runHdr;
            while (runPtr != null) {
                if (this.currentRunNumber > this.highRunNumber) {
                    try {
                        this.currentRunNumber = SQLUtil.getIdentifier(2, SchCommon.IDsToGet, this.connection);
                    }
                    catch (SQLException ignored) {
                        if (SchedulerSvp.connectBad(this.connection)) {
                            SchCommon.bounceNeeded = true;
                        }
                        MessageLog.logMessage((String)"JSS0023E", (Object)"ScheduleBuild.insertRows");
                        SchCommon.stopped = true;
                        this.currentRunNumber = -2;
                    }
                    this.highRunNumber = this.currentRunNumber + SchCommon.IDsToGet - 1;
                }
                ++this.currentRunNumber;
                runPtr.runNumber = runPtr.runNumber;
                try {
                    this.insertJobStmt.setLong(1, SQLUtil.getTimestamp(this.connection).getTime());
                    this.insertJobStmt.setInt(2, schedulePtr.SID);
                    this.insertJobStmt.setInt(3, schedulePtr.runNumber);
                    this.insertJobStmt.setInt(4, runPtr.CID);
                    this.insertJobStmt.setInt(5, runPtr.runNumber);
                    this.insertJobStmt.setLong(6, runPtr.submitMillis);
                    this.insertJobStmt.executeUpdate();
                    runPtr.rowInserted = true;
                }
                catch (SQLException e7a) {
                    if (SchedulerSvp.connectBad(this.connection)) {
                        SchCommon.stopped = true;
                        SchCommon.bounceNeeded = true;
                    }
                    msg = SQLUtil.getSQLExceptionMsg("JSS0008E", e7a, this.args);
                    this.logWriter.println(msg);
                    worked = false;
                }
                runPtr = runPtr.next;
            }
            if (worked) {
                this.args[1] = "t_runs";
                try {
                    this.currentMillis = SQLUtil.getTimestamp(this.connection).getTime();
                    this.insertStmt.setLong(1, this.currentMillis);
                    this.insertStmt.setInt(2, schedulePtr.SID);
                    this.insertStmt.setInt(3, schedulePtr.runNumber);
                    this.insertStmt.setInt(4, schedulePtr.numberRuns);
                    this.insertStmt.executeUpdate();
                    this.connection.commit();
                }
                catch (SQLException e8) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)ScheduleBuild.class.getName(), (String)"insertRows", (Throwable)e8);
                    }
                    if (SchedulerSvp.connectBad(this.connection)) {
                        SchCommon.stopped = true;
                        SchCommon.bounceNeeded = true;
                    }
                    msg = SQLUtil.getSQLExceptionMsg("JSS0008E", e8, this.args);
                    this.logWriter.println(msg);
                    worked = false;
                }
            }
        }
        boolean traceResult = worked;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleBuild.class.getName(), (String)"insertRows", (boolean)traceResult);
        }
        return traceResult;
    }

    private void submit(SchScheduleNode schedulePtr) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleBuild.class.getName(), (String)"submit", (String)"schedulePtr");
        }
        SchRunNode lastPtr = null;
        SchRunNode runPtr = schedulePtr.runHdr;
        while (runPtr != null) {
            runPtr.submitNext = runPtr.next;
            runPtr.submitPrev = lastPtr;
            lastPtr = runPtr;
            runPtr = runPtr.next;
        }
        this.submittedRoutine.addRunNodes(schedulePtr.runHdr);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleBuild.class.getName(), (String)"submit");
        }
    }

    public synchronized void deleteSchedule(SchScheduleNode schedulePtr) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleBuild.class.getName(), (String)"deleteSchedule", (String)"schedulePtr");
        }
        if (!ScheduleQueue.isInternal(schedulePtr.SID)) {
            try {
                this.updateStmt.setInt(1, schedulePtr.successfulRuns);
                this.updateStmt.setLong(2, SQLUtil.getTimestamp(this.connection).getTime());
                SQLUtil.setByte(this.updateStmt, 3, (byte)schedulePtr.state);
                this.updateStmt.setInt(4, schedulePtr.SID);
                this.updateStmt.setInt(5, schedulePtr.runNumber);
                this.updateStmt.executeUpdate();
                this.connection.commit();
            }
            catch (SQLException e9) {
                String msgID;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)ScheduleBuild.class.getName(), (String)"deleteSchedule", (Throwable)e9);
                }
                if (SchedulerSvp.connectBad(this.connection)) {
                    SchCommon.stopped = true;
                    SchCommon.bounceNeeded = true;
                }
                String msg = SQLUtil.getSQLExceptionMsg("JSS0009E", e9, this.args2);
                this.logWriter.println(msg);
                this.args4[0] = Integer.toString(schedulePtr.runNumber);
                this.args4[1] = ResourceTypeManager.getJobName((short)schedulePtr.jobType);
                this.args4[2] = schedulePtr.creator + "." + schedulePtr.getName();
                switch (schedulePtr.state) {
                    case 1: {
                        msgID = "JSS0016L";
                        break;
                    }
                    case 3: {
                        msgID = "JSS2000L";
                        break;
                    }
                    default: {
                        msgID = "JSS0017L";
                    }
                }
                this.args4[3] = MessageLog.getMessageNoID((String)msgID, null);
                MessageLog.logMessage((String)"JSS0015E", (Object[])this.args4);
            }
            int retention = Server.getSettings().csRetainCopies;
            int firstRunNumber = schedulePtr.runNumber - retention + 1;
            try {
                this.deleteRunStmt.setInt(1, schedulePtr.SID);
                this.deleteRunStmt.setInt(2, firstRunNumber);
                this.deleteRunStmt.executeUpdate();
                this.connection.commit();
                this.deleteJobStmt.setInt(1, schedulePtr.SID);
                this.deleteJobStmt.setInt(2, firstRunNumber);
                this.deleteJobStmt.executeUpdate();
                this.connection.commit();
            }
            catch (SQLException e10) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)ScheduleBuild.class.getName(), (String)"deleteSchedule", (Throwable)e10);
                }
                if (SchedulerSvp.connectBad(this.connection)) {
                    SchCommon.stopped = true;
                    SchCommon.bounceNeeded = true;
                }
                this.args4[1] = ResourceTypeManager.getJobName((short)schedulePtr.jobType);
                this.args4[2] = schedulePtr.creator + "." + schedulePtr.getName();
                String msg = SQLUtil.getSQLExceptionMsg("JSS0027E", e10, this.args4);
                this.logWriter.println(msg);
            }
        }
        SchRunNode runPtr = schedulePtr.runHdr;
        while (runPtr != null) {
            SchRunNode nextRun = runPtr.next;
            runPtr.clear();
            if (this.runCount < 300) {
                runPtr.next = this.runStack;
                this.runStack = runPtr;
                ++this.runCount;
            }
            runPtr = nextRun;
        }
        SchScheduleNode prevSchedulePtr = schedulePtr.prev;
        SchScheduleNode nextSchedulePtr = schedulePtr.next;
        if (prevSchedulePtr == null) {
            this.scheduleHdr = nextSchedulePtr;
        } else {
            prevSchedulePtr.next = nextSchedulePtr;
        }
        if (nextSchedulePtr != null) {
            nextSchedulePtr.prev = prevSchedulePtr;
        }
        schedulePtr.clear();
        if (this.scheduleCount < 30) {
            schedulePtr.next = this.scheduleStack;
            this.scheduleStack = schedulePtr;
            ++this.scheduleCount;
        }
        schedulePtr = null;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleBuild.class.getName(), (String)"deleteSchedule");
        }
    }

    public synchronized void displaySchedules() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleBuild.class.getName(), (String)"displaySchedules", (String)"");
        }
        SchScheduleNode schedulePtr = this.scheduleHdr;
        while (schedulePtr != null) {
            String msg = "schedule " + schedulePtr.getName();
            MessageLog.logMessage((String)"JSS0018E", (Object)msg);
            schedulePtr = schedulePtr.next;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleBuild.class.getName(), (String)"displaySchedules");
        }
    }

    private void close() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleBuild.class.getName(), (String)"close", (String)"");
        }
        if (this.runNumberStmt != null) {
            block15: {
                try {
                    this.runNumberStmt.close();
                }
                catch (SQLException ignored) {
                    if (!TraceLogger.enableTrace) break block15;
                    TraceLogger.exception((String)ScheduleBuild.class.getName(), (String)"close", (Throwable)ignored);
                }
            }
            this.runNumberStmt = null;
        }
        if (this.insertStmt != null) {
            block16: {
                try {
                    this.insertStmt.close();
                }
                catch (SQLException ignored) {
                    if (!TraceLogger.enableTrace) break block16;
                    TraceLogger.exception((String)ScheduleBuild.class.getName(), (String)"close", (Throwable)ignored);
                }
            }
            this.insertStmt = null;
        }
        if (this.insertJobStmt != null) {
            block17: {
                try {
                    this.insertJobStmt.close();
                }
                catch (SQLException ignored) {
                    if (!TraceLogger.enableTrace) break block17;
                    TraceLogger.exception((String)ScheduleBuild.class.getName(), (String)"close", (Throwable)ignored);
                }
            }
            this.insertJobStmt = null;
        }
        if (this.updateStmt != null) {
            block18: {
                try {
                    this.updateStmt.close();
                }
                catch (SQLException ignored) {
                    if (!TraceLogger.enableTrace) break block18;
                    TraceLogger.exception((String)ScheduleBuild.class.getName(), (String)"close", (Throwable)ignored);
                }
            }
            this.updateStmt = null;
        }
        if (this.connection != null) {
            Server.returnConnection(this.connection);
            this.connection = null;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleBuild.class.getName(), (String)"close");
        }
    }

    public void finalize() throws Throwable {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleBuild.class.getName(), (String)"finalize", (String)"");
        }
        this.close();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleBuild.class.getName(), (String)"finalize");
        }
    }
}

