/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.scheduler;

import java.io.PrintWriter;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.LinkedInteger;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.constants.metadata.ResourceTypeManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.ScheduleQueryable;
import org.eclipse.aperi.repository.table.TScript;
import org.eclipse.aperi.repository.table.TStatComputer;
import org.eclipse.aperi.scheduler.SchChangeNode;
import org.eclipse.aperi.scheduler.SchCommon;
import org.eclipse.aperi.scheduler.SchIntervalNode;
import org.eclipse.aperi.scheduler.SchScheduleNode;
import org.eclipse.aperi.scheduler.ScheduleBuild;
import org.eclipse.aperi.scheduler.ScheduleQueue;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.handler.agent.ProbeDefHndlr;
import org.eclipse.aperi.server.svp.SchedulerSvp;
import org.eclipse.aperi.xmsg.MessageLog;

public class ScheduleInterval {
    Calendar calendar;
    Connection connection;
    Date date;
    PrintWriter logWriter;
    TimeZone timezone;
    TimeZone[] timezoneArray;
    String[] zoneNameArray;
    int[] intArray;
    AgentManager agentRoutine;
    TStatComputer tStatRoutine;
    TScript tScriptRoutine;
    ScheduleBuild buildRoutine;
    ScheduleQueue queueRoutine;
    static SchIntervalNode runNumberHdr;
    SchIntervalNode allHead;
    SchIntervalNode allTail;
    SchIntervalNode buildHdr;
    SchIntervalNode runHdr;
    SchIntervalNode disabledHdr;
    SchIntervalNode[] headArray;
    SchIntervalNode[] midArray;
    SchScheduleNode schedule;
    long startupMillis;
    int numberSchedules;
    int numberLists;
    int buildIndex;
    int timezoneIndex;
    int serverYear;
    int serverMonth;
    int serverDay;
    boolean ok;
    Object[] args = new Object[]{"query", "t_schedule", "ScheduleInterval.init"};
    static final short[] monthDays;
    static final short[] DAYS_ARRAY;
    static final int ERA = 0;
    static final int YEAR = 1;
    static final int MONTH = 2;
    static final int DATE = 5;
    static final int HOUR_OF_DAY = 11;
    static final long DMILLIS = 86400000L;
    static final long HMILLIS = 3600000L;
    static final long MMILLIS = 60000L;
    static final long HIGHLONG = 0x7FFFFFFFFFFFL;

    public void init(ScheduleBuild buildTask) {
        String msg;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleInterval.class.getName(), (String)"init", (String)"buildTask");
        }
        ResultSet results = null;
        Statement statement = null;
        SchCommon.intervalRoutine = this;
        this.logWriter = MessageLog.getThreadLog();
        this.connection = Server.getConnection();
        if (this.connection == null) {
            MessageLog.logMessage((String)"JSS0006E", (Object[])this.args);
            SchCommon.stopped = true;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ScheduleInterval.class.getName(), (String)"init");
            }
            return;
        }
        this.startupMillis = SchCommon.startMillis;
        this.agentRoutine = Server.getAgentManager();
        this.buildRoutine = buildTask;
        this.queueRoutine = ScheduleQueue.routine;
        this.tStatRoutine = new TStatComputer(this.connection);
        this.tScriptRoutine = new TScript(this.connection);
        this.intArray = new int[8000];
        this.zoneNameArray = new String[256];
        this.timezoneArray = new TimeZone[256];
        this.calendar = Calendar.getInstance();
        this.date = new Date(this.startupMillis - 86400000L);
        this.calendar.setTime(this.date);
        this.serverYear = this.calendar.get(1) - 2000;
        this.serverMonth = this.calendar.get(2);
        this.serverDay = this.calendar.get(5) - 1;
        this.serverMonth = this.serverYear * 12 + this.serverMonth;
        this.serverDay = this.serverMonth / 48 * 1461 + monthDays[ScheduleInterval.mod(this.serverMonth, 48)] + this.serverDay;
        this.timezoneArray[0] = TimeZone.getDefault();
        this.timezoneIndex = 1;
        int offset = this.timezoneArray[0].getRawOffset();
        this.zoneNameArray[0] = offset == -18000000 ? "EST" : (offset == -21600000 ? "CST" : (offset == -25200000 ? "MST" : (offset == -28800000 ? "PST" : (offset == 0 ? "GMT" : "unknown"))));
        if (!SchCommon.autoRestart) {
            this.queueRoutine.clear();
        }
        try {
            statement = this.connection.createStatement();
            results = statement.executeQuery("select job_type_id      ,        schedule_id      ,        creator          ,        name             ,        enabled          ,        schedule_type    ,        start_year       ,        start_month      ,        start_day        ,        start_hour       ,        start_minute     ,        repeat_type      ,        interval_type    ,        interval_number  ,        run_sunday       ,        run_monday       ,        run_tuesday      ,        run_wednesday    ,        run_thursday     ,        run_friday       ,        run_saturday     ,        timezone_type    ,        global_type      ,        timezone         ,        arguments        ,        alert_id         ,        high_run_number  ,        computer_id        from   t_schedule         ");
        }
        catch (SQLException e1) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ScheduleInterval.class.getName(), (String)"init", (Throwable)e1);
            }
            msg = SQLUtil.getSQLExceptionMsg("JSS0007E", e1, this.args);
            this.logWriter.println(msg);
            SchCommon.stopped = true;
        }
        try {
            while (!SchCommon.stopped && results.next()) {
                short jobType = results.getShort(1);
                SchIntervalNode interval = new SchIntervalNode();
                interval.SID = results.getInt(2);
                interval.creator = results.getString(3);
                interval.setName(results.getString(4));
                interval.enabled = results.getByte(5) == 1;
                interval.scheduleType = results.getByte(6);
                interval.startYear = results.getShort(7) - 2000;
                interval.startMonth = results.getShort(8) - 1;
                interval.startDay = results.getShort(9) - 1;
                interval.startHour = results.getShort(10);
                interval.startMinute = results.getShort(11);
                interval.intervalType = results.getByte(13);
                interval.intervalNumber = results.getShort(14);
                if (results.getByte(12) == 2) {
                    interval.daysArray = new boolean[7];
                    if (results.getByte(15) == 2) {
                        interval.daysArray[1] = true;
                    }
                    if (results.getByte(16) == 2) {
                        interval.daysArray[2] = true;
                    }
                    if (results.getByte(17) == 2) {
                        interval.daysArray[3] = true;
                    }
                    if (results.getByte(18) == 2) {
                        interval.daysArray[4] = true;
                    }
                    if (results.getByte(19) == 2) {
                        interval.daysArray[5] = true;
                    }
                    if (results.getByte(20) == 2) {
                        interval.daysArray[6] = true;
                    }
                    if (results.getByte(21) == 2) {
                        interval.daysArray[0] = true;
                    }
                }
                interval.timezoneType = results.getByte(22);
                interval.globalType = results.getByte(23);
                interval.timezone = results.getString(24);
                interval.arguments = results.getString(25);
                interval.alertID = results.getInt(26);
                interval.jobType = jobType;
                interval.highRunNumber = results.getInt(27);
                interval.computerID = results.getInt(28);
                if (interval.jobType != 16 && interval.jobType != 36 && interval.jobType != 67 && interval.jobType != 32) {
                    interval.timezoneType = (byte)2;
                }
                this.initNode(interval);
            }
        }
        catch (SQLException e2) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ScheduleInterval.class.getName(), (String)"init", (Throwable)e2);
            }
            msg = SQLUtil.getSQLExceptionMsg("JSS0010E", e2, this.args);
            this.logWriter.println(msg);
            SchCommon.stopped = true;
        }
        if (results != null) {
            block28: {
                try {
                    results.close();
                }
                catch (SQLException ignored) {
                    if (!TraceLogger.enableTrace) break block28;
                    TraceLogger.exception((String)ScheduleInterval.class.getName(), (String)"init", (Throwable)ignored);
                }
            }
            results = null;
        }
        if (statement != null) {
            block29: {
                try {
                    statement.close();
                }
                catch (SQLException ignored) {
                    if (!TraceLogger.enableTrace) break block29;
                    TraceLogger.exception((String)ScheduleInterval.class.getName(), (String)"init", (Throwable)ignored);
                }
            }
            statement = null;
        }
        if (!SchCommon.stopped) {
            this.buildLists();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleInterval.class.getName(), (String)"init");
        }
    }

    public synchronized boolean checkNoPlaceToRun(int schedID) {
        SchIntervalNode checkNode = this.allHead;
        while (checkNode != null) {
            if (checkNode.SID == schedID) {
                return checkNode.CIDarray == null || checkNode.CIDarray.length < 1;
            }
            checkNode = checkNode.allNext;
        }
        return false;
    }

    public synchronized SchScheduleNode getNext(long maxMillis) {
        int lowIndex = 0;
        long lowMillis = this.headArray[0].nextMillis;
        this.schedule = null;
        if (ScheduleQueue.head != null) {
            this.processChange();
        }
        if (this.schedule == null && !SchCommon.stopped) {
            for (int ix = 1; ix < this.headArray.length; ++ix) {
                if (this.headArray[ix].nextMillis >= lowMillis) continue;
                lowIndex = ix;
                lowMillis = this.headArray[ix].nextMillis;
            }
            SchIntervalNode interval = this.headArray[lowIndex];
            if (this.runHdr != null && this.runHdr.nextMillis <= interval.nextMillis) {
                if (this.runHdr.nextMillis <= maxMillis) {
                    interval = this.runHdr;
                    this.runHdr = interval.runNext;
                    interval.runNext = null;
                    interval.onRunList = false;
                    this.schedule = this.buildRoutine.addSchedule(interval);
                }
            } else if (interval.nextMillis <= maxMillis) {
                this.schedule = this.buildRoutine.addSchedule(interval);
                interval.lastRunMillis = interval.nextMillis;
                if (interval.daysArray != null) {
                    ++interval.currentDay;
                    while (!interval.daysArray[ScheduleInterval.mod(interval.currentDay, 7)]) {
                        ++interval.currentDay;
                    }
                    this.getNextMillis(interval);
                } else if (interval.incrementMillis != 0L) {
                    this.getNextFixed(interval);
                } else {
                    if (interval.incrementMonths == 0) {
                        interval.currentDay += interval.incrementDays;
                    } else {
                        interval.currentMonth += interval.incrementMonths;
                        this.setCurrentDay(interval);
                    }
                    this.getNextMillis(interval);
                }
                if (interval.nextMillis > interval.next.nextMillis) {
                    this.headArray[lowIndex] = interval.next;
                    this.headArray[lowIndex].prev = null;
                    this.addNode(interval, lowIndex);
                }
            }
        }
        return this.schedule;
    }

    public synchronized SchIntervalNode getIntervalNode(int SID) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleInterval.class.getName(), (String)"getIntervalNode", (String)"SID");
        }
        SchIntervalNode returnInterval = this.allHead;
        while (returnInterval != null && returnInterval.SID != SID) {
            returnInterval = returnInterval.allNext;
        }
        SchIntervalNode traceResult = returnInterval;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleInterval.class.getName(), (String)"getIntervalNode", (Object)traceResult);
        }
        return traceResult;
    }

    public void changeConnection(Connection connect) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleInterval.class.getName(), (String)"changeConnection", (String)"connect");
        }
        this.connection = connect;
        this.tStatRoutine = new TStatComputer(this.connection);
        this.tScriptRoutine = new TScript(this.connection);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleInterval.class.getName(), (String)"changeConnection");
        }
    }

    private void retryNode(SchIntervalNode interval) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleInterval.class.getName(), (String)"retryNode", (String)"interval");
        }
        this.deleteNode(interval.SID);
        try {
            this.startupMillis = SQLUtil.getTimestamp(this.connection).getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ScheduleInterval.class.getName(), (String)"retryNode", (Throwable)e);
            }
            return;
        }
        this.initNode(interval);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleInterval.class.getName(), (String)"retryNode");
        }
    }

    private void initNode(SchIntervalNode interval) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleInterval.class.getName(), (String)"initNode", (String)"interval");
        }
        interval.allNext = null;
        if (this.allHead == null) {
            this.allHead = interval;
        } else {
            this.allTail.allNext = interval;
        }
        this.allTail = interval;
        this.getComputers(interval);
        if (!interval.enabled || interval.noComputers) {
            this.addToDisabledList(interval);
        } else if (interval.scheduleType == 3) {
            interval.next = this.buildHdr;
            this.buildHdr = interval;
            this.setupRepeatedly(interval);
            ++this.numberSchedules;
        } else if (interval.scheduleType == 2) {
            this.setupOnce(interval);
        } else {
            this.addToDisabledList(interval);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleInterval.class.getName(), (String)"initNode");
        }
    }

    private void buildLists() {
        SchIntervalNode searchNode;
        int ix;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleInterval.class.getName(), (String)"buildLists", (String)"");
        }
        if (this.numberSchedules == 0) {
            this.buildHdr = new SchIntervalNode();
            this.buildHdr.nextMillis = 0x7FFFFFFFFFFEL;
            this.numberSchedules = 1;
        }
        this.numberLists = ((int)Math.round(Math.sqrt(this.numberSchedules)) + 1) / 2;
        int midNumber = (this.numberSchedules / this.numberLists + 2) / 2;
        this.headArray = new SchIntervalNode[this.numberLists];
        this.midArray = new SchIntervalNode[this.numberLists];
        for (ix = 0; ix < this.numberLists; ++ix) {
            this.headArray[ix] = new SchIntervalNode();
            this.headArray[ix].setName("sentinal");
            this.headArray[ix].nextMillis = 0x7FFFFFFFFFFFL;
        }
        this.buildIndex = 0;
        while (this.buildHdr != null) {
            SchIntervalNode interval = this.buildHdr;
            this.buildHdr = interval.next;
            interval.index = this.buildIndex;
            if (interval.nextMillis < this.headArray[this.buildIndex].nextMillis) {
                interval.next = this.headArray[this.buildIndex];
                this.headArray[this.buildIndex].prev = interval;
                this.headArray[this.buildIndex] = interval;
            } else {
                searchNode = this.headArray[this.buildIndex].next;
                while (interval.nextMillis > searchNode.nextMillis) {
                    searchNode = searchNode.next;
                }
                interval.prev = searchNode.prev;
                interval.next = searchNode;
                searchNode.prev.next = interval;
                searchNode.prev = interval;
            }
            ++this.buildIndex;
            if (this.buildIndex < this.numberLists) continue;
            this.buildIndex = 0;
        }
        for (ix = 0; ix < this.numberLists; ++ix) {
            searchNode = this.headArray[ix];
            for (int i = 1; i < midNumber; ++i) {
                searchNode = searchNode.next;
            }
            this.midArray[ix] = searchNode;
        }
        runNumberHdr = this.allHead;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleInterval.class.getName(), (String)"buildLists");
        }
    }

    private void processChange() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleInterval.class.getName(), (String)"processChange", (String)"");
        }
        SchChangeNode change = this.queueRoutine.getNext();
        if (SchedulerSvp.connectBad(this.connection)) {
            this.queueRoutine.setAsFirst(change);
            SchCommon.stopped = true;
            SchCommon.bounceNeeded = true;
        } else if (change.type == 1) {
            this.deleteNode(change.interval.SID);
            this.addChange(change);
        } else if (change.type == 2) {
            change.interval.highRunNumber = this.deleteNode(change.interval.SID);
            this.addChange(change);
        } else if (change.type == 3) {
            SchIntervalNode processInterval = this.allHead;
            while (processInterval != null && processInterval.SID != change.SID) {
                processInterval = processInterval.allNext;
            }
            if (processInterval != null) {
                processInterval.setName(change.getTrueName());
            }
        } else if (change.type == 4) {
            this.deleteNode(change.SID);
        } else if (change.type == 5) {
            this.runNode(change.SID, change.computerID, change.jobData, change.alertLogID);
        } else if (change.type == 6) {
            this.rebuild();
        } else {
            SchIntervalNode processInterval = this.getIntervalNode(change.SID);
            if (processInterval != null) {
                this.retryNode(processInterval);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleInterval.class.getName(), (String)"processChange");
        }
    }

    private void rebuild() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleInterval.class.getName(), (String)"rebuild", (String)"");
        }
        long rebuildMillis = 0L;
        try {
            rebuildMillis = SQLUtil.getTimestamp(this.connection).getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ScheduleInterval.class.getName(), (String)"rebuild", (Throwable)e);
            }
            return;
        }
        for (int ix = 0; ix < this.headArray.length; ++ix) {
            if (this.headArray[ix].nextMillis >= rebuildMillis) continue;
            rebuildMillis = this.headArray[ix].nextMillis;
        }
        if (this.runHdr != null && this.runHdr.nextMillis < rebuildMillis) {
            rebuildMillis = this.runHdr.nextMillis;
        }
        this.calendar = Calendar.getInstance();
        this.date = new Date(rebuildMillis - 86400000L);
        this.calendar.setTime(this.date);
        this.serverYear = this.calendar.get(1) - 2000;
        this.serverMonth = this.calendar.get(2);
        this.serverDay = this.calendar.get(5) - 1;
        this.serverMonth = this.serverYear * 12 + this.serverMonth;
        this.serverDay = this.serverMonth / 48 * 1461 + monthDays[ScheduleInterval.mod(this.serverMonth, 48)] + this.serverDay;
        SchIntervalNode rebuildHdr = this.allHead;
        runNumberHdr = null;
        this.allHead = null;
        this.allTail = null;
        this.buildHdr = null;
        this.runHdr = null;
        this.disabledHdr = null;
        this.headArray = null;
        this.midArray = null;
        this.numberSchedules = 0;
        this.buildIndex = 0;
        while (rebuildHdr != null) {
            SchIntervalNode rebuildInterval = rebuildHdr;
            rebuildHdr = rebuildInterval.allNext;
            rebuildInterval.clearDerived();
            this.startupMillis = rebuildMillis <= rebuildInterval.lastRunMillis ? rebuildInterval.lastRunMillis + 1L : rebuildMillis;
            this.initNode(rebuildInterval);
        }
        this.buildLists();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleInterval.class.getName(), (String)"rebuild");
        }
    }

    private void addChange(SchChangeNode change) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleInterval.class.getName(), (String)"addChange", (String)"change");
        }
        SchIntervalNode interval = change.interval;
        try {
            this.startupMillis = SQLUtil.getTimestamp(this.connection).getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ScheduleInterval.class.getName(), (String)"addChange", (Throwable)e);
            }
            return;
        }
        boolean enabled = interval.enabled;
        this.initNode(interval);
        if (this.buildHdr != null) {
            interval = this.buildHdr;
            this.buildHdr = null;
            this.addNode(interval, this.buildIndex);
            ++this.buildIndex;
            if (this.buildIndex >= this.numberLists) {
                this.buildIndex = 0;
            }
        }
        if (interval.scheduleType == 1 && enabled) {
            this.runNode(interval.SID, -1, null, -1);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleInterval.class.getName(), (String)"addChange");
        }
    }

    private int deleteNode(int SID) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleInterval.class.getName(), (String)"deleteNode", (String)"SID");
        }
        int runNumber = 1;
        if (this.allHead != null) {
            SchIntervalNode prevNode;
            SchIntervalNode searchNode = this.allHead;
            if (this.allHead.SID == SID) {
                this.allHead = this.allHead.allNext;
                if (this.allHead == null) {
                    this.allTail = null;
                }
            } else {
                prevNode = null;
                while (searchNode != null && searchNode.SID != SID) {
                    prevNode = searchNode;
                    searchNode = searchNode.allNext;
                }
                if (searchNode != null) {
                    prevNode.allNext = searchNode.allNext;
                    if (searchNode.allNext == null) {
                        this.allTail = prevNode;
                    }
                }
            }
            if (searchNode != null) {
                if (searchNode.onRunList) {
                    if (searchNode == this.runHdr) {
                        this.runHdr = this.runHdr.runNext;
                    } else {
                        prevNode = this.runHdr;
                        while (prevNode.runNext != searchNode) {
                            prevNode = prevNode.runNext;
                        }
                        prevNode.runNext = searchNode.runNext;
                    }
                }
                if (searchNode.onDisabledList) {
                    if (searchNode.prev == null) {
                        this.disabledHdr = searchNode.next;
                    } else {
                        searchNode.prev.next = searchNode.next;
                    }
                    if (searchNode.next != null) {
                        searchNode.next.prev = searchNode.prev;
                    }
                } else {
                    if (searchNode.prev == null) {
                        this.headArray[searchNode.index] = searchNode.next;
                    } else {
                        searchNode.prev.next = searchNode.next;
                    }
                    searchNode.next.prev = searchNode.prev;
                    if (this.midArray[searchNode.index] == searchNode) {
                        this.midArray[searchNode.index] = searchNode.prev == null ? searchNode.next : searchNode.prev;
                    }
                }
                runNumber = searchNode.highRunNumber;
                searchNode.clearDerived();
            }
        }
        int traceResult = runNumber;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleInterval.class.getName(), (String)"deleteNode", (int)traceResult);
        }
        return traceResult;
    }

    private void runNode(int SID, int computerID, Serializable jobData, int alertLogID) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleInterval.class.getName(), (String)"runNode", (String)"SID, computerID, jobData, alertLogID");
        }
        SchIntervalNode runInterval = this.allHead;
        while (runInterval != null) {
            if (runInterval.SID == SID) {
                if (runInterval.fetchFailed) {
                    this.retryNode(runInterval);
                }
                if (runInterval.fetchFailed) break;
                runInterval.alertLogID = alertLogID;
                runInterval.jobData = jobData;
                int[] savedCompIDs = runInterval.CIDarray;
                if (computerID > 0) {
                    runInterval.CIDarray = new int[1];
                    runInterval.CIDarray[0] = computerID;
                }
                runInterval.runNow = true;
                this.schedule = this.buildRoutine.addSchedule(runInterval);
                runInterval.runNow = false;
                runInterval.CIDarray = savedCompIDs;
                runInterval.jobData = null;
                runInterval.alertLogID = -1;
                break;
            }
            runInterval = runInterval.allNext;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleInterval.class.getName(), (String)"runNode");
        }
    }

    private void addNode(SchIntervalNode interval, int currentIndex) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleInterval.class.getName(), (String)"addNode", (String)"interval, currentIndex");
        }
        SchIntervalNode searchNode = this.midArray[currentIndex];
        interval.index = currentIndex;
        if (interval.nextMillis >= searchNode.nextMillis) {
            searchNode = searchNode.next;
            while (interval.nextMillis > searchNode.nextMillis) {
                searchNode = searchNode.next;
            }
            interval.prev = searchNode.prev;
            interval.next = searchNode;
            searchNode.prev.next = interval;
            searchNode.prev = interval;
            this.midArray[currentIndex] = this.midArray[currentIndex].next;
        } else {
            searchNode = this.headArray[currentIndex];
            if (interval.nextMillis < searchNode.nextMillis) {
                interval.prev = null;
                interval.next = searchNode;
                searchNode.prev = interval;
                this.headArray[currentIndex] = interval;
            } else {
                while (interval.nextMillis >= searchNode.nextMillis) {
                    searchNode = searchNode.next;
                }
                interval.prev = searchNode.prev;
                interval.next = searchNode;
                searchNode.prev.next = interval;
                searchNode.prev = interval;
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleInterval.class.getName(), (String)"addNode");
        }
    }

    private void setupRepeatedly(SchIntervalNode interval) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleInterval.class.getName(), (String)"setupRepeatedly", (String)"interval");
        }
        if (interval.daysArray != null) {
            interval.incrementDays = 1;
            this.setupDay(interval);
            if (!interval.daysArray[ScheduleInterval.mod(interval.currentDay, 7)]) {
                ++interval.currentDay;
                while (!interval.daysArray[ScheduleInterval.mod(interval.currentDay, 7)]) {
                    ++interval.currentDay;
                }
                this.getNextMillis(interval);
            }
        } else if (interval.intervalType == 5) {
            interval.incrementMonths = interval.intervalNumber;
            this.setupMonth(interval);
        } else if (interval.intervalType == 4) {
            interval.incrementDays = interval.intervalNumber * 7;
            this.setupDay(interval);
        } else if (interval.intervalType == 3) {
            interval.incrementDays = interval.intervalNumber;
            this.setupDay(interval);
        } else if (interval.intervalType == 2) {
            interval.incrementMillis = (long)interval.intervalNumber * 3600000L;
            this.setupFixed(interval);
        } else {
            interval.incrementMillis = (long)interval.intervalNumber * 60000L;
            this.setupFixed(interval);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleInterval.class.getName(), (String)"setupRepeatedly");
        }
    }

    private void getComputers(SchIntervalNode interval) {
        int computerIndex;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleInterval.class.getName(), (String)"getComputers", (String)"interval");
        }
        if (interval.jobType == 16) {
            computerIndex = this.getProbe(interval);
        } else if (interval.jobType == 67) {
            computerIndex = this.getScript(interval);
            this.getScriptName(interval);
        } else if (interval.jobType == 36) {
            computerIndex = this.getReport(interval);
        } else if (interval.jobType == 32) {
            computerIndex = this.getDiscovery(interval);
        } else if (interval.jobType == 104) {
            this.intArray[0] = -999999999;
            computerIndex = 1;
        } else if (interval.jobType == 105) {
            this.intArray[0] = -999999999;
            computerIndex = 1;
        } else {
            if (interval.jobType == 17) {
                this.getPing(interval);
            }
            this.intArray[0] = -1;
            computerIndex = 1;
        }
        if (computerIndex == 0) {
            interval.noComputers = true;
            interval.fetchFailed = true;
        } else {
            int index;
            interval.CIDarray = new int[computerIndex];
            for (index = 0; index < computerIndex; ++index) {
                interval.CIDarray[index] = this.intArray[index];
            }
            if (interval.timezoneType == 2) {
                interval.TZ = interval.globalType == 1 ? 0 : this.lookUpZone(interval.timezone);
            } else {
                interval.CIDTZarray = new int[computerIndex];
                int intIndex = 0;
                for (index = 0; index < computerIndex; ++index) {
                    int ix;
                    TimeZone tz = interval.CIDarray[index] < 0 ? null : this.agentRoutine.getAgentTimezone(interval.CIDarray[index]);
                    if (tz == null) {
                        tz = this.timezoneArray[0];
                    }
                    int tzIndex = this.lookUpZone(tz.getID());
                    for (ix = 0; ix < intIndex && this.intArray[ix] != tzIndex; ++ix) {
                    }
                    if (ix == intIndex) {
                        this.intArray[intIndex] = tzIndex;
                        ++intIndex;
                    }
                    interval.CIDTZarray[index] = ix;
                }
                if (intIndex < 2) {
                    interval.TZ = this.intArray[0];
                } else {
                    interval.TZarray = new int[intIndex];
                    interval.submitMillisArray = new long[intIndex];
                    for (index = 0; index < intIndex; ++index) {
                        interval.TZarray[index] = this.intArray[index];
                    }
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleInterval.class.getName(), (String)"getComputers");
        }
    }

    private int getProbe(SchIntervalNode interval) {
        int index;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleInterval.class.getName(), (String)"getProbe", (String)"interval");
        }
        try {
            index = ProbeDefHndlr.getProbeComputers(this.connection, interval.SID, this.intArray);
        }
        catch (GeneralException ge2) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ScheduleInterval.class.getName(), (String)"getProbe", (Throwable)ge2);
            }
            Object[] argy = new Object[]{ResourceTypeManager.getJobName((short)interval.jobType), interval.creator + "." + interval.getName()};
            MessageLog.logException((String)"JSS0026E", (Exception)((Object)ge2), (Object[])argy);
            index = 0;
        }
        int traceResult = index;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleInterval.class.getName(), (String)"getProbe", (int)traceResult);
        }
        return traceResult;
    }

    private int getScript(SchIntervalNode interval) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleInterval.class.getName(), (String)"getScript", (String)"interval");
        }
        NameList node = null;
        try {
            node = this.tStatRoutine.computersTiedTo(interval.SID, true);
        }
        catch (GeneralException ge2) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ScheduleInterval.class.getName(), (String)"getScript", (Throwable)ge2);
            }
            Object[] argy = new Object[]{ResourceTypeManager.getJobName((short)interval.jobType), interval.creator + "." + interval.getName()};
            MessageLog.logException((String)"JSS0026E", (Exception)((Object)ge2), (Object[])argy);
            node = null;
        }
        int index = 0;
        while (node != null) {
            if (!Constants.isVirtualServer((int)node.nlInfo)) {
                this.intArray[index] = node.nlID;
                ++index;
            }
            node = node.nlNext;
        }
        int traceResult = index;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleInterval.class.getName(), (String)"getScript", (int)traceResult);
        }
        return traceResult;
    }

    private int getReport(SchIntervalNode interval) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleInterval.class.getName(), (String)"getReport", (String)"interval");
        }
        this.intArray[0] = interval.computerID;
        int traceResult = 1;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleInterval.class.getName(), (String)"getReport", (int)traceResult);
        }
        return traceResult;
    }

    private int getDiscovery(SchIntervalNode interval) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleInterval.class.getName(), (String)"getDiscovery", (String)"interval");
        }
        NameList nameList = new NameList();
        int index = 0;
        int prevDID = -1;
        int prevCID = -1;
        int prevState = 0;
        boolean bl = false;
        boolean prevAgentDown = true;
        try {
            this.tStatRoutine.initQueryBySchedule(interval.SID, interval.jobType);
            while (this.tStatRoutine.fetchQueryBySchedule(nameList)) {
                AgentManager.AgentAddress agent;
                short s;
                if (nameList.nlID == -1) {
                    this.intArray[index++] = nameList.nlID2;
                    continue;
                }
                if (nameList.nlID != prevDID) {
                    if (prevCID > 0) {
                        this.intArray[index++] = prevCID;
                    }
                    prevDID = nameList.nlID;
                    prevState = 2;
                    s = Integer.MAX_VALUE;
                    prevAgentDown = false;
                }
                if (nameList.nlID2 == prevCID) continue;
                if (prevState == 1 && nameList.nlState == 1) {
                    this.intArray[index++] = prevCID;
                }
                if (nameList.nlState == 1) {
                    prevCID = nameList.nlID2;
                    prevState = nameList.nlState;
                    prevAgentDown = false;
                    s = 0;
                    continue;
                }
                if (!prevAgentDown && s <= 0 || (agent = Server.agentMgr.get(nameList.nlID2)) == null || (agent.state != 1 || !prevAgentDown) && agent.consecutiveErrors >= s) continue;
                prevCID = nameList.nlID2;
                prevState = nameList.nlState;
                prevAgentDown = agent.state != 1;
                s = agent.consecutiveErrors;
            }
            if (prevCID > 0) {
                this.intArray[index] = prevCID;
                ++index;
            }
        }
        catch (GeneralException ge1) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ScheduleInterval.class.getName(), (String)"getDiscovery", (Throwable)ge1);
            }
            Object[] argy = new Object[]{ResourceTypeManager.getJobName((short)interval.jobType), interval.creator + "." + interval.getName()};
            MessageLog.logException((String)"JSS0026E", (Exception)((Object)ge1), (Object[])argy);
            index = 0;
        }
        int traceResult = index;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleInterval.class.getName(), (String)"getDiscovery", (int)traceResult);
        }
        return traceResult;
    }

    private void getPing(SchIntervalNode interval) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleInterval.class.getName(), (String)"getPing", (String)"interval");
        }
        try {
            NameList list = this.tStatRoutine.computersTiedTo(interval.SID, true);
            interval.pingList = null;
            NameList node = list;
            while (node != null) {
                if (!this.agentRoutine.isNasComputerExpired(node.nlID)) {
                    LinkedInteger li = new LinkedInteger(node.nlID);
                    li.next = interval.pingList;
                    interval.pingList = li;
                }
                node = node.nlNext;
            }
        }
        catch (GeneralException ge2) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ScheduleInterval.class.getName(), (String)"getPing", (Throwable)ge2);
            }
            Object[] argy = new Object[]{ResourceTypeManager.getJobName((short)interval.jobType), interval.creator + "." + interval.getName()};
            MessageLog.logException((String)"JSS0026E", (Exception)((Object)ge2), (Object[])argy);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleInterval.class.getName(), (String)"getPing");
        }
    }

    private void getScriptName(SchIntervalNode interval) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleInterval.class.getName(), (String)"getScriptName", (String)"interval");
        }
        try {
            interval.scriptName = this.tScriptRoutine.select(interval.SID);
        }
        catch (GeneralException ge7) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)ScheduleInterval.class.getName(), (String)"getScriptName", (Throwable)ge7);
            }
            Object[] argy = new Object[]{ResourceTypeManager.getJobName((short)interval.jobType), interval.creator + "." + interval.getName()};
            MessageLog.logException((String)"JSS0026E", (Exception)((Object)ge7), (Object[])argy);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleInterval.class.getName(), (String)"getScriptName");
        }
    }

    private int lookUpZone(String zoneName) {
        int index;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleInterval.class.getName(), (String)"lookUpZone", (String)"zoneName");
        }
        for (index = 0; index < this.timezoneIndex && !zoneName.equals(this.zoneNameArray[index]); ++index) {
        }
        if (index == this.timezoneIndex) {
            this.zoneNameArray[this.timezoneIndex] = zoneName;
            this.timezoneArray[this.timezoneIndex] = TimeZone.getTimeZone(zoneName);
            ++this.timezoneIndex;
        }
        int traceResult = index;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleInterval.class.getName(), (String)"lookUpZone", (int)traceResult);
        }
        return traceResult;
    }

    private void setupMonth(SchIntervalNode interval) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleInterval.class.getName(), (String)"setupMonth", (String)"interval");
        }
        interval.currentMonth = interval.startYear * 12 + interval.startMonth;
        while (interval.currentMonth < this.serverMonth) {
            interval.currentMonth += interval.incrementMonths;
        }
        this.setCurrentDay(interval);
        if (interval.currentDay < this.serverDay) {
            interval.currentMonth += interval.incrementMonths;
            this.setCurrentDay(interval);
        }
        this.getNextMillis(interval);
        if (interval.nextMillis < this.startupMillis) {
            interval.currentMonth += interval.incrementMonths;
            this.setCurrentDay(interval);
            this.getNextMillis(interval);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleInterval.class.getName(), (String)"setupMonth");
        }
    }

    private void setCurrentDay(SchIntervalNode interval) {
        int diff;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleInterval.class.getName(), (String)"setCurrentDay", (String)"interval");
        }
        interval.currentDay = interval.currentMonth / 48 * 1461 + monthDays[ScheduleInterval.mod(interval.currentMonth, 48)] + interval.startDay;
        if (interval.startDay > 27 && (diff = interval.startDay - DAYS_ARRAY[ScheduleInterval.mod(interval.currentMonth, 48)]) > 0) {
            interval.currentDay -= diff;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleInterval.class.getName(), (String)"setCurrentDay");
        }
    }

    private void setupDay(SchIntervalNode interval) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleInterval.class.getName(), (String)"setupDay", (String)"interval");
        }
        interval.currentMonth = interval.startYear * 12 + interval.startMonth;
        interval.currentDay = interval.currentMonth / 48 * 1461 + monthDays[ScheduleInterval.mod(interval.currentMonth, 48)] + interval.startDay;
        while (interval.currentDay < this.serverDay) {
            interval.currentDay += interval.incrementDays;
        }
        this.getNextMillis(interval);
        while (interval.nextMillis < this.startupMillis) {
            interval.currentDay += interval.incrementDays;
            this.getNextMillis(interval);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleInterval.class.getName(), (String)"setupDay");
        }
    }

    private void setupFixed(SchIntervalNode interval) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleInterval.class.getName(), (String)"setupFixed", (String)"interval");
        }
        interval.currentMonth = interval.startYear * 12 + interval.startMonth;
        interval.currentDay = interval.currentMonth / 48 * 1461 + monthDays[ScheduleInterval.mod(interval.currentMonth, 48)] + interval.startDay;
        this.getNextMillis(interval);
        long addMillis = interval.nextMillis;
        while (interval.nextMillis < this.startupMillis) {
            interval.nextMillis += interval.incrementMillis;
        }
        if (interval.TZarray == null) {
            interval.submitMillis = interval.nextMillis;
        } else {
            addMillis = interval.nextMillis - addMillis;
            int ix = 0;
            while (ix < interval.TZarray.length) {
                int n = ix++;
                interval.submitMillisArray[n] = interval.submitMillisArray[n] + addMillis;
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleInterval.class.getName(), (String)"setupFixed");
        }
    }

    private void setupOnce(SchIntervalNode interval) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleInterval.class.getName(), (String)"setupOnce", (String)"interval");
        }
        this.addToDisabledList(interval);
        interval.currentMonth = interval.startYear * 12 + interval.startMonth;
        interval.currentDay = interval.currentMonth / 48 * 1461 + monthDays[ScheduleInterval.mod(interval.currentMonth, 48)] + interval.startDay;
        this.getNextMillis(interval);
        if (interval.nextMillis >= this.startupMillis) {
            this.addToRunList(interval);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleInterval.class.getName(), (String)"setupOnce");
        }
    }

    private void addToRunList(SchIntervalNode interval) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleInterval.class.getName(), (String)"addToRunList", (String)"interval");
        }
        interval.onRunList = true;
        if (this.runHdr == null || interval.nextMillis < this.runHdr.nextMillis) {
            interval.runNext = this.runHdr;
            this.runHdr = interval;
        } else {
            SchIntervalNode searchNode = this.runHdr;
            while (searchNode.runNext != null && interval.nextMillis >= searchNode.runNext.nextMillis) {
                searchNode = searchNode.runNext;
            }
            interval.runNext = searchNode.runNext;
            searchNode.runNext = interval;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleInterval.class.getName(), (String)"addToRunList");
        }
    }

    private void addToDisabledList(SchIntervalNode interval) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleInterval.class.getName(), (String)"addToDisabledList", (String)"interval");
        }
        interval.onDisabledList = true;
        interval.prev = null;
        interval.next = this.disabledHdr;
        if (this.disabledHdr != null) {
            this.disabledHdr.prev = interval;
        }
        this.disabledHdr = interval;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleInterval.class.getName(), (String)"addToDisabledList");
        }
    }

    private void getNextMillis(SchIntervalNode interval) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleInterval.class.getName(), (String)"getNextMillis", (String)"interval");
        }
        int year = 2000 + interval.currentDay / 1461 * 4;
        int month = 0;
        int day = ScheduleInterval.mod(interval.currentDay, 1461);
        if (day < 366) {
            if (day < 31) {
                ++day;
            } else if (day < 60) {
                month = 1;
                day -= 30;
            } else if (day < 91) {
                month = 2;
                day -= 59;
            } else if (day < 121) {
                month = 3;
                day -= 90;
            } else if (day < 152) {
                month = 4;
                day -= 120;
            } else if (day < 182) {
                month = 5;
                day -= 151;
            } else if (day < 213) {
                month = 6;
                day -= 181;
            } else if (day < 244) {
                month = 7;
                day -= 212;
            } else if (day < 274) {
                month = 8;
                day -= 243;
            } else if (day < 305) {
                month = 9;
                day -= 273;
            } else if (day < 335) {
                month = 10;
                day -= 304;
            } else {
                month = 11;
                day -= 334;
            }
        } else {
            if (day < 731) {
                ++year;
                day -= 366;
            } else if (day < 1096) {
                year += 2;
                day -= 731;
            } else {
                year += 3;
                day -= 1096;
            }
            if (day < 31) {
                ++day;
            } else if (day < 59) {
                month = 1;
                day -= 30;
            } else if (day < 90) {
                month = 2;
                day -= 58;
            } else if (day < 120) {
                month = 3;
                day -= 89;
            } else if (day < 151) {
                month = 4;
                day -= 119;
            } else if (day < 181) {
                month = 5;
                day -= 150;
            } else if (day < 212) {
                month = 6;
                day -= 180;
            } else if (day < 243) {
                month = 7;
                day -= 211;
            } else if (day < 273) {
                month = 8;
                day -= 242;
            } else if (day < 304) {
                month = 9;
                day -= 272;
            } else if (day < 334) {
                month = 10;
                day -= 303;
            } else {
                month = 11;
                day -= 333;
            }
        }
        if (interval.TZarray == null) {
            this.calendar.setTimeZone(this.timezoneArray[interval.TZ]);
            this.calendar.set(year, month, day, interval.startHour, interval.startMinute, 0);
            interval.nextMillis = interval.submitMillis = this.getMillis();
        } else {
            this.calendar.set(year, month, day, interval.startHour, interval.startMinute, 0);
            interval.nextMillis = 0x7FFFFFFFFFFFL;
            for (int ix = 0; ix < interval.TZarray.length; ++ix) {
                this.calendar.setTimeZone(this.timezoneArray[interval.TZarray[ix]]);
                this.calendar.set(1, year);
                interval.submitMillisArray[ix] = this.getMillis();
                if (interval.submitMillisArray[ix] >= interval.nextMillis) continue;
                interval.nextMillis = interval.submitMillisArray[ix];
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleInterval.class.getName(), (String)"getNextMillis");
        }
    }

    private long getMillis() {
        long exactMillis;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleInterval.class.getName(), (String)"getMillis", (String)"");
        }
        this.date = this.calendar.getTime();
        long roughMillis = this.date.getTime();
        if (roughMillis - (exactMillis = roughMillis / 60000L * 60000L) > 30000L) {
            exactMillis += 60000L;
        }
        long traceResult = exactMillis;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleInterval.class.getName(), (String)"getMillis", (long)traceResult);
        }
        return traceResult;
    }

    private void getNextFixed(SchIntervalNode interval) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScheduleInterval.class.getName(), (String)"getNextFixed", (String)"interval");
        }
        interval.nextMillis += interval.incrementMillis;
        if (interval.TZarray == null) {
            interval.submitMillis += interval.incrementMillis;
        } else {
            int ix = 0;
            while (ix < interval.TZarray.length) {
                int n = ix++;
                interval.submitMillisArray[n] = interval.submitMillisArray[n] + interval.incrementMillis;
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScheduleInterval.class.getName(), (String)"getNextFixed");
        }
    }

    private static int mod(int n, int d) {
        int r = n % d;
        if (r < 0) {
            r += d;
        }
        return r;
    }

    static {
        monthDays = new short[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335, 366, 397, 425, 456, 486, 517, 547, 578, 609, 639, 670, 700, 731, 762, 790, 821, 851, 882, 912, 943, 974, 1004, 1035, 1065, 1096, 1127, 1155, 1186, 1216, 1247, 1277, 1308, 1339, 1369, 1400, 1430};
        DAYS_ARRAY = new short[]{30, 28, 30, 29, 30, 29, 30, 30, 29, 30, 29, 30, 30, 27, 30, 29, 30, 29, 30, 30, 29, 30, 29, 30, 30, 27, 30, 29, 30, 29, 30, 30, 29, 30, 29, 30, 30, 27, 30, 29, 30, 29, 30, 30, 29, 30, 29, 30};
    }

    private class ComputerFetcher {
        Class accessorClass;
        ScheduleQueryable accessor;
        boolean loadFailed;

        ComputerFetcher(Class accessorClass) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)ComputerFetcher.class.getName(), (String)"ComputerFetcher", (String)"className");
            }
            this.accessorClass = accessorClass;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ComputerFetcher.class.getName(), (String)"ComputerFetcher");
            }
        }

        ScheduleQueryable getAccessor() {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)ComputerFetcher.class.getName(), (String)"getAccessor", (String)"");
            }
            if (this.accessor == null && !this.loadFailed) {
                try {
                    Class[] argdef = new Class[]{Connection.class};
                    Constructor c = this.accessorClass.getConstructor(argdef);
                    Object[] args = new Object[]{ScheduleInterval.this.connection};
                    this.accessor = (ScheduleQueryable)c.newInstance(args);
                }
                catch (Exception e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)ComputerFetcher.class.getName(), (String)"getAccessor", (Throwable)e);
                    }
                    this.loadFailed = true;
                    MessageLog.logException((String)"JSS0071E", (Exception)e, (Object)this.accessorClass);
                    e.printStackTrace();
                }
            }
            ScheduleQueryable traceResult = this.accessor;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ComputerFetcher.class.getName(), (String)"getAccessor", (Object)traceResult);
            }
            return traceResult;
        }
    }
}

