/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server;

import java.io.PrintWriter;
import org.eclipse.aperi.common.TSThread;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.ServiceQueue;
import org.eclipse.aperi.server.ServiceRequest;
import org.eclipse.aperi.server.ThreadSafe;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.VMTransceiver;
import org.eclipse.aperi.util.extensions.AbstractExtensionMgr;
import org.eclipse.aperi.util.extensions.ExtensionException;
import org.eclipse.aperi.util.osgi.IDisposable;
import org.eclipse.aperi.xmsg.MessageLog;

public class RequestManager
implements IDisposable {
    private static final String CLASSNAME = RequestManager.class.getName();
    private static final int THREAD_STOP_WAIT_TIME_MS = 300000;
    private String extensionPointId;
    private RmExtensionManager extensionManager;
    private ServiceQueue queue;
    private ThreadGroup threadGroup;
    private String threadName;
    private int priority;
    private int threadPoolSize;
    private int pendingRequestLimit;
    private int activeThreadCount;
    private Thread[] threads;
    private int[] freeThreads;
    private int freeThreadsIndex;
    private PrintWriter logWriter;
    private boolean shutdown;

    public RequestManager(String extensionPointId, ServiceQueue queue, ThreadGroup threadGroup, String threadName, int priority, int threadPoolSize, int maxThreadPoolSize, int pendingRequestLimit) {
        this.extensionPointId = extensionPointId;
        this.queue = queue;
        this.threadGroup = threadGroup;
        this.threadName = threadName != null ? threadName : "RequestHandler";
        this.priority = priority;
        this.threadPoolSize = threadPoolSize;
        if (maxThreadPoolSize > threadPoolSize) {
            queue.setThreadManager(this);
            this.pendingRequestLimit = pendingRequestLimit;
        } else {
            queue.setThreadManager(null);
        }
        this.activeThreadCount = 0;
        this.threads = new RmThread[maxThreadPoolSize];
        this.freeThreads = new int[maxThreadPoolSize];
        this.freeThreadsIndex = maxThreadPoolSize;
        for (int i = this.freeThreadsIndex - 1; i >= 0; --i) {
            this.freeThreads[i] = i;
        }
        this.logWriter = MessageLog.getThreadLog();
        this.shutdown = false;
    }

    public boolean initialize() {
        String methodName = "initialize";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"initialize", (String)"");
        }
        this.extensionManager = new RmExtensionManager(this.extensionPointId, true);
        this.startThreads();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"initialize", (boolean)true);
        }
        return true;
    }

    public void dispose() {
        String methodName = "dispose";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"dispose", (String)"");
        }
        this.stopThreads();
        this.extensionManager.dispose();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"dispose");
        }
    }

    private void startThreads() {
        String methodName = "startThreads";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"startThreads", (String)"");
        }
        this.spawnThreads(this.threadPoolSize);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"startThreads");
        }
    }

    private void stopThreads() {
        block6: {
            int i;
            String methodName = "stopThreads";
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)CLASSNAME, (String)"stopThreads", (String)"");
            }
            this.shutdown = true;
            for (i = this.threads.length - 1; i >= 0; --i) {
                if (this.threads[i] == null) continue;
                this.threads[i].interrupt();
            }
            try {
                for (i = this.threads.length - 1; i >= 0; --i) {
                    if (this.threads[i] == null) continue;
                    this.threads[i].join(300000L);
                }
            }
            catch (InterruptedException e) {
                if (!TraceLogger.enableTrace) break block6;
                TraceLogger.exception((String)CLASSNAME, (String)"stopThreads", (Throwable)e);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"stopThreads");
        }
    }

    public void growThreadPool() {
        String methodName = "growThreadPool";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"growThreadPool", (String)"");
        }
        if (this.freeThreadsIndex > 0 && this.queue.getWaiting() == 0 && this.pendingRequestLimit < this.queue.getPending()) {
            this.spawnThreads(1);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"growThreadPool");
        }
    }

    synchronized void spawnThreads(int threadCount) {
        String methodName = "spawnThreads";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"spawnThreads", (String)"threadCount");
        }
        if (threadCount > this.freeThreadsIndex) {
            threadCount = this.freeThreadsIndex;
        }
        this.activeThreadCount += threadCount;
        while (threadCount > 0) {
            --this.freeThreadsIndex;
            int threadsIndex = this.freeThreads[this.freeThreadsIndex];
            RmThread t = new RmThread(threadsIndex);
            this.threads[threadsIndex] = t;
            TSThread.setProperty((Object)"TSThread.key.terminate", null);
            t.setPriority(this.priority);
            t.setDaemon(true);
            t.start();
            --threadCount;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"spawnThreads");
        }
    }

    synchronized void freeThread(int threadsIndex) {
        String methodName = "freeThread";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"freeThread", (String)"threadsIndex");
        }
        this.freeThreads[this.freeThreadsIndex] = threadsIndex;
        ++this.freeThreadsIndex;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"freeThread");
        }
    }

    public synchronized boolean shouldThreadWait() {
        String methodName = "shouldThreadWait";
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)CLASSNAME, (String)"shouldThreadWait", (String)"");
        }
        boolean wait = true;
        if (this.activeThreadCount > this.threadPoolSize) {
            TSThread.setProperty((Object)"TSThread.key.terminate", (Object)new Boolean(true));
            --this.activeThreadCount;
            wait = false;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)CLASSNAME, (String)"shouldThreadWait", (boolean)wait);
        }
        return wait;
    }

    private static class RmExtensionManager
    extends AbstractExtensionMgr {
        private RmExtensionManager parentManager;
        private String extensionPointId;
        private boolean cacheOnlyThreadSafe;

        public RmExtensionManager(RmExtensionManager parentManager, boolean cacheOnlyThreadSafe) {
            this(parentManager, parentManager.getExtensionPointId(), cacheOnlyThreadSafe);
        }

        public RmExtensionManager(String extensionPointId, boolean cacheOnlyThreadSafe) {
            this(null, extensionPointId, cacheOnlyThreadSafe);
        }

        private RmExtensionManager(RmExtensionManager parentManager, String extensionPointId, boolean cacheOnlyThreadSafe) {
            this.parentManager = parentManager;
            this.extensionPointId = extensionPointId;
            this.cacheOnlyThreadSafe = cacheOnlyThreadSafe;
        }

        public Object getExtensionImpl(String extensionId) throws ExtensionException {
            Object impl = this.getExtensionImplFromCache(extensionId);
            if (impl == null && (impl = super.getExtensionImpl(extensionId, false)) != null) {
                this.cacheExtensionImpl(extensionId, impl);
            }
            return impl;
        }

        private Object getExtensionImplFromCache(String extensionId) {
            Object impl = this.cache.get(extensionId);
            if (impl == null && this.parentManager != null) {
                return this.parentManager.getExtensionImplFromCache(extensionId);
            }
            return impl;
        }

        private void cacheExtensionImpl(String extensionId, Object impl) {
            if (!(impl instanceof ThrowAway || !(impl instanceof ThreadSafe) && this.cacheOnlyThreadSafe)) {
                this.cache.put(extensionId, impl);
            }
            if (this.parentManager != null) {
                this.parentManager.cacheExtensionImpl(extensionId, impl);
            }
        }

        public Object getExtensionImpl(String extensionId, boolean useCache) throws ExtensionException {
            throw new UnsupportedOperationException();
        }

        public String getExtensionPointId() {
            return this.extensionPointId;
        }
    }

    private class RmThread
    extends TSThread {
        private final String CLASSNAME;
        private RmExtensionManager localExtensionManager;
        private int threadsIndex;

        public RmThread(int threadsIndex) {
            super(RequestManager.this.threadGroup, RequestManager.this.threadName + "-" + threadsIndex);
            this.CLASSNAME = RmThread.class.getName();
            this.threadsIndex = threadsIndex;
        }

        public void run() {
            String methodName = "run";
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)this.CLASSNAME, (String)"run", (String)"");
            }
            MessageLog.setThreadLog((PrintWriter)RequestManager.this.logWriter);
            this.localExtensionManager = new RmExtensionManager(RequestManager.this.extensionManager, false);
            while (!RequestManager.this.shutdown) {
                ServiceRequest serviceRequest = (ServiceRequest)RequestManager.this.queue.get();
                if (serviceRequest == null) {
                    Object stop = TSThread.getProperty((Object)"TSThread.key.terminate");
                    if (stop == null) continue;
                    break;
                }
                Transceiver comm = serviceRequest.comm;
                Request request = serviceRequest.request;
                String subType = request.subType;
                serviceRequest.returnServiceRequest();
                Response response = null;
                RequestHandler handler = null;
                try {
                    handler = (RequestHandler)this.localExtensionManager.getExtensionImpl(subType);
                }
                catch (Exception e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)this.CLASSNAME, (String)"run", (Throwable)e);
                    }
                    response = Response.getResponse((short)12, null);
                    response.errorMessage = MessageLog.getMessage((String)"SRV0032E", (Object)subType);
                }
                if (handler != null) {
                    try {
                        response = handler.handle(request, comm);
                    }
                    catch (RuntimeException e) {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)this.CLASSNAME, (String)"run", (Throwable)e);
                        }
                        comm.close();
                        this.logRuntimeException(request, e);
                        RequestManager.this.freeThread(this.threadsIndex);
                        throw e;
                    }
                }
                if (response != null && response.status != -99) {
                    comm.transmitResponse(request, response);
                    if (!(comm instanceof VMTransceiver)) {
                        response.returnResponse();
                    }
                }
                if ((response == null || response.status == -99) && response != null) continue;
                comm.close();
                comm.returnTransceiver();
            }
            this.localExtensionManager.dispose();
            RequestManager.this.freeThread(this.threadsIndex);
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)this.CLASSNAME, (String)"run");
            }
        }

        private String logRuntimeException(Request request, RuntimeException e) {
            String methodName = "logRuntimeException";
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)this.CLASSNAME, (String)"logRuntimeException", (String)"request, e");
            }
            Object[] args = new Object[4];
            args[0] = request.machineName;
            if (args[0] == null) {
                args[0] = "unknown";
            }
            args[1] = request.serviceName;
            if (args[1] == null) {
                args[1] = "unknown";
            }
            args[2] = request.toString();
            args[3] = request.userName;
            String msgID = request.userName == null ? "GEN7078E" : "GEN7076E";
            String errorMessage = MessageLog.getMessage((String)msgID, (Object[])args);
            MessageLog.getThreadLog().println(errorMessage);
            e.printStackTrace(MessageLog.getThreadLog());
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)this.CLASSNAME, (String)"logRuntimeException", (Object)errorMessage);
            }
            return errorMessage;
        }
    }
}

