/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server;

import java.io.PrintWriter;
import org.eclipse.aperi.backend.ThreadDumper;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.StateChangeReq;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.ClientSocket;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ServerSocketTransceiver;
import org.eclipse.aperi.server.ServiceManager;
import org.eclipse.aperi.xmsg.MessageLog;

class Router
implements Runnable {
    private static Thread[] routers = null;
    private static final int WAIT_TIME = 75000;
    private static PrintWriter logWriter;

    Router() {
    }

    protected static void startThreads(ThreadGroup serverThreadGroup, int threadCount) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Router.class.getName(), (String)"startThreads", (String)"serverThreadGroup, threadCount");
        }
        logWriter = MessageLog.getThreadLog();
        routers = new Thread[threadCount];
        for (int i = 0; i < threadCount; ++i) {
            Router r = new Router();
            Router.routers[i] = new Thread(serverThreadGroup, r, "Router-" + i);
            routers[i].setDaemon(true);
            routers[i].start();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Router.class.getName(), (String)"startThreads");
        }
    }

    protected static void stopThreads() {
        int i;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Router.class.getName(), (String)"stopThreads", (String)"");
        }
        if (routers == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Router.class.getName(), (String)"stopThreads");
            }
            return;
        }
        Server.routerQueue.setActive(false);
        for (i = 0; i < routers.length; ++i) {
            routers[i].interrupt();
        }
        for (i = 0; i < routers.length; ++i) {
            try {
                routers[i].join(75000L);
                continue;
            }
            catch (InterruptedException e) {
                if (!TraceLogger.enableTrace) continue;
                TraceLogger.exception((String)Router.class.getName(), (String)"stopThreads", (Throwable)e);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Router.class.getName(), (String)"stopThreads");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Router.class.getName(), (String)"run", (String)"");
        }
        MessageLog.setThreadLog((PrintWriter)logWriter);
        while (true) {
            ClientSocket clientSocket;
            if ((clientSocket = (ClientSocket)Server.routerQueue.get()) == null || clientSocket.socket == null) {
                MessageLog.logMessage((String)"SRV0026I");
                if (!TraceLogger.enableTrace) return;
                TraceLogger.exit((String)Router.class.getName(), (String)"run");
                return;
            }
            ServerSocketTransceiver transceiver = ServerSocketTransceiver.getServerSocketTransceiver(clientSocket.socket);
            clientSocket.returnClientSocket();
            clientSocket = null;
            Request request = transceiver.receiveRequest();
            if (request == null) {
                this.discard((Transceiver)transceiver);
                continue;
            }
            if (request.requestData instanceof StateChangeReq) {
                StateChangeReq data = (StateChangeReq)request.requestData;
                if (data.serviceProvider == "org.eclipse.aperi.server.svp.ServerSvp" && (data.newState == 3 || data.newState == 5)) {
                    Class<Server> clazz = Server.class;
                    // MONITORENTER : org.eclipse.aperi.server.Server.class
                    Response response = new Response(0, null);
                    transceiver.transmitResponse(request, response);
                    transceiver.close();
                    MessageLog.logMessage((String)"SRV0012I", (Object)Constants.shutdownType[data.newState]);
                    if (data.newState == 5) {
                        ThreadDumper.abort();
                    } else {
                        System.exit(0);
                    }
                    // MONITOREXIT : clazz
                    MessageLog.logMessage((String)"SRV0203E");
                    continue;
                }
            }
            if (Server.terminate != 0) {
                this.discard((Transceiver)transceiver);
                continue;
            }
            if ((request.flags & 4) == 0 && Server.connectionCount > Server.maxConnections) {
                ServiceManager.routingError(request, (Transceiver)transceiver, "SRV0025E", (short)8);
                continue;
            }
            Server.serviceMgr.routeRequest(request, (Transceiver)transceiver);
        }
    }

    private void discard(Transceiver transceiver) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Router.class.getName(), (String)"discard", (String)"transceiver");
        }
        transceiver.close();
        transceiver.returnTransceiver();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Router.class.getName(), (String)"discard");
        }
    }
}

