/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.aperi.agent.req.RunScriptReq;
import org.eclipse.aperi.common.MutableBoolean;
import org.eclipse.aperi.common.TSThread;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.ScriptQElement;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ServiceQueue;
import org.eclipse.aperi.xmsg.MessageLog;

public class ScriptSubmitter
implements Runnable {
    public static Thread thread;
    public static ServiceQueue queue;
    private ScriptQElement current;
    private boolean reQueueIt;
    private RunScriptReq requestData;

    public static void init(ThreadGroup threadGroup) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScriptSubmitter.class.getName(), (String)"init", (String)"threadGroup");
        }
        queue = new ServiceQueue();
        ScriptSubmitter self = new ScriptSubmitter();
        thread = new TSThread(threadGroup, (Runnable)self, "ScriptSubmitter");
        thread.start();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScriptSubmitter.class.getName(), (String)"init");
        }
    }

    public static byte[] loadFile(String path, MutableBoolean ok) {
        byte[] result;
        block11: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)ScriptSubmitter.class.getName(), (String)"loadFile", (String)"path, ok");
            }
            File file = new File(path);
            result = new byte[(int)file.length()];
            FileInputStream in = null;
            try {
                in = new FileInputStream(path);
            }
            catch (IOException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)ScriptSubmitter.class.getName(), (String)"loadFile", (Throwable)e);
                }
                MessageLog.logException((String)"GEN0029E", (Exception)e);
                ok.value = false;
            }
            if (in != null) {
                try {
                    ((InputStream)in).read(result);
                }
                catch (IOException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)ScriptSubmitter.class.getName(), (String)"loadFile", (Throwable)e);
                    }
                    MessageLog.logException((String)"GEN0133E", (Exception)e, (Object)path);
                    ok.value = false;
                }
                try {
                    ((InputStream)in).close();
                }
                catch (IOException ignored) {
                    if (!TraceLogger.enableTrace) break block11;
                    TraceLogger.exception((String)ScriptSubmitter.class.getName(), (String)"loadFile", (Throwable)ignored);
                }
            }
        }
        byte[] traceResult = result;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScriptSubmitter.class.getName(), (String)"loadFile", (Object)traceResult);
        }
        return traceResult;
    }

    private boolean submitRequest() {
        int i;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScriptSubmitter.class.getName(), (String)"submitRequest", (String)"");
        }
        String[] files = this.current.sqFiles;
        int length = files.length;
        this.requestData.scrData = new byte[length][];
        MutableBoolean good = new MutableBoolean(true);
        for (i = 0; good.value && i < length; ++i) {
            if (files[i] == null) continue;
            this.requestData.scrData[i] = ScriptSubmitter.loadFile(files[i], good);
        }
        for (i = 1; i < length; ++i) {
            File file = new File(files[i]);
            file.delete();
        }
        if (!good.value) {
            this.reQueueIt = false;
            boolean traceResult = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)ScriptSubmitter.class.getName(), (String)"submitRequest", (boolean)traceResult);
            }
            return traceResult;
        }
        Response response = Server.agentMgr.transmitToAgent(this.current.sqRequest, null, this.requestData.getComputerID(), false);
        boolean ok = false;
        this.reQueueIt = true;
        if (response != null) {
            if (response.status <= 4) {
                ok = true;
            } else {
                switch (response.status) {
                    case 12: 
                    case 16: 
                    case 34: {
                        this.reQueueIt = false;
                    }
                }
            }
        }
        if (!ok && this.reQueueIt) {
            --this.current.sqRetryCounter;
            if (this.current.sqRetryCounter <= 0) {
                this.reQueueIt = false;
            }
        }
        boolean traceResult = ok;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScriptSubmitter.class.getName(), (String)"submitRequest", (boolean)traceResult);
        }
        return traceResult;
    }

    public void run() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)ScriptSubmitter.class.getName(), (String)"run", (String)"");
        }
        while ((this.current = (ScriptQElement)queue.get()) != null) {
            this.requestData = (RunScriptReq)this.current.sqRequest.requestData;
            if (!this.submitRequest() && this.reQueueIt) {
                queue.add(this.current, false);
            }
            this.current = null;
            this.requestData = null;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)ScriptSubmitter.class.getName(), (String)"run");
        }
    }
}

