/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import org.eclipse.aperi.agent.req.AgentRequestData;
import org.eclipse.aperi.agent.req.AgentStatusReq;
import org.eclipse.aperi.common.Constants;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.StorageException;
import org.eclipse.aperi.common.TSThread;
import org.eclipse.aperi.common.Variables;
import org.eclipse.aperi.constants.metadata.RequestTypeManager;
import org.eclipse.aperi.guid.GUID;
import org.eclipse.aperi.identity.HardwareID;
import org.eclipse.aperi.identity.SingleInstance;
import org.eclipse.aperi.identity.SuperUser;
import org.eclipse.aperi.infrastructure.database.DBConnPoolDataSource;
import org.eclipse.aperi.logging.NativeLogManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.logging.TraceLoggerFactory;
import org.eclipse.aperi.repository.ConnectionPool;
import org.eclipse.aperi.repository.SQLUtil;
import org.eclipse.aperi.repository.table.TConfigSettings;
import org.eclipse.aperi.repository.table.TServer;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.AgentManager;
import org.eclipse.aperi.server.Alerter;
import org.eclipse.aperi.server.ConfigParser;
import org.eclipse.aperi.server.DeviceServerManager;
import org.eclipse.aperi.server.Listener;
import org.eclipse.aperi.server.Router;
import org.eclipse.aperi.server.ServerThreadGroup;
import org.eclipse.aperi.server.ServiceManager;
import org.eclipse.aperi.server.ServiceQueue;
import org.eclipse.aperi.server.guireq.ConfigSettings;
import org.eclipse.aperi.server.guireq.SmtpSettings;
import org.eclipse.aperi.xmsg.CurtailedWriter;
import org.eclipse.aperi.xmsg.LocalizableException;
import org.eclipse.aperi.xmsg.MessageLog;

public class Server {
    private static final String LOG_DIR = "log";
    public static boolean enableTrace = true;
    public static final ServiceManager serviceMgr = new ServiceManager();
    public static final AgentManager agentMgr = new AgentManager();
    public static DeviceServerManager devMgr;
    public static final String TEMP_DIR;
    public static final ServiceQueue routerQueue;
    public static Properties repositoryProperties;
    public static ConnectionPool connectionPool;
    public static ServerThreadGroup serverThreadGroup;
    private static PrintWriter logWriter;
    public static TServer serverIdentity;
    public static ServerSocket listenerSocket;
    public static Lock connectionCountLock;
    public static byte terminate;
    public static Thread thread;
    public static Date startTime;
    public static int connectionCount;
    public static Throwable fatalError;
    public static String name;
    public static String hostAlias;
    public static String repositoryDriver;
    public static String repositoryURL;
    public static HardwareID hardwareID;
    public static int connectionPoolSize;
    private static int listenerPort;
    public static int agentErrorLimit;
    public static int messagesPerLog;
    public static int logsKept;
    public static short maxConnections;
    public static short routerThreads;
    public static short serviceThreads;
    public static String adminGroup;
    public static int adminGID;
    public static boolean multipleMaintenance;
    public static String dupCompInfo;
    public static int instanceID;
    private static Thread listener;
    private static ConfigSettings settings;
    private static long uniqueTimestamp;
    private static String homeDirectory;
    private static final int CONNECTION_ATTEMPTS = 11;
    public static final String COMPUTER_LOCK_TYPE = "Computer";
    private static final int LOGFILE_ERROR = 8;
    private static final int CONFIGFILE_ERROR = 12;
    private static final int SERVICEMGR_ERROR = 16;
    private static final int LISTENER_ERROR = 20;
    private static final int AGENTMGR_ERROR = 24;
    private static final int REPOSITORY_ERROR = 28;
    public static final int REGISTRATION_ERROR = 32;
    private static final int CONFIG_ERROR = 36;
    private static final int LICENSEMGR_ERROR = 40;
    private static final int SERVER_DUP_ERROR = 44;
    private static final int AUTHORIZATION_ERROR = 48;
    private static final int NO_WORKING_DIRECTORY = 52;
    public static final int DB_CONNECTION_ERROR = 56;
    private static final String[] ERROR_MSGIDS;
    private static final String[] EMAIL_NOTIFICATION;
    public static GUID guidO;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        block35: {
            Variables.whoAmI = 1;
            try {
                logWriter = Server.initMessageLog("org.eclipse.aperi.server.svp.ServerSvp", true);
            }
            catch (Exception e) {
                MessageLog.logException((String)"SRV0001E", (Exception)e, (Object)Server.getLogFileName("org.eclipse.aperi.server.svp.ServerSvp"));
                Server.shutdown(8);
            }
            homeDirectory = System.getProperty("user.dir");
            if (homeDirectory == null) {
                MessageLog.logMessage((String)"GEN0041E", (Object)"user.dir");
                System.exit(52);
            }
            System.setProperty("data.baseDir", homeDirectory);
            try {
                SmtpSettings smtpSettings = TConfigSettings.getSmtpSettings();
                if (smtpSettings != null) {
                    settings = new ConfigSettings();
                    Server.settings.csSmtp = smtpSettings;
                }
            }
            catch (GeneralException ignored) {
                // empty catch block
            }
            String serverTraceConfig = homeDirectory + File.separator + "configuration" + File.separator + "ServerTraceLog.config";
            String traceFile = LOG_DIR + File.separator + "ServerTrace.log";
            String auditFile = LOG_DIR + File.separator + "AuditTrace.log";
            TraceLoggerFactory.initializeTraceLogger((String)serverTraceConfig, (String)traceFile, (String)auditFile);
            TSThread.setServiceID((String)"org.eclipse.aperi.server.svp.ServerSvp");
            TraceLoggerFactory.startLogger((String)"ITSRM.logger.trace.Server", (String)"org.eclipse.aperi.server.svp.ServerSvp");
            TraceLoggerFactory.startLogger((String)"ITSRM.logger.audit", (String)"org.eclipse.aperi.common.svp.AuditSvp");
            try {
                NativeLogManager.initServerTraceLogger();
            }
            catch (LocalizableException e) {
                e.print();
            }
            MessageLog.initNative();
            System.loadLibrary("DataServer");
            if (!SuperUser.check()) {
                Server.shutdown(48);
            }
            try {
                String instanceFile = Server.getInstanceFile();
                if (instanceFile == null) break block35;
                try {
                    instanceID = Integer.parseInt(instanceFile.substring(8, instanceFile.length() - 4));
                }
                catch (NumberFormatException ignored) {
                    // empty catch block
                }
                int pid = SingleInstance.check((String)instanceFile, (int)0);
                if (pid != 0) {
                    String processInfo = "";
                    if (pid > 0) {
                        processInfo = MessageLog.getMessageNoID((String)"SRV0116E", (Object)String.valueOf(pid));
                    }
                    MessageLog.logMessage((String)"SRV0115E", (Object)processInfo);
                    Server.shutdown(44);
                }
            }
            catch (LocalizableException e) {
                e.print();
                Server.shutdown(44);
            }
        }
        Server.cleanupTempDir();
        new File(TEMP_DIR).mkdir();
        String configFile = args.length > 0 ? args[0] : "server.config";
        String passwordFile = "configuration" + File.separator + "repository.config";
        MessageLog.logMessage((String)"SRV0011I", (Object)configFile);
        SingleInstance.logPID();
        ConfigParser parser = new ConfigParser("configuration" + File.separator + configFile, passwordFile);
        if (!parser.parse()) {
            Server.shutdown(12);
        }
        name = parser.name;
        hostAlias = parser.hostAlias;
        repositoryDriver = parser.repositoryDriver;
        repositoryURL = parser.repositoryURL;
        hardwareID = parser.hardwareID;
        connectionPoolSize = parser.connectionPoolSize;
        listenerPort = parser.listenerPort;
        agentErrorLimit = parser.agentErrorLimit;
        messagesPerLog = parser.messagesPerLog;
        logsKept = parser.logsKept;
        maxConnections = parser.maxConnections;
        routerThreads = parser.routerThreads;
        serviceThreads = parser.serviceThreads;
        adminGroup = parser.adminGroup;
        repositoryProperties = parser.repositoryProperties;
        multipleMaintenance = parser.multipleMaintenance;
        dupCompInfo = parser.dupCompInfo;
        Variables.server = "localhost";
        Variables.port = listenerPort;
        passwordFile = null;
        SQLUtil.setRepositoryType(repositoryDriver);
        if (SQLUtil.isSybase()) {
            repositoryProperties.put("charset", "iso_1");
        }
        parser = null;
        if (SQLUtil.isCloudscape()) {
            System.setProperty("db2j.system.home", System.getProperty("user.dir", ".") + File.separatorChar + "cloudscape");
            System.setProperty("db2j.storage.pageCacheSize", "160");
            System.setProperty("db2j.language.spsCacheSize", "50");
            System.setProperty("db2j.language.stalePlanCheckInterval", "5");
        }
        try {
            connectionPool = new ConnectionPool(repositoryDriver, repositoryURL, repositoryProperties, connectionPoolSize);
        }
        catch (SQLException e) {
            SQLUtil.logSQLException("SRV0048E", e, new Object[]{repositoryURL});
            Server.shutdown(28);
        }
        catch (Exception e) {
            MessageLog.logException((String)"SRV0047E", (Exception)e, (Object)repositoryDriver);
            Server.shutdown(28);
        }
        guidO = GUID.readGUID();
        if (!Server.isRepositoryAvailable()) {
            Server.shutdown(56);
        }
        Server.initDBHelper();
        try {
            String guid = guidO != null ? guidO.toNoDotString() : null;
            serverIdentity = new TServer(hostAlias, listenerPort, name, hardwareID, guid);
        }
        catch (GeneralException e) {
            Server.shutdown(32);
        }
        if (!serverIdentity.registerServer()) {
            Server.shutdown(32);
        }
        if (SQLUtil.isMSSQL()) {
            Connection dbc = Server.getConnection();
            try {
                SQLUtil.handleMSSQL(dbc);
            }
            finally {
                Server.returnConnection(dbc);
            }
        }
        Server.initIDs();
        devMgr = DeviceServerManager.getDeviceServerManager();
        if (!agentMgr.init()) {
            Server.shutdown(24);
        }
        Server.broadcastLocation(false);
        serverThreadGroup = new ServerThreadGroup("Server");
        try {
            settings = Server.fetchSettings();
        }
        catch (GeneralException e) {
            MessageLog.getThreadLog().println(e.getMessage());
            Server.shutdown(36);
        }
        Alerter.startThreads(serverThreadGroup);
        if (!serviceMgr.initialize()) {
            Server.shutdown(16);
        }
        Router.startThreads(serverThreadGroup, routerThreads);
        listener = new Listener(serverThreadGroup);
        try {
            listener.join(0L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        Server.shutdown(terminate > 0 ? 0 : 20);
    }

    private static void initDBHelper() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Server.class.getName(), (String)"initDBHelper", (String)"");
        }
        String dbSchema = repositoryProperties.getProperty("schema");
        String user = repositoryProperties.getProperty("user");
        String password = repositoryProperties.getProperty("password");
        String connPool = repositoryProperties.getProperty("connectionpool");
        if (repositoryDriver == null || repositoryURL == null || dbSchema == null || user == null || password == null || connPool == null) {
            GeneralException ge = new GeneralException(MessageLog.getMessage((String)"DBA0043E"));
            if (TraceLogger.enableTrace) {
                String msg = "\n\t trepositoryDrive = " + repositoryDriver + "\n\t repositoryURL = " + repositoryURL + "\n\t dbSchema = " + dbSchema + "\n\t user = " + user + "\n\t password = " + password != null ? "xxx" : null + "\n\t connPool = " + connPool;
                TraceLogger.traceMessage((int)1, (String)Server.class.getName(), (String)"initDBHelper()", (String)msg);
                TraceLogger.exit((String)Server.class.getName(), (String)"initDBHelper", (Object)"");
            }
            throw ge;
        }
        int connPoolCount = new Integer(connPool);
        DBConnPoolDataSource.initialize((String)repositoryDriver, (String)repositoryURL, (String)dbSchema, (String)user, (String)password, (int)connPoolCount);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isRepositoryAvailable() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Server.class.getName(), (String)"isRepositoryAvailable", (String)"");
        }
        Connection dbc = null;
        int counter = 0;
        boolean status = false;
        try {
            do {
                if (counter <= 0) continue;
                try {
                    MessageLog.logMessage((String)"SRV0178I");
                    Thread.sleep(30000L);
                }
                catch (InterruptedException ignored) {
                    if (!TraceLogger.enableTrace) continue;
                    TraceLogger.exception((String)Server.class.getName(), (String)"registerServer", (Throwable)ignored);
                }
            } while ((dbc = Server.getConnection()) == null && ++counter < 11);
            status = dbc != null;
        }
        finally {
            Server.returnConnection(dbc);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Server.class.getName(), (String)"registerServer", (boolean)status);
        }
        return status;
    }

    public static int broadcastLocation(boolean force) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Server.class.getName(), (String)"broadcastLocation", (String)"force");
        }
        if (!Server.serverIdentity.serverRelocated && !force) {
            int traceResult = 0;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Server.class.getName(), (String)"broadcastLocation", (int)traceResult);
            }
            return traceResult;
        }
        MessageLog.logMessage((String)"SRV0062I");
        int agentErrors = 0;
        Response response = Response.getResponse((short)0, null);
        Request agentRequest = new Request();
        Server.setAgentRequest(agentRequest, "org.eclipse.aperi.agent.handler.status.StatusHandler");
        agentRequest.requestData = new AgentStatusReq(false);
        AgentManager.AgentAddress agent = new AgentManager.AgentAddress();
        Iterator i = agentMgr.listAgents(agent);
        while (i.hasNext()) {
            byte state;
            agent = (AgentManager.AgentAddress)i.next();
            if (agent.computerID < 1 || agent.state == 2) continue;
            Response agentResponse = agentMgr.transmitToAgent(agentRequest, null, agent.computerID, true);
            if (agentResponse == null || agentResponse.status == 12) {
                ++agentErrors;
                state = 0;
            } else {
                if (agentResponse.status == 16) {
                    ++agentErrors;
                    continue;
                }
                state = 1;
            }
            if (state == agent.state) continue;
            agentMgr.setState(agent.computerID, state);
        }
        MessageLog.logMessage((String)"SRV0063I");
        response.returnResponse();
        int traceResult = agentErrors;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Server.class.getName(), (String)"broadcastLocation", (int)traceResult);
        }
        return traceResult;
    }

    protected static void setAgentRequest(Request request, String requestHandler) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Server.class.getName(), (String)"setAgentRequest", (String)"request, subType");
        }
        AgentRequestData data = new AgentRequestData();
        request.typeCode = "org.eclipse.aperi.agent.svp.AgentSvp";
        request.subType = requestHandler;
        request.machineName = Server.serverIdentity.computer.tsName;
        request.requestData = data;
        data.setServerPort(Server.serverIdentity.serverPort);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Server.class.getName(), (String)"setAgentRequest");
        }
    }

    protected static AgentRequestData setAgentRequestData(AgentRequestData data, int computerID) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Server.class.getName(), (String)"setAgentRequestData", (String)"data, computerID");
        }
        data.setServerPort(Server.serverIdentity.serverPort);
        data.setServerToken(Server.serverIdentity.serverToken);
        data.setComputerID(computerID);
        AgentRequestData traceResult = data;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Server.class.getName(), (String)"setAgentRequestData", (Object)traceResult);
        }
        return traceResult;
    }

    public static PrintWriter initMessageLog(String requestTypeCode) throws IOException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Server.class.getName(), (String)"initMessageLog", (String)"requestTypeCode");
        }
        PrintWriter traceResult = Server.initMessageLog(requestTypeCode, false);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Server.class.getName(), (String)"initMessageLog", (Object)traceResult);
        }
        return traceResult;
    }

    private static PrintWriter initMessageLog(String requestTypeCode, boolean redirectErrOut) throws IOException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Server.class.getName(), (String)"initMessageLog", (String)"requestTypeCode, redirectErrOut");
        }
        String logFile = Server.getLogFileName(requestTypeCode);
        CurtailedWriter logger = null;
        logger = new CurtailedWriter(logFile, 0, 0, redirectErrOut);
        logger.setParms(logsKept, messagesPerLog);
        if (redirectErrOut) {
            MessageLog.logMessage((String)"GEN0198I", (Object)"Server");
        }
        MessageLog.setThreadLog((PrintWriter)logger);
        CurtailedWriter traceResult = logger;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Server.class.getName(), (String)"initMessageLog", (Object)traceResult);
        }
        return traceResult;
    }

    public static String getLogFileName(String requestTypeCode) {
        return LOG_DIR + File.separator + RequestTypeManager.getLogPrefix((String)requestTypeCode);
    }

    public static String getLogDir() {
        return LOG_DIR;
    }

    public static short getOSType() {
        return Server.serverIdentity.computer.hwID.osType;
    }

    public static ServerThreadGroup getServerTG() {
        return serverThreadGroup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ConfigSettings fetchSettings() throws GeneralException {
        Connection dbc;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Server.class.getName(), (String)"fetchSettings", (String)"");
        }
        if ((dbc = Server.getConnection()) == null) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Server.class.getName(), (String)"fetchSettings");
            }
            throw new GeneralException();
        }
        try {
            TConfigSettings csAccessor = new TConfigSettings(dbc);
            ConfigSettings traceResult = csAccessor.getConfigSettings();
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)Server.class.getName(), (String)"fetchSettings", (Object)traceResult);
            }
            ConfigSettings configSettings = traceResult;
            return configSettings;
        }
        finally {
            Server.returnConnection(dbc);
        }
    }

    public static ConfigSettings getSettings() {
        return settings;
    }

    public static void updateSettings(ConfigSettings pSettings) {
        settings = pSettings;
    }

    private static void shutdown(int status) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Server.class.getName(), (String)"shutdown", (String)"status");
        }
        if (terminate == 0) {
            terminate = 1;
        }
        if (status == 0) {
            MessageLog.logMessage((String)"SRV0012I", (Object)Constants.shutdownType[terminate]);
        } else {
            MessageLog.logMessage((String)"SRV0014E", (Object)new Integer(status));
            int index = (status >> 2) - 1;
            if (index < ERROR_MSGIDS.length) {
                String errorMsgID = null;
                if (ERROR_MSGIDS[index] != null) {
                    errorMsgID = ERROR_MSGIDS[index];
                    MessageLog.logMessage((String)errorMsgID);
                }
            }
            if (index < EMAIL_NOTIFICATION.length && EMAIL_NOTIFICATION[index] != null) {
                Object[] args = new Object[]{((CurtailedWriter)logWriter).getCurrentFileName(), homeDirectory, new Date()};
                Alerter.shutdownNotification("SRV0180M", EMAIL_NOTIFICATION[index], args);
            }
        }
        serviceMgr.terminate(terminate);
        Alerter.stopThreads(terminate);
        Router.stopThreads();
        if (connectionPool != null) {
            connectionPool.freePool();
        }
        Server.cleanupTempDir();
        if (fatalError != null) {
            Object[] args = new Object[]{((CurtailedWriter)logWriter).getCurrentFileName(), homeDirectory, new Date()};
            Alerter.shutdownNotification("SRV0180M", "SRV0181M", args);
            if (fatalError instanceof OutOfMemoryError) {
                MessageLog.logMessage((String)"SRV0179E");
            }
        }
        MessageLog.logMessage((String)"SRV0013I");
        if (logWriter != null) {
            logWriter.close();
        }
        TraceLoggerFactory.stopLogger((String)"org.eclipse.aperi.server.svp.ServerSvp");
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Server.class.getName(), (String)"shutdown");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void bumpConnectionCount(int i) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Server.class.getName(), (String)"bumpConnectionCount", (String)"i");
        }
        Lock lock = connectionCountLock;
        synchronized (lock) {
            connectionCount += i;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Server.class.getName(), (String)"bumpConnectionCount");
        }
    }

    public static Connection getConnection() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Server.class.getName(), (String)"getConnection", (String)"");
        }
        Connection traceResult = connectionPool.getConnection(true);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Server.class.getName(), (String)"getConnection", (Object)traceResult);
        }
        return traceResult;
    }

    public static Connection getConnection(boolean messageWanted) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Server.class.getName(), (String)"getConnection", (String)"messageWanted");
        }
        Connection traceResult = connectionPool.getConnection(messageWanted);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Server.class.getName(), (String)"getConnection", (Object)traceResult);
        }
        return traceResult;
    }

    public static void returnConnection(Connection dbConnection) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Server.class.getName(), (String)"returnConnection", (String)"dbConnection");
        }
        connectionPool.returnConnection(dbConnection);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Server.class.getName(), (String)"returnConnection");
        }
    }

    public static String getUdbSchema() {
        return Server.connectionPool.udbSqlid;
    }

    public static int getServerID() {
        return Server.serverIdentity.serverID;
    }

    public static int getServerComputerID() {
        return Server.serverIdentity.computer.computerID;
    }

    public static long getServerToken() {
        return Server.serverIdentity.serverToken;
    }

    public static String getServerName() {
        return Server.serverIdentity.serverName;
    }

    public static String getServerHostName() {
        return Server.serverIdentity.computer.hwID.hostName;
    }

    public static boolean isWindows() {
        return Constants.isWindows((short)Server.serverIdentity.computer.hwID.osType);
    }

    private static native void initIDs();

    public static AgentManager getAgentManager() {
        return agentMgr;
    }

    public static DeviceServerManager getDeviceServerManager() {
        return devMgr;
    }

    public static ServiceManager getServiceManager() {
        return serviceMgr;
    }

    public static String getHomeDirectory() {
        return homeDirectory;
    }

    public static PrintWriter getLogWriter() {
        return logWriter;
    }

    public static int getListenerPort() {
        return listenerPort;
    }

    public static void setResponseWarning(Response response, Exception e) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Server.class.getName(), (String)"setResponseWarning", (String)"response, e");
        }
        response.status = (short)4;
        if (e instanceof StorageException) {
            response.setException((StorageException)e);
        } else {
            response.errorMessage = e.getMessage();
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Server.class.getName(), (String)"setResponseWarning");
        }
    }

    public static void setResponseWarning(Response response, String msgID, Object[] args) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Server.class.getName(), (String)"setResponseWarning", (String)"response, msgID, args");
        }
        response.status = (short)4;
        response.errorMessage = MessageLog.getMessage((String)msgID, (Object[])args);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Server.class.getName(), (String)"setResponseWarning");
        }
    }

    public static void setResponseWarning(Response response, String msgID) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Server.class.getName(), (String)"setResponseWarning", (String)"response, msgID");
        }
        Server.setResponseWarning(response, msgID, null);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Server.class.getName(), (String)"setResponseWarning");
        }
    }

    public static void setResponseWarning(Response response, String msgID, Object parm1) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Server.class.getName(), (String)"setResponseWarning", (String)"response, msgID, parm1");
        }
        Object[] args = new Object[]{parm1};
        Server.setResponseWarning(response, msgID, args);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Server.class.getName(), (String)"setResponseWarning");
        }
    }

    public static void setResponseWarning(Response response, String msgID, Object parm1, Object parm2) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Server.class.getName(), (String)"setResponseWarning", (String)"response, msgID, parm1, parm2");
        }
        Object[] args = new Object[]{parm1, parm2};
        Server.setResponseWarning(response, msgID, args);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Server.class.getName(), (String)"setResponseWarning");
        }
    }

    public static void setResponseError(Response response, Exception e) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Server.class.getName(), (String)"setResponseError", (String)"response, e");
        }
        response.status = (short)12;
        if (e instanceof StorageException) {
            response.setException((StorageException)e);
        } else {
            response.errorMessage = e.getMessage();
        }
        response.responseData = null;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Server.class.getName(), (String)"setResponseError");
        }
    }

    public static void setResponseError(Response response, String msgID, Object[] args) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Server.class.getName(), (String)"setResponseError", (String)"response, msgID, args");
        }
        response.status = (short)12;
        response.errorMessage = MessageLog.getMessage((String)msgID, (Object[])args);
        response.responseData = null;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Server.class.getName(), (String)"setResponseError");
        }
    }

    public static void setResponseError(Response response, String msgID) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Server.class.getName(), (String)"setResponseError", (String)"response, msgID");
        }
        Server.setResponseError(response, msgID, null);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Server.class.getName(), (String)"setResponseError");
        }
    }

    public static void setResponseError(Response response, String msgID, Object parm1) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Server.class.getName(), (String)"setResponseError", (String)"response, msgID, parm1");
        }
        Object[] args = new Object[]{parm1};
        Server.setResponseError(response, msgID, args);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Server.class.getName(), (String)"setResponseError");
        }
    }

    public static void setResponseError(Response response, String msgID, Object parm1, Object parm2) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Server.class.getName(), (String)"setResponseError", (String)"response, msgID, parm1, parm2");
        }
        Object[] args = new Object[]{parm1, parm2};
        Server.setResponseError(response, msgID, args);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Server.class.getName(), (String)"setResponseError");
        }
    }

    private static void cleanupTempDir() {
        File[] tmpFiles;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Server.class.getName(), (String)"cleanupTempDir", (String)"");
        }
        if ((tmpFiles = new File(TEMP_DIR).listFiles()) != null) {
            for (int i = 0; i < tmpFiles.length; ++i) {
                tmpFiles[i].delete();
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Server.class.getName(), (String)"cleanupTempDir");
        }
    }

    public static synchronized long getUniqueTimestamp() {
        long ts;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Server.class.getName(), (String)"getUniqueTimestamp", (String)"");
        }
        uniqueTimestamp = (ts = System.currentTimeMillis()) == uniqueTimestamp ? ++uniqueTimestamp : ts;
        long traceResult = uniqueTimestamp;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Server.class.getName(), (String)"getUniqueTimestamp", (long)traceResult);
        }
        return traceResult;
    }

    protected static String getInstanceFile() {
        File file;
        String[] instanceFiles;
        String traceResult;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)Server.class.getName(), (String)"getInstanceFile", (String)"");
        }
        String string = traceResult = (instanceFiles = (file = new File(System.getProperty("user.dir", "."))).list(new InstanceFileFilter())) != null && instanceFiles.length > 0 ? instanceFiles[0] : null;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)Server.class.getName(), (String)"getInstanceFile", (Object)traceResult);
        }
        return traceResult;
    }

    public static String getDupCompInfo() {
        return dupCompInfo;
    }

    static {
        TEMP_DIR = "tmp" + File.separator;
        routerQueue = new ServiceQueue();
        connectionCountLock = new Lock();
        terminate = 0;
        thread = Thread.currentThread();
        startTime = new Date();
        connectionCount = 0;
        connectionPoolSize = 5;
        listenerPort = 3123;
        agentErrorLimit = 0;
        messagesPerLog = 1000000;
        logsKept = 5;
        maxConnections = (short)200;
        routerThreads = 1;
        serviceThreads = (short)2;
        adminGroup = null;
        adminGID = 4;
        multipleMaintenance = false;
        dupCompInfo = "";
        uniqueTimestamp = System.currentTimeMillis();
        ERROR_MSGIDS = new String[]{null, null, null, null, null, null, null, null, null, null, null, null, null, "SRV0177E"};
        EMAIL_NOTIFICATION = new String[]{null, null, "SRV0181M", "SRV0181M", "SRV0181M", "SRV0181M", "SRV0181M", "SRV0181M", "SRV0181M", "SRV0181M", null, "SRV0181M", "SRV0181M", "SRV0182M"};
        guidO = null;
    }

    private static class InstanceFileFilter
    implements FilenameFilter {
        private InstanceFileFilter() {
        }

        public boolean accept(File dir, String name) {
            return name.startsWith("INSTANCE") && name.endsWith(".DAT");
        }
    }

    private static class Lock {
        private Lock() {
        }
    }
}

