/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui;

import java.sql.Connection;
import org.eclipse.aperi.backend.LockManager;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.TSThread;
import org.eclipse.aperi.constants.metadata.ResourceTypeManager;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.StorageRepositoryAccessor;
import org.eclipse.aperi.repository.table.TGroup;
import org.eclipse.aperi.repository.table.TGroup2Mask;
import org.eclipse.aperi.repository.table.TGroup2Res;
import org.eclipse.aperi.repository.table.TResAttr;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.scheduler.ScheduleQueue;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.guireq.ResourceAttribute;
import org.eclipse.aperi.server.handler.gui.GroupDefHndlr;
import org.eclipse.aperi.server.jobs.Aggregator;
import org.eclipse.aperi.xmsg.MessageLog;

public class GroupDeleteHndlr
implements RequestHandler,
ThrowAway,
Runnable {
    private int groupID;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response handle(Request request, Transceiver transceiver) {
        Response response;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GroupDeleteHndlr.class.getName(), (String)"handle", (String)"request, transceiver");
        }
        if (!RequestChecker.isDesiredType(NameList.class, (Request)request, (Response)(response = Response.getResponse((short)0, null)))) {
            Response traceResult = response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)GroupDeleteHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        NameList toDelete = (NameList)request.requestData;
        String objectType = GroupDefHndlr.translateGroup(toDelete.nlInfo, response);
        if (objectType == null) {
            Response traceResult = response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)GroupDeleteHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        this.groupID = toDelete.nlID;
        LockManager.lock((short)0, (String)"GLOBAL", (String)"DELETE", (byte)1, (boolean)true);
        Connection dbc = Server.getConnection();
        try {
            int defaultGroup;
            if (GroupDefHndlr.whichGroup(toDelete.nlInfo) == GroupDefHndlr.MONITORING_GROUP) {
                TGroup accessor = new TGroup(dbc);
                accessor.revertToDefaultGroup(ResourceTypeManager.getGroupTable((short)toDelete.nlInfo), this.groupID, ResourceTypeManager.getDefaultGroup((short)toDelete.nlInfo));
                accessor = new TGroup(dbc);
                accessor.deleteByID(this.groupID, objectType);
                accessor = null;
                TGroup2Res g2r_accessor = new TGroup2Res(dbc);
                g2r_accessor.deleteResources(this.groupID, toDelete.nlInfo, true);
                TResAttr attrAccessor = new TResAttr(dbc);
                attrAccessor.prepDelete();
                ResourceAttribute attr = new ResourceAttribute();
                attr.raResourceID = this.groupID;
                attr.raResourceType = toDelete.nlInfo;
                attrAccessor.delete(attr);
            } else {
                TGroup2Res g2r_accessor = new TGroup2Res(dbc);
                g2r_accessor.deleteResources(this.groupID, toDelete.nlInfo, true);
                TGroup2Mask g2m = new TGroup2Mask(dbc);
                g2m.deleteMasksByGID(this.groupID, false);
                TGroup accessor = new TGroup(dbc);
                accessor.deleteByID(this.groupID, objectType);
                accessor.commit();
            }
            if (TraceLogger.enableAudit) {
                TraceLogger.auditMessage((String)GroupDeleteHndlr.class.getName(), (String)"handle()", (String)("\nUsername=" + request.userName + " Delete Group.  Group name='" + toDelete.nlName + "'"));
            }
            if ((defaultGroup = ResourceTypeManager.getDefaultGroup((short)toDelete.nlInfo)) == 3 || defaultGroup == 4) {
                ScheduleQueue.routine.rebuild();
            }
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)GroupDeleteHndlr.class.getName(), (String)"handle", (Throwable)e);
            }
            Server.setResponseError(response, (Exception)((Object)e));
        }
        finally {
            Server.returnConnection(dbc);
            LockManager.unLock((short)0, (String)"GLOBAL", (String)"DELETE");
        }
        if ((toDelete.nlInfo == 2 || toDelete.nlInfo == 0) && response.status <= 4) {
            TSThread thread = new TSThread(Thread.currentThread().getThreadGroup(), (Runnable)this);
            thread.start();
        }
        Response traceResult = response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GroupDeleteHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GroupDeleteHndlr.class.getName(), (String)"run", (String)"");
        }
        String whereClause = " WHERE filesystem_id = " + Integer.toString(this.groupID);
        Connection dbc = Server.getConnection();
        try {
            StorageRepositoryAccessor deleter = new StorageRepositoryAccessor(dbc);
            for (int i = 0; i < Aggregator.AGGREGATED_FS_HISTORY.length; ++i) {
                deleter.delete(Aggregator.AGGREGATED_FS_HISTORY[i], whereClause);
            }
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)GroupDeleteHndlr.class.getName(), (String)"run", (Throwable)e);
            }
            MessageLog.getThreadLog().println(e.getMessage());
        }
        finally {
            Server.returnConnection(dbc);
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GroupDeleteHndlr.class.getName(), (String)"run");
        }
    }
}

