/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui;

import java.lang.reflect.UndeclaredThrowableException;
import org.apache.soap.SOAPException;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.common.api.RemoteException;
import org.eclipse.aperi.common.api.SRMException;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.SRMRuntimeException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThreadSafe;
import org.eclipse.aperi.server.handler.DeviceRequestHndlr;

public abstract class GuiDeviceRequestHndlr
extends DeviceRequestHndlr
implements ThreadSafe {
    private static final String SOAP_PROTOCOL = "SOAP-ENV:Protocol";
    private static final String SOAP_CLIENT = "SOAP-ENV:Client";

    private final String asString(Object obj) {
        if (obj == null) {
            return "Null ";
        }
        try {
            return obj.toString();
        }
        catch (Exception e) {
            return obj.getClass().getName();
        }
    }

    protected final void logEnter(String method, Object arg1) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)this.getClass().getName(), (String)method, (String)this.asString(arg1));
        }
    }

    protected final void logEnter(String method, Object arg1, Object arg2) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)this.getClass().getName(), (String)method, (String)(this.asString(arg1) + this.asString(arg2)));
        }
    }

    protected final void logEnter(String method, Object arg1, Object arg2, Object arg3) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)this.getClass().getName(), (String)method, (String)(this.asString(arg1) + this.asString(arg2) + this.asString(arg3)));
        }
    }

    protected final void logExit(String method) {
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)this.getClass().getName(), (String)method);
        }
    }

    protected final void logExit(String method, Object retval) {
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)this.getClass().getName(), (String)method, (Object)this.asString(retval));
        }
    }

    protected final void logMessage(String method, Object msg1) {
        if (TraceLogger.enableTrace) {
            TraceLogger.traceMessage((int)1, (String)this.getClass().getName(), (String)method, (String)this.asString(msg1));
        }
    }

    protected final void logMessage(String method, Object msg1, Object msg2) {
        if (TraceLogger.enableTrace) {
            TraceLogger.traceMessage((int)1, (String)this.getClass().getName(), (String)method, (String)(this.asString(msg1) + this.asString(msg2)));
        }
    }

    protected final void logException(String method, Exception e) {
        if (TraceLogger.enableTrace) {
            TraceLogger.exception((String)this.getClass().getName(), (String)method, (Throwable)e);
        }
    }

    public int deviceAPI(DeviceRequest request, Response response) {
        String method = "deviceAPI";
        this.logEnter(method, request, response);
        try {
            this.processRequest(request, response);
        }
        catch (Exception e) {
            this.logException(method, e);
            this.setResponseErrorFromException(response, e);
        }
        this.logExit(method);
        return 0;
    }

    protected abstract void processRequest(DeviceRequest var1, Response var2) throws RemoteException;

    protected void setResponseErrorFromException(Response response, Throwable t) {
        SOAPException se;
        String errorID = null;
        String[] params = null;
        if (t instanceof UndeclaredThrowableException) {
            t = ((UndeclaredThrowableException)t).getUndeclaredThrowable();
        }
        if (t instanceof SRMException || t instanceof SRMRuntimeException) {
            SRMMessage tpcMes = t instanceof SRMException ? ((SRMException)t).getSRMMessage() : ((SRMRuntimeException)t).getSRMMessage();
            errorID = tpcMes.getMsgId();
            params = tpcMes.getMsgInserts();
        } else if (t instanceof SOAPException && ((se = (SOAPException)t).getFaultCode().equals(SOAP_CLIENT) || se.getFaultCode().equals(SOAP_PROTOCOL))) {
            errorID = "GUI8223E";
            params = null;
        }
        if (errorID == null) {
            errorID = "GUI8224E";
            params = new String[]{t.toString()};
        }
        Server.setResponseError(response, errorID, params);
    }
}

