/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui;

import java.sql.Connection;
import org.eclipse.aperi.TStorm.common.ProbePing;
import org.eclipse.aperi.TStorm.common.Settings;
import org.eclipse.aperi.TStorm.server.guireq.GuiListReq;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.CreateHeader;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.common.NameList;
import org.eclipse.aperi.common.ScheduleHeader;
import org.eclipse.aperi.common.StorageException;
import org.eclipse.aperi.infrastructure.database.DBConstants;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.repository.CommunitiesSaver;
import org.eclipse.aperi.repository.RaceConditionChecker;
import org.eclipse.aperi.repository.table.TAlertDefinition;
import org.eclipse.aperi.repository.table.TResIpAddresses;
import org.eclipse.aperi.repository.table.TSchedule;
import org.eclipse.aperi.repository.table.TSnmpCommunity;
import org.eclipse.aperi.repository.table.TStormSettings;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.scheduler.ScheduleQueue;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.jobs.Ping;
import org.eclipse.aperi.xmsg.MessageLog;

public class GuiDiscoveryHndlr
implements RequestHandler,
ThrowAway {
    private String scheduleType;
    private ProbePing requestData;
    private Connection dbc;
    private Response response;
    private final String RES_CIMOM_DISCOVERY_KEY = "SLP Directory agent IP";
    private final String RES_SNMP_DISCOVERY_KEY = "SNMP TRAP IP";

    private void retrieve() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiDiscoveryHndlr.class.getName(), (String)"retrieve", (String)"");
        }
        TSchedule accessor = new TSchedule(this.dbc);
        accessor.retrieve((ScheduleHeader)this.requestData, this.scheduleType);
        accessor = null;
        TAlertDefinition alertAccessor = new TAlertDefinition(this.dbc);
        alertAccessor.prepSelectByID(false, false);
        this.requestData.pbAlert = alertAccessor.getByID(this.requestData.ID);
        alertAccessor.closeSelect();
        switch (this.requestData.jobType) {
            case 32: {
                try {
                    TStormSettings settingsAccessor = new TStormSettings(this.dbc);
                    Settings settings = settingsAccessor.getSettings();
                    this.requestData.pbAllComputers = !settings.seNoWkstaDiscovery;
                    TSnmpCommunity snmpAccessor = new TSnmpCommunity(this.dbc);
                    this.requestData.pbSnmpCommunities = snmpAccessor.getCommunities();
                    break;
                }
                catch (GeneralException ex) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiDiscoveryHndlr.class.getName(), (String)"save", (Throwable)ex);
                    }
                    throw ex;
                }
            }
            case 104: {
                try {
                    NameList list;
                    GuiListReq req = new GuiListReq();
                    String type = DBConstants.getValueFromKey((String)"IP_Address_Type", (String)"SLP Directory agent IP");
                    req.listRequested = Integer.parseInt(type);
                    TResIpAddresses ipAddressesHelper = new TResIpAddresses();
                    this.requestData.pbManualSlpDAs = list = ipAddressesHelper.selectNames(req);
                    break;
                }
                catch (GeneralException ex) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiDiscoveryHndlr.class.getName(), (String)"save", (Throwable)ex);
                    }
                    throw ex;
                }
            }
            case 105: {
                try {
                    NameList list;
                    GuiListReq req = new GuiListReq();
                    String type = DBConstants.getValueFromKey((String)"IP_Address_Type", (String)"SNMP TRAP IP");
                    req.listRequested = Integer.parseInt(type);
                    TResIpAddresses ipAddressesHelper = new TResIpAddresses();
                    this.requestData.pbSnmpIPAddresses = list = ipAddressesHelper.selectNames(req);
                    break;
                }
                catch (GeneralException ex) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiDiscoveryHndlr.class.getName(), (String)"save", (Throwable)ex);
                    }
                    throw ex;
                }
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiDiscoveryHndlr.class.getName(), (String)"retrieve");
        }
    }

    private void save() throws GeneralException {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiDiscoveryHndlr.class.getName(), (String)"save", (String)"");
        }
        String checkerWarning = null;
        RaceConditionChecker checker = new RaceConditionChecker(this.dbc, "t_schedule", TSchedule.ID_COLUMN_NAME, (CreateHeader)this.requestData, this.scheduleType);
        checker.check();
        checkerWarning = checker.message;
        boolean rowExists = !checker.wasDeleted;
        checker = null;
        this.requestData.alertID = this.requestData.ID;
        TAlertDefinition alertAccessor = new TAlertDefinition(this.dbc);
        if (rowExists) {
            alertAccessor.deleteByID(this.requestData.ID);
        }
        alertAccessor.insert((CreateHeader)this.requestData, this.requestData.pbAlert);
        alertAccessor = null;
        TSchedule accessor = new TSchedule(this.dbc);
        if (rowExists) {
            accessor.deleteByID(this.requestData.ID, this.scheduleType);
        }
        ScheduleQueue.routine.getHighRunNumber((ScheduleHeader)this.requestData);
        accessor.insert((ScheduleHeader)this.requestData, this.scheduleType);
        accessor.commit();
        accessor = null;
        switch (this.requestData.jobType) {
            case 32: {
                try {
                    Settings settings = new Settings();
                    settings.seNoWkstaDiscovery = !this.requestData.pbAllComputers;
                    TStormSettings settingsAccessor = new TStormSettings(this.dbc);
                    settingsAccessor.updateDiscovery(settings);
                    CommunitiesSaver.save(this.dbc, this.requestData.pbSnmpCommunities);
                    break;
                }
                catch (GeneralException ex) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiDiscoveryHndlr.class.getName(), (String)"save", (Throwable)ex);
                    }
                    throw ex;
                }
            }
            case 104: {
                try {
                    TResIpAddresses ipAddressesHelper = new TResIpAddresses();
                    String type = DBConstants.getValueFromKey((String)"IP_Address_Type", (String)"SLP Directory agent IP");
                    ipAddressesHelper.update(this.requestData.pbManualSlpDAs, Integer.parseInt(type));
                    break;
                }
                catch (GeneralException ex) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiDiscoveryHndlr.class.getName(), (String)"save", (Throwable)ex);
                    }
                    throw ex;
                }
            }
            case 105: {
                try {
                    TResIpAddresses ipAddressesHelper = new TResIpAddresses();
                    String type = DBConstants.getValueFromKey((String)"IP_Address_Type", (String)"SNMP TRAP IP");
                    ipAddressesHelper.update(this.requestData.pbSnmpIPAddresses, Integer.parseInt(type));
                    break;
                }
                catch (GeneralException ex) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)GuiDiscoveryHndlr.class.getName(), (String)"save", (Throwable)ex);
                    }
                    throw ex;
                }
            }
        }
        if (rowExists) {
            ScheduleQueue.routine.addEdit((ScheduleHeader)this.requestData);
        } else {
            ScheduleQueue.routine.addCreate((ScheduleHeader)this.requestData);
        }
        if (checkerWarning != null) {
            this.response.status = (short)4;
            this.response.errorMessage = checkerWarning;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiDiscoveryHndlr.class.getName(), (String)"save");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response handle(Request request, Transceiver transceiver) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiDiscoveryHndlr.class.getName(), (String)"handle", (String)"request, transceiver");
        }
        this.response = Response.getResponse((short)0, null);
        if (!RequestChecker.isDesiredType(ProbePing.class, (Request)request, (Response)this.response)) {
            Response traceResult = this.response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)GuiDiscoveryHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        this.requestData = (ProbePing)request.requestData;
        boolean forRetrieve = this.requestData.ID == 0;
        boolean validIPs = false;
        switch (this.requestData.jobType) {
            case 32: {
                this.requestData.ID = 100;
                this.scheduleType = MessageLog.getMessageNoID((String)"STS0122L");
                break;
            }
            case 104: {
                if (!forRetrieve && this.requestData.validateIPs) {
                    validIPs = this.validateIPs(this.requestData.pbManualSlpDAs, this.response, "SLP Directory agent IP");
                    break;
                }
                this.requestData.ID = 110;
                this.scheduleType = MessageLog.getMessageNoID((String)"STS0182L");
                break;
            }
            case 105: {
                this.requestData.ID = 111;
                this.scheduleType = MessageLog.getMessageNoID((String)"STS0183L");
                break;
            }
            case 31: {
                this.requestData.ID = 101;
                this.scheduleType = MessageLog.getMessageNoID((String)"STS0127L");
                break;
            }
            default: {
                Server.setResponseError(this.response, "STS0136E", Integer.toString(this.requestData.jobType));
                Response traceResult = this.response;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)GuiDiscoveryHndlr.class.getName(), (String)"handle", (Object)traceResult);
                }
                return traceResult;
            }
        }
        if (this.requestData.jobType == 104 && !forRetrieve && this.requestData.validateIPs && !validIPs) {
            this.response.responseData = this.requestData;
            Response traceResult = this.response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)GuiDiscoveryHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        this.dbc = Server.getConnection();
        try {
            if (forRetrieve) {
                this.retrieve();
            } else {
                this.save();
            }
            this.response.responseData = this.requestData;
        }
        catch (GeneralException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)GuiDiscoveryHndlr.class.getName(), (String)"handle", (Throwable)e);
            }
            Server.setResponseError(this.response, (Exception)((Object)e));
        }
        finally {
            Server.returnConnection(this.dbc);
        }
        Response traceResult = this.response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiDiscoveryHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }

    private boolean validateIPs(NameList ipList, Response response, String key) {
        String machineNames;
        boolean validIPs = false;
        NameList storedIPs = null;
        NameList validateIPs = null;
        NameList warningIPs = null;
        NameList errorIPs = null;
        int status = 0;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiDiscoveryHndlr.class.getName(), (String)"validateIPs", (String)"ipList, response, key");
        }
        if ((validateIPs = this.removeDuplicateIPs(storedIPs = this.readIPs(key), ipList)) != null) {
            NameList ip = validateIPs;
            while (ip != null) {
                status = this.pingHostByName(ip.nlName);
                switch (status) {
                    case 0: {
                        break;
                    }
                    case 2: {
                        NameList element = new NameList();
                        element.nlName = ip.nlName;
                        element.nlNext = warningIPs;
                        warningIPs = element;
                        break;
                    }
                    default: {
                        NameList element = new NameList();
                        element.nlName = ip.nlName;
                        element.nlNext = errorIPs;
                        errorIPs = element;
                    }
                }
                ip = ip.nlNext;
            }
        }
        if (errorIPs != null) {
            machineNames = this.getMachineNames(errorIPs);
            Server.setResponseError(response, machineNames.indexOf(44) == -1 ? "SRV0752E" : "SRV0753E", machineNames);
        } else if (warningIPs != null) {
            machineNames = this.getMachineNames(warningIPs);
            Server.setResponseWarning(response, machineNames.indexOf(44) == -1 ? "SRV0750W" : "SRV0751W", machineNames);
        } else {
            validIPs = true;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiDiscoveryHndlr.class.getName(), (String)"validateIPs", (boolean)validIPs);
        }
        return validIPs;
    }

    private NameList readIPs(String key) {
        NameList storedIPs = null;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiDiscoveryHndlr.class.getName(), (String)"readIPs", (String)key);
        }
        if (key != null) {
            try {
                GuiListReq req = new GuiListReq();
                TResIpAddresses ipAddressesHelper = new TResIpAddresses();
                String type = DBConstants.getValueFromKey((String)"IP_Address_Type", (String)key);
                req.listRequested = Integer.parseInt(type);
                storedIPs = ipAddressesHelper.selectNames(req);
            }
            catch (GeneralException genEx) {
                MessageLog.logException((StorageException)((Object)genEx));
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiDiscoveryHndlr.class.getName(), (String)"readIPs", storedIPs);
        }
        return storedIPs;
    }

    private NameList removeDuplicateIPs(NameList readIPs, NameList passedIPs) {
        NameList returnIPs = NameList.cloneNameList((NameList)passedIPs);
        NameList element = null;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiDiscoveryHndlr.class.getName(), (String)"removeDuplicateIPs", (String)"readIPs, passedIPs");
        }
        if (readIPs != null) {
            returnIPs = null;
            while (passedIPs != null) {
                element = NameList.cloneNameList((NameList)passedIPs);
                NameList entry = readIPs;
                while (entry != null) {
                    if (element.nlName.compareTo(entry.nlName) == 0) {
                        element = null;
                        break;
                    }
                    entry = entry.nlNext;
                }
                if (element != null) {
                    element.nlNext = returnIPs;
                    returnIPs = element;
                }
                passedIPs = passedIPs.nlNext;
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiDiscoveryHndlr.class.getName(), (String)"removeDuplicateIPs", (Object)returnIPs);
        }
        return returnIPs;
    }

    private int pingHostByName(String hostName) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiDiscoveryHndlr.class.getName(), (String)"pingHostByName", (String)hostName);
        }
        int status = Ping.pingHostByName(hostName);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiDiscoveryHndlr.class.getName(), (String)"pingHostByName", (int)status);
        }
        return status;
    }

    private String getMachineNames(NameList ipList) {
        String hostNames = null;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)GuiDiscoveryHndlr.class.getName(), (String)"getMachineNames", (String)"ipList");
        }
        if (ipList != null) {
            NameList ip = ipList;
            while (ip != null) {
                hostNames = hostNames == null ? ip.nlName : hostNames + ip.nlName;
                if (ip.nlNext != null) {
                    hostNames = hostNames + ", ";
                }
                ip = ip.nlNext;
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiDiscoveryHndlr.class.getName(), (String)"getMachineNames", hostNames);
        }
        return hostNames;
    }
}

