/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.GeneralException;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThreadSafe;
import org.eclipse.aperi.server.guireq.PartitionedReport;
import org.eclipse.aperi.server.handler.StormReportHndlr;
import org.eclipse.aperi.server.svp.AgentSvp;
import org.eclipse.aperi.xmsg.MessageLog;

public class PartitionHndlr
implements RequestHandler,
ThreadSafe {
    private static final String FILE_PREFIX = "REPORT_";
    private static final String FILE_SUFFIX = ".PRT";
    private static final int PART_WAIT_TIME = 300;
    private static final int SLEEP_TIME = 5;
    private static final int MAX_RETRY_COUNT = 60;

    public Response handle(Request request, Transceiver comm) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)PartitionHndlr.class.getName(), (String)"handle", (String)"request, comm");
        }
        if (request.requestData instanceof long[]) {
            this.deletePartitions((long[])request.requestData);
            Response traceResult = null;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)PartitionHndlr.class.getName(), (String)"handle", traceResult);
            }
            return traceResult;
        }
        Response response = Response.getResponse((short)12, null);
        if (!RequestChecker.isDesiredType(PartitionedReport.class, (Request)request, (Response)response)) {
            Response traceResult = response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)PartitionHndlr.class.getName(), (String)"handle", (Object)traceResult);
            }
            return traceResult;
        }
        PartitionedReport partition = (PartitionedReport)request.requestData;
        String fileName = PartitionHndlr.makeFileName(partition);
        int timeToWait = 300 * partition.prPartition;
        int timeSinceCreate = (int)((System.currentTimeMillis() - partition.prID) / 1000L);
        int retryCount = (timeToWait - timeSinceCreate) / 5;
        if (retryCount > 60) {
            retryCount = 60;
        }
        File file = new File(fileName);
        for (int i = 0; i < retryCount; ++i) {
            if (file.exists()) continue;
            try {
                Thread.sleep(5000L);
                continue;
            }
            catch (InterruptedException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)PartitionHndlr.class.getName(), (String)"handle", (Throwable)e);
                }
                response.errorMessage = MessageLog.getMessage((String)"GEN0159E");
                Response traceResult = response;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)PartitionHndlr.class.getName(), (String)"handle", (Object)traceResult);
                }
                return traceResult;
            }
        }
        Response traceResult = PartitionHndlr.getPartition(fileName, partition, response);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)PartitionHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }

    private static Response getPartition(String fileName, PartitionedReport partition, Response response) {
        Response traceResult;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)PartitionHndlr.class.getName(), (String)"getPartition", (String)"fileName, partition, response");
        }
        FileInputStream fileStream = null;
        ObjectInputStream objectStream = null;
        try {
            fileStream = new FileInputStream(fileName);
        }
        catch (FileNotFoundException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)PartitionHndlr.class.getName(), (String)"getPartition", (Throwable)e);
            }
            response.errorMessage = MessageLog.getMessageWithException((String)"GEN0160E", (Exception)e);
            Response traceResult2 = response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)PartitionHndlr.class.getName(), (String)"getPartition", (Object)traceResult2);
            }
            return traceResult2;
        }
        try {
            objectStream = new ObjectInputStream(fileStream);
        }
        catch (ObjectStreamException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)PartitionHndlr.class.getName(), (String)"getPartition", (Throwable)e);
            }
            response.errorMessage = MessageLog.getMessageWithException((String)"GEN0155E", (Exception)e, (Object)fileName);
        }
        catch (IOException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)PartitionHndlr.class.getName(), (String)"getPartition", (Throwable)e);
            }
            response.errorMessage = MessageLog.getMessageWithException((String)"GEN0154E", (Exception)e, (Object)fileName);
        }
        if (objectStream == null) {
            PartitionHndlr.closeInputStream(fileStream);
            traceResult = response;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)PartitionHndlr.class.getName(), (String)"getPartition", (Object)traceResult);
            }
            return traceResult;
        }
        try {
            response.responseData = (Serializable)objectStream.readObject();
            response.status = 0;
        }
        catch (ClassNotFoundException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)PartitionHndlr.class.getName(), (String)"getPartition", (Throwable)e);
            }
            Object[] args = new Object[]{e.getMessage(), fileName};
            response.errorMessage = MessageLog.getMessage((String)"GEN0157E", (Object[])args);
        }
        catch (ObjectStreamException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)PartitionHndlr.class.getName(), (String)"getPartition", (Throwable)e);
            }
            response.errorMessage = MessageLog.getMessageWithException((String)"GEN0155E", (Exception)e, (Object)fileName);
        }
        catch (EOFException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)PartitionHndlr.class.getName(), (String)"getPartition", (Throwable)e);
            }
            response.errorMessage = MessageLog.getMessageWithException((String)"GEN0156E", (Exception)e, (Object)fileName);
        }
        catch (IOException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)PartitionHndlr.class.getName(), (String)"getPartition", (Throwable)e);
            }
            response.errorMessage = MessageLog.getMessageWithException((String)"GEN0154E", (Exception)e, (Object)fileName);
        }
        catch (ClassCastException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)PartitionHndlr.class.getName(), (String)"getPartition", (Throwable)e);
            }
            response.errorMessage = MessageLog.getMessageWithException((String)"GEN0158E", (Exception)e, (Object)fileName, (Object)"PartitionedReport");
        }
        PartitionHndlr.closeInputStream(objectStream);
        traceResult = response;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)PartitionHndlr.class.getName(), (String)"getPartition", (Object)traceResult);
        }
        return traceResult;
    }

    private static void closeInputStream(InputStream is) {
        block4: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)PartitionHndlr.class.getName(), (String)"closeInputStream", (String)"is");
            }
            try {
                is.close();
            }
            catch (IOException e) {
                if (!TraceLogger.enableTrace) break block4;
                TraceLogger.exception((String)PartitionHndlr.class.getName(), (String)"closeInputStream", (Throwable)e);
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)PartitionHndlr.class.getName(), (String)"closeInputStream");
        }
    }

    public static String makeFileName(PartitionedReport partition) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)PartitionHndlr.class.getName(), (String)"makeFileName", (String)"partition");
        }
        StringBuffer buffer = new StringBuffer(64);
        buffer.append(Server.TEMP_DIR);
        buffer.append(FILE_PREFIX);
        buffer.append(partition.prID);
        buffer.append('_');
        buffer.append(partition.prPartition);
        buffer.append(FILE_SUFFIX);
        String traceResult = buffer.toString();
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)PartitionHndlr.class.getName(), (String)"makeFileName", (Object)traceResult);
        }
        return traceResult;
    }

    public static PartitionedReport getPartitionZero(long partitionToken) {
        PartitionedReport traceResult;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)PartitionHndlr.class.getName(), (String)"getPartitionZero", (String)"partitionToken");
        }
        PartitionedReport partition = new PartitionedReport();
        partition.prID = partitionToken;
        Response response = Response.getResponse((short)12, null);
        PartitionHndlr.getPartition(PartitionHndlr.makeFileName(partition), partition, response);
        PartitionedReport partitionedReport = traceResult = response.status == 0 ? (PartitionedReport)response.responseData : null;
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)PartitionHndlr.class.getName(), (String)"getPartitionZero", (Object)traceResult);
        }
        return traceResult;
    }

    public static void savePartition(PartitionedReport partition, StormReportHndlr grh) throws GeneralException {
        boolean written;
        File file;
        block29: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)PartitionHndlr.class.getName(), (String)"savePartition", (String)"partition, grh");
            }
            if (partition.prPartition == 0) {
                if (!partition.prLastPart) {
                    partition.prID = Server.getUniqueTimestamp();
                }
                grh.transmitReportData(partition);
                if (partition.prLastPart) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)PartitionHndlr.class.getName(), (String)"savePartition");
                    }
                    return;
                }
                PartitionHndlr.ageFiles(partition.prID);
            }
            try {
                file = File.createTempFile("TMP", FILE_SUFFIX, new File(Server.TEMP_DIR));
            }
            catch (IOException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)PartitionHndlr.class.getName(), (String)"savePartition", (Throwable)e);
                }
                MessageLog.logException((String)"GEN0036E", (Exception)e);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)PartitionHndlr.class.getName(), (String)"savePartition");
                }
                throw new GeneralException();
            }
            String fileName = file.getName();
            FileOutputStream fileStream = null;
            try {
                fileStream = new FileOutputStream(file);
            }
            catch (IOException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)PartitionHndlr.class.getName(), (String)"savePartition", (Throwable)e);
                }
                MessageLog.logException((String)"GEN0036E", (Exception)e);
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)PartitionHndlr.class.getName(), (String)"savePartition");
                }
                throw new GeneralException();
            }
            written = false;
            ObjectOutputStream objectStream = null;
            try {
                objectStream = new ObjectOutputStream(fileStream);
                objectStream.writeObject(partition);
                written = true;
            }
            catch (ObjectStreamException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)PartitionHndlr.class.getName(), (String)"savePartition", (Throwable)e);
                }
                MessageLog.logException((String)"GEN0153E", (Exception)e, (Object)fileName);
            }
            catch (IOException e) {
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)PartitionHndlr.class.getName(), (String)"savePartition", (Throwable)e);
                }
                MessageLog.logException((String)"GEN0152E", (Exception)e, (Object)fileName);
            }
            if (objectStream != null) {
                try {
                    objectStream.close();
                }
                catch (IOException e) {
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exception((String)PartitionHndlr.class.getName(), (String)"savePartition", (Throwable)e);
                    }
                    if (written) {
                        MessageLog.logException((String)"GEN0152E", (Exception)e, (Object)fileName);
                        written = false;
                    }
                    break block29;
                }
            }
            if (fileStream != null) {
                try {
                    ((OutputStream)fileStream).close();
                }
                catch (IOException ignored) {
                    if (!TraceLogger.enableTrace) break block29;
                    TraceLogger.exception((String)PartitionHndlr.class.getName(), (String)"savePartition", (Throwable)ignored);
                }
            }
        }
        if (!written) {
            file.delete();
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)PartitionHndlr.class.getName(), (String)"savePartition");
            }
            throw new GeneralException();
        }
        written = file.renameTo(new File(PartitionHndlr.makeFileName(partition)));
        partition.prPartition = (short)(partition.prPartition + 1);
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)PartitionHndlr.class.getName(), (String)"savePartition");
        }
    }

    private void deletePartitions(long[] idArray) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)PartitionHndlr.class.getName(), (String)"deletePartitions", (String)"idArray");
        }
        PartitionHndlr.remove(new DeletePartitionFilter(idArray));
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)PartitionHndlr.class.getName(), (String)"deletePartitions");
        }
    }

    private static void ageFiles(long timestamp) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)PartitionHndlr.class.getName(), (String)"ageFiles", (String)"timestamp");
        }
        PartitionHndlr.remove(new AgeFilesFilter(timestamp - (long)(AgentSvp.keepCachedReport * 60 * 1000)));
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)PartitionHndlr.class.getName(), (String)"ageFiles");
        }
    }

    private static void remove(FilenameFilter filter) {
        File[] removeList;
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)PartitionHndlr.class.getName(), (String)"remove", (String)"filter");
        }
        if ((removeList = new File(Server.TEMP_DIR).listFiles(filter)) != null) {
            for (int i = 0; i < removeList.length; ++i) {
                removeList[i].delete();
            }
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)PartitionHndlr.class.getName(), (String)"remove");
        }
    }

    private static class DeletePartitionFilter
    implements FilenameFilter {
        String[] partitionIDs;

        DeletePartitionFilter(long[] idArray) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)DeletePartitionFilter.class.getName(), (String)"DeletePartitionFilter", (String)"idArray");
            }
            this.partitionIDs = new String[idArray.length];
            for (int i = 0; i < idArray.length; ++i) {
                this.partitionIDs[i] = Long.toString(idArray[i]);
            }
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)DeletePartitionFilter.class.getName(), (String)"DeletePartitionFilter");
            }
        }

        public boolean accept(File dir, String fileName) {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)DeletePartitionFilter.class.getName(), (String)"accept", (String)"dir, fileName");
            }
            if (!fileName.startsWith(PartitionHndlr.FILE_PREFIX) || !fileName.endsWith(PartitionHndlr.FILE_SUFFIX)) {
                boolean traceResult = false;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)DeletePartitionFilter.class.getName(), (String)"accept", (boolean)traceResult);
                }
                return traceResult;
            }
            for (int i = 0; i < this.partitionIDs.length; ++i) {
                if (!fileName.regionMatches(PartitionHndlr.FILE_PREFIX.length(), this.partitionIDs[i], 0, this.partitionIDs[i].length())) continue;
                boolean traceResult = true;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)DeletePartitionFilter.class.getName(), (String)"accept", (boolean)traceResult);
                }
                return traceResult;
            }
            boolean traceResult = false;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)DeletePartitionFilter.class.getName(), (String)"accept", (boolean)traceResult);
            }
            return traceResult;
        }
    }

    private static class AgeFilesFilter
    implements FilenameFilter {
        String deletePrefix;

        AgeFilesFilter(long deleteTime) {
            this.deletePrefix = PartitionHndlr.FILE_PREFIX + deleteTime;
        }

        public boolean accept(File dir, String fileName) {
            boolean traceResult;
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)AgeFilesFilter.class.getName(), (String)"accept", (String)"dir, fileName");
            }
            boolean bl = traceResult = fileName.startsWith(PartitionHndlr.FILE_PREFIX) && fileName.endsWith(PartitionHndlr.FILE_SUFFIX) && fileName.compareTo(this.deletePrefix) < 0;
            if (TraceLogger.enableTrace) {
                TraceLogger.exit((String)AgeFilesFilter.class.getName(), (String)"accept", (boolean)traceResult);
            }
            return traceResult;
        }
    }
}

