/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui.cimom;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.common.Util;
import org.eclipse.aperi.common.api.CIMOM;
import org.eclipse.aperi.common.api.CIMOMConnectionStatus;
import org.eclipse.aperi.common.api.ICIMOMMgmtService;
import org.eclipse.aperi.common.api.RemoteException;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.ServerException;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.objects.RegisteredCimom;
import org.eclipse.aperi.infrastructure.database.objects.SlpAttributes;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.handler.gui.GuiDeviceRequestHndlr;
import org.eclipse.aperi.util.SRMCrypto;
import org.eclipse.aperi.xmsg.MessageLog;

public abstract class CIMOMMgmtRequestHandler
extends GuiDeviceRequestHndlr {
    private static final String INTERNAL_ERROR = "HWN021503E";
    private static final String BAD_DB_CONNECTION = "HWN021800E";
    private static final String BAD_CIMOM_CURSOR = "HWN021801E";
    private static final String BAD_SLPATTR_CURSOR = "HWN021804E";

    protected void processRequest(DeviceRequest request, Response response) throws RemoteException {
        String method = "processRequest";
        this.logEnter(method, request, response);
        this.logMessage(method, "Getting CIMOM Service Proxy");
        ICIMOMMgmtService cimomProxy = CIMOMMgmtRequestHandler.getCimomProxy(request);
        this.logMessage(method, "Processing CIMOM request");
        this.processCIMOMRequest(request, response, cimomProxy);
        if (response.status <= 4) {
            CIMOM[] cimoms;
            this.logMessage(method, "Collecting refreshed CIMOM list");
            response.responseData = cimoms = this.getCIMOMs();
        }
        this.logExit(method);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CIMOM createCIMOMObject(RegisteredCimom bRegisteredCimom, DBConnection mConn) throws SQLException {
        String method = "createCIMOMObject";
        this.logEnter(method, bRegisteredCimom.getServiceUrl(), mConn.toString());
        String bServiceUrl = bRegisteredCimom.getServiceUrl();
        CIMOM mNewCIMOM = new CIMOM();
        mNewCIMOM.setServiceUrl(bServiceUrl);
        mNewCIMOM.setHiName(bRegisteredCimom.getHiName());
        mNewCIMOM.setDescription(bRegisteredCimom.getDescription());
        mNewCIMOM.setSoftwareLevel(bRegisteredCimom.getSoftwareLevel());
        mNewCIMOM.setProtocolVersion(bRegisteredCimom.getProtocolVersion());
        mNewCIMOM.setAuthenticationMechanism(bRegisteredCimom.getAuthenticationMechanism());
        mNewCIMOM.setUserId(bRegisteredCimom.getUserId());
        mNewCIMOM.setServiceId(String.valueOf(bRegisteredCimom.getRegCimomId()));
        String bEncrypted = bRegisteredCimom.getPassword();
        if (bEncrypted != null) {
            try {
                mNewCIMOM.setPassword(SRMCrypto.decrypt((String)bEncrypted));
            }
            catch (Exception pEx) {
                this.logException(method + ": Failed to decrypt password " + bEncrypted + " for CIMOM " + bServiceUrl + "due to " + pEx.getMessage(), pEx);
                throw new ServerException(new SRMMessage(INTERNAL_ERROR, new String[]{pEx.getMessage()}));
            }
        }
        mNewCIMOM.setTrustStoreLocation(bRegisteredCimom.getTrustStoreLocation());
        mNewCIMOM.setTrustStorePassphrase(bRegisteredCimom.getTrustStorePassphrase());
        mNewCIMOM.setInteropSchemaNamespace(bRegisteredCimom.getInteropSchemaNamespace());
        mNewCIMOM.setProtocol(bRegisteredCimom.getProtocol());
        mNewCIMOM.setDisplayName(bRegisteredCimom.getDisplayName());
        mNewCIMOM.setStatus(CIMOMConnectionStatus.getStatus((short)bRegisteredCimom.getStatus()));
        Timestamp bTempTimestamp = bRegisteredCimom.getStatusTimestamp();
        if (bTempTimestamp != null) {
            Calendar bTempCal = Calendar.getInstance();
            bTempCal.setTime(bTempTimestamp);
            mNewCIMOM.setStatusTimestamp(bTempCal);
        }
        SlpAttributes.SlpAttributesCursor mAttrCursor = null;
        try {
            mAttrCursor = SlpAttributes.getCursor((DBConnection)mConn, null, null);
            if (mAttrCursor == null) {
                this.logMessage(method, "SlpAttributes.getCursor returned null", bRegisteredCimom.getServiceUrl());
                throw new ServerException(new SRMMessage(BAD_SLPATTR_CURSOR, new String[]{bRegisteredCimom.getServiceUrl()}));
            }
            String bAllAttributes = new String();
            while (mAttrCursor.next()) {
                SlpAttributes bAttributes = mAttrCursor.getObject();
                if (bAttributes == null) {
                    this.logMessage(method, "Unexpected null SLP attributes reference", bRegisteredCimom.getServiceUrl());
                    throw new ServerException(new SRMMessage(BAD_SLPATTR_CURSOR, new String[]{bRegisteredCimom.getServiceUrl()}));
                }
                if (bAttributes.getRegCimomId() != bRegisteredCimom.getRegCimomId()) continue;
                bAllAttributes = bAllAttributes + bAttributes.getAttributeName() + ":" + bAttributes.getValue();
            }
        }
        catch (SQLException pEx) {
            try {
                this.logException("Getting CIMOMs failed due to " + pEx.getMessage(), pEx);
                throw new ServerException(new SRMMessage(INTERNAL_ERROR, new String[]{pEx.getMessage()}));
            }
            catch (Throwable throwable) {
                try {
                    if (mAttrCursor == null) throw throwable;
                    mAttrCursor.close();
                    throw throwable;
                }
                catch (SQLException pEx2) {
                    this.logException(method + ": Exception closing SLP attribute cursor", pEx2);
                    throw new ServerException(new SRMMessage(INTERNAL_ERROR, new String[]{pEx2.getMessage()}));
                }
            }
        }
        try {
            if (mAttrCursor != null) {
                mAttrCursor.close();
            }
        }
        catch (SQLException pEx) {
            this.logException(method + ": Exception closing SLP attribute cursor", pEx);
            throw new ServerException(new SRMMessage(INTERNAL_ERROR, new String[]{pEx.getMessage()}));
        }
        this.logExit(method);
        return mNewCIMOM;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private CIMOM[] getCIMOMs() {
        String method = "createCIMOMObject";
        this.logEnter(method, null);
        DBConnection mConn = ServiceUtils.getConnection();
        if (mConn == null) {
            this.logMessage(method, "ServiceUtils.getConnection returned null");
            throw new ServerException(new SRMMessage(BAD_DB_CONNECTION, new String[0]));
        }
        RegisteredCimom.RegisteredCimomCursor mCursor = null;
        ArrayList<CIMOM> mCimoms = new ArrayList<CIMOM>();
        try {
            try {
                mCursor = RegisteredCimom.getCursor((DBConnection)mConn, null, null);
                if (mCursor == null) {
                    this.logMessage(method, "RegisteredCimom.getCursor returned null", mConn.toString());
                    throw new ServerException(new SRMMessage(BAD_CIMOM_CURSOR, new String[0]));
                }
                while (mCursor.next()) {
                    RegisteredCimom bRegisteredCimom = mCursor.getObject();
                    if (bRegisteredCimom == null) {
                        this.logMessage("Unexpected null CIMOM reference from mCursor.getObject()", mCursor);
                        throw new ServerException(new SRMMessage(BAD_CIMOM_CURSOR, new String[0]));
                    }
                    if (bRegisteredCimom.getStatus() == CIMOMConnectionStatus.PENDING_DELETION.toID()) continue;
                    mCimoms.add(this.createCIMOMObject(bRegisteredCimom, mConn));
                }
                Object var7_7 = null;
            }
            catch (SQLException pEx) {
                this.logException("Getting CIMOMs failed due to " + pEx.getMessage(), pEx);
                throw new ServerException(new SRMMessage(INTERNAL_ERROR, new String[]{pEx.getMessage()}));
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            try {
                if (mCursor != null) {
                    mCursor.close();
                }
            }
            catch (SQLException pEx) {
                this.logException("Exception closing CIMOM cursor", pEx);
                throw new ServerException(new SRMMessage(INTERNAL_ERROR, new String[]{pEx.getMessage()}));
            }
            try {
                mConn.close();
                throw throwable;
            }
            catch (SQLException pEx) {
                this.logException("Exception closing connection", pEx);
                throw new ServerException(new SRMMessage(INTERNAL_ERROR, new String[]{pEx.getMessage()}));
            }
        }
        try {}
        catch (SQLException pEx) {
            this.logException("Exception closing CIMOM cursor", pEx);
            throw new ServerException(new SRMMessage(INTERNAL_ERROR, new String[]{pEx.getMessage()}));
        }
        if (mCursor != null) {
            mCursor.close();
        }
        try {}
        catch (SQLException pEx) {
            this.logException("Exception closing connection", pEx);
            throw new ServerException(new SRMMessage(INTERNAL_ERROR, new String[]{pEx.getMessage()}));
        }
        mConn.close();
        this.logExit(method);
        return mCimoms.toArray(new CIMOM[mCimoms.size()]);
    }

    public static ICIMOMMgmtService getCimomProxy(DeviceRequest request) {
        ICIMOMMgmtService proxy = (ICIMOMMgmtService)ConnectorClient.getService((String)request.deviceServerHost, (int)request.deviceServerPort, ICIMOMMgmtService.class, (String)"DiskManagerService");
        if (proxy == null) {
            throw new RuntimeException(MessageLog.getMessageNoTS((String)"GUI8104E"));
        }
        return proxy;
    }

    protected abstract void processCIMOMRequest(DeviceRequest var1, Response var2, ICIMOMMgmtService var3) throws RemoteException;

    private static String getBestDisplayName(CIMOM cimom) {
        String name = cimom.getDisplayName();
        if (name == null || name.length() == 0) {
            name = cimom.getServiceUrl();
        }
        return name;
    }

    protected final boolean testCIMOM(CIMOM cimom, Response response, ICIMOMMgmtService cimomProxy) throws RemoteException {
        boolean retval = true;
        CIMOMConnectionStatus[] results = cimomProxy.testCIMOMConnection(new CIMOM[]{cimom});
        if (results[0] != CIMOMConnectionStatus.SUCCESS) {
            Server.setResponseError(response, "GUI8101I", new Object[]{CIMOMMgmtRequestHandler.getBestDisplayName(cimom), this.getLocalizedStatus(results[0])});
            retval = false;
        }
        return retval;
    }

    private Object getLocalizedStatus(CIMOMConnectionStatus status) {
        if (status == CIMOMConnectionStatus.SUCCESS) {
            return Util.getString((String)"CIMOM_MGT_CONNECTION_STATUS_SUCCESS");
        }
        if (status == CIMOMConnectionStatus.UNCONFIGURED) {
            return Util.getString((String)"CIMOM_MGT_CONNECTION_STATUS_UNCONFIGURED");
        }
        if (status == CIMOMConnectionStatus.UNKNOWN) {
            return Util.getString((String)"CIMOM_MGT_CONNECTION_STATUS_UNKNOWN");
        }
        if (status == CIMOMConnectionStatus.INVALID_NAMESPACE) {
            return Util.getString((String)"CIMOM_MGT_CONNECTION_STATUS_INVALID_NAMESPACE");
        }
        if (status == CIMOMConnectionStatus.TIMEOUT) {
            return Util.getString((String)"CIMOM_MGT_CONNECTION_STATUS_TIMEOUT");
        }
        if (status == CIMOMConnectionStatus.REFUSED) {
            return Util.getString((String)"DISK_COMMON_STATE_UNREACHABLE");
        }
        if (status == CIMOMConnectionStatus.LOGIN_FAILED) {
            return Util.getString((String)"CIMOM_MGT_CONNECTION_STATUS_LOGIN_FAILED");
        }
        if (status == CIMOMConnectionStatus.SSL_HANDSHAKE_ERROR) {
            return Util.getString((String)"CIMOM_MGT_CONNECTION_STATUS_SSL_HANDSHAKE_ERROR");
        }
        if (status == CIMOMConnectionStatus.SSL_REGISTRATION_INVALID) {
            return Util.getString((String)"CIMOM_MGT_CONNECTION_STATUS_SSL_REGISTRATION_INVALID");
        }
        if (status == CIMOMConnectionStatus.CIMCLIENT_ERROR) {
            return Util.getString((String)"CIMOM_MGT_CONNECTION_STATUS_CIMCLIENT_ERROR");
        }
        return Util.getString((String)"CIMOM_MGT_CONNECTION_STATUS_UNKNOWN");
    }
}

