/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui.disk;

import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.SRMRuntimeException;
import org.eclipse.aperi.gui.common.model.GUIRequestData;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.handler.gui.disk.GUIEntityFactory;

public class FabricInfoHandler
implements RequestHandler,
ThrowAway {
    GUIEntityFactory entityFactory = null;

    public Response handle(Request request, Transceiver transceiver) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)FabricInfoHandler.class.getName(), (String)"handle", (String)"request, transceiver");
        }
        GUIRequestData reqData = (GUIRequestData)request.requestData;
        Response response = Response.getResponse((short)0, null);
        this.entityFactory = GUIEntityFactory.getInstance();
        try {
            if (reqData.getActionId() == 71) {
                this.getFabrics(reqData, response);
            } else if (reqData.getActionId() == 72) {
                this.getActiveZoneSet(reqData, response);
            } else if (reqData.getActionId() == 73) {
                this.getZones(reqData, response);
            } else if (reqData.getActionId() == 74) {
                this.getPortsByZone(reqData, response);
            }
        }
        catch (Exception ex) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)FabricInfoHandler.class.getName(), (String)"handle", (Throwable)ex);
            }
            response.status = (short)12;
            if (ex instanceof SRMRuntimeException) {
                response.errorMessage = ((SRMRuntimeException)ex).getLocalizedMessage();
            } else {
                String[] inserts = new String[]{};
                String msg = ex.getMessage();
                if (msg != null) {
                    inserts = new String[]{msg};
                }
                response.errorMessage = new SRMMessage("HWN021503E", inserts).getLocalizedMessage();
            }
            response.responseData = null;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)FabricInfoHandler.class.getName(), (String)"handle", (Object)response);
        }
        return response;
    }

    private void getFabrics(GUIRequestData reqData, Response response) throws Exception {
        response.responseData = this.entityFactory.getFabrics();
    }

    private void getActiveZoneSet(GUIRequestData reqData, Response response) throws Exception {
        String fabricId = (String)((Object)reqData.getParameter("fabric.id"));
        TraceLogger.traceMessage((int)1, (String)FabricInfoHandler.class.getName(), (String)"getActiveZoneSet", (String)("fabricId: " + fabricId));
        response.responseData = this.entityFactory.getActiveZoneSet(fabricId);
    }

    private void getZones(GUIRequestData reqData, Response response) throws Exception {
        String fabricId = (String)((Object)reqData.getParameter("fabric.id"));
        TraceLogger.traceMessage((int)1, (String)FabricInfoHandler.class.getName(), (String)"getZones", (String)("fabricId: " + fabricId));
        String zoneSetId = (String)((Object)reqData.getParameter("zoneset.id"));
        TraceLogger.traceMessage((int)1, (String)FabricInfoHandler.class.getName(), (String)"getZones", (String)("zoneSetId: " + zoneSetId));
        response.responseData = this.entityFactory.getZones(fabricId, zoneSetId);
    }

    private void getPortsByZone(GUIRequestData reqData, Response response) throws Exception {
        String fabricId = (String)((Object)reqData.getParameter("fabric.id"));
        TraceLogger.traceMessage((int)1, (String)FabricInfoHandler.class.getName(), (String)"getPortsByZone", (String)("fabricId: " + fabricId));
        String zoneSetId = (String)((Object)reqData.getParameter("zoneset.id"));
        TraceLogger.traceMessage((int)1, (String)FabricInfoHandler.class.getName(), (String)"getPortsByZone", (String)("zoneSetId: " + zoneSetId));
        String zoneId = (String)((Object)reqData.getParameter("zone.id"));
        TraceLogger.traceMessage((int)1, (String)FabricInfoHandler.class.getName(), (String)"getPortsByZone", (String)("zoneId: " + zoneId));
        response.responseData = this.entityFactory.getPortsByZone(fabricId, zoneSetId, zoneId);
    }
}

