/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui.disk;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.common.dbaccess.FabricDbAccess;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.disk.api.ExtendedVolumeAssignments;
import org.eclipse.aperi.disk.api.HostInfo;
import org.eclipse.aperi.disk.api.IDiskReportingService;
import org.eclipse.aperi.disk.common.util.ExternalKeyConverter;
import org.eclipse.aperi.gui.common.model.GUIEntityUtil;
import org.eclipse.aperi.gui.disk.common.model.DiskDbAccessor;
import org.eclipse.aperi.gui.disk.common.model.GUICapabilityData;
import org.eclipse.aperi.gui.disk.common.model.GUIFabric;
import org.eclipse.aperi.gui.disk.common.model.GUIIOGroup;
import org.eclipse.aperi.gui.disk.common.model.GUIMDisk;
import org.eclipse.aperi.gui.disk.common.model.GUIMDiskGroup;
import org.eclipse.aperi.gui.disk.common.model.GUIPort;
import org.eclipse.aperi.gui.disk.common.model.GUIPortAssignment;
import org.eclipse.aperi.gui.disk.common.model.GUIStoragePool;
import org.eclipse.aperi.gui.disk.common.model.GUIStorageSubsystem;
import org.eclipse.aperi.gui.disk.common.model.GUIVDisk;
import org.eclipse.aperi.gui.disk.common.model.GUIVolume;
import org.eclipse.aperi.gui.disk.common.model.GUIZone;
import org.eclipse.aperi.gui.disk.common.model.GUIZoneSet;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.server.handler.DeviceRequestHndlr;

public class GUIEntityFactory {
    private static final String[] CAPABILITY_DATA_DB_ATTRIBUTES = new String[]{"CAPABILITY_DATA_ID", "VOLUME_CREATION", "VOLUME_DELETION", "ACCESS_ASSIGNMENT", "ACCESS_UNASSIGNMENT", "NUM_VOLUMES", "RAID_LEVELS", "TARGET_PORT_RESTRICTION", "PORTS_PER_VIEW", "MAX_MAP_COUNT"};
    private static final String[] FABRIC_DB_ATTRIBUTES = new String[]{"FABRIC_ID", "FABRIC_WWN", "NAME", "SAN_WWN", "CONSOLIDATED_STATUS", "DETECTABLE", "SUPPORTS_ZONING", "DISPLAY_NAME"};
    private static final String[] IO_GROUP_DB_ATTRIBUTES = new String[]{"IO_GROUP_ID", "GROUP_ID", "NAME", "SUBSYSTEM_ID"};
    private static final String[] MDISK_DB_ATTRIBUTES = new String[]{"STORAGE_EXTENT_ID", "DEVICE_ID", "NAME", "ELEMENT_NAME", "TOTAL_CAPACITY", "FREE_SPACE", "BLOCK_SIZE", "NUM_OF_BLOCKS", "CONSUMABLE_BLOCKS", "POOL_ID", "NATIVE_STATUS", "SUBSYSTEM_ID", "MODE"};
    private static final String PORT_ATTR_PORT_WWN = "PORT_WWN";
    private static final String PORT_ATTR_FABRIC_WWN = "FABRIC_WWN";
    private static final String PORT_ATTR_HOST_URL = "HOST_URL";
    private static final String PORT_ATTR_SUBSYSTEM_DISPLAY_NAME = "SUBSYSTEM_DISPLAY_NAME";
    private static final String[] PORT_DB_ATTRIBUTES = new String[]{"PORT_WWN", "FABRIC_WWN", "HOST_URL", "SUBSYSTEM_DISPLAY_NAME"};
    private static final String[] STORAGE_POOL_DB_ATTRIBUTES = new String[]{"POOL_ID", "NAME", "DISPLAY_NAME", "INSTANCE_ID", "CONSOLIDATED_STATUS", "DETECTABLE", "RAID_LEVEL", "DATA_REDUNDANCY_DEF", "PCK_REDUNDANCY_DEF", "TOTAL_AVAILABLE_SPACE", "FORMAT", "SUBSYSTEM_ID"};
    private static final String SUBSYSTEM_ATTR_MODEL = "MODEL";
    private static final String SUBSYSTEM_ATTR_VENDOR = "VENDOR";
    private static final String[] SUBSYSTEM_DB_ATTRIBUTES = new String[]{"SUBSYSTEM_ID", "NAME", "NAME_FORMAT", "DISPLAY_NAME", "CONSOLIDATED_STATUS", "DETECTABLE", "TYPE", "MODEL", "VENDOR", "MODEL_ID", "VENDOR_ID", "CODE_LEVEL", "SERIAL_NUMBER", "ACCESS_INFO", "IP_ADDRESS", "ALLOCATED_CAPACITY", "AVAILABLE_CAPACITY", "VG_CAPACITY", "VG_FREESPACE", "USER_PROVIDED_NAME", "USER_PROVIDED_LOCATION", "USER_ATTRIB1", "USER_ATTRIB2", "USER_ATTRIB3"};
    private static final String[] VDISK_DB_ATTRIBUTES = new String[]{"SVID", "NAME", "DISPLAY_NAME", "CONSOLIDATED_STATUS", "DETECTABLE", "LSS", "CAPACITY", "SUBSYSTEM_ID", "POOL_ID", "REDUNDANCY", "DATA_REDUNDANCY", "PACKAGE_REDUNDANCY", "FORMAT", "USER_ATTRIB1", "USER_ATTRIB2", "USER_ATTRIB3", "VDISK_TYPE", "NATIVE_STATUS", "MDISK_ID", "IO_GROUP_ID", "IS_FORMATTED", "THROTTLE", "PREFERRED_NODE", "FAST_WRITE_STATE", "UNIQUE_ID", "IS_ASSIGNED", "FLASH_COPY_ID", "FLASH_COPY_NAME", "METRO_MIRROR_ID", "METRO_MIRROR_NAME"};
    private static final String[] VOLUME_DB_ATTRIBUTES = new String[]{"SVID", "NAME", "DISPLAY_NAME", "CONSOLIDATED_STATUS", "DETECTABLE", "LSS", "CAPACITY", "SUBSYSTEM_ID", "POOL_ID", "REDUNDANCY", "DATA_REDUNDANCY", "PACKAGE_REDUNDANCY", "FORMAT", "USER_ATTRIB1", "USER_ATTRIB2", "USER_ATTRIB3"};
    private static final String[] ZONE_DB_ATTRIBUTES = new String[]{"ZONE_ID", "ZONE_NAME", "ZONE_TYPE"};
    private static final String[] ZONE_SET_DB_ATTRIBUTES = new String[]{"ZSET_ID", "ZSET_NAME", "ACTIVE", "FABRIC_WWN"};
    private static GUIEntityFactory factory = null;

    private static GUICapabilityData createCapabilityDataInstance(HashMap attr) {
        GUICapabilityData capdata = new GUICapabilityData();
        if (attr != null) {
            int subsystemId = (Integer)attr.get("CAPABILITY_DATA_ID");
            boolean crvol = (Short)attr.get("VOLUME_CREATION") == 1;
            boolean delvol = (Short)attr.get("VOLUME_DELETION") == 1;
            boolean portmap = (Short)attr.get("ACCESS_ASSIGNMENT") == 1;
            boolean portunmap = (Short)attr.get("ACCESS_UNASSIGNMENT") == 1;
            long numvol = (Long)attr.get("NUM_VOLUMES");
            String raidLevels = (String)attr.get("RAID_LEVELS");
            boolean portrestrict = (Short)attr.get("TARGET_PORT_RESTRICTION") == 1;
            int portsPerView = (Integer)attr.get("PORTS_PER_VIEW");
            if (raidLevels != null && !raidLevels.equals("__NULL__") && raidLevels.trim().length() > 0) {
                String[] raidstrs = raidLevels.trim().split(",");
                int[] raids = new int[raidstrs.length];
                for (int i = 0; i < raidstrs.length; ++i) {
                    String raid = raidstrs[i].trim().toLowerCase();
                    if (raid.startsWith("raid")) {
                        raid = raid.substring(4);
                    }
                    raids[i] = Integer.parseInt(raid);
                }
                if (raids.length > 1 || raids[0] != 0) {
                    capdata.setRaidLevelsSupported(raids);
                }
            }
            if (portsPerView == 1) {
                portsPerView = 3;
            }
            capdata.setSubsystemId(subsystemId);
            capdata.setVolumeCreationSupported(crvol);
            capdata.setVolumeDeletionSupported(delvol);
            capdata.setPortAssignmentSupported(portmap);
            capdata.setPortUnassignmentSupported(portunmap);
            if (numvol != 0L && numvol != 0L) {
                capdata.setNumVolumesSupported(numvol);
            }
            capdata.setTargetPortRestrictionSupported(portrestrict);
            capdata.setPortsPerView(portsPerView);
        }
        return capdata;
    }

    private static GUIFabric createFabricInstance(HashMap attr) {
        GUIFabric fabric = new GUIFabric();
        String dispname = (String)attr.get("DISPLAY_NAME");
        String name = (String)attr.get("NAME");
        String sanwwn = (String)attr.get("SAN_WWN");
        String wwn = (String)attr.get(PORT_ATTR_FABRIC_WWN);
        boolean supportZoning = (Integer)attr.get("SUPPORTS_ZONING") == 1;
        fabric.setId(wwn);
        fabric.setName(wwn);
        if (dispname != null && dispname.trim().length() > 0) {
            fabric.setDeviceId(dispname);
        } else if (name != null && name.trim().length() > 0) {
            fabric.setDeviceId(name);
        } else if (sanwwn != null && sanwwn.trim().length() > 0) {
            fabric.setDeviceId(sanwwn);
        } else {
            fabric.setDeviceId(wwn);
        }
        fabric.setZoningSupported(true);
        return fabric;
    }

    private static GUIIOGroup createIOGroupInstance(HashMap attr) {
        GUIIOGroup ioGroup = new GUIIOGroup();
        String ioGroupId = String.valueOf(attr.get("IO_GROUP_ID"));
        String groupId = (String)attr.get("GROUP_ID");
        String name = (String)attr.get("NAME");
        int subsysId = (Integer)attr.get("SUBSYSTEM_ID");
        ioGroup.setId(ioGroupId);
        ioGroup.setDeviceId(groupId);
        ioGroup.setName(name);
        ioGroup.setSubsystemId(String.valueOf(subsysId));
        return ioGroup;
    }

    private static GUIMDisk createMDiskInstance(HashMap attr, GUIStorageSubsystem subsys) {
        GUIMDisk mdisk = new GUIMDisk();
        int sid = (Integer)attr.get("STORAGE_EXTENT_ID");
        String deviceId = String.valueOf(attr.get("DEVICE_ID"));
        String elemname = (String)attr.get("ELEMENT_NAME");
        double totalCap = (Double)attr.get("TOTAL_CAPACITY") * 512.0;
        double freeSpace = (Double)attr.get("FREE_SPACE") * 512.0;
        int poolId = (Integer)attr.get("POOL_ID");
        short nativeStatus = Short.valueOf(attr.get("NATIVE_STATUS").toString());
        short subsystemId = ((Integer)attr.get("SUBSYSTEM_ID")).shortValue();
        int mode = ((Integer)attr.get("MODE")).shortValue();
        if (mode < 0 || mode > 3) {
            mode = 99;
        }
        mdisk.setId(ExternalKeyConverter.frameKeyStorageExtent((String)deviceId, (String)subsys.getName(), (short)subsys.getNameFormat()));
        mdisk.setInternalId(sid);
        mdisk.setName(elemname);
        mdisk.setDeviceId(elemname);
        mdisk.setCapacity((long)totalCap);
        mdisk.setUnusedCapacity((long)freeSpace);
        mdisk.setNativeStatus((int)nativeStatus);
        mdisk.setMode(mode);
        mdisk.setSubsystemId(String.valueOf(subsystemId));
        mdisk.setMdiskGroupId(String.valueOf(poolId));
        return mdisk;
    }

    private static GUIStoragePool createMDiskGroupInstance(HashMap attr, String poolId) {
        GUIMDiskGroup group = new GUIMDiskGroup();
        GUIEntityFactory.populateStoragePoolInstance((GUIStoragePool)group, attr, poolId);
        return group;
    }

    private static GUIPort createPortInstance(HashMap attr) {
        GUIPort port = new GUIPort();
        String portwwn = (String)attr.get(PORT_ATTR_PORT_WWN);
        String fabricwwn = (String)attr.get(PORT_ATTR_FABRIC_WWN);
        String hosturl = (String)attr.get(PORT_ATTR_HOST_URL);
        String subsysname = (String)attr.get(PORT_ATTR_SUBSYSTEM_DISPLAY_NAME);
        port.setId(portwwn);
        port.setName(portwwn);
        port.setDeviceId(portwwn);
        port.setWwpn(portwwn);
        if (fabricwwn != null) {
            port.addFabricId(fabricwwn);
        }
        if (hosturl != null) {
            port.setHostName(hosturl);
        } else if (subsysname != null) {
            port.setHostName(String.valueOf(subsysname));
        }
        return port;
    }

    private static GUIPortAssignment createPortAssignmentInstance(ExtendedVolumeAssignments attr, String volumeId, String hostWwpn) {
        GUIPortAssignment assignment = new GUIPortAssignment();
        assignment.setVolumeId(volumeId);
        assignment.setHostPortWwpn(hostWwpn);
        assignment.setLunId(attr.getVolumeDeviceNumber());
        assignment.setSubsystemPorts(attr.getSubsystemPorts());
        return assignment;
    }

    private static GUIStoragePool createStoragePoolInstance(HashMap attr, String poolId) {
        GUIStoragePool pool = new GUIStoragePool();
        GUIEntityFactory.populateStoragePoolInstance(pool, attr, poolId);
        return pool;
    }

    private static void populateStoragePoolInstance(GUIStoragePool pool, HashMap attr, String poolId) {
        int id = (Integer)attr.get("POOL_ID");
        String name = (String)attr.get("NAME");
        String dispname = (String)attr.get("DISPLAY_NAME");
        String instanceId = (String)attr.get("INSTANCE_ID");
        short state = (Short)attr.get("CONSOLIDATED_STATUS");
        boolean detectable = (Short)attr.get("DETECTABLE") != 0;
        String raidLevel = (String)attr.get("RAID_LEVEL");
        int dataRdcy = (Integer)attr.get("DATA_REDUNDANCY_DEF");
        int pkRdcy = (Integer)attr.get("PCK_REDUNDANCY_DEF");
        long unusedCap = (Long)attr.get("TOTAL_AVAILABLE_SPACE");
        short format = (Short)attr.get("FORMAT");
        String subsytemId = String.valueOf(attr.get("SUBSYSTEM_ID"));
        int raidLevelInt = 99;
        if (raidLevel != null && !raidLevel.equals("__NULL__") && raidLevel.trim().length() > 0) {
            if ((raidLevel = raidLevel.trim()).indexOf(",") > 0 || raidLevel.indexOf(" ") > 0) {
                raidLevelInt = 77;
            } else {
                String raid = raidLevel.toLowerCase();
                if (raid.startsWith("raid")) {
                    raid = raid.substring(4);
                }
                raidLevelInt = Integer.parseInt(raid);
            }
        }
        if (raidLevelInt == 99 && (raidLevelInt = GUIEntityUtil.getRaidLevel((int)dataRdcy, (int)pkRdcy)) == -1) {
            raidLevelInt = 99;
        }
        int formatInt = 99;
        if (format >= 1 && format <= 4) {
            formatInt = 0;
        } else if (format == 5) {
            formatInt = 1;
        } else if (format == 6) {
            formatInt = 2;
        }
        pool.setId(poolId);
        pool.setName(name);
        pool.setDeviceId(dispname);
        pool.setState((int)state);
        pool.setDetectable(detectable);
        pool.setRaidLevel(raidLevelInt);
        if (unusedCap != 0L) {
            pool.setUnusedCapacity(unusedCap * 512L);
        }
        pool.setSubsystemId(subsytemId);
        pool.setFormat(formatInt);
        pool.setInternalId(id);
        pool.setInstanceId(instanceId);
    }

    private static GUIStorageSubsystem createStorageSubsystemInstance(HashMap subsysAttr, String subsysId) {
        GUIStorageSubsystem subsys = new GUIStorageSubsystem();
        int id = (Integer)subsysAttr.get("SUBSYSTEM_ID");
        String name = (String)subsysAttr.get("NAME");
        short nameFormat = (Short)subsysAttr.get("NAME_FORMAT");
        String dispname = (String)subsysAttr.get("DISPLAY_NAME");
        String typeStr = (String)subsysAttr.get("TYPE");
        String model = (String)subsysAttr.get(SUBSYSTEM_ATTR_MODEL);
        String vendor = (String)subsysAttr.get(SUBSYSTEM_ATTR_VENDOR);
        String serialNum = (String)subsysAttr.get("SERIAL_NUMBER");
        String revision = (String)subsysAttr.get("CODE_LEVEL");
        String username = (String)subsysAttr.get("USER_PROVIDED_NAME");
        String elementMgr = (String)subsysAttr.get("ACCESS_INFO");
        String ip = (String)subsysAttr.get("IP_ADDRESS");
        short state = (Short)subsysAttr.get("CONSOLIDATED_STATUS");
        boolean detectable = (Short)subsysAttr.get("DETECTABLE") != 0;
        long unusedCap = (Long)subsysAttr.get("ALLOCATED_CAPACITY");
        long usedCap = (Long)subsysAttr.get("AVAILABLE_CAPACITY");
        long vgCap = (Long)subsysAttr.get("VG_CAPACITY");
        long freeCap = (Long)subsysAttr.get("VG_FREESPACE");
        String location = (String)subsysAttr.get("USER_PROVIDED_LOCATION");
        String udp1 = (String)subsysAttr.get("USER_ATTRIB1");
        String udp2 = (String)subsysAttr.get("USER_ATTRIB2");
        String udp3 = (String)subsysAttr.get("USER_ATTRIB3");
        int type = 99;
        if (typeStr.equals("FAStT")) {
            type = 1;
        } else if (typeStr.equals("DS6000")) {
            type = 2;
        } else if (typeStr.equals("DS8000")) {
            type = 3;
        } else if (typeStr.equals("ESS")) {
            type = 0;
        } else if (typeStr.equals("SVC")) {
            type = 4;
        } else if (typeStr.equals("HDS")) {
            type = 5;
        } else if (typeStr.equals("EMC")) {
            type = 6;
        } else if (typeStr.equals("HP")) {
            type = 7;
        } else if (typeStr.equals("FUJITSU")) {
            type = 9;
        } else if (typeStr.equals("XP128")) {
            type = 10;
        } else if (typeStr.equals("SUN")) {
            type = 8;
        }
        subsys.setId(subsysId);
        subsys.setName(name);
        subsys.setNameFormat(nameFormat);
        if (username != null && !username.equals("__NULL__")) {
            subsys.setUserProvidedName(username);
        }
        subsys.setState((int)state);
        subsys.setDetectable(detectable);
        subsys.setRevision(revision);
        subsys.setVendor(vendor);
        subsys.setModel(model);
        subsys.setSerialNumber(serialNum);
        if (elementMgr != null && !elementMgr.equals("__NULL__")) {
            subsys.setElementManager(elementMgr);
        }
        if (vgCap != 0L && freeCap != 0L) {
            subsys.setUsedCapacity(vgCap * 512L - freeCap * 512L);
        } else if (usedCap != 0L) {
            subsys.setUnusedCapacity(usedCap * 512L);
        }
        if (freeCap != 0L) {
            subsys.setUnusedCapacity(freeCap * 512L);
        } else if (unusedCap != 0L) {
            subsys.setUsedCapacity(unusedCap * 512L);
        }
        subsys.setLocation(location);
        if (ip != null && !ip.equals("__NULL__")) {
            subsys.setIpAddress(ip);
        }
        subsys.setDeviceId(dispname);
        subsys.setType(type);
        subsys.setInternalId(id);
        if (udp1 != null && !udp1.equals("__NULL__")) {
            subsys.setUserAttrib1(udp1);
        }
        if (udp2 != null && !udp2.equals("__NULL__")) {
            subsys.setUserAttrib2(udp2);
        }
        if (udp3 != null && !udp3.equals("__NULL__")) {
            subsys.setUserAttrib3(udp3);
        }
        return subsys;
    }

    private static GUIVolume createVolumeInstance(HashMap attr, String volumeId, GUIStorageSubsystem subsystem) {
        GUIVolume volume = new GUIVolume();
        GUIEntityFactory.populateVolumeInstance(volume, attr, volumeId, subsystem);
        return volume;
    }

    private static GUIVolume createVDiskInstance(HashMap attr, String vdiskId, GUIStorageSubsystem subsystem) {
        GUIVDisk vdisk = new GUIVDisk();
        GUIEntityFactory.populateVolumeInstance((GUIVolume)vdisk, attr, vdiskId, subsystem);
        GUIEntityFactory.populateVDiskInstance(vdisk, attr, vdiskId);
        return vdisk;
    }

    private static void populateVolumeInstance(GUIVolume volume, HashMap attr, String volumeId, GUIStorageSubsystem subsystem) {
        String name = (String)attr.get("NAME");
        String displayName = (String)attr.get("DISPLAY_NAME");
        short state = (Short)attr.get("CONSOLIDATED_STATUS");
        boolean detectable = (Short)attr.get("DETECTABLE") != 0;
        int lss = (Integer)attr.get("LSS");
        long capacity = (Long)attr.get("CAPACITY");
        int sysid = (Integer)attr.get("SUBSYSTEM_ID");
        int poolid = (Integer)attr.get("POOL_ID");
        Short redundancyInt = (Short)attr.get("REDUNDANCY");
        int redundancy = redundancyInt != null ? (int)redundancyInt.shortValue() : -1;
        short dataRdcy = (Short)attr.get("DATA_REDUNDANCY");
        short pkRdcy = (Short)attr.get("PACKAGE_REDUNDANCY");
        Short formatInt = (Short)attr.get("FORMAT");
        int format = formatInt != null ? formatInt : 0;
        String udp1 = (String)attr.get("USER_ATTRIB1");
        String udp2 = (String)attr.get("USER_ATTRIB2");
        String udp3 = (String)attr.get("USER_ATTRIB3");
        int raidLevel = redundancy;
        if (raidLevel == -1 || raidLevel == 0) {
            raidLevel = GUIEntityUtil.getRaidLevel((int)dataRdcy, (int)pkRdcy);
        }
        if (raidLevel == -1) {
            raidLevel = 99;
        }
        format = format >= 1 && format <= 4 ? 0 : (format == 5 ? 1 : (format == 6 ? 2 : 0));
        volume.setId(volumeId);
        volume.setName(name);
        if (displayName == null) {
            displayName = name;
        }
        volume.setDeviceId(displayName);
        volume.setState((int)state);
        volume.setDetectable(detectable);
        volume.setUserAttrib1(udp1);
        volume.setUserAttrib2(udp2);
        volume.setUserAttrib3(udp3);
        if (Integer.toString(lss) != null) {
            volume.setLcu(String.valueOf(lss));
        }
        if (capacity != 0L) {
            volume.setCapacity(capacity * 512L);
        }
        volume.setSubsystemId(String.valueOf(sysid));
        volume.setSubsystemDeviceId(subsystem.getDeviceId());
        volume.setSubsystemName(subsystem.getUserProvidedName());
        volume.setStoragePoolId(String.valueOf(poolid));
        volume.setRaidLevel(raidLevel);
        volume.setFormat(format);
    }

    private static void populateVDiskInstance(GUIVDisk vdisk, HashMap attr, String vdiskId) {
        short vdiskType = (Short)attr.get("VDISK_TYPE");
        short nativeStatus = (Short)attr.get("NATIVE_STATUS");
        int ioGroupId = (Integer)attr.get("IO_GROUP_ID");
        int mdiskId = (Integer)attr.get("MDISK_ID");
        long throttle = (Long)attr.get("THROTTLE");
        int fastWriteState = (Integer)attr.get("FAST_WRITE_STATE");
        short isAssigned = (Short)attr.get("IS_ASSIGNED");
        short isFormatted = (Short)attr.get("IS_FORMATTED");
        Object fcId = attr.get("FLASH_COPY_ID");
        Object fcName = attr.get("FLASH_COPY_NAME");
        Object mmId = attr.get("METRO_MIRROR_ID");
        Object mmName = attr.get("METRO_MIRROR_NAME");
        Object uid = attr.get("UNIQUE_ID");
        Object preferredNode = attr.get("PREFERRED_NODE");
        vdisk.setType((int)vdiskType);
        vdisk.setNativeStatus((int)nativeStatus);
        vdisk.setIoGroupId(String.valueOf(ioGroupId));
        if (mdiskId != 0) {
            vdisk.setMdiskId(String.valueOf(mdiskId));
        }
        vdisk.setIoThrottling(throttle);
        if (preferredNode != null && !preferredNode.equals("__NULL__")) {
            vdisk.setPreferredNodeForIO(String.valueOf(preferredNode));
        }
        if (fastWriteState != 0) {
            vdisk.setFastWriteState(fastWriteState);
        }
        if (uid != null && !uid.equals("__NULL__")) {
            vdisk.setUid(String.valueOf(String.valueOf(uid)));
        }
        vdisk.setAssigned(isAssigned == 1);
        vdisk.setFormatted(isFormatted == 1);
        if (fcId != null && !fcId.equals("__NULL__")) {
            vdisk.setFlashCopyId(String.valueOf(fcId));
        }
        if (fcName != null && !fcName.equals("__NULL__")) {
            vdisk.setFlashCopyName(String.valueOf(fcName));
        }
        if (mmId != null && !mmId.equals("__NULL__")) {
            vdisk.setMetroMirrorId(String.valueOf(mmId));
        }
        if (mmName != null && !mmName.equals("__NULL__")) {
            vdisk.setMetroMirrorName(String.valueOf(mmName));
        }
    }

    private static GUIZone createZoneInstance(HashMap attr, String fabricId, String zsetId) {
        GUIZone zone = new GUIZone();
        String name = (String)attr.get("ZONE_NAME");
        zone.setId(name);
        zone.setDeviceId(name);
        zone.setName(name);
        zone.setZonesetId(zsetId);
        return zone;
    }

    private static GUIZoneSet createZoneSetInstance(HashMap attr, String fabricId, String zonsetId) {
        GUIZoneSet zset = new GUIZoneSet();
        String name = (String)attr.get("ZSET_NAME");
        boolean active = (Integer)attr.get("ACTIVE") == 1;
        zset.setId(zonsetId);
        zset.setDeviceId(name);
        zset.setName(name);
        zset.setActive(active);
        zset.setFabricId(fabricId);
        return zset;
    }

    public static GUIEntityFactory getInstance() {
        if (factory == null) {
            factory = new GUIEntityFactory();
        }
        return factory;
    }

    private DBConnection getDBConnection() {
        return ServiceUtils.getConnection();
    }

    private void closeDBConnection(DBConnection dbCon) throws Exception {
        if (dbCon != null && !dbCon.isClosed()) {
            dbCon.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getAllStorageSubsystems() throws Exception {
        DBConnection dbConnection = this.getDBConnection();
        HashMap storageSubsystems = null;
        try {
            DeviceRequest dr = new DeviceRequest();
            DeviceRequestHndlr.initDeviceServerComm(dr);
            IDiskReportingService repSvc = (IDiskReportingService)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, IDiskReportingService.class, (String)"DiskManagerService");
            String[] subsysIds = repSvc.getStorageSubsystems(new HashMap());
            storageSubsystems = this.getStorageSubsystems(subsysIds);
        }
        catch (Exception exception) {
        }
        finally {
            this.closeDBConnection(dbConnection);
        }
        return storageSubsystems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getStorageSubsystems(String[] subsysIds) throws Exception {
        HashMap<String, GUIStorageSubsystem> storageSubsystems = new HashMap<String, GUIStorageSubsystem>();
        DBConnection dbConnection = this.getDBConnection();
        try {
            if (subsysIds != null && subsysIds.length > 0) {
                DeviceRequest dr = new DeviceRequest();
                DeviceRequestHndlr.initDeviceServerComm(dr);
                IDiskReportingService repSvc = (IDiskReportingService)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, IDiskReportingService.class, (String)"DiskManagerService");
                HashMap[] subsysAttrs = repSvc.getStorageSubsystemAttributes(subsysIds, SUBSYSTEM_DB_ATTRIBUTES);
                if (subsysAttrs != null && subsysAttrs.length > 0 && subsysAttrs.length == subsysIds.length) {
                    for (int i = 0; i < subsysAttrs.length; ++i) {
                        HashMap subsysAttr = subsysAttrs[i];
                        GUIStorageSubsystem subsys = GUIEntityFactory.createStorageSubsystemInstance(subsysAttr, subsysIds[i]);
                        storageSubsystems.put(subsys.getId(), subsys);
                    }
                }
            }
        }
        finally {
            this.closeDBConnection(dbConnection);
        }
        return storageSubsystems;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getSubsystemPorts(String subsystemId) throws Exception {
        DBConnection dbConnection = this.getDBConnection();
        HashMap subsystems = this.getStorageSubsystems(new String[]{subsystemId});
        GUIStorageSubsystem subsys = (GUIStorageSubsystem)subsystems.values().iterator().next();
        HashMap<String, GUIPort> sysports = new HashMap<String, GUIPort>();
        try {
            HashMap[] portAttrs = DiskDbAccessor.getPortsForSubsystem((String)String.valueOf(subsys.getInternalId()), (String[])PORT_DB_ATTRIBUTES, (DBConnection)dbConnection);
            if (portAttrs != null && portAttrs.length > 0) {
                for (int i = 0; i < portAttrs.length; ++i) {
                    HashMap portAttr = portAttrs[i];
                    GUIPort port = GUIEntityFactory.createPortInstance(portAttr);
                    GUIPort curport = (GUIPort)sysports.get(port.getWwpn());
                    if (curport != null) {
                        Vector fabricIds = port.getFabrics();
                        if (fabricIds.size() < 1) continue;
                        curport.addFabricId((String)fabricIds.elementAt(0));
                        continue;
                    }
                    port.setHostName(subsys.getDeviceId());
                    sysports.put(port.getWwpn(), port);
                }
            }
        }
        finally {
            this.closeDBConnection(dbConnection);
        }
        return sysports;
    }

    public HashMap getFabricPortMap() throws Exception {
        HashMap fabricMap = new HashMap();
        String[] fabricIds = FabricDbAccess.getFabrics(new HashMap());
        if (fabricIds != null && fabricIds.length > 0) {
            for (int i = 0; i < fabricIds.length; ++i) {
                String fabricId = fabricIds[i];
                String[] zsetIds = FabricDbAccess.getZoneSets((String)fabricId, (boolean)true);
                if (zsetIds == null || zsetIds.length <= 0) continue;
                for (int j = 0; j < zsetIds.length; ++j) {
                    String zsetId = zsetIds[j];
                    String[] zoneIds = FabricDbAccess.getZones((String)fabricId, (String)zsetId, (boolean)true);
                    if (zoneIds == null || zoneIds.length <= 0) continue;
                    for (int k = 0; k < zoneIds.length; ++k) {
                        String zoneId = zoneIds[k];
                        String[] portWwpn = FabricDbAccess.getPortsInZone((String)fabricId, (String)zoneId, (boolean)true);
                        Vector<String> fIds = (Vector<String>)fabricMap.get(portWwpn);
                        if (fIds == null) {
                            fIds = new Vector<String>();
                        }
                        if (!fIds.contains(fabricId)) {
                            fIds.add(fabricId);
                        }
                        fabricMap.put(portWwpn, fIds);
                    }
                }
            }
        }
        return fabricMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getHostPortsBySubsystem(String subsystemId) throws Exception {
        DBConnection dbConnection = this.getDBConnection();
        HashMap<String, GUIPort> hostports = new HashMap<String, GUIPort>();
        try {
            GUIPort curport;
            GUIPort port;
            HashMap portAttr;
            int i;
            HashMap subsystems = this.getStorageSubsystems(new String[]{subsystemId});
            GUIStorageSubsystem subsys = (GUIStorageSubsystem)subsystems.values().iterator().next();
            HashMap[] portInFabricAttrs = DiskDbAccessor.getHostPortsInFabricForSubsystem((String)String.valueOf(subsys.getInternalId()), (String[])PORT_DB_ATTRIBUTES, (DBConnection)dbConnection);
            HashMap[] portDefinedAttrs = DiskDbAccessor.getDefinedHostPortsForSubsystem((String)String.valueOf(subsys.getInternalId()), (String[])PORT_DB_ATTRIBUTES, (DBConnection)dbConnection);
            if (portInFabricAttrs != null && portInFabricAttrs.length > 0) {
                for (i = 0; i < portInFabricAttrs.length; ++i) {
                    portAttr = portInFabricAttrs[i];
                    port = GUIEntityFactory.createPortInstance(portAttr);
                    curport = (GUIPort)hostports.get(port.getWwpn());
                    if (curport != null) {
                        Vector fabricIds = port.getFabrics();
                        if (fabricIds.size() < 1) continue;
                        curport.addFabricId((String)fabricIds.elementAt(0));
                        continue;
                    }
                    hostports.put(port.getWwpn(), port);
                }
            }
            if (portDefinedAttrs != null && portDefinedAttrs.length > 0) {
                for (i = 0; i < portDefinedAttrs.length; ++i) {
                    portAttr = portDefinedAttrs[i];
                    port = GUIEntityFactory.createPortInstance(portAttr);
                    curport = (GUIPort)hostports.get(port.getWwpn());
                    if (curport != null) continue;
                    hostports.put(port.getWwpn(), port);
                }
            }
        }
        finally {
            this.closeDBConnection(dbConnection);
        }
        return hostports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getStoragePoolsBySubsytstem(String subsystemId) throws Exception {
        DBConnection dbConnection = this.getDBConnection();
        HashMap stgpools = new HashMap();
        try {
            DeviceRequest dr = new DeviceRequest();
            DeviceRequestHndlr.initDeviceServerComm(dr);
            IDiskReportingService repSvc = (IDiskReportingService)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, IDiskReportingService.class, (String)"DiskManagerService");
            String[] poolIds = repSvc.getStoragePoolsForSubsystem(subsystemId, new HashMap());
            stgpools = this.getStoragePools(subsystemId, poolIds);
        }
        finally {
            this.closeDBConnection(dbConnection);
        }
        return stgpools;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getStoragePools(String subsystemId, String[] poolIds) throws Exception {
        HashMap<String, GUIStoragePool> stgpools = new HashMap<String, GUIStoragePool>();
        DBConnection dbConnection = this.getDBConnection();
        try {
            if (poolIds != null && poolIds.length > 0) {
                DeviceRequest dr = new DeviceRequest();
                DeviceRequestHndlr.initDeviceServerComm(dr);
                IDiskReportingService repSvc = (IDiskReportingService)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, IDiskReportingService.class, (String)"DiskManagerService");
                HashMap[] poolAttrs = repSvc.getStoragePoolAttributes(poolIds, STORAGE_POOL_DB_ATTRIBUTES);
                if (poolAttrs != null && poolAttrs.length > 0 && poolAttrs.length == poolAttrs.length) {
                    for (int i = 0; i < poolAttrs.length; ++i) {
                        HashMap poolAttr = poolAttrs[i];
                        GUIStoragePool pool = GUIEntityFactory.createStoragePoolInstance(poolAttr, poolIds[i]);
                        if (!pool.isDetectable()) continue;
                        stgpools.put(pool.getId(), pool);
                    }
                }
            }
        }
        finally {
            this.closeDBConnection(dbConnection);
        }
        return stgpools;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getIOGroupsBySVC(String subsystemId) throws Exception {
        HashMap subsystems = this.getStorageSubsystems(new String[]{subsystemId});
        GUIStorageSubsystem subsys = (GUIStorageSubsystem)subsystems.values().iterator().next();
        DBConnection dbConnection = this.getDBConnection();
        HashMap<String, GUIIOGroup> iogroups = new HashMap<String, GUIIOGroup>();
        try {
            HashMap[] ioGroupAttrs = DiskDbAccessor.getIOGroupsBySVC((String)String.valueOf(subsys.getInternalId()), (String[])IO_GROUP_DB_ATTRIBUTES, null, (DBConnection)dbConnection);
            if (ioGroupAttrs != null && ioGroupAttrs.length > 0) {
                for (int i = 0; i < ioGroupAttrs.length; ++i) {
                    HashMap ioGroupAttr = ioGroupAttrs[i];
                    GUIIOGroup group = GUIEntityFactory.createIOGroupInstance(ioGroupAttr);
                    iogroups.put(group.getId(), group);
                }
            }
        }
        finally {
            this.closeDBConnection(dbConnection);
        }
        return iogroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getMDiskGroupsBySVC(String subsystemId) throws Exception {
        DBConnection dbConnection = this.getDBConnection();
        HashMap mdiskGroups = null;
        try {
            DeviceRequest dr = new DeviceRequest();
            DeviceRequestHndlr.initDeviceServerComm(dr);
            IDiskReportingService repSvc = (IDiskReportingService)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, IDiskReportingService.class, (String)"DiskManagerService");
            String[] groupIds = repSvc.getStoragePoolsForSubsystem(subsystemId, new HashMap());
            mdiskGroups = this.getMDiskGroups(subsystemId, groupIds);
        }
        finally {
            this.closeDBConnection(dbConnection);
        }
        return mdiskGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getMDiskGroups(String subsystemId, String[] groupIds) throws Exception {
        HashMap<String, GUIMDiskGroup> mdiskGroups = new HashMap<String, GUIMDiskGroup>();
        DBConnection dbConnection = this.getDBConnection();
        try {
            if (groupIds != null && groupIds.length > 0) {
                DeviceRequest dr = new DeviceRequest();
                DeviceRequestHndlr.initDeviceServerComm(dr);
                IDiskReportingService repSvc = (IDiskReportingService)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, IDiskReportingService.class, (String)"DiskManagerService");
                HashMap[] groupAttrs = repSvc.getStoragePoolAttributes(groupIds, STORAGE_POOL_DB_ATTRIBUTES);
                if (groupAttrs != null && groupAttrs.length > 0 && groupAttrs.length == groupAttrs.length) {
                    for (int i = 0; i < groupAttrs.length; ++i) {
                        HashMap groupAttr = groupAttrs[i];
                        GUIMDiskGroup group = (GUIMDiskGroup)GUIEntityFactory.createMDiskGroupInstance(groupAttr, groupIds[i]);
                        mdiskGroups.put(group.getId(), group);
                    }
                }
            }
        }
        finally {
            this.closeDBConnection(dbConnection);
        }
        return mdiskGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getMDisksByMDiskGroup(String subsystemId, String mdiskGroupId) throws Exception {
        HashMap subsystems = this.getStorageSubsystems(new String[]{subsystemId});
        GUIStorageSubsystem subsys = (GUIStorageSubsystem)subsystems.values().iterator().next();
        HashMap mdiskgroups = this.getMDiskGroups(subsystemId, new String[]{mdiskGroupId});
        GUIMDiskGroup mdiskgroup = (GUIMDiskGroup)mdiskgroups.values().iterator().next();
        DBConnection dbConnection = this.getDBConnection();
        HashMap<String, GUIMDisk> mdisks = new HashMap<String, GUIMDisk>();
        try {
            HashMap[] mdiskAttrs = DiskDbAccessor.getMDisksByMDiskGroup((String)String.valueOf(mdiskgroup.getInternalId()), (String[])MDISK_DB_ATTRIBUTES, (DBConnection)dbConnection);
            if (mdiskAttrs != null && mdiskAttrs.length > 0) {
                for (int i = 0; i < mdiskAttrs.length; ++i) {
                    HashMap mdiskAttr = mdiskAttrs[i];
                    GUIMDisk mdisk = GUIEntityFactory.createMDiskInstance(mdiskAttr, subsys);
                    mdisks.put(mdisk.getId(), mdisk);
                }
            }
        }
        finally {
            this.closeDBConnection(dbConnection);
        }
        return mdisks;
    }

    public HashMap getUnmanagedMDisksBySVC(String subsystemId) throws Exception {
        return this.getMDisksBySVC(subsystemId, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getMDisksBySVC(String subsystemId, int mode) throws Exception {
        HashMap subsystems = this.getStorageSubsystems(new String[]{subsystemId});
        GUIStorageSubsystem subsys = (GUIStorageSubsystem)subsystems.values().iterator().next();
        DBConnection dbConnection = this.getDBConnection();
        HashMap<String, GUIMDisk> mdisks = new HashMap<String, GUIMDisk>();
        try {
            HashMap[] mdiskAttrs = DiskDbAccessor.getMDisksBySVC((String)String.valueOf(subsys.getInternalId()), (int)mode, (String[])MDISK_DB_ATTRIBUTES, null, (DBConnection)dbConnection);
            if (mdiskAttrs != null && mdiskAttrs.length > 0) {
                for (int i = 0; i < mdiskAttrs.length; ++i) {
                    HashMap mdiskAttr = mdiskAttrs[i];
                    GUIMDisk mdisk = GUIEntityFactory.createMDiskInstance(mdiskAttr, subsys);
                    mdisks.put(mdisk.getId(), mdisk);
                }
            }
        }
        finally {
            this.closeDBConnection(dbConnection);
        }
        return mdisks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getVDiskIdsByIOGroup(String subsystemId, String ioGroupId) throws Exception {
        DBConnection dbConnection = this.getDBConnection();
        String[] vdiskIds = null;
        try {
            vdiskIds = DiskDbAccessor.getVDiskIdsForByIOGroup((String)subsystemId, (String)ioGroupId, new HashMap(), null, (DBConnection)dbConnection);
        }
        finally {
            this.closeDBConnection(dbConnection);
        }
        return vdiskIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getVolumeIdsBySubsystem(String subsystemId) throws Exception {
        String[] volumeIds = null;
        DBConnection dbConnection = this.getDBConnection();
        try {
            DeviceRequest dr = new DeviceRequest();
            DeviceRequestHndlr.initDeviceServerComm(dr);
            IDiskReportingService repSvc = (IDiskReportingService)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, IDiskReportingService.class, (String)"DiskManagerService");
            volumeIds = repSvc.getStorageVolumesForSubsystem(subsystemId, new HashMap());
        }
        finally {
            this.closeDBConnection(dbConnection);
        }
        return volumeIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getVolumeNamesBySubsystem(String subsystemId) throws Exception {
        DBConnection dbConnection = this.getDBConnection();
        HashMap subsystems = this.getStorageSubsystems(new String[]{subsystemId});
        GUIStorageSubsystem subsys = (GUIStorageSubsystem)subsystems.values().iterator().next();
        String[] volumeNames = new String[]{};
        try {
            HashMap[] volNameAttrs = DiskDbAccessor.getVolumeNamesForSubsystem((String)String.valueOf(subsys.getInternalId()), (String[])new String[]{"DISPLAY_NAME"}, (DBConnection)dbConnection);
            if (volNameAttrs != null && volNameAttrs.length > 0) {
                volumeNames = new String[volNameAttrs.length];
                for (int i = 0; i < volNameAttrs.length; ++i) {
                    HashMap volNameAttr = volNameAttrs[i];
                    volumeNames[i] = (String)volNameAttr.get("DISPLAY_NAME");
                }
            }
        }
        finally {
            this.closeDBConnection(dbConnection);
        }
        return volumeNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getVolumes(String subsystemId, String[] volumeIdsIn) throws Exception {
        HashMap<String, GUIVolume> volumes = new HashMap<String, GUIVolume>();
        DBConnection dbConnection = this.getDBConnection();
        try {
            String[] volumeIds = volumeIdsIn;
            if (volumeIds != null && volumeIds.length > 0) {
                HashMap subsystems = this.getStorageSubsystems(new String[]{subsystemId});
                GUIStorageSubsystem subsys = (GUIStorageSubsystem)subsystems.values().iterator().next();
                HashMap stgpools = this.getStoragePoolsBySubsytstem(subsystemId);
                HashMap<Integer, String> poolIdNameMap = new HashMap<Integer, String>();
                for (GUIStoragePool pool : stgpools.values()) {
                    poolIdNameMap.put(new Integer(pool.getInternalId()), pool.getDeviceId());
                }
                DeviceRequest dr = new DeviceRequest();
                DeviceRequestHndlr.initDeviceServerComm(dr);
                IDiskReportingService repSvc = (IDiskReportingService)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, IDiskReportingService.class, (String)"DiskManagerService");
                HashMap[] volumeAttrs = repSvc.getStorageVolumeAttributes(volumeIds, VOLUME_DB_ATTRIBUTES);
                if (volumeAttrs != null && volumeAttrs.length > 0 && volumeAttrs.length == volumeIds.length) {
                    for (int i = 0; i < volumeAttrs.length; ++i) {
                        HashMap volumeAttr = volumeAttrs[i];
                        if (volumeAttr == null) continue;
                        GUIVolume volume = GUIEntityFactory.createVolumeInstance(volumeAttr, volumeIds[i], subsys);
                        volume.setStoragePoolName((String)poolIdNameMap.get(new Integer(volume.getStoragePoolId())));
                        if (!volume.isDetectable()) continue;
                        volumes.put(volume.getId(), volume);
                    }
                }
            }
        }
        finally {
            this.closeDBConnection(dbConnection);
        }
        return volumes;
    }

    public HashMap getVolumesBySubsystem(String subsystemId) throws Exception {
        String[] volumeIds = this.getVolumeIdsBySubsystem(subsystemId);
        return this.getVolumes(subsystemId, volumeIds);
    }

    public String[] getVDiskIdsBySVC(String subsystemId) throws Exception {
        return this.getVolumeIdsBySubsystem(subsystemId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getVDisks(String subsystemId, String[] vdiskIds) throws Exception {
        HashMap<String, GUIVDisk> vdisksBySubsystem = new HashMap<String, GUIVDisk>();
        DBConnection dbConnection = this.getDBConnection();
        try {
            if (vdiskIds != null && vdiskIds.length > 0) {
                HashMap subsystems = this.getStorageSubsystems(new String[]{subsystemId});
                GUIStorageSubsystem subsys = (GUIStorageSubsystem)subsystems.values().iterator().next();
                HashMap mdgroups = this.getMDiskGroupsBySVC(subsystemId);
                HashMap<String, String> grpIdNameMap = new HashMap<String, String>();
                for (GUIMDiskGroup group : mdgroups.values()) {
                    grpIdNameMap.put(String.valueOf(group.getInternalId()), group.getDeviceId());
                }
                HashMap iogroups = this.getIOGroupsBySVC(subsystemId);
                HashMap<String, String> iogrpIdNameMap = new HashMap<String, String>();
                HashMap<String, String> iogrpIDMap = new HashMap<String, String>();
                for (GUIIOGroup iogroup : iogroups.values()) {
                    iogrpIdNameMap.put(iogroup.getId(), iogroup.getName());
                    iogrpIDMap.put(iogroup.getId(), iogroup.getDeviceId());
                }
                HashMap mdisks = this.getMDisksBySVC(subsystemId, -1);
                HashMap<String, String> mdiskIdNameMap = new HashMap<String, String>();
                for (GUIMDisk mdisk : mdisks.values()) {
                    mdiskIdNameMap.put(String.valueOf(mdisk.getInternalId()), mdisk.getName());
                }
                DeviceRequest dr = new DeviceRequest();
                DeviceRequestHndlr.initDeviceServerComm(dr);
                IDiskReportingService repSvc = (IDiskReportingService)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, IDiskReportingService.class, (String)"DiskManagerService");
                HashMap[] vdiskAttrs = repSvc.getStorageVolumeAttributes(vdiskIds, VDISK_DB_ATTRIBUTES);
                if (vdiskAttrs != null && vdiskAttrs.length > 0 && vdiskAttrs.length == vdiskIds.length) {
                    for (int i = 0; i < vdiskAttrs.length; ++i) {
                        HashMap vdiskAttr = vdiskAttrs[i];
                        if (vdiskAttr == null) continue;
                        GUIVDisk vdisk = (GUIVDisk)GUIEntityFactory.createVDiskInstance(vdiskAttr, vdiskIds[i], subsys);
                        vdisk.setStoragePoolName((String)grpIdNameMap.get(vdisk.getStoragePoolId()));
                        vdisk.setIoGroupName((String)iogrpIdNameMap.get(vdisk.getIoGroupId()));
                        vdisk.setMdiskName((String)mdiskIdNameMap.get(vdisk.getMdiskId()));
                        vdisk.setIoGrpId((String)iogrpIDMap.get(vdisk.getIoGroupId()));
                        if (!vdisk.isDetectable()) continue;
                        vdisksBySubsystem.put(vdisk.getId(), vdisk);
                    }
                }
            }
        }
        finally {
            this.closeDBConnection(dbConnection);
        }
        return vdisksBySubsystem;
    }

    public HashMap getVDisksBySVC(String subsystemId) throws Exception {
        String[] vdiskIds = this.getVDiskIdsBySVC(subsystemId);
        return this.getVDisks(subsystemId, vdiskIds);
    }

    public GUIVolume getVolume(String subsystemId, String volumeId) throws Exception {
        GUIVolume volume = null;
        String[] volumeIds = new String[]{volumeId};
        HashMap volumes = this.getVolumes(subsystemId, volumeIds);
        if (volumes != null && volumes.size() > 0) {
            volume = (GUIVolume)volumes.values().iterator().next();
        }
        return volume;
    }

    public GUIVDisk getVDisk(String subsystemId, String vdiskId) throws Exception {
        GUIVDisk vdisk = null;
        String[] vdiskIds = new String[]{vdiskId};
        HashMap vdisks = this.getVDisks(subsystemId, vdiskIds);
        if (vdisks != null && vdisks.size() > 0) {
            vdisk = (GUIVDisk)vdisks.values().iterator().next();
        }
        return vdisk;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getVolumeIdsByStoragePool(String subsystemId, String stgpoolId) throws Exception {
        String[] volumeIds = null;
        DBConnection dbConnection = this.getDBConnection();
        try {
            HashMap<String, String> attributes = new HashMap<String, String>();
            attributes.put("DETECTABLE", "1");
            DeviceRequest dr = new DeviceRequest();
            DeviceRequestHndlr.initDeviceServerComm(dr);
            IDiskReportingService repSvc = (IDiskReportingService)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, IDiskReportingService.class, (String)"DiskManagerService");
            volumeIds = repSvc.getStorageVolumesForPool(stgpoolId, attributes);
        }
        finally {
            this.closeDBConnection(dbConnection);
        }
        return volumeIds;
    }

    public HashMap getVolumesByStoragePool(String subsystemId, String stgpoolId) throws Exception {
        String[] volumeIds = this.getVolumeIdsByStoragePool(subsystemId, stgpoolId);
        return this.getVolumes(subsystemId, volumeIds);
    }

    public String[] getVDiskIdsByMDiskGroup(String subsystemId, String mdiskgroupId) throws Exception {
        return this.getVolumeIdsByStoragePool(subsystemId, mdiskgroupId);
    }

    public HashMap getVDisksByMDiskGroup(String subsystemId, String mdiskgroupId) throws Exception {
        String[] vdiskIds = this.getVDiskIdsByMDiskGroup(subsystemId, mdiskgroupId);
        return this.getVDisks(subsystemId, vdiskIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getVolumeIdsByHost(String subsystemId, String hostPortWwpn) throws Exception {
        String[] volumeIds = null;
        DBConnection dbConnection = this.getDBConnection();
        try {
            HashMap<String, Object> filters = new HashMap<String, Object>();
            filters.put("WWPN", new String[]{hostPortWwpn});
            filters.put("Assigned", Boolean.TRUE);
            DeviceRequest dr = new DeviceRequest();
            DeviceRequestHndlr.initDeviceServerComm(dr);
            IDiskReportingService repSvc = (IDiskReportingService)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, IDiskReportingService.class, (String)"DiskManagerService");
            HashMap hostInfoMap = repSvc.getHostInfo(subsystemId, filters, true);
            if (hostInfoMap != null && hostInfoMap.size() > 0) {
                Iterator hostInfoIter = hostInfoMap.values().iterator();
                Vector<String> volIdVec = new Vector<String>();
                while (hostInfoIter.hasNext()) {
                    HostInfo hostInfo = (HostInfo)hostInfoIter.next();
                    String[] mappedVolIds = hostInfo.getMappedVolumeIDs();
                    if (mappedVolIds == null || mappedVolIds.length <= 0) continue;
                    for (int i = 0; i < mappedVolIds.length; ++i) {
                        String volId = mappedVolIds[i];
                        if (volIdVec.contains(volId)) continue;
                        volIdVec.add(volId);
                    }
                }
                volumeIds = volIdVec.toArray(new String[0]);
            }
        }
        finally {
            this.closeDBConnection(dbConnection);
        }
        return volumeIds;
    }

    public HashMap getVolumesByHost(String subsystemId, String hostPortWwpn) throws Exception {
        String[] volumeIds = this.getVolumeIdsByHost(subsystemId, hostPortWwpn);
        return this.getVolumes(subsystemId, volumeIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap getAssignedHostPortsBySubsystem(String subsystemId) throws Exception {
        HashMap<String, GUIPort> hostPorts = new HashMap<String, GUIPort>();
        DBConnection dbConnection = this.getDBConnection();
        try {
            HashMap<String, String> port2hostMap = new HashMap<String, String>();
            HashMap[] mappingAttrs = DiskDbAccessor.getPort2HostMapping((String[])new String[]{PORT_ATTR_PORT_WWN, PORT_ATTR_HOST_URL}, (DBConnection)dbConnection);
            if (mappingAttrs != null && mappingAttrs.length > 0) {
                for (int i = 0; i < mappingAttrs.length; ++i) {
                    HashMap mapAttr = mappingAttrs[i];
                    String portwwn = (String)mapAttr.get(PORT_ATTR_PORT_WWN);
                    String hosturl = (String)mapAttr.get(PORT_ATTR_HOST_URL);
                    port2hostMap.put(portwwn, hosturl);
                }
            }
            HashMap<String, Boolean> filters = new HashMap<String, Boolean>();
            filters.put("Assigned", Boolean.TRUE);
            DeviceRequest dr = new DeviceRequest();
            DeviceRequestHndlr.initDeviceServerComm(dr);
            IDiskReportingService repSvc = (IDiskReportingService)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, IDiskReportingService.class, (String)"DiskManagerService");
            HashMap hostInfoMap = repSvc.getHostInfo(subsystemId, filters, false);
            if (hostInfoMap != null && hostInfoMap.size() > 0) {
                for (String portwwpn : hostInfoMap.keySet()) {
                    GUIPort port = new GUIPort();
                    port.setId(portwwpn);
                    port.setName(portwwpn);
                    port.setWwpn(portwwpn);
                    port.setDeviceId(portwwpn);
                    String hostname = (String)port2hostMap.get(portwwpn);
                    if (hostname != null) {
                        port.setHostName(hostname);
                    }
                    hostPorts.put(portwwpn, port);
                }
            }
        }
        finally {
            this.closeDBConnection(dbConnection);
        }
        return hostPorts;
    }

    public String[] getVDiskIdsByHost(String subsystemId, String hostPortWwpn) throws Exception {
        return this.getVolumeIdsByHost(subsystemId, hostPortWwpn);
    }

    public HashMap getVDisksByHost(String subsystemId, String hostId) throws Exception {
        String[] vdiskIds = this.getVDiskIdsByHost(subsystemId, hostId);
        return this.getVDisks(subsystemId, vdiskIds);
    }

    public HashMap getPortAssignments(String subsystemId, String volumeId) throws Exception {
        String[] volumeIds = new String[]{volumeId};
        return this.getPortAssignments(subsystemId, volumeIds)[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap[] getPortAssignments(String subsystemId, String[] volumeIds) throws Exception {
        DBConnection dbConnection = this.getDBConnection();
        HashMap[] allAssignments = new HashMap[volumeIds.length];
        try {
            DeviceRequest dr = new DeviceRequest();
            DeviceRequestHndlr.initDeviceServerComm(dr);
            IDiskReportingService repSvc = (IDiskReportingService)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, IDiskReportingService.class, (String)"DiskManagerService");
            HashMap[] portAssignMap = repSvc.getStorageVolumeAssignments(volumeIds, new HashMap());
            if (portAssignMap != null && portAssignMap.length == volumeIds.length) {
                for (int i = 0; i < volumeIds.length; ++i) {
                    HashMap portMap = portAssignMap[i];
                    HashMap<String, GUIPortAssignment> portAssignments = new HashMap<String, GUIPortAssignment>();
                    if (portMap != null && portMap.size() > 0) {
                        for (String wwpn : portMap.keySet()) {
                            ExtendedVolumeAssignments assign = (ExtendedVolumeAssignments)portMap.get(wwpn);
                            GUIPortAssignment portAssign = GUIEntityFactory.createPortAssignmentInstance(assign, volumeIds[i], wwpn);
                            portAssignments.put(wwpn, portAssign);
                        }
                    }
                    allAssignments[i] = portAssignments;
                }
            }
        }
        finally {
            this.closeDBConnection(dbConnection);
        }
        return allAssignments;
    }

    public GUICapabilityData getCapabilities(String subsystemId) throws Exception {
        GUICapabilityData subsysCap = null;
        HashMap subsystems = this.getStorageSubsystems(new String[]{subsystemId});
        GUIStorageSubsystem subsys = (GUIStorageSubsystem)subsystems.values().iterator().next();
        String internalId = String.valueOf(subsys.getInternalId());
        HashMap[] subsysCapAttrs = DiskDbAccessor.getStorageSubsystemCapabilities((String[])new String[]{internalId}, (String[])CAPABILITY_DATA_DB_ATTRIBUTES, null);
        HashMap subsysCapAttr = subsysCapAttrs[0];
        subsysCap = subsysCapAttr != null ? GUIEntityFactory.createCapabilityDataInstance(subsysCapAttr) : new GUICapabilityData();
        return subsysCap;
    }

    public int[] getSupportedRaidLevels(String subsystemId) throws Exception {
        return this.getCapabilities(subsystemId).getRaidLevelsSupported();
    }

    public long getMaxVolumes(String subsystemId) throws Exception {
        return this.getCapabilities(subsystemId).getNumVolumesSupported();
    }

    private long[] getVolumeSizeRange(String subsystemId, String stgpoolId) throws Exception {
        DeviceRequest dr = new DeviceRequest();
        DeviceRequestHndlr.initDeviceServerComm(dr);
        IDiskReportingService repSvc = (IDiskReportingService)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, IDiskReportingService.class, (String)"DiskManagerService");
        return repSvc.getDefaultSupportedVolumeSizeRange(stgpoolId);
    }

    public HashMap getFabrics() throws Exception {
        HashMap[] fabricAttrs;
        HashMap<String, GUIFabric> fabrics = new HashMap<String, GUIFabric>();
        String[] fabricIds = FabricDbAccess.getFabrics(new HashMap());
        if (fabricIds != null && fabricIds.length > 0 && (fabricAttrs = FabricDbAccess.getFabricAttributes((String[])fabricIds, (String[])FABRIC_DB_ATTRIBUTES)) != null && fabricAttrs.length > 0) {
            for (int i = 0; i < fabricAttrs.length; ++i) {
                HashMap fabricAttr = fabricAttrs[i];
                GUIFabric fabric = GUIEntityFactory.createFabricInstance(fabricAttr);
                GUIZoneSet activeZS = this.getActiveZoneSet(fabric.getId());
                if (activeZS != null) {
                    fabric.setActiveZoneSet(activeZS);
                }
                fabrics.put(fabric.getId(), fabric);
            }
        }
        return fabrics;
    }

    public GUIZoneSet getActiveZoneSet(String fabricId) throws Exception {
        HashMap zones;
        HashMap zonesetAttr;
        HashMap[] zonesetAttrs;
        GUIZoneSet activeZoneSet = null;
        String[] zonesetIds = FabricDbAccess.getZoneSets((String)fabricId, (boolean)true);
        if (zonesetIds != null && zonesetIds.length > 0 && (zonesetAttrs = FabricDbAccess.getZoneSetAttributes((String)fabricId, (String[])zonesetIds, (boolean)true, (String[])ZONE_SET_DB_ATTRIBUTES)) != null && zonesetAttrs.length > 0 && (activeZoneSet = GUIEntityFactory.createZoneSetInstance(zonesetAttr = zonesetAttrs[0], fabricId, zonesetIds[0])) != null && (zones = this.getZones(fabricId, activeZoneSet.getId())) != null) {
            activeZoneSet.setZones(zones);
        }
        return activeZoneSet;
    }

    public HashMap getZones(String fabricId, String zoneSetId) throws Exception {
        HashMap[] zoneAttrs;
        HashMap<String, GUIZone> zones = new HashMap<String, GUIZone>();
        String[] zoneIds = FabricDbAccess.getZones((String)fabricId, (String)zoneSetId, (boolean)true);
        if (zoneIds != null && zoneIds.length > 0 && (zoneAttrs = FabricDbAccess.getZoneAttributes((String)fabricId, (String[])zoneIds, (boolean)true, (String[])ZONE_DB_ATTRIBUTES)) != null && zoneAttrs.length > 0) {
            for (int i = 0; i < zoneAttrs.length; ++i) {
                String[] ports;
                HashMap zoneAttr = zoneAttrs[i];
                GUIZone zone = GUIEntityFactory.createZoneInstance(zoneAttr, fabricId, zoneSetId);
                if (zone != null && (ports = this.getPortsByZone(fabricId, zoneSetId, zone.getId())) != null) {
                    zone.setPorts(ports);
                }
                zones.put(zone.getId(), zone);
            }
        }
        return zones;
    }

    public String[] getPortsByZone(String fabricId, String zonesetId, String zoneId) throws Exception {
        String[] portWwpns = null;
        portWwpns = FabricDbAccess.getPortsInZone((String)fabricId, (String)zoneId, (boolean)true);
        return portWwpns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areVolumeActionsInProgress(String subsystemId) throws Exception {
        DBConnection dbConnection = this.getDBConnection();
        int numJobs = 0;
        try {
            numJobs = DiskDbAccessor.getNumberOfJobs((int)113, (int)2, null, (DBConnection)dbConnection);
        }
        finally {
            this.closeDBConnection(dbConnection);
        }
        return numJobs > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setStorageSubsystemAttributes(String subsystemId, Hashtable attributes) throws Exception {
        int retcode = 0;
        DBConnection dbConnection = this.getDBConnection();
        try {
            retcode = DiskDbAccessor.updateSubsystemAttributes((String)subsystemId, (Hashtable)attributes, null, (DBConnection)dbConnection);
        }
        finally {
            this.closeDBConnection(dbConnection);
        }
        return retcode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setStorageVolumeAttributes(String volumeId, Hashtable attributes) throws Exception {
        int retcode = 0;
        DBConnection dbConnection = this.getDBConnection();
        try {
            retcode = DiskDbAccessor.updateVolumeAttributes((String)volumeId, (Hashtable)attributes, null, (DBConnection)dbConnection);
        }
        finally {
            this.closeDBConnection(dbConnection);
        }
        return retcode;
    }
}

