/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui.disk;

import java.util.Hashtable;
import org.eclipse.aperi.common.api.SRMMessage;
import org.eclipse.aperi.common.api.SRMRuntimeException;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.disk.api.IDiskManagerService;
import org.eclipse.aperi.gui.common.model.GUIRequestData;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.sanmgmt.middleware.data.MiddlewareCrypto;
import org.eclipse.aperi.sanmgmt.middleware.data.SecurityContext;
import org.eclipse.aperi.sanmgmt.middleware.data.SystemSecurityContext;
import org.eclipse.aperi.server.DeviceServerManager;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.ThrowAway;
import org.eclipse.aperi.server.handler.gui.disk.GUIEntityFactory;
import org.eclipse.aperi.util.SRMCrypto;
import org.eclipse.aperi.xmsg.MessageLog;

public class VolumeInfoHandler
implements RequestHandler,
ThrowAway {
    GUIEntityFactory entityFactory = null;

    public Response handle(Request request, Transceiver transceiver) {
        if (TraceLogger.enableTrace) {
            TraceLogger.entry((String)VolumeInfoHandler.class.getName(), (String)"handle", (String)"request, transceiver");
        }
        GUIRequestData reqData = (GUIRequestData)request.requestData;
        Response response = Response.getResponse((short)0, null);
        this.entityFactory = GUIEntityFactory.getInstance();
        try {
            if (reqData.getActionId() == 30) {
                this.getVolumeIdsBySubsystem(reqData, response);
            } else if (reqData.getActionId() == 51) {
                this.getVolumeNamesBySubsystem(reqData, response);
            } else if (reqData.getActionId() == 31) {
                this.getVolumesBySubsystem(reqData, response);
            } else if (reqData.getActionId() == 32) {
                this.getVolumeIdsByStoragePool(reqData, response);
            } else if (reqData.getActionId() == 33) {
                this.getVolumesByStoragePool(reqData, response);
            } else if (reqData.getActionId() == 34) {
                this.getVolumeIdsByHost(reqData, response);
            } else if (reqData.getActionId() == 35) {
                this.getVolumesByHost(reqData, response);
            } else if (reqData.getActionId() == 36) {
                this.getVolume(reqData, response);
            } else if (reqData.getActionId() == 37) {
                this.getMDisksByMDiskGroup(reqData, response);
            } else if (reqData.getActionId() == 38) {
                this.getVDiskIdsByIOGroup(reqData, response);
            } else if (reqData.getActionId() == 39) {
                this.getVDiskIdsByMDiskGroup(reqData, response);
            } else if (reqData.getActionId() == 40) {
                this.getVDisksByMDiskGroup(reqData, response);
            } else if (reqData.getActionId() == 41) {
                this.getVDiskIdsByHost(reqData, response);
            } else if (reqData.getActionId() == 42) {
                this.getVDisksByHost(reqData, response);
            } else if (reqData.getActionId() == 43) {
                this.getVDiskIdsBySVC(reqData, response);
            } else if (reqData.getActionId() == 44) {
                this.getVDisksBySVC(reqData, response);
            } else if (reqData.getActionId() == 45) {
                this.getVDisk(reqData, response);
            } else if (reqData.getActionId() == 46) {
                this.getPortAssignments(reqData, response);
            } else if (reqData.getActionId() == 49) {
                this.getPortAssignmentsExt(reqData, response);
            } else if (reqData.getActionId() == 47) {
                this.getVolumeSizeRange(reqData, response);
            } else if (reqData.getActionId() == 48) {
                this.areVolumeActionsInProgress(reqData, response);
            } else if (reqData.getActionId() == 50) {
                this.setStorageVolumeAttributes(reqData, response);
            }
        }
        catch (Exception ex) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)VolumeInfoHandler.class.getName(), (String)"handle", (Throwable)ex);
            }
            response.status = (short)12;
            if (ex instanceof SRMRuntimeException) {
                response.errorMessage = ((SRMRuntimeException)ex).getLocalizedMessage();
            } else {
                String[] inserts = new String[]{};
                String msg = ex.getMessage();
                if (msg != null) {
                    inserts = new String[]{msg};
                }
                response.errorMessage = new SRMMessage("HWN021503E", inserts).getLocalizedMessage();
            }
            response.responseData = null;
        }
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)VolumeInfoHandler.class.getName(), (String)"handle", (Object)response);
        }
        return response;
    }

    private void getVolumeIdsBySubsystem(GUIRequestData reqData, Response response) throws Exception {
        String subsystemId = (String)((Object)reqData.getParameter("subsystem.id"));
        TraceLogger.traceMessage((int)1, (String)VolumeInfoHandler.class.getName(), (String)"getVolumeIdsBySubsystem", (String)("subsystemId: " + subsystemId));
        response.responseData = this.entityFactory.getVolumeIdsBySubsystem(subsystemId);
    }

    private void getVolumeNamesBySubsystem(GUIRequestData reqData, Response response) throws Exception {
        String subsystemId = (String)((Object)reqData.getParameter("subsystem.id"));
        TraceLogger.traceMessage((int)1, (String)VolumeInfoHandler.class.getName(), (String)"getVolumeNamesBySubsystem", (String)("subsystemId: " + subsystemId));
        response.responseData = this.entityFactory.getVolumeNamesBySubsystem(subsystemId);
    }

    private void getVolumesBySubsystem(GUIRequestData reqData, Response response) throws Exception {
        String subsystemId = (String)((Object)reqData.getParameter("subsystem.id"));
        TraceLogger.traceMessage((int)1, (String)VolumeInfoHandler.class.getName(), (String)"getVolumesBySubsystem", (String)("subsystemId: " + subsystemId));
        response.responseData = this.entityFactory.getVolumesBySubsystem(subsystemId);
    }

    private void getVolumeIdsByStoragePool(GUIRequestData reqData, Response response) throws Exception {
        String subsystemId = (String)((Object)reqData.getParameter("subsystem.id"));
        TraceLogger.traceMessage((int)1, (String)VolumeInfoHandler.class.getName(), (String)"getVolumeIdsByStoragePool", (String)("subsystemId: " + subsystemId));
        String stgpoolId = (String)((Object)reqData.getParameter("storagepool.id"));
        TraceLogger.traceMessage((int)1, (String)VolumeInfoHandler.class.getName(), (String)"getVolumeIdsByStoragePool", (String)("stgpoolId: " + stgpoolId));
        response.responseData = this.entityFactory.getVolumeIdsByStoragePool(subsystemId, stgpoolId);
    }

    private void getVolumesByStoragePool(GUIRequestData reqData, Response response) throws Exception {
        String subsystemId = (String)((Object)reqData.getParameter("subsystem.id"));
        TraceLogger.traceMessage((int)1, (String)VolumeInfoHandler.class.getName(), (String)"getVolumesByStoragePool", (String)("subsystemId: " + subsystemId));
        String stgpoolId = (String)((Object)reqData.getParameter("storagepool.id"));
        TraceLogger.traceMessage((int)1, (String)VolumeInfoHandler.class.getName(), (String)"getVolumesByStoragePool", (String)("stgpoolId: " + stgpoolId));
        response.responseData = this.entityFactory.getVolumesByStoragePool(subsystemId, stgpoolId);
    }

    private void getVolumeIdsByHost(GUIRequestData reqData, Response response) throws Exception {
        String subsystemId = (String)((Object)reqData.getParameter("subsystem.id"));
        TraceLogger.traceMessage((int)1, (String)VolumeInfoHandler.class.getName(), (String)"getVolumeIdsByHost", (String)("subsystemId: " + subsystemId));
        String hostId = (String)((Object)reqData.getParameter("host.id"));
        TraceLogger.traceMessage((int)1, (String)VolumeInfoHandler.class.getName(), (String)"getVolumeIdsByHost", (String)("hostId: " + hostId));
        response.responseData = this.entityFactory.getVolumeIdsByHost(subsystemId, hostId);
    }

    private void getVolumesByHost(GUIRequestData reqData, Response response) throws Exception {
        String subsystemId = (String)((Object)reqData.getParameter("subsystem.id"));
        TraceLogger.traceMessage((int)1, (String)VolumeInfoHandler.class.getName(), (String)"getVolumesByHost", (String)("subsystemId: " + subsystemId));
        String hostId = (String)((Object)reqData.getParameter("host.id"));
        TraceLogger.traceMessage((int)1, (String)VolumeInfoHandler.class.getName(), (String)"getVolumesByHost", (String)("hostId: " + hostId));
        response.responseData = this.entityFactory.getVolumesByHost(subsystemId, hostId);
    }

    private void getVolume(GUIRequestData reqData, Response response) throws Exception {
        String subsystemId = (String)((Object)reqData.getParameter("subsystem.id"));
        TraceLogger.traceMessage((int)1, (String)VolumeInfoHandler.class.getName(), (String)"getVolume", (String)("subsystemId: " + subsystemId));
        String volumeId = (String)((Object)reqData.getParameter("volume.id"));
        TraceLogger.traceMessage((int)1, (String)VolumeInfoHandler.class.getName(), (String)"getVolume", (String)("volumeId: " + volumeId));
        response.responseData = this.entityFactory.getVolume(subsystemId, volumeId);
    }

    private void getMDisksByMDiskGroup(GUIRequestData reqData, Response response) throws Exception {
        String subsystemId = (String)((Object)reqData.getParameter("subsystem.id"));
        TraceLogger.traceMessage((int)1, (String)VolumeInfoHandler.class.getName(), (String)"getMDisksByMDiskGroup", (String)("subsystemId: " + subsystemId));
        String mdiskGroupId = (String)((Object)reqData.getParameter("mdiskgroup.id"));
        TraceLogger.traceMessage((int)1, (String)VolumeInfoHandler.class.getName(), (String)"getMDisksByMDiskGroup", (String)("mdiskGroupId: " + mdiskGroupId));
        response.responseData = this.entityFactory.getMDisksByMDiskGroup(subsystemId, mdiskGroupId);
    }

    private void getVDiskIdsByIOGroup(GUIRequestData reqData, Response response) throws Exception {
        String subsystemId = (String)((Object)reqData.getParameter("subsystem.id"));
        TraceLogger.traceMessage((int)1, (String)VolumeInfoHandler.class.getName(), (String)"getVDiskIdsByIOGroup", (String)("subsystemId: " + subsystemId));
        String ioGroupId = (String)((Object)reqData.getParameter("iogroup.id"));
        TraceLogger.traceMessage((int)1, (String)VolumeInfoHandler.class.getName(), (String)"getVDiskIdsByIOGroup", (String)("ioGroupId: " + ioGroupId));
        response.responseData = this.entityFactory.getVDiskIdsByIOGroup(subsystemId, ioGroupId);
    }

    private void getVDiskIdsByMDiskGroup(GUIRequestData reqData, Response response) throws Exception {
        String subsystemId = (String)((Object)reqData.getParameter("subsystem.id"));
        TraceLogger.traceMessage((int)1, (String)VolumeInfoHandler.class.getName(), (String)"getVDiskIdsByMDiskGroup", (String)("subsystemId: " + subsystemId));
        String mdiskgroupId = (String)((Object)reqData.getParameter("mdiskgroup.id"));
        TraceLogger.traceMessage((int)1, (String)VolumeInfoHandler.class.getName(), (String)"getVDiskIdsByMDiskGroup", (String)("mdiskgroupId: " + mdiskgroupId));
        response.responseData = this.entityFactory.getVDiskIdsByMDiskGroup(subsystemId, mdiskgroupId);
    }

    private void getVDisksByMDiskGroup(GUIRequestData reqData, Response response) throws Exception {
        String subsystemId = (String)((Object)reqData.getParameter("subsystem.id"));
        TraceLogger.traceMessage((int)1, (String)VolumeInfoHandler.class.getName(), (String)"getVDisksByMDiskGroup", (String)("subsystemId: " + subsystemId));
        String mdiskgroupId = (String)((Object)reqData.getParameter("mdiskgroup.id"));
        TraceLogger.traceMessage((int)1, (String)VolumeInfoHandler.class.getName(), (String)"getVDisksByMDiskGroup", (String)("mdiskgroupId: " + mdiskgroupId));
        response.responseData = this.entityFactory.getVDisksByMDiskGroup(subsystemId, mdiskgroupId);
    }

    private void getVDiskIdsByHost(GUIRequestData reqData, Response response) throws Exception {
        String subsystemId = (String)((Object)reqData.getParameter("subsystem.id"));
        TraceLogger.traceMessage((int)1, (String)VolumeInfoHandler.class.getName(), (String)"getVDiskIdsByHost", (String)("subsystemId: " + subsystemId));
        String hostId = (String)((Object)reqData.getParameter("host.id"));
        TraceLogger.traceMessage((int)1, (String)VolumeInfoHandler.class.getName(), (String)"getVDiskIdsByHost", (String)("hostId: " + hostId));
        response.responseData = this.entityFactory.getVDiskIdsByHost(subsystemId, hostId);
    }

    private void getVDisksByHost(GUIRequestData reqData, Response response) throws Exception {
        String subsystemId = (String)((Object)reqData.getParameter("subsystem.id"));
        TraceLogger.traceMessage((int)1, (String)VolumeInfoHandler.class.getName(), (String)"getVDisksByHost", (String)("subsystemId: " + subsystemId));
        String hostId = (String)((Object)reqData.getParameter("host.id"));
        TraceLogger.traceMessage((int)1, (String)VolumeInfoHandler.class.getName(), (String)"getVDisksByHost", (String)("hostId: " + hostId));
        response.responseData = this.entityFactory.getVDisksByHost(subsystemId, hostId);
    }

    private void getVDiskIdsBySVC(GUIRequestData reqData, Response response) throws Exception {
        String subsystemId = (String)((Object)reqData.getParameter("subsystem.id"));
        TraceLogger.traceMessage((int)1, (String)VolumeInfoHandler.class.getName(), (String)"getVDiskIdsBySVC", (String)("subsystemId: " + subsystemId));
        response.responseData = this.entityFactory.getVDiskIdsBySVC(subsystemId);
    }

    private void getVDisksBySVC(GUIRequestData reqData, Response response) throws Exception {
        String subsystemId = (String)((Object)reqData.getParameter("subsystem.id"));
        TraceLogger.traceMessage((int)1, (String)VolumeInfoHandler.class.getName(), (String)"getVDisksBySVC", (String)("subsystemId: " + subsystemId));
        response.responseData = this.entityFactory.getVDisksBySVC(subsystemId);
    }

    private void getVDisk(GUIRequestData reqData, Response response) throws Exception {
        String subsystemId = (String)((Object)reqData.getParameter("subsystem.id"));
        TraceLogger.traceMessage((int)1, (String)VolumeInfoHandler.class.getName(), (String)"getVDisk", (String)("subsystemId: " + subsystemId));
        String vdiskId = (String)((Object)reqData.getParameter("vdisk.id"));
        TraceLogger.traceMessage((int)1, (String)VolumeInfoHandler.class.getName(), (String)"getVDisk", (String)("vdiskId: " + vdiskId));
        response.responseData = this.entityFactory.getVDisk(subsystemId, vdiskId);
    }

    private void getPortAssignments(GUIRequestData reqData, Response response) throws Exception {
        String subsystemId = (String)((Object)reqData.getParameter("subsystem.id"));
        TraceLogger.traceMessage((int)1, (String)VolumeInfoHandler.class.getName(), (String)"getPortAssignments", (String)("subsystemId: " + subsystemId));
        String volumeId = (String)((Object)reqData.getParameter("volume.id"));
        TraceLogger.traceMessage((int)1, (String)VolumeInfoHandler.class.getName(), (String)"getPortAssignments", (String)("volumeId: " + volumeId));
        response.responseData = this.entityFactory.getPortAssignments(subsystemId, volumeId);
    }

    private void getPortAssignmentsExt(GUIRequestData reqData, Response response) throws Exception {
        String subsystemId = (String)((Object)reqData.getParameter("subsystem.id"));
        TraceLogger.traceMessage((int)1, (String)VolumeInfoHandler.class.getName(), (String)"getPortAssignmentsExt", (String)("subsystemId: " + subsystemId));
        String[] volumeIds = (String[])reqData.getParameter("volume.ids");
        TraceLogger.traceMessage((int)1, (String)VolumeInfoHandler.class.getName(), (String)"getPortAssignmentsExt", (String)("volumeIds: " + volumeIds.toString()));
        response.responseData = this.entityFactory.getPortAssignments(subsystemId, volumeIds);
    }

    private void getVolumeSizeRange(GUIRequestData reqData, Response response) throws Exception {
        long[] ranges = null;
        String subsystemId = (String)((Object)reqData.getParameter("subsystem.id"));
        TraceLogger.traceMessage((int)1, (String)VolumeInfoHandler.class.getName(), (String)"getVolumeSizeRange", (String)("subsystemId: " + subsystemId));
        String stgpoolId = (String)((Object)reqData.getParameter("storagepool.id"));
        TraceLogger.traceMessage((int)1, (String)VolumeInfoHandler.class.getName(), (String)"getVolumeSizeRange", (String)("stgpoolId: " + stgpoolId));
        DeviceServerManager dsm = Server.getDeviceServerManager();
        org.eclipse.aperi.infrastructure.database.objects.Server deviceServer = dsm.getDeviceServer();
        if (deviceServer != null) {
            if (SecurityContext.getDefaultContext() == null) {
                SecurityContext.setDefaultContext((SecurityContext)new SystemSecurityContext());
            }
            String pWord = null;
            try {
                pWord = SRMCrypto.decrypt((String)deviceServer.getPassword());
            }
            catch (Exception e) {
                e.printStackTrace(MessageLog.getThreadLog());
                pWord = deviceServer.getPassword();
            }
            MiddlewareCrypto.initialize((char[])pWord.toCharArray());
            IDiskManagerService dmService = (IDiskManagerService)ConnectorClient.getService((String)deviceServer.getServerName(), (int)deviceServer.getPortNumber(), IDiskManagerService.class, (String)"DiskManagerService");
            ranges = dmService.getDefaultSupportedVolumeSizeRange(stgpoolId);
        }
        response.responseData = ranges;
    }

    private void areVolumeActionsInProgress(GUIRequestData reqData, Response response) throws Exception {
        String subsystemId = (String)((Object)reqData.getParameter("subsystem.id"));
        TraceLogger.traceMessage((int)1, (String)VolumeInfoHandler.class.getName(), (String)"areVolumeActionsInProgress", (String)("subsystemId: " + subsystemId));
        response.responseData = new Boolean(this.entityFactory.areVolumeActionsInProgress(subsystemId));
    }

    private void setStorageVolumeAttributes(GUIRequestData reqData, Response response) throws Exception {
        String volumeId = (String)((Object)reqData.getParameter("volume.id"));
        TraceLogger.traceMessage((int)1, (String)VolumeInfoHandler.class.getName(), (String)"setStorageVolumeAttributes", (String)("volumeId: " + volumeId));
        Hashtable attributes = (Hashtable)reqData.getParameter("volume.attrs");
        response.responseData = new Integer(this.entityFactory.setStorageVolumeAttributes(volumeId, attributes));
    }
}

