/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui.fabric;

import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.aperi.ServiceUtils;
import org.eclipse.aperi.backend.RequestChecker;
import org.eclipse.aperi.common.dbaccess.FabricDbAccess;
import org.eclipse.aperi.gui.fabric.FabricGuiUtil;
import org.eclipse.aperi.infrastructure.database.DBConnection;
import org.eclipse.aperi.infrastructure.database.DBResultSet;
import org.eclipse.aperi.logging.TraceLogger;
import org.eclipse.aperi.request.Request;
import org.eclipse.aperi.request.Response;
import org.eclipse.aperi.request.Transceiver;
import org.eclipse.aperi.server.RequestHandler;
import org.eclipse.aperi.server.Server;
import org.eclipse.aperi.server.guireq.fabric.details.GuiDetailsReq;
import org.eclipse.aperi.server.handler.gui.fabric.GuiDetailsDeviceHndlr;

public class GuiDetailsHndlr
implements RequestHandler {
    public String m_userName = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Response handle(Request request, Transceiver transceiver) {
        Response response;
        block69: {
            if (TraceLogger.enableTrace) {
                TraceLogger.entry((String)GuiDetailsHndlr.class.getName(), (String)"handle", (String)"request, transceiver");
            }
            if (!RequestChecker.isDesiredType(GuiDetailsReq.class, (Request)request, (Response)(response = Response.getResponse((short)0, null)))) {
                Response traceResult = response;
                if (TraceLogger.enableTrace) {
                    TraceLogger.exit((String)GuiDetailsHndlr.class.getName(), (String)"handle", (Object)traceResult);
                }
                return traceResult;
            }
            GuiDetailsReq gdr = (GuiDetailsReq)request.requestData;
            this.m_userName = request.userName;
            StringBuffer auditMsgBuffer = null;
            String methodName = "handle()";
            DBConnection dbc = null;
            try {
                dbc = ServiceUtils.getConnection();
                if (dbc == null) {
                    Server.setResponseError(response, "GEN0050E");
                    Response traceResult = response;
                    if (TraceLogger.enableTrace) {
                        TraceLogger.exit((String)GuiDetailsHndlr.class.getName(), (String)"handle", (Object)traceResult);
                    }
                    Response response2 = traceResult;
                    return response2;
                }
                String id = gdr.entityID;
                int detailMode = gdr.mode;
                if (gdr.entityType.equals("cluster")) {
                    try {
                        gdr.data = FabricDbAccess.getClusterDetail((DBConnection)dbc, (String)id, (String)"FabricDetails_Label", (String)"FabricDetails_ID", (Hashtable)gdr.data);
                        response.responseData = gdr;
                    }
                    catch (Exception e) {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)GuiDetailsHndlr.class.getName(), (String)"handle", (Throwable)e);
                        }
                        Server.setResponseError(response, e);
                    }
                    break block69;
                }
                if (gdr.entityType.equals("server")) {
                    try {
                        if (detailMode == 0) {
                            gdr.data = GuiDetailsHndlr.getComputerDetail(dbc, id, gdr.data);
                            response.responseData = gdr;
                        }
                        if (detailMode != 1) break block69;
                        String label = (String)gdr.data.get("FabricDetails_Label");
                        String userAttrib1 = (String)gdr.data.get("FabricDetails_UserAttrib1");
                        String userAttrib2 = (String)gdr.data.get("FabricDetails_UserAttrib2");
                        String userAttrib3 = (String)gdr.data.get("FabricDetails_UserAttrib3");
                        FabricDbAccess.setComputerDetail((DBConnection)dbc, (String)id, (String)label, (String)userAttrib1, (String)userAttrib2, (String)userAttrib3);
                        response.responseData = gdr;
                        if (TraceLogger.enableAudit) {
                            auditMsgBuffer = new StringBuffer("User: " + this.m_userName + "\n");
                            auditMsgBuffer.append("update computer details: \n");
                            this.addDetailAttribute(auditMsgBuffer, "id", id);
                            this.addDetailAttribute(auditMsgBuffer, "label", label);
                            this.addDetailAttribute(auditMsgBuffer, "userAttrib1", userAttrib1);
                            this.addDetailAttribute(auditMsgBuffer, "userAttrib2", userAttrib2);
                            this.addDetailAttribute(auditMsgBuffer, "userAttrib3", userAttrib3);
                            TraceLogger.auditMessage((String)GuiDetailsDeviceHndlr.class.getName(), (String)methodName, (String)auditMsgBuffer.toString());
                        }
                        break block69;
                    }
                    catch (Exception e) {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)GuiDetailsHndlr.class.getName(), (String)"handle", (Throwable)e);
                        }
                        Server.setResponseError(response, e);
                    }
                    break block69;
                }
                if (gdr.entityType.equals("pe")) {
                    try {
                        if (detailMode == 0) {
                            gdr.data = GuiDetailsHndlr.getPhyPeDetail(dbc, id, gdr.data);
                            response.responseData = gdr;
                        }
                        if (detailMode == 1) {
                            String label = (String)gdr.data.get("FabricDetails_Label");
                            FabricDbAccess.setPhyPeDetail((DBConnection)dbc, (String)id, (String)label);
                            response.responseData = gdr;
                        }
                        break block69;
                    }
                    catch (Exception e) {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)GuiDetailsHndlr.class.getName(), (String)"handle", (Throwable)e);
                        }
                        Server.setResponseError(response, e);
                    }
                    break block69;
                }
                if (gdr.entityType.equals("fabric")) {
                    try {
                        if (detailMode == 0) {
                            gdr.data = GuiDetailsHndlr.getFabricDetail(dbc, id, gdr.data);
                            response.responseData = gdr;
                        }
                        if (detailMode != 1) break block69;
                        String label = (String)gdr.data.get("FabricDetails_Label");
                        String userAttrib1 = (String)gdr.data.get("FabricDetails_UserAttrib1");
                        String userAttrib2 = (String)gdr.data.get("FabricDetails_UserAttrib2");
                        String userAttrib3 = (String)gdr.data.get("FabricDetails_UserAttrib3");
                        FabricDbAccess.setFabricDetail((DBConnection)dbc, (String)id, (String)label, (String)userAttrib1, (String)userAttrib2, (String)userAttrib3);
                        response.responseData = gdr;
                        if (TraceLogger.enableAudit) {
                            auditMsgBuffer = new StringBuffer("User: " + this.m_userName + "\n");
                            auditMsgBuffer.append("update fabric details:\n");
                            this.addDetailAttribute(auditMsgBuffer, "id", id);
                            this.addDetailAttribute(auditMsgBuffer, "label", label);
                            this.addDetailAttribute(auditMsgBuffer, "userAttrib1", userAttrib1);
                            this.addDetailAttribute(auditMsgBuffer, "userAttrib2", userAttrib2);
                            this.addDetailAttribute(auditMsgBuffer, "userAttrib3", userAttrib3);
                            TraceLogger.auditMessage((String)GuiDetailsDeviceHndlr.class.getName(), (String)"handle()", (String)auditMsgBuffer.toString());
                        }
                        break block69;
                    }
                    catch (Exception e) {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)GuiDetailsHndlr.class.getName(), (String)"handle", (Throwable)e);
                        }
                        Server.setResponseError(response, e);
                    }
                    break block69;
                }
                if (gdr.entityType.equals("hba")) {
                    try {
                        gdr.data = GuiDetailsHndlr.getHBADetail(dbc, id, gdr.data);
                        response.responseData = gdr;
                    }
                    catch (Exception e) {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)GuiDetailsHndlr.class.getName(), (String)"handle", (Throwable)e);
                        }
                        Server.setResponseError(response, e);
                    }
                    break block69;
                }
                if (gdr.entityType.equals("port")) {
                    try {
                        if (detailMode == 0) {
                            gdr.data = GuiDetailsHndlr.getPortDetail(dbc, id, gdr.data);
                            response.responseData = gdr;
                        }
                        if (detailMode != 1) break block69;
                        String label = (String)gdr.data.get("FabricDetails_Label");
                        String icon = (String)gdr.data.get("FabricDetails_icon");
                        FabricDbAccess.setPortDetail((DBConnection)dbc, (String)id, (String)label, (String)icon);
                        response.responseData = gdr;
                        if (TraceLogger.enableAudit) {
                            auditMsgBuffer = new StringBuffer("User: " + this.m_userName + "\n");
                            auditMsgBuffer.append("update port details:\n");
                            this.addDetailAttribute(auditMsgBuffer, "id", id);
                            this.addDetailAttribute(auditMsgBuffer, "label", label);
                            this.addDetailAttribute(auditMsgBuffer, "icon", icon);
                            TraceLogger.auditMessage((String)GuiDetailsDeviceHndlr.class.getName(), (String)"handle()", (String)auditMsgBuffer.toString());
                        }
                        break block69;
                    }
                    catch (Exception e) {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)GuiDetailsHndlr.class.getName(), (String)"handle", (Throwable)e);
                        }
                        Server.setResponseError(response, e);
                    }
                    break block69;
                }
                if (gdr.entityType.equals("node")) {
                    try {
                        if (detailMode == 0) {
                            gdr.data = GuiDetailsHndlr.getNodeDetail(dbc, id, gdr.data);
                            response.responseData = gdr;
                        }
                        if (detailMode != 1) break block69;
                        String label = (String)gdr.data.get("FabricDetails_Label");
                        String icon = (String)gdr.data.get("FabricDetails_icon");
                        FabricDbAccess.setNodeDetail((DBConnection)dbc, (String)id, (String)label, (String)icon);
                        response.responseData = gdr;
                        if (TraceLogger.enableAudit) {
                            auditMsgBuffer = new StringBuffer("User: " + this.m_userName + "\n");
                            auditMsgBuffer.append("update node details:\n");
                            this.addDetailAttribute(auditMsgBuffer, "id", id);
                            this.addDetailAttribute(auditMsgBuffer, "label", label);
                            this.addDetailAttribute(auditMsgBuffer, "icon", icon);
                            TraceLogger.auditMessage((String)GuiDetailsDeviceHndlr.class.getName(), (String)"handle()", (String)auditMsgBuffer.toString());
                        }
                        break block69;
                    }
                    catch (Exception e) {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)GuiDetailsHndlr.class.getName(), (String)"handle", (Throwable)e);
                        }
                        Server.setResponseError(response, e);
                    }
                    break block69;
                }
                if (gdr.entityType.equals("switch")) {
                    try {
                        if (detailMode == 0) {
                            gdr.data = GuiDetailsHndlr.getSwitchDetail(dbc, id, gdr.data);
                            gdr.blades = GuiDetailsHndlr.getSwitchBlades(dbc, (String)gdr.data.get("FabricDetails_WWN"));
                            response.responseData = gdr;
                        }
                        if (detailMode != 1) break block69;
                        String label = (String)gdr.data.get("FabricDetails_Label");
                        String userAttrib1 = (String)gdr.data.get("FabricDetails_UserAttrib1");
                        String userAttrib2 = (String)gdr.data.get("FabricDetails_UserAttrib2");
                        String userAttrib3 = (String)gdr.data.get("FabricDetails_UserAttrib3");
                        FabricDbAccess.setSwitchDetail((DBConnection)dbc, (String)id, (String)label, (String)userAttrib1, (String)userAttrib2, (String)userAttrib3);
                        response.responseData = gdr;
                        if (TraceLogger.enableAudit) {
                            auditMsgBuffer = new StringBuffer("User: " + this.m_userName + "\n");
                            auditMsgBuffer.append("update switch details:\n");
                            this.addDetailAttribute(auditMsgBuffer, "id", id);
                            this.addDetailAttribute(auditMsgBuffer, "label", label);
                            this.addDetailAttribute(auditMsgBuffer, "userAttrib1", userAttrib1);
                            this.addDetailAttribute(auditMsgBuffer, "userAttrib2", userAttrib2);
                            this.addDetailAttribute(auditMsgBuffer, "userAttrib3", userAttrib3);
                            TraceLogger.auditMessage((String)GuiDetailsDeviceHndlr.class.getName(), (String)"handle()", (String)auditMsgBuffer.toString());
                        }
                        break block69;
                    }
                    catch (Exception e) {
                        if (TraceLogger.enableTrace) {
                            TraceLogger.exception((String)GuiDetailsHndlr.class.getName(), (String)"handle", (Throwable)e);
                        }
                        Server.setResponseError(response, e);
                    }
                    break block69;
                }
                response.responseData = gdr;
                dbc.setAutoCommit(true);
                dbc.close();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
                try {
                    if (dbc != null) {
                        dbc.close();
                    }
                }
                catch (SQLException sqle) {
                    System.out.println(sqle.getMessage());
                }
                if (TraceLogger.enableTrace) {
                    TraceLogger.exception((String)GuiDetailsHndlr.class.getName(), (String)"handle", (Throwable)e);
                }
                Server.setResponseError(response, e);
            }
            finally {
                if (dbc != null) {
                    try {
                        dbc.commit();
                        dbc.close();
                    }
                    catch (SQLException e1) {
                        e1.printStackTrace();
                    }
                }
            }
        }
        Response traceResult = response;
        System.out.println("Finish checking Fabric Details.\n");
        if (TraceLogger.enableTrace) {
            TraceLogger.exit((String)GuiDetailsHndlr.class.getName(), (String)"handle", (Object)traceResult);
        }
        return traceResult;
    }

    private void addDetailAttribute(StringBuffer buffer, String name, String value) {
        buffer.append(" ");
        buffer.append(name);
        buffer.append("=[");
        if (value != null) {
            buffer.append(value);
        }
        buffer.append("]\n");
    }

    static void safeHashPut(Hashtable hash, String key, String value) {
        if (value == null) {
            value = "";
        }
        hash.put(key, value);
    }

    static String safeRsGetString(DBResultSet rs, String label) {
        String res = "";
        try {
            res = rs.getString(label);
        }
        catch (SQLException sqle) {
            System.out.println(sqle);
        }
        return res;
    }

    static int safeRsGetShort(DBResultSet rs, String label) {
        short res = 0;
        try {
            res = rs.getShort(label);
        }
        catch (SQLException sqle) {
            System.out.println(sqle);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable getFabricDetail(DBConnection con, String id, Hashtable detailTable) {
        DBResultSet rs = FabricDbAccess.getFabricDetail((DBConnection)con, (String)id);
        try {
            while (rs != null && rs.next()) {
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_Label", GuiDetailsHndlr.safeRsGetString(rs, "Label"));
                String type = GuiDetailsHndlr.safeRsGetString(rs, "TYPE");
                type = type == null ? "" : type.trim();
                if (type.equals("1")) {
                    GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_Type", FabricGuiUtil.getString((String)"FabricDetails_PhysicalType"));
                } else if (type.equals("0")) {
                    GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_Type", FabricGuiUtil.getString((String)"FabricDetails_VirtualType"));
                } else {
                    GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_Type", type);
                }
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_WWN", GuiDetailsHndlr.safeRsGetString(rs, "FWWN"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_UserAttrib1", GuiDetailsHndlr.safeRsGetString(rs, "USER_ATTRIB1"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_UserAttrib2", GuiDetailsHndlr.safeRsGetString(rs, "USER_ATTRIB2"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_UserAttrib3", GuiDetailsHndlr.safeRsGetString(rs, "USER_ATTRIB3"));
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)FabricDbAccess.class.getName(), (String)"getFabricDetail", (Throwable)e);
            }
        }
        finally {
            block19: {
                try {
                    if (rs != null) {
                        rs.getStatement().close();
                    }
                }
                catch (Exception e) {
                    if (!TraceLogger.enableTrace) break block19;
                    TraceLogger.exception((String)FabricDbAccess.class.getName(), (String)"getFabricDetail", (Throwable)e);
                }
            }
        }
        return detailTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable getComputerDetail(DBConnection con, String id, Hashtable detailTable) {
        DBResultSet rs = FabricDbAccess.getComputerDetail((DBConnection)con, (String)id);
        try {
            while (rs != null && rs.next()) {
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_Label", GuiDetailsHndlr.safeRsGetString(rs, "Label"));
                int statusInt = rs.getInt("STATUS");
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_State", "" + statusInt);
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_Type", String.valueOf(rs.getShort("TYPE")));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_IPAddress", GuiDetailsHndlr.safeRsGetString(rs, "IP"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_Hostname", GuiDetailsHndlr.safeRsGetString(rs, "URL"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_Guid", GuiDetailsHndlr.safeRsGetString(rs, "GUID"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_UserAttrib1", GuiDetailsHndlr.safeRsGetString(rs, "USER_ATTRIB1"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_UserAttrib2", GuiDetailsHndlr.safeRsGetString(rs, "USER_ATTRIB2"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_UserAttrib3", GuiDetailsHndlr.safeRsGetString(rs, "USER_ATTRIB3"));
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)FabricDbAccess.class.getName(), (String)"getComputerDetail", (Throwable)e);
            }
        }
        finally {
            block15: {
                try {
                    if (rs != null) {
                        rs.getStatement().close();
                    }
                }
                catch (Exception e) {
                    if (!TraceLogger.enableTrace) break block15;
                    TraceLogger.exception((String)FabricDbAccess.class.getName(), (String)"getComputerDetail", (Throwable)e);
                }
            }
        }
        return detailTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable getPhyPeDetail(DBConnection con, String id, Hashtable detailTable) {
        DBResultSet rs = FabricDbAccess.getPhyPeDetail((DBConnection)con, (String)id);
        try {
            while (rs != null && rs.next()) {
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_Type", GuiDetailsHndlr.safeRsGetString(rs, "TYPE"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_Label", GuiDetailsHndlr.safeRsGetString(rs, "LABEL"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_SerialNumber", GuiDetailsHndlr.safeRsGetString(rs, "NUM"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_VendorID", GuiDetailsHndlr.safeRsGetString(rs, "VNAME"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_Revision", GuiDetailsHndlr.safeRsGetString(rs, "REV"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_ManagementURLAddress", GuiDetailsHndlr.safeRsGetString(rs, "ADDR"));
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)FabricDbAccess.class.getName(), (String)"getPhyPeDetail", (Throwable)e);
            }
        }
        finally {
            block15: {
                try {
                    if (rs != null) {
                        rs.getStatement().close();
                    }
                }
                catch (Exception e) {
                    if (!TraceLogger.enableTrace) break block15;
                    TraceLogger.exception((String)FabricDbAccess.class.getName(), (String)"getPhyPeDetail", (Throwable)e);
                }
            }
        }
        return detailTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable getHBADetail(DBConnection con, String id, Hashtable detailTable) {
        DBResultSet rs = FabricDbAccess.getHBADetail((DBConnection)con, (String)id);
        try {
            while (rs != null && rs.next()) {
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_Label", GuiDetailsHndlr.safeRsGetString(rs, "LABEL"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_SerialNumber", GuiDetailsHndlr.safeRsGetString(rs, "NUM"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_Manufacturer", GuiDetailsHndlr.safeRsGetString(rs, "VNAME"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_Model", GuiDetailsHndlr.safeRsGetString(rs, "MNAME"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_ModelDescription", GuiDetailsHndlr.safeRsGetString(rs, "MDES"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_DriverName", GuiDetailsHndlr.safeRsGetString(rs, "DNAME"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_DriverVersion", GuiDetailsHndlr.safeRsGetString(rs, "DVER"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_OptionROMVersion", GuiDetailsHndlr.safeRsGetString(rs, "ROMVER"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_HardwareVersion", GuiDetailsHndlr.safeRsGetString(rs, "HWVER"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_FirmwareVersion", GuiDetailsHndlr.safeRsGetString(rs, "FWVER"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_APIVersion", GuiDetailsHndlr.safeRsGetString(rs, "AVER"));
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)FabricDbAccess.class.getName(), (String)"getHBADetail", (Throwable)e);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.getStatement().close();
                    con.commit();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return detailTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable getPortDetail(DBConnection con, String id, Hashtable detailTable) {
        DBResultSet rs = FabricDbAccess.getPortDetail((DBConnection)con, (String)id);
        try {
            while (rs != null && rs.next()) {
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_Label", GuiDetailsHndlr.safeRsGetString(rs, "LABEL"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_icon", "" + GuiDetailsHndlr.safeRsGetShort(rs, "ICON"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_Type", "" + GuiDetailsHndlr.safeRsGetShort(rs, "TYPE"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_WWN", GuiDetailsHndlr.safeRsGetString(rs, "NAME"));
            }
        }
        catch (SQLException e) {
            System.out.println(e);
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)FabricDbAccess.class.getName(), (String)"getPortDetail", (Throwable)e);
            }
        }
        finally {
            if (rs != null) {
                try {
                    rs.getStatement().close();
                    con.commit();
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return detailTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable getNodeDetail(DBConnection con, String id, Hashtable detailTable) {
        DBResultSet rs = FabricDbAccess.getNodeDetail((DBConnection)con, (String)id);
        try {
            while (rs != null && rs.next()) {
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_Label", GuiDetailsHndlr.safeRsGetString(rs, "LABEL"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_icon", "" + GuiDetailsHndlr.safeRsGetShort(rs, "ICON"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_Type", "" + GuiDetailsHndlr.safeRsGetShort(rs, "TYPE"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_WWN", GuiDetailsHndlr.safeRsGetString(rs, "NAME"));
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)FabricDbAccess.class.getName(), (String)"getNodeDetail", (Throwable)e);
            }
        }
        finally {
            try {
                if (rs != null) {
                    rs.getStatement().close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return detailTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable getSwitchDetail(DBConnection con, String id, Hashtable detailTable) {
        DBResultSet rs = FabricDbAccess.getSwitchDetail((DBConnection)con, (String)id);
        try {
            while (rs != null && rs.next()) {
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_Label", GuiDetailsHndlr.safeRsGetString(rs, "Label"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_Description", GuiDetailsHndlr.safeRsGetString(rs, "DES"));
                int statusInt = rs.getInt("DEC");
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_State", "" + statusInt);
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_LogicalName", GuiDetailsHndlr.safeRsGetString(rs, "LNAME"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_IPAddress", GuiDetailsHndlr.safeRsGetString(rs, "IP"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_VendorID", GuiDetailsHndlr.safeRsGetString(rs, "VNAME"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_Model", GuiDetailsHndlr.safeRsGetString(rs, "MNAME"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_Version", GuiDetailsHndlr.safeRsGetString(rs, "VER"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_SerialNumber", GuiDetailsHndlr.safeRsGetString(rs, "SNUM"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_ObjectID", String.valueOf(rs.getInt("ID")));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_ManagementID", GuiDetailsHndlr.safeRsGetString(rs, "MID"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_ManagementAddress", GuiDetailsHndlr.safeRsGetString(rs, "MUA"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_Domain", GuiDetailsHndlr.safeRsGetString(rs, "DOM"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_Contact", GuiDetailsHndlr.safeRsGetString(rs, "CON"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_WWN", GuiDetailsHndlr.safeRsGetString(rs, "WWN"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_Location", GuiDetailsHndlr.safeRsGetString(rs, "LOC"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_PhysicalSwitchWWN", GuiDetailsHndlr.safeRsGetString(rs, "PWWN"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_UserAttrib1", GuiDetailsHndlr.safeRsGetString(rs, "USER_ATTRIB1"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_UserAttrib2", GuiDetailsHndlr.safeRsGetString(rs, "USER_ATTRIB2"));
                GuiDetailsHndlr.safeHashPut(detailTable, "FabricDetails_UserAttrib3", GuiDetailsHndlr.safeRsGetString(rs, "USER_ATTRIB3"));
            }
        }
        catch (SQLException e) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)FabricDbAccess.class.getName(), (String)"getSwitchDetail", (Throwable)e);
            }
        }
        finally {
            block15: {
                try {
                    if (rs != null) {
                        rs.getStatement().close();
                    }
                }
                catch (Exception e) {
                    if (!TraceLogger.enableTrace) break block15;
                    TraceLogger.exception((String)FabricDbAccess.class.getName(), (String)"getSwitchDetail", (Throwable)e);
                }
            }
        }
        return detailTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector getSwitchBlades(DBConnection con, String switchWWN) {
        Vector hashArray = new Vector();
        DBResultSet rs = FabricDbAccess.getSwitchBlades((DBConnection)con, (String)switchWWN);
        try {
            if (rs != null) {
                while (rs.next()) {
                    Hashtable h = new Hashtable();
                    GuiDetailsHndlr.safeHashPut(h, "FabricBladeTable_Identifier", GuiDetailsHndlr.safeRsGetString(rs, "ID"));
                    GuiDetailsHndlr.safeHashPut(h, "FabricBladeTable_Slot", GuiDetailsHndlr.safeRsGetString(rs, "SLOT"));
                    GuiDetailsHndlr.safeHashPut(h, "FabricBladeTable_Type", GuiDetailsHndlr.safeRsGetString(rs, "TYPE"));
                    GuiDetailsHndlr.safeHashPut(h, "FabricBladeTable_Vendor", GuiDetailsHndlr.safeRsGetString(rs, "VNAME"));
                    GuiDetailsHndlr.safeHashPut(h, "FabricBladeTable_Model", GuiDetailsHndlr.safeRsGetString(rs, "MNAME"));
                    GuiDetailsHndlr.safeHashPut(h, "FabricBladeTable_Firmware", GuiDetailsHndlr.safeRsGetString(rs, "FIRMWARE"));
                    hashArray.addElement(h);
                }
            }
        }
        catch (SQLException sqle) {
            if (TraceLogger.enableTrace) {
                TraceLogger.exception((String)FabricDbAccess.class.getName(), (String)"getSwitchBlades", (Throwable)sqle);
            }
        }
        finally {
            block16: {
                try {
                    if (rs != null) {
                        rs.getStatement().close();
                    }
                }
                catch (SQLException sqle) {
                    if (!TraceLogger.enableTrace) break block16;
                    TraceLogger.exception((String)FabricDbAccess.class.getName(), (String)"getSwitchBlades", (Throwable)sqle);
                }
            }
        }
        return hashArray;
    }
}

