/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aperi.server.handler.gui.tape;

import java.util.HashMap;
import java.util.Hashtable;
import org.eclipse.aperi.TStorm.server.guireq.DeviceRequest;
import org.eclipse.aperi.common.api.RemoteException;
import org.eclipse.aperi.connector.ConnectorClient;
import org.eclipse.aperi.gui.tape.common.model.GUICartridge;
import org.eclipse.aperi.gui.tape.common.model.GUIDrive;
import org.eclipse.aperi.gui.tape.common.model.GUIException;
import org.eclipse.aperi.gui.tape.common.model.GUIFrame;
import org.eclipse.aperi.gui.tape.common.model.GUIIOPort;
import org.eclipse.aperi.gui.tape.common.model.GUILibrary;
import org.eclipse.aperi.gui.tape.common.model.GUIMediaChanger;
import org.eclipse.aperi.gui.tape.common.model.TapeLibraryDBHelper;
import org.eclipse.aperi.server.handler.DeviceRequestHndlr;
import org.eclipse.aperi.tape.api.ITapeReportingService;

public class GUIEntityFactory {
    private static final String[] CARTRIDGE_DB_ATTRIBUTES = new String[]{"PHYSICAL_LABEL", "CAPACITY", "MEDIA_TYPE", "CLEANER_MEDIA", "DUAL_SIDED", "LOCATION_ID", "MEDIA_DESCRIPTION"};
    private static final String[] DRIVE_DB_ATTRIBUTES = new String[]{"DISPLAY_NAME", "CONSOLIDATED_STATUS", "NEEDS_CLEANING", "MOUNT_COUNT", "FIRMWARE_VERSION", "DETECTABLE"};
    private static final String[] FRAME_DB_ATTRIBUTES = new String[]{"MODEL_ID", "VENDOR_ID", "SERIAL_NUMBER", "LOCK_PRESENT", "IS_LOCKED", "SECURITY_BREACH"};
    private static final String[] IO_PORT_DB_ATTRIBUTES = new String[]{"DEVICE_ID", "ELEMENT_NAME", "DESCRIPTION", "EXTENDED"};
    private static final String[] LIBRARY_DB_ATTRIBUTES = new String[]{"TAPE_LIBRARY_ID", "DISPLAY_NAME", "USER_PROVIDED_NAME", "CONSOLIDATED_STATUS", "DESCRIPTION", "MAX_CARTRIDGES", "PRIMARY_OWNER_NAME", "PRIMARY_OWNER_CONTACT", "FIRMWARE_VERSION", "ACCESS_INFO", "USER_ATTRIB1", "USER_ATTRIB2", "USER_ATTRIB3", "DETECTABLE"};
    private static final String[] MEDIA_CHANGER_DB_ATTRIBUTES = new String[]{"ELEMENT_NAME", "CONSOLIDATED_STATUS", "MEDIA_FLIP_SUPPORTED", "NODE_ID", "FIRMWARE_VERSION", "DETECTABLE"};
    private static GUIEntityFactory factory = null;

    private static GUICartridge createCartridgeInstance(HashMap attr, String cartridgeId) {
        GUICartridge cartridge = new GUICartridge();
        GUIEntityFactory.populateCartridgeInstance(cartridge, attr, cartridgeId);
        return cartridge;
    }

    private static void populateCartridgeInstance(GUICartridge cartridge, HashMap attr, String cartridgeId) {
        String name = String.valueOf(attr.get("PHYSICAL_LABEL"));
        long capacity = (Long)attr.get("CAPACITY");
        String mediaType = String.valueOf(attr.get("MEDIA_TYPE"));
        boolean cleaner = ((Short)attr.get("CLEANER_MEDIA")).intValue() != 0;
        boolean dualSided = ((Short)attr.get("DUAL_SIDED")).intValue() != 0;
        String description = String.valueOf(attr.get("MEDIA_DESCRIPTION"));
        String[] location = null;
        String[] locationattr = new String[]{"LOCATION_COORDINATES"};
        HashMap[] locCoordinates = null;
        try {
            DeviceRequest dr = new DeviceRequest();
            DeviceRequestHndlr.initDeviceServerComm(dr);
            ITapeReportingService repSvc = (ITapeReportingService)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, ITapeReportingService.class, (String)"TapeManagerService");
            location = repSvc.getComponentLocation(4, new String[]{cartridgeId});
            locCoordinates = repSvc.getComponentAttributes(6, location, locationattr);
        }
        catch (RemoteException e) {
            // empty catch block
        }
        String cartLocation = "" + locCoordinates[0].get("LOCATION_COORDINATES");
        cartridge.setId(cartridgeId);
        cartridge.setLabel(name);
        cartridge.setCapacity(capacity);
        cartridge.setType(mediaType);
        cartridge.setCleanerMedia(cleaner);
        cartridge.setDualSided(dualSided);
        cartridge.setLocation(cartLocation);
        cartridge.setDescription(description);
    }

    private static GUIDrive createDriveInstance(HashMap attr, String driveId) {
        GUIDrive drive = new GUIDrive();
        GUIEntityFactory.populateDriveInstance(drive, attr, driveId);
        return drive;
    }

    private static void populateDriveInstance(GUIDrive drive, HashMap attr, String driveId) {
        String name = String.valueOf(attr.get("DISPLAY_NAME"));
        short state = (Short)attr.get("CONSOLIDATED_STATUS");
        boolean b = ((Short)attr.get("NEEDS_CLEANING")).intValue() != 0;
        long mounts = (Long)attr.get("MOUNT_COUNT");
        String version = (String)attr.get("FIRMWARE_VERSION");
        boolean detectable = (Short)attr.get("DETECTABLE") != 0;
        try {
            DeviceRequest dr = new DeviceRequest();
            DeviceRequestHndlr.initDeviceServerComm(dr);
            ITapeReportingService repSvc = (ITapeReportingService)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, ITapeReportingService.class, (String)"TapeManagerService");
            String[] portattr = new String[]{"NAME"};
            String[] portWWNs = repSvc.getComponentPorts(1, new String[]{driveId});
            HashMap[] portWWNMaps = repSvc.getComponentAttributes(7, portWWNs, portattr);
            String portWWN = portWWNMaps[0].get("NAME").toString();
            String[] locationattr = new String[]{"LOCATION_COORDINATES"};
            String[] location = repSvc.getComponentLocation(1, new String[]{driveId});
            HashMap[] locCoordinates = repSvc.getComponentAttributes(6, location, locationattr);
            String driveLocation = "" + locCoordinates[0].get("LOCATION_COORDINATES");
            drive.setId(driveId);
            drive.setName(name);
            drive.setState((int)state);
            drive.setNeedsCleaning(b);
            drive.setMounts(mounts);
            drive.setWwpn(portWWN);
            drive.setVersion(version);
            drive.setLocation(driveLocation);
            drive.setDetectable(detectable);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    private static GUIFrame createFrameInstance(HashMap attr, String frameId) {
        GUIFrame frame = new GUIFrame();
        GUIEntityFactory.populateFrameInstance(frame, attr, frameId);
        return frame;
    }

    private static void populateFrameInstance(GUIFrame frame, HashMap attr, String frameId) {
        String type = (String)attr.get("MODEL_ID");
        String vendor = (String)attr.get("VENDOR_ID");
        String serialNumber = (String)attr.get("SERIAL_NUMBER");
        boolean lockPresent = (Short)attr.get("LOCK_PRESENT") != 0;
        boolean isLocked = (Short)attr.get("IS_LOCKED") != 0;
        String security = (String)attr.get("SECURITY_BREACH");
        frame.setId(frameId);
        frame.setType(type);
        frame.setVendor(vendor);
        frame.setSerialNumber(serialNumber);
        frame.setLocked(isLocked);
        frame.setLockPresent(lockPresent);
        frame.setSecurity(security);
    }

    private static GUIIOPort createIOPortInstance(HashMap attr, String ioPortId) {
        GUIIOPort ioPort = new GUIIOPort();
        GUIEntityFactory.populateIOPortInstance(ioPort, attr, ioPortId);
        return ioPort;
    }

    private static void populateIOPortInstance(GUIIOPort ioPort, HashMap attr, String ioPortId) {
        String id = String.valueOf(attr.get("DEVICE_ID"));
        String name = String.valueOf(attr.get("ELEMENT_NAME"));
        boolean extended = ((Short)attr.get("EXTENDED")).intValue() != 0;
        String description = String.valueOf(attr.get("DESCRIPTION"));
        String portLocation = null;
        try {
            DeviceRequest dr = new DeviceRequest();
            DeviceRequestHndlr.initDeviceServerComm(dr);
            ITapeReportingService repSvc = (ITapeReportingService)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, ITapeReportingService.class, (String)"TapeManagerService");
            String[] locationattr = new String[]{"LOCATION_COORDINATES"};
            String[] location = repSvc.getComponentLocation(3, new String[]{ioPortId});
            HashMap[] locCoordinates = repSvc.getComponentAttributes(6, location, locationattr);
            portLocation = "" + locCoordinates[0].get("LOCATION_COORDINATES");
        }
        catch (RemoteException e) {
            // empty catch block
        }
        ioPort.setId(id);
        ioPort.setName(name);
        ioPort.setDescription(description);
        ioPort.setExtended(extended);
        ioPort.setLocation(portLocation);
    }

    private static GUILibrary createLibraryInstance(HashMap libAttr, String libId) {
        GUILibrary lib = new GUILibrary();
        String[] driveIds = null;
        String[] mediaChangerIds = null;
        String[] cartridgeIds = null;
        String[] portIds = null;
        int driveNumber = 0;
        int mediaChangerNumber = 0;
        int cartridgeNumber = 0;
        int portNumber = 0;
        HashMap driveattr = new HashMap();
        HashMap medChanattr = new HashMap();
        HashMap carattr = new HashMap();
        HashMap portattr = new HashMap();
        int internalId = (Integer)libAttr.get("TAPE_LIBRARY_ID");
        String displayName = (String)libAttr.get("DISPLAY_NAME");
        String userProvidedName = (String)libAttr.get("USER_PROVIDED_NAME");
        short state = (Short)libAttr.get("CONSOLIDATED_STATUS");
        int maxCartridges = (Integer)libAttr.get("MAX_CARTRIDGES");
        String description = (String)libAttr.get("DESCRIPTION");
        String ownerName = (String)libAttr.get("PRIMARY_OWNER_NAME");
        String ownerContact = (String)libAttr.get("PRIMARY_OWNER_CONTACT");
        String version = (String)libAttr.get("FIRMWARE_VERSION");
        String elementMgr = (String)libAttr.get("ACCESS_INFO");
        String userAttr1 = (String)libAttr.get("USER_ATTRIB1");
        String userAttr2 = (String)libAttr.get("USER_ATTRIB2");
        String userAttr3 = (String)libAttr.get("USER_ATTRIB3");
        boolean detectable = (Short)libAttr.get("DETECTABLE") != 0;
        try {
            DeviceRequest dr = new DeviceRequest();
            DeviceRequestHndlr.initDeviceServerComm(dr);
            ITapeReportingService repSvc = (ITapeReportingService)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, ITapeReportingService.class, (String)"TapeManagerService");
            driveIds = repSvc.getComponents(1, libId, driveattr);
            driveNumber = driveIds.length;
            cartridgeIds = repSvc.getComponents(4, libId, carattr);
            cartridgeNumber = cartridgeIds.length;
            mediaChangerIds = repSvc.getComponents(2, libId, medChanattr);
            mediaChangerNumber = mediaChangerIds.length;
            portIds = repSvc.getComponents(3, libId, portattr);
            portNumber = portIds.length;
        }
        catch (RemoteException e) {
            // empty catch block
        }
        int type = 1;
        lib.setId(libId);
        lib.setDisplayName(displayName);
        lib.setState((int)state);
        lib.setDrives(driveNumber);
        lib.setCatridges(cartridgeNumber);
        lib.setCatridgeCapacity(maxCartridges);
        lib.setType(type);
        lib.setDescription(description);
        lib.setOwnerName(ownerName);
        lib.setOwnerContact(ownerContact);
        lib.setMediaChangers(mediaChangerNumber);
        lib.setIoPorts(portNumber);
        lib.setVersion(version);
        lib.setElementManager(elementMgr);
        lib.setDetectable(detectable);
        lib.setUserProvidedName(userProvidedName);
        lib.setUserAttrib1(userAttr1);
        lib.setUserAttrib2(userAttr2);
        lib.setUserAttrib3(userAttr3);
        lib.setInternalId(internalId);
        return lib;
    }

    private static GUIMediaChanger createMediaChangerInstance(HashMap attr, String mediaChangerId) {
        GUIMediaChanger mediaChanger = new GUIMediaChanger();
        GUIEntityFactory.populateMediaChangerInstance(mediaChanger, attr, mediaChangerId);
        return mediaChanger;
    }

    private static void populateMediaChangerInstance(GUIMediaChanger mediaChanger, HashMap attr, String mediaChangerId) {
        String name = String.valueOf(attr.get("ELEMENT_NAME"));
        short state = (Short)attr.get("CONSOLIDATED_STATUS");
        boolean mediaFlipSupported = ((Short)attr.get("MEDIA_FLIP_SUPPORTED")).intValue() != 0;
        Integer nodeId = (Integer)attr.get("NODE_ID");
        String version = (String)attr.get("FIRMWARE_VERSION");
        boolean detectable = (Short)attr.get("DETECTABLE") != 0;
        String portWWN = null;
        try {
            DeviceRequest dr = new DeviceRequest();
            DeviceRequestHndlr.initDeviceServerComm(dr);
            ITapeReportingService repSvc = (ITapeReportingService)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, ITapeReportingService.class, (String)"TapeReportingService");
            String[] portattr = new String[]{"NAME"};
            String[] portWWNs = repSvc.getComponentPorts(2, new String[]{mediaChangerId});
            HashMap[] portWWNMaps = repSvc.getComponentAttributes(7, portWWNs, portattr);
            portWWN = portWWNMaps[0].get("NAME").toString();
        }
        catch (RemoteException e) {
            // empty catch block
        }
        mediaChanger.setId(mediaChangerId);
        mediaChanger.setName(name);
        mediaChanger.setState((int)state);
        mediaChanger.setMediaFlipSupported(mediaFlipSupported);
        mediaChanger.setWwpn(portWWN);
        mediaChanger.setVersion(version);
        mediaChanger.setDetectable(detectable);
    }

    public static GUIEntityFactory getInstance() {
        if (factory == null) {
            factory = new GUIEntityFactory();
        }
        return factory;
    }

    protected ITapeReportingService getTapeReportingService() {
        DeviceRequest dr = new DeviceRequest();
        DeviceRequestHndlr.initDeviceServerComm(dr);
        ITapeReportingService repSvc = (ITapeReportingService)ConnectorClient.getService((String)dr.deviceServerHost, (int)dr.deviceServerPort, ITapeReportingService.class, (String)"TapeManagerService");
        return repSvc;
    }

    public HashMap getAllTapeLibraries() throws GUIException {
        HashMap tapeLibraries = null;
        try {
            ITapeReportingService repSvc = this.getTapeReportingService();
            String[] libIds = repSvc.getTapeLibraries();
            tapeLibraries = this.getTapeLibraries(libIds);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return tapeLibraries;
    }

    public HashMap getTapeLibraries(String[] libIds) throws GUIException {
        HashMap<String, GUILibrary> tapeLibraries;
        block4: {
            ITapeReportingService repSvc = this.getTapeReportingService();
            tapeLibraries = new HashMap<String, GUILibrary>();
            try {
                HashMap[] libAttrs;
                if (libIds == null || libIds.length <= 0 || (libAttrs = repSvc.getTapeLibraryAttributes(libIds, LIBRARY_DB_ATTRIBUTES)) == null || libAttrs.length <= 0) break block4;
                if (libAttrs.length == libIds.length) {
                    for (int i = 0; i < libAttrs.length; ++i) {
                        HashMap libAttr = libAttrs[i];
                        GUILibrary lib = GUIEntityFactory.createLibraryInstance(libAttr, libIds[i]);
                        tapeLibraries.put(lib.getId(), lib);
                    }
                    break block4;
                }
                throw new RuntimeException("Tape Libraries mismatch error!");
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        return tapeLibraries;
    }

    public HashMap getLibraryDetails(String libraryId) throws GUIException {
        String[] frameIds = this.getFrameIdsByLibrary(libraryId);
        return this.getFrames(libraryId, frameIds);
    }

    public int deleteTapeLibrary(String libraryId) throws GUIException {
        TapeLibraryDBHelper libDBHelper = new TapeLibraryDBHelper();
        return libDBHelper.deleteLibrary(libraryId);
    }

    public int setLibraryAttributes(String libraryId, Hashtable attributes) throws Exception {
        TapeLibraryDBHelper libDBHelper = new TapeLibraryDBHelper();
        return libDBHelper.saveProperties(libraryId, attributes);
    }

    public String[] getDriveIdsByLibrary(String libraryId) throws GUIException {
        ITapeReportingService repSvc = this.getTapeReportingService();
        String[] driveIds = null;
        try {
            HashMap attributes = new HashMap();
            driveIds = repSvc.getComponents(1, libraryId, attributes);
        }
        catch (RemoteException e) {
            // empty catch block
        }
        return driveIds;
    }

    public HashMap getDrives(String libraryId, String[] driveIds) throws GUIException {
        ITapeReportingService repSvc = this.getTapeReportingService();
        HashMap<String, GUIDrive> drives = new HashMap<String, GUIDrive>();
        try {
            if (driveIds != null && driveIds.length > 0) {
                Object driveAttrs = null;
                repSvc.getComponentAttributes(1, driveIds, DRIVE_DB_ATTRIBUTES);
                if (driveAttrs != null && (driveAttrs).length > 0 && (driveAttrs).length == driveIds.length) {
                    for (int i = 0; i < (driveAttrs).length; ++i) {
                        void driveAttr = driveAttrs[i];
                        GUIDrive drive = GUIEntityFactory.createDriveInstance((HashMap)driveAttr, driveIds[i]);
                        drives.put(drive.getId(), drive);
                    }
                }
            }
        }
        catch (RemoteException e) {
            // empty catch block
        }
        return drives;
    }

    public HashMap getDrivesByLibrary(String libraryId) throws GUIException {
        String[] driveIds = this.getDriveIdsByLibrary(libraryId);
        return this.getDrives(libraryId, driveIds);
    }

    public String[] getMediaChangersIdsByLibrary(String libraryId) throws GUIException {
        ITapeReportingService repSvc = this.getTapeReportingService();
        String[] mediaChangersIds = null;
        try {
            HashMap attributes = new HashMap();
            mediaChangersIds = repSvc.getComponents(2, libraryId, attributes);
        }
        catch (RemoteException e) {
            // empty catch block
        }
        return mediaChangersIds;
    }

    public HashMap getMediaChangers(String libraryId, String[] mediaChangersIds) throws GUIException {
        ITapeReportingService repSvc = this.getTapeReportingService();
        HashMap<String, GUIMediaChanger> mediaChangers = new HashMap<String, GUIMediaChanger>();
        try {
            HashMap[] mediaChangerAttrs;
            if (mediaChangersIds != null && mediaChangersIds.length > 0 && (mediaChangerAttrs = repSvc.getComponentAttributes(2, mediaChangersIds, MEDIA_CHANGER_DB_ATTRIBUTES)) != null && mediaChangerAttrs.length > 0 && mediaChangerAttrs.length == mediaChangersIds.length) {
                for (int i = 0; i < mediaChangerAttrs.length; ++i) {
                    HashMap mediaChangerAttr = mediaChangerAttrs[i];
                    GUIMediaChanger mediaChanger = GUIEntityFactory.createMediaChangerInstance(mediaChangerAttr, mediaChangersIds[i]);
                    mediaChangers.put(mediaChanger.getId(), mediaChanger);
                }
            }
        }
        catch (RemoteException e) {
            // empty catch block
        }
        return mediaChangers;
    }

    public HashMap getMediaChangersByLibrary(String libraryId) throws GUIException {
        String[] mediaChangersIds = this.getMediaChangersIdsByLibrary(libraryId);
        return this.getMediaChangers(libraryId, mediaChangersIds);
    }

    public String[] getIoPortIdsByLibrary(String libraryId) throws GUIException {
        ITapeReportingService repSvc = this.getTapeReportingService();
        String[] ioPortIds = null;
        try {
            HashMap attributes = new HashMap();
            ioPortIds = repSvc.getComponents(3, libraryId, attributes);
        }
        catch (RemoteException e) {
            // empty catch block
        }
        return ioPortIds;
    }

    public HashMap getIoPorts(String libraryId, String[] ioPortIds) throws GUIException {
        ITapeReportingService repSvc = this.getTapeReportingService();
        HashMap<String, GUIIOPort> ioPorts = new HashMap<String, GUIIOPort>();
        try {
            HashMap[] ioPortsAttrs;
            if (ioPortIds != null && ioPortIds.length > 0 && (ioPortsAttrs = repSvc.getComponentAttributes(3, ioPortIds, IO_PORT_DB_ATTRIBUTES)) != null && ioPortsAttrs.length > 0 && ioPortsAttrs.length == ioPortIds.length) {
                for (int i = 0; i < ioPortsAttrs.length; ++i) {
                    HashMap ioPortAttr = ioPortsAttrs[i];
                    GUIIOPort ioPort = GUIEntityFactory.createIOPortInstance(ioPortAttr, ioPortIds[i]);
                    ioPorts.put(ioPort.getId(), ioPort);
                }
            }
        }
        catch (RemoteException e) {
            // empty catch block
        }
        return ioPorts;
    }

    public HashMap getIoPortsByLibrary(String libraryId) throws GUIException {
        String[] ioPortIds = this.getIoPortIdsByLibrary(libraryId);
        return this.getIoPorts(libraryId, ioPortIds);
    }

    public String[] getCartridgesIdsByLibrary(String libraryId) throws GUIException {
        ITapeReportingService repSvc = this.getTapeReportingService();
        String[] cartridgeIds = null;
        try {
            HashMap attributes = new HashMap();
            cartridgeIds = repSvc.getComponents(4, libraryId, attributes);
        }
        catch (RemoteException e) {
            // empty catch block
        }
        return cartridgeIds;
    }

    public HashMap getCartridges(String libraryId, String[] cartridgeIds) throws GUIException {
        ITapeReportingService repSvc = this.getTapeReportingService();
        HashMap<String, GUICartridge> cartridges = new HashMap<String, GUICartridge>();
        try {
            HashMap[] cartridgesAttrs;
            if (cartridgeIds != null && cartridgeIds.length > 0 && (cartridgesAttrs = repSvc.getComponentAttributes(4, cartridgeIds, CARTRIDGE_DB_ATTRIBUTES)) != null && cartridgesAttrs.length > 0 && cartridgesAttrs.length == cartridgeIds.length) {
                for (int i = 0; i < cartridgesAttrs.length; ++i) {
                    HashMap cartridgeAttr = cartridgesAttrs[i];
                    GUICartridge cartridge = GUIEntityFactory.createCartridgeInstance(cartridgeAttr, cartridgeIds[i]);
                    cartridges.put(cartridge.getId(), cartridge);
                }
            }
        }
        catch (RemoteException e) {
            // empty catch block
        }
        return cartridges;
    }

    public HashMap getCartridgesByLibrary(String libraryId) throws GUIException {
        String[] cartridgeIds = this.getCartridgesIdsByLibrary(libraryId);
        return this.getCartridges(libraryId, cartridgeIds);
    }

    public String[] getFrameIdsByLibrary(String libraryId) throws GUIException {
        ITapeReportingService repSvc = this.getTapeReportingService();
        String[] frameIds = null;
        try {
            HashMap attributes = new HashMap();
            frameIds = repSvc.getComponents(5, libraryId, attributes);
        }
        catch (RemoteException e) {
            // empty catch block
        }
        return frameIds;
    }

    public HashMap getFrames(String libraryId, String[] frameIds) throws GUIException {
        ITapeReportingService repSvc = this.getTapeReportingService();
        HashMap<String, GUIFrame> frames = new HashMap<String, GUIFrame>();
        try {
            HashMap[] framesAttrs;
            if (frameIds != null && frameIds.length > 0 && (framesAttrs = repSvc.getComponentAttributes(5, frameIds, FRAME_DB_ATTRIBUTES)) != null && framesAttrs.length > 0 && framesAttrs.length == frameIds.length) {
                for (int i = 0; i < framesAttrs.length; ++i) {
                    HashMap frameAttr = framesAttrs[i];
                    GUIFrame frame = GUIEntityFactory.createFrameInstance(frameAttr, frameIds[i]);
                    frames.put(frame.getId(), frame);
                }
            }
        }
        catch (RemoteException e) {
            // empty catch block
        }
        return frames;
    }

    public HashMap getFramesByLibrary(String libraryId) throws GUIException {
        String[] frameIds = this.getFrameIdsByLibrary(libraryId);
        return this.getFrames(libraryId, frameIds);
    }
}

